/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol.tasks;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.tasks.TradeTask;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import monero.daemon.model.MoneroTx;
import monero.wallet.MoneroWallet;
import monero.wallet.model.MoneroAccount;
import monero.wallet.model.MoneroSubaddress;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuyerPreparePaymentSentMessage
extends TradeTask {
    private static final Logger log = LoggerFactory.getLogger(BuyerPreparePaymentSentMessage.class);

    public BuyerPreparePaymentSentMessage(TaskRunner taskHandler, Trade trade) {
        super((TaskRunner<Trade>)taskHandler, trade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        try {
            this.runInterceptHook();
            if (this.trade.isPayoutPublished()) {
                throw new RuntimeException("Cannot mark payment sent because payout already published for " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId());
            }
            if (this.trade.getSelf().getUnsignedPayoutTxHex() != null) {
                log.warn("Skipping preparation of payment sent message because payout tx is already created for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getShortId());
                this.complete();
                return;
            }
            Preconditions.checkNotNull((Object)this.trade.getSeller().getPaymentAccountPayload(), (Object)"Seller's payment account payload is null");
            Preconditions.checkNotNull((Object)this.trade.getAmount(), (Object)"trade.getTradeAmount() must not be null");
            Preconditions.checkNotNull((Object)this.trade.getMakerDepositTx(), (Object)"trade.getMakerDepositTx() must not be null");
            if (!this.trade.hasBuyerAsTakerWithoutDeposit()) {
                Preconditions.checkNotNull((Object)this.trade.getTakerDepositTx(), (Object)"trade.getTakerDepositTx() must not be null");
            }
            Preconditions.checkNotNull((Object)this.trade.getOffer(), (Object)"offer must not be null");
            if (this.trade.getSeller().getUpdatedMultisigHex() != null) {
                Object object = this.trade.getWalletLock();
                synchronized (object) {
                    Object object2 = HavenoUtils.getWalletFunctionLock();
                    synchronized (object2) {
                        try {
                            this.trade.importMultisigHex();
                            log.info("Buyer creating unsigned payout tx for {} {} ", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getShortId());
                            MoneroTxWallet payoutTx = this.trade.createPayoutTx();
                            this.trade.setPayoutTx((MoneroTx)payoutTx);
                            this.trade.getSelf().setUnsignedPayoutTxHex(payoutTx.getTxSet().getMultisigTxHex());
                            this.trade.requestPersistence();
                        }
                        catch (Exception e) {
                            if (HavenoUtils.isIllegal(e)) {
                                log.warn("Failed to create unsigned payout tx for " + this.trade.getClass().getSimpleName() + " " + this.trade.getShortId(), (Throwable)e);
                            }
                            throw e;
                        }
                    }
                }
            }
            this.complete();
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    public static void printBalances(MoneroWallet wallet) {
        ArrayList<Pair<String, List<Object>>> pairs = new ArrayList<Pair<String, List<Object>>>();
        BigInteger balance = wallet.getBalance();
        BigInteger unlockedBalance = wallet.getUnlockedBalance();
        List accounts = wallet.getAccounts(true);
        System.out.println("Wallet balance: " + String.valueOf(balance));
        System.out.println("Wallet unlocked balance: " + String.valueOf(unlockedBalance));
        for (MoneroAccount account : accounts) {
            BuyerPreparePaymentSentMessage.add(pairs, "ACCOUNT", account.getIndex());
            BuyerPreparePaymentSentMessage.add(pairs, "SUBADDRESS", "");
            BuyerPreparePaymentSentMessage.add(pairs, "LABEL", "");
            BuyerPreparePaymentSentMessage.add(pairs, "ADDRESS", "");
            BuyerPreparePaymentSentMessage.add(pairs, "BALANCE", account.getBalance());
            BuyerPreparePaymentSentMessage.add(pairs, "UNLOCKED", account.getUnlockedBalance());
            for (MoneroSubaddress subaddress : account.getSubaddresses()) {
                BuyerPreparePaymentSentMessage.add(pairs, "ACCOUNT", account.getIndex());
                BuyerPreparePaymentSentMessage.add(pairs, "SUBADDRESS", subaddress.getIndex());
                BuyerPreparePaymentSentMessage.add(pairs, "LABEL", subaddress.getLabel());
                BuyerPreparePaymentSentMessage.add(pairs, "ADDRESS", subaddress.getAddress());
                BuyerPreparePaymentSentMessage.add(pairs, "BALANCE", subaddress.getBalance());
                BuyerPreparePaymentSentMessage.add(pairs, "UNLOCKED", subaddress.getUnlockedBalance());
            }
        }
        Integer length = null;
        for (Pair pair : pairs) {
            if (length != null) continue;
            length = ((List)pair.getSecond()).size();
        }
        System.out.println(BuyerPreparePaymentSentMessage.pairsToCsv(pairs));
    }

    private static void add(List<Pair<String, List<Object>>> pairs, String header, Object value) {
        if (value == null) {
            value = "";
        }
        Pair<String, List<Object>> pair = null;
        for (Pair<String, List<Object>> aPair : pairs) {
            if (!aPair.getFirst().equals(header)) continue;
            pair = aPair;
            break;
        }
        if (pair == null) {
            ArrayList vals = new ArrayList();
            pair = new Pair(header, vals);
            pairs.add(pair);
        }
        ((List)pair.getSecond()).add(value);
    }

    private static String pairsToCsv(List<Pair<String, List<Object>>> pairs) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < pairs.size(); ++i) {
            sb.append(pairs.get(i).getFirst());
            if (i < pairs.size() - 1) {
                sb.append(',');
                continue;
            }
            sb.append('\n');
        }
        for (i = 0; i < pairs.get(0).getSecond().size(); ++i) {
            for (int j = 0; j < pairs.size(); ++j) {
                sb.append(pairs.get(j).getSecond().get(i));
                if (j < pairs.size() - 1) {
                    sb.append(',');
                    continue;
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static class Pair<F, S> {
        private F first;
        private S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public F getFirst() {
            return this.first;
        }

        public void setFirst(F first) {
            this.first = first;
        }

        public S getSecond() {
            return this.second;
        }

        public void setSecond(S second) {
            this.second = second;
        }
    }
}

