/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.BuyerAsMakerTrade;
import haveno.core.trade.BuyerAsTakerTrade;
import haveno.core.trade.SellerAsMakerTrade;
import haveno.core.trade.SellerAsTakerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.ArbitratorProtocol;
import haveno.core.trade.protocol.BuyerAsMakerProtocol;
import haveno.core.trade.protocol.BuyerAsTakerProtocol;
import haveno.core.trade.protocol.SellerAsMakerProtocol;
import haveno.core.trade.protocol.SellerAsTakerProtocol;
import haveno.core.trade.protocol.TradeProtocol;

public class TradeProtocolFactory {
    public static TradeProtocol getNewTradeProtocol(Trade trade) {
        if (trade instanceof BuyerAsMakerTrade) {
            return new BuyerAsMakerProtocol((BuyerAsMakerTrade)trade);
        }
        if (trade instanceof BuyerAsTakerTrade) {
            return new BuyerAsTakerProtocol((BuyerAsTakerTrade)trade);
        }
        if (trade instanceof SellerAsMakerTrade) {
            return new SellerAsMakerProtocol((SellerAsMakerTrade)trade);
        }
        if (trade instanceof SellerAsTakerTrade) {
            return new SellerAsTakerProtocol((SellerAsTakerTrade)trade);
        }
        if (trade instanceof ArbitratorTrade) {
            return new ArbitratorProtocol((ArbitratorTrade)trade);
        }
        throw new IllegalStateException("Trade not of expected type. Trade=" + String.valueOf(trade));
    }
}

