/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import haveno.common.app.Version;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.core.account.witness.AccountAgeWitness;
import haveno.core.network.MessageState;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.support.dispute.messages.DisputeClosedMessage;
import haveno.core.trade.TradeManager;
import haveno.core.trade.messages.PaymentReceivedMessage;
import haveno.core.trade.messages.PaymentSentMessage;
import haveno.network.p2p.AckMessage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.Nullable;
import monero.wallet.model.MoneroTxWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.NodeAddress;
import protobuf.PaymentAccountPayload;
import protobuf.TradePeer;

public final class TradePeer
implements PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(TradePeer.class);
    @Nullable
    private transient byte[] delayedPayoutTxSignature;
    @Nullable
    private transient byte[] preparedDepositTx;
    private transient MoneroTxWallet depositTx;
    private transient TradeManager tradeManager;
    @Nullable
    private haveno.network.p2p.NodeAddress nodeAddress;
    @Nullable
    private PubKeyRing pubKeyRing;
    @Nullable
    private String accountId;
    @Nullable
    private String paymentAccountId;
    @Nullable
    private String paymentMethodId;
    @Nullable
    private byte[] paymentAccountPayloadHash;
    @Nullable
    private byte[] encryptedPaymentAccountPayload;
    @Nullable
    private byte[] paymentAccountKey;
    @Nullable
    private haveno.core.payment.payload.PaymentAccountPayload paymentAccountPayload;
    @Nullable
    private String payoutAddressString;
    @Nullable
    private String contractAsJson;
    @Nullable
    private byte[] contractSignature;
    @Nullable
    private PaymentSentMessage paymentSentMessage;
    @Nullable
    private PaymentReceivedMessage paymentReceivedMessage;
    @Nullable
    private DisputeClosedMessage disputeClosedMessage;
    @Nullable
    private byte[] accountAgeWitnessNonce;
    @Nullable
    private byte[] accountAgeWitnessSignature;
    @Nullable
    private AccountAgeWitness accountAgeWitness;
    private long currentDate;
    @Nullable
    private byte[] mediatedPayoutTxSignature;
    @Nullable
    private String reserveTxHash;
    @Nullable
    private String reserveTxHex;
    @Nullable
    private String reserveTxKey;
    @Nullable
    private List<String> reserveTxKeyImages = new ArrayList<String>();
    @Nullable
    private String preparedMultisigHex;
    @Nullable
    private String madeMultisigHex;
    @Nullable
    private String exchangedMultisigHex;
    @Nullable
    private String depositTxHash;
    @Nullable
    private String depositTxHex;
    @Nullable
    private String depositTxKey;
    private long depositTxFee;
    private long securityDeposit;
    @Nullable
    private String unsignedPayoutTxHex;
    private long payoutTxFee;
    private long payoutAmount;
    @Nullable
    private String updatedMultisigHex;
    @Deprecated
    private boolean depositsConfirmedMessageAcked;
    private ObjectProperty<MessageState> depositsConfirmedMessageStateProperty = new SimpleObjectProperty((Object)MessageState.UNDEFINED);
    private ObjectProperty<MessageState> paymentSentMessageStateProperty = new SimpleObjectProperty((Object)MessageState.UNDEFINED);
    private ObjectProperty<MessageState> paymentReceivedMessageStateProperty = new SimpleObjectProperty((Object)MessageState.UNDEFINED);

    public void applyTransient(TradeManager tradeManager) {
        this.tradeManager = tradeManager;
        if (this.depositsConfirmedMessageAcked && this.depositsConfirmedMessageStateProperty.get() == MessageState.UNDEFINED) {
            this.depositsConfirmedMessageStateProperty.set((Object)MessageState.ACKNOWLEDGED);
            tradeManager.requestPersistence();
        }
    }

    public BigInteger getDepositTxFee() {
        return BigInteger.valueOf(this.depositTxFee);
    }

    public void setDepositTxFee(BigInteger depositTxFee) {
        this.depositTxFee = depositTxFee.longValueExact();
    }

    public BigInteger getSecurityDeposit() {
        return BigInteger.valueOf(this.securityDeposit);
    }

    public void setSecurityDeposit(BigInteger securityDeposit) {
        this.securityDeposit = securityDeposit.longValueExact();
    }

    public BigInteger getPayoutTxFee() {
        return BigInteger.valueOf(this.payoutTxFee);
    }

    public void setPayoutTxFee(BigInteger payoutTxFee) {
        this.payoutTxFee = payoutTxFee.longValueExact();
    }

    public BigInteger getPayoutAmount() {
        return BigInteger.valueOf(this.payoutAmount);
    }

    public void setPayoutAmount(BigInteger payoutAmount) {
        this.payoutAmount = payoutAmount.longValueExact();
    }

    void setDepositsConfirmedAckMessage(AckMessage ackMessage) {
        MessageState messageState = ackMessage.isSuccess() ? MessageState.ACKNOWLEDGED : MessageState.NACKED;
        this.setDepositsConfirmedMessageState(messageState);
    }

    void setPaymentSentAckMessage(AckMessage ackMessage) {
        MessageState messageState = ackMessage.isSuccess() ? MessageState.ACKNOWLEDGED : MessageState.NACKED;
        this.setPaymentSentMessageState(messageState);
    }

    void setPaymentReceivedAckMessage(AckMessage ackMessage) {
        MessageState messageState = ackMessage.isSuccess() ? MessageState.ACKNOWLEDGED : MessageState.NACKED;
        this.setPaymentReceivedMessageState(messageState);
    }

    public void setDepositsConfirmedMessageState(MessageState depositsConfirmedMessageStateProperty) {
        this.depositsConfirmedMessageStateProperty.set((Object)depositsConfirmedMessageStateProperty);
        if (this.tradeManager != null) {
            this.tradeManager.requestPersistence();
        }
    }

    public void setPaymentSentMessageState(MessageState paymentSentMessageStateProperty) {
        this.paymentSentMessageStateProperty.set((Object)paymentSentMessageStateProperty);
        if (this.tradeManager != null) {
            this.tradeManager.requestPersistence();
        }
    }

    public void setPaymentReceivedMessageState(MessageState paymentReceivedMessageStateProperty) {
        this.paymentReceivedMessageStateProperty.set((Object)paymentReceivedMessageStateProperty);
        if (this.tradeManager != null) {
            this.tradeManager.requestPersistence();
        }
    }

    public boolean isDepositsConfirmedMessageAcked() {
        return this.depositsConfirmedMessageStateProperty.get() == MessageState.ACKNOWLEDGED;
    }

    public boolean isPaymentSentMessageAcked() {
        return this.paymentSentMessageStateProperty.get() == MessageState.ACKNOWLEDGED;
    }

    public boolean isPaymentReceivedMessageReceived() {
        return this.isPaymentReceivedMessageAckedOrStored() || this.isPaymentReceivedMessageNacked();
    }

    public boolean isPaymentReceivedMessageAckedOrStored() {
        return this.paymentReceivedMessageStateProperty.get() == MessageState.ACKNOWLEDGED || this.paymentReceivedMessageStateProperty.get() == MessageState.STORED_IN_MAILBOX;
    }

    public boolean isPaymentReceivedMessageNacked() {
        return this.paymentReceivedMessageStateProperty.get() == MessageState.NACKED;
    }

    public boolean isPaymentReceivedMessageArrived() {
        return this.paymentReceivedMessageStateProperty.get() == MessageState.ARRIVED;
    }

    public Message toProtoMessage() {
        TradePeer.Builder builder = protobuf.TradePeer.newBuilder();
        Optional.ofNullable(this.nodeAddress).ifPresent(e -> builder.setNodeAddress(this.nodeAddress.toProtoMessage()));
        Optional.ofNullable(this.pubKeyRing).ifPresent(e -> builder.setPubKeyRing(this.pubKeyRing.toProtoMessage()));
        Optional.ofNullable(this.accountId).ifPresent(arg_0 -> ((TradePeer.Builder)builder).setAccountId(arg_0));
        Optional.ofNullable(this.paymentAccountId).ifPresent(arg_0 -> ((TradePeer.Builder)builder).setPaymentAccountId(arg_0));
        Optional.ofNullable(this.paymentMethodId).ifPresent(arg_0 -> ((TradePeer.Builder)builder).setPaymentMethodId(arg_0));
        Optional.ofNullable(this.paymentAccountPayloadHash).ifPresent(e -> builder.setPaymentAccountPayloadHash(ByteString.copyFrom((byte[])this.paymentAccountPayloadHash)));
        Optional.ofNullable(this.encryptedPaymentAccountPayload).ifPresent(e -> builder.setEncryptedPaymentAccountPayload(ByteString.copyFrom((byte[])e)));
        Optional.ofNullable(this.paymentAccountKey).ifPresent(e -> builder.setPaymentAccountKey(ByteString.copyFrom((byte[])e)));
        Optional.ofNullable(this.paymentAccountPayload).ifPresent(e -> builder.setPaymentAccountPayload((PaymentAccountPayload)e.toProtoMessage()));
        Optional.ofNullable(this.payoutAddressString).ifPresent(arg_0 -> ((TradePeer.Builder)builder).setPayoutAddressString(arg_0));
        Optional.ofNullable(this.contractAsJson).ifPresent(arg_0 -> ((TradePeer.Builder)builder).setContractAsJson(arg_0));
        Optional.ofNullable(this.contractSignature).ifPresent(e -> builder.setContractSignature(ByteString.copyFrom((byte[])e)));
        Optional.ofNullable(this.pubKeyRing).ifPresent(e -> builder.setPubKeyRing(e.toProtoMessage()));
        Optional.ofNullable(this.accountAgeWitnessNonce).ifPresent(e -> builder.setAccountAgeWitnessNonce(ByteString.copyFrom((byte[])e)));
        Optional.ofNullable(this.accountAgeWitnessSignature).ifPresent(e -> builder.setAccountAgeWitnessSignature(ByteString.copyFrom((byte[])e)));
        Optional.ofNullable(this.accountAgeWitness).ifPresent(e -> builder.setAccountAgeWitness(this.accountAgeWitness.toProtoAccountAgeWitness()));
        Optional.ofNullable(this.mediatedPayoutTxSignature).ifPresent(e -> builder.setMediatedPayoutTxSignature(ByteString.copyFrom((byte[])e)));
        Optional.ofNullable(this.paymentSentMessage).ifPresent(e -> builder.setPaymentSentMessage(this.paymentSentMessage.toProtoNetworkEnvelope().getPaymentSentMessage()));
        Optional.ofNullable(this.paymentReceivedMessage).ifPresent(e -> builder.setPaymentReceivedMessage(this.paymentReceivedMessage.toProtoNetworkEnvelope().getPaymentReceivedMessage()));
        Optional.ofNullable(this.disputeClosedMessage).ifPresent(e -> builder.setDisputeClosedMessage(this.disputeClosedMessage.toProtoNetworkEnvelope().getDisputeClosedMessage()));
        Optional.ofNullable(this.reserveTxHash).ifPresent(e -> builder.setReserveTxHash(this.reserveTxHash));
        Optional.ofNullable(this.reserveTxHex).ifPresent(e -> builder.setReserveTxHex(this.reserveTxHex));
        Optional.ofNullable(this.reserveTxKey).ifPresent(e -> builder.setReserveTxKey(this.reserveTxKey));
        Optional.ofNullable(this.reserveTxKeyImages).ifPresent(e -> builder.addAllReserveTxKeyImages(this.reserveTxKeyImages));
        Optional.ofNullable(this.preparedMultisigHex).ifPresent(e -> builder.setPreparedMultisigHex(this.preparedMultisigHex));
        Optional.ofNullable(this.madeMultisigHex).ifPresent(e -> builder.setMadeMultisigHex(this.madeMultisigHex));
        Optional.ofNullable(this.exchangedMultisigHex).ifPresent(e -> builder.setExchangedMultisigHex(this.exchangedMultisigHex));
        Optional.ofNullable(this.updatedMultisigHex).ifPresent(e -> builder.setUpdatedMultisigHex(this.updatedMultisigHex));
        Optional.ofNullable(this.depositTxHash).ifPresent(e -> builder.setDepositTxHash(this.depositTxHash));
        Optional.ofNullable(this.depositTxHex).ifPresent(e -> builder.setDepositTxHex(this.depositTxHex));
        Optional.ofNullable(this.depositTxKey).ifPresent(e -> builder.setDepositTxKey(this.depositTxKey));
        Optional.ofNullable(this.depositTxFee).ifPresent(e -> builder.setDepositTxFee(this.depositTxFee));
        Optional.ofNullable(this.securityDeposit).ifPresent(e -> builder.setSecurityDeposit(this.securityDeposit));
        Optional.ofNullable(this.unsignedPayoutTxHex).ifPresent(e -> builder.setUnsignedPayoutTxHex(this.unsignedPayoutTxHex));
        Optional.ofNullable(this.payoutTxFee).ifPresent(e -> builder.setPayoutTxFee(this.payoutTxFee));
        Optional.ofNullable(this.payoutAmount).ifPresent(e -> builder.setPayoutAmount(this.payoutAmount));
        builder.setDepositsConfirmedMessageAcked(this.depositsConfirmedMessageAcked);
        builder.setDepositsConfirmedMessageState(((MessageState)((Object)this.depositsConfirmedMessageStateProperty.get())).name());
        builder.setPaymentSentMessageState(((MessageState)((Object)this.paymentSentMessageStateProperty.get())).name());
        builder.setPaymentReceivedMessageState(((MessageState)((Object)this.paymentReceivedMessageStateProperty.get())).name());
        builder.setCurrentDate(this.currentDate);
        return builder.build();
    }

    public static TradePeer fromProto(protobuf.TradePeer proto, CoreProtoResolver coreProtoResolver) {
        if (proto.getDefaultInstanceForType().equals((Object)proto)) {
            return null;
        }
        TradePeer tradePeer = new TradePeer();
        tradePeer.setNodeAddress(proto.hasNodeAddress() ? haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getNodeAddress()) : null);
        tradePeer.setPubKeyRing(proto.hasPubKeyRing() ? PubKeyRing.fromProto((protobuf.PubKeyRing)proto.getPubKeyRing()) : null);
        tradePeer.setAccountId(ProtoUtil.stringOrNullFromProto((String)proto.getAccountId()));
        tradePeer.setPaymentAccountId(ProtoUtil.stringOrNullFromProto((String)proto.getPaymentAccountId()));
        tradePeer.setPaymentMethodId(ProtoUtil.stringOrNullFromProto((String)proto.getPaymentMethodId()));
        tradePeer.setPaymentAccountPayloadHash(proto.getPaymentAccountPayloadHash().toByteArray());
        tradePeer.setEncryptedPaymentAccountPayload(proto.getEncryptedPaymentAccountPayload().toByteArray());
        tradePeer.setPaymentAccountKey(ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getPaymentAccountKey()));
        tradePeer.setPaymentAccountPayload(proto.hasPaymentAccountPayload() ? coreProtoResolver.fromProto(proto.getPaymentAccountPayload()) : null);
        tradePeer.setPayoutAddressString(ProtoUtil.stringOrNullFromProto((String)proto.getPayoutAddressString()));
        tradePeer.setContractAsJson(ProtoUtil.stringOrNullFromProto((String)proto.getContractAsJson()));
        tradePeer.setContractSignature(ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getContractSignature()));
        tradePeer.setPubKeyRing(proto.hasPubKeyRing() ? PubKeyRing.fromProto((protobuf.PubKeyRing)proto.getPubKeyRing()) : null);
        tradePeer.setAccountAgeWitnessNonce(ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getAccountAgeWitnessNonce()));
        tradePeer.setAccountAgeWitnessSignature(ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getAccountAgeWitnessSignature()));
        protobuf.AccountAgeWitness protoAccountAgeWitness = proto.getAccountAgeWitness();
        tradePeer.setAccountAgeWitness(protoAccountAgeWitness.getHash().isEmpty() ? null : AccountAgeWitness.fromProto(protoAccountAgeWitness));
        tradePeer.setCurrentDate(proto.getCurrentDate());
        tradePeer.setMediatedPayoutTxSignature(ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getMediatedPayoutTxSignature()));
        tradePeer.setPaymentSentMessage(proto.hasPaymentSentMessage() ? PaymentSentMessage.fromProto(proto.getPaymentSentMessage(), Version.getP2PMessageVersion()) : null);
        tradePeer.setPaymentReceivedMessage(proto.hasPaymentReceivedMessage() ? PaymentReceivedMessage.fromProto(proto.getPaymentReceivedMessage(), Version.getP2PMessageVersion()) : null);
        tradePeer.setDisputeClosedMessage(proto.hasDisputeClosedMessage() ? DisputeClosedMessage.fromProto(proto.getDisputeClosedMessage(), Version.getP2PMessageVersion()) : null);
        tradePeer.setReserveTxHash(ProtoUtil.stringOrNullFromProto((String)proto.getReserveTxHash()));
        tradePeer.setReserveTxHex(ProtoUtil.stringOrNullFromProto((String)proto.getReserveTxHex()));
        tradePeer.setReserveTxKey(ProtoUtil.stringOrNullFromProto((String)proto.getReserveTxKey()));
        tradePeer.setReserveTxKeyImages((List<String>)proto.getReserveTxKeyImagesList());
        tradePeer.setPreparedMultisigHex(ProtoUtil.stringOrNullFromProto((String)proto.getPreparedMultisigHex()));
        tradePeer.setMadeMultisigHex(ProtoUtil.stringOrNullFromProto((String)proto.getMadeMultisigHex()));
        tradePeer.setExchangedMultisigHex(ProtoUtil.stringOrNullFromProto((String)proto.getExchangedMultisigHex()));
        tradePeer.setUpdatedMultisigHex(ProtoUtil.stringOrNullFromProto((String)proto.getUpdatedMultisigHex()));
        tradePeer.setDepositsConfirmedMessageAcked(proto.getDepositsConfirmedMessageAcked());
        tradePeer.setDepositTxHash(ProtoUtil.stringOrNullFromProto((String)proto.getDepositTxHash()));
        tradePeer.setDepositTxHex(ProtoUtil.stringOrNullFromProto((String)proto.getDepositTxHex()));
        tradePeer.setDepositTxKey(ProtoUtil.stringOrNullFromProto((String)proto.getDepositTxKey()));
        tradePeer.setDepositTxFee(BigInteger.valueOf(proto.getDepositTxFee()));
        tradePeer.setSecurityDeposit(BigInteger.valueOf(proto.getSecurityDeposit()));
        tradePeer.setUnsignedPayoutTxHex(ProtoUtil.stringOrNullFromProto((String)proto.getUnsignedPayoutTxHex()));
        tradePeer.setPayoutTxFee(BigInteger.valueOf(proto.getPayoutTxFee()));
        tradePeer.setPayoutAmount(BigInteger.valueOf(proto.getPayoutAmount()));
        String depositsConfirmedMessageStateString = ProtoUtil.stringOrNullFromProto((String)proto.getDepositsConfirmedMessageState());
        MessageState depositsConfirmedMessageState = (MessageState)ProtoUtil.enumFromProto(MessageState.class, (String)depositsConfirmedMessageStateString);
        tradePeer.setDepositsConfirmedMessageState(depositsConfirmedMessageState);
        String paymentSentMessageStateString = ProtoUtil.stringOrNullFromProto((String)proto.getPaymentSentMessageState());
        MessageState paymentSentMessageState = (MessageState)ProtoUtil.enumFromProto(MessageState.class, (String)paymentSentMessageStateString);
        tradePeer.setPaymentSentMessageState(paymentSentMessageState);
        String paymentReceivedMessageStateString = ProtoUtil.stringOrNullFromProto((String)proto.getPaymentReceivedMessageState());
        MessageState paymentReceivedMessageState = (MessageState)ProtoUtil.enumFromProto(MessageState.class, (String)paymentReceivedMessageStateString);
        tradePeer.setPaymentReceivedMessageState(paymentReceivedMessageState);
        return tradePeer;
    }

    @Nullable
    public byte[] getDelayedPayoutTxSignature() {
        return this.delayedPayoutTxSignature;
    }

    @Nullable
    public byte[] getPreparedDepositTx() {
        return this.preparedDepositTx;
    }

    public MoneroTxWallet getDepositTx() {
        return this.depositTx;
    }

    public TradeManager getTradeManager() {
        return this.tradeManager;
    }

    @Nullable
    public haveno.network.p2p.NodeAddress getNodeAddress() {
        return this.nodeAddress;
    }

    @Nullable
    public PubKeyRing getPubKeyRing() {
        return this.pubKeyRing;
    }

    @Nullable
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    public String getPaymentAccountId() {
        return this.paymentAccountId;
    }

    @Nullable
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @Nullable
    public byte[] getPaymentAccountPayloadHash() {
        return this.paymentAccountPayloadHash;
    }

    @Nullable
    public byte[] getEncryptedPaymentAccountPayload() {
        return this.encryptedPaymentAccountPayload;
    }

    @Nullable
    public byte[] getPaymentAccountKey() {
        return this.paymentAccountKey;
    }

    @Nullable
    public haveno.core.payment.payload.PaymentAccountPayload getPaymentAccountPayload() {
        return this.paymentAccountPayload;
    }

    @Nullable
    public String getPayoutAddressString() {
        return this.payoutAddressString;
    }

    @Nullable
    public String getContractAsJson() {
        return this.contractAsJson;
    }

    @Nullable
    public byte[] getContractSignature() {
        return this.contractSignature;
    }

    @Nullable
    public byte[] getAccountAgeWitnessNonce() {
        return this.accountAgeWitnessNonce;
    }

    @Nullable
    public byte[] getAccountAgeWitnessSignature() {
        return this.accountAgeWitnessSignature;
    }

    public long getCurrentDate() {
        return this.currentDate;
    }

    @Nullable
    public byte[] getMediatedPayoutTxSignature() {
        return this.mediatedPayoutTxSignature;
    }

    @Nullable
    public String getReserveTxHash() {
        return this.reserveTxHash;
    }

    @Nullable
    public String getReserveTxHex() {
        return this.reserveTxHex;
    }

    @Nullable
    public String getReserveTxKey() {
        return this.reserveTxKey;
    }

    @Nullable
    public List<String> getReserveTxKeyImages() {
        return this.reserveTxKeyImages;
    }

    @Nullable
    public String getPreparedMultisigHex() {
        return this.preparedMultisigHex;
    }

    @Nullable
    public String getMadeMultisigHex() {
        return this.madeMultisigHex;
    }

    @Nullable
    public String getExchangedMultisigHex() {
        return this.exchangedMultisigHex;
    }

    @Nullable
    public String getDepositTxHash() {
        return this.depositTxHash;
    }

    @Nullable
    public String getDepositTxHex() {
        return this.depositTxHex;
    }

    @Nullable
    public String getDepositTxKey() {
        return this.depositTxKey;
    }

    @Nullable
    public String getUnsignedPayoutTxHex() {
        return this.unsignedPayoutTxHex;
    }

    @Nullable
    public String getUpdatedMultisigHex() {
        return this.updatedMultisigHex;
    }

    public ObjectProperty<MessageState> getDepositsConfirmedMessageStateProperty() {
        return this.depositsConfirmedMessageStateProperty;
    }

    public ObjectProperty<MessageState> getPaymentSentMessageStateProperty() {
        return this.paymentSentMessageStateProperty;
    }

    public ObjectProperty<MessageState> getPaymentReceivedMessageStateProperty() {
        return this.paymentReceivedMessageStateProperty;
    }

    public void setDepositTx(MoneroTxWallet depositTx) {
        this.depositTx = depositTx;
    }

    public void setTradeManager(TradeManager tradeManager) {
        this.tradeManager = tradeManager;
    }

    public void setNodeAddress(@Nullable haveno.network.p2p.NodeAddress nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public void setPubKeyRing(@Nullable PubKeyRing pubKeyRing) {
        this.pubKeyRing = pubKeyRing;
    }

    public void setAccountId(@Nullable String accountId) {
        this.accountId = accountId;
    }

    public void setPaymentAccountId(@Nullable String paymentAccountId) {
        this.paymentAccountId = paymentAccountId;
    }

    public void setPaymentMethodId(@Nullable String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public void setPaymentAccountPayloadHash(@Nullable byte[] paymentAccountPayloadHash) {
        this.paymentAccountPayloadHash = paymentAccountPayloadHash;
    }

    public void setEncryptedPaymentAccountPayload(@Nullable byte[] encryptedPaymentAccountPayload) {
        this.encryptedPaymentAccountPayload = encryptedPaymentAccountPayload;
    }

    public void setPaymentAccountKey(@Nullable byte[] paymentAccountKey) {
        this.paymentAccountKey = paymentAccountKey;
    }

    public void setPaymentAccountPayload(@Nullable haveno.core.payment.payload.PaymentAccountPayload paymentAccountPayload) {
        this.paymentAccountPayload = paymentAccountPayload;
    }

    public void setPayoutAddressString(@Nullable String payoutAddressString) {
        this.payoutAddressString = payoutAddressString;
    }

    public void setContractAsJson(@Nullable String contractAsJson) {
        this.contractAsJson = contractAsJson;
    }

    public void setContractSignature(@Nullable byte[] contractSignature) {
        this.contractSignature = contractSignature;
    }

    public void setAccountAgeWitnessNonce(@Nullable byte[] accountAgeWitnessNonce) {
        this.accountAgeWitnessNonce = accountAgeWitnessNonce;
    }

    public void setAccountAgeWitnessSignature(@Nullable byte[] accountAgeWitnessSignature) {
        this.accountAgeWitnessSignature = accountAgeWitnessSignature;
    }

    public void setCurrentDate(long currentDate) {
        this.currentDate = currentDate;
    }

    public void setMediatedPayoutTxSignature(@Nullable byte[] mediatedPayoutTxSignature) {
        this.mediatedPayoutTxSignature = mediatedPayoutTxSignature;
    }

    public void setReserveTxHash(@Nullable String reserveTxHash) {
        this.reserveTxHash = reserveTxHash;
    }

    public void setReserveTxHex(@Nullable String reserveTxHex) {
        this.reserveTxHex = reserveTxHex;
    }

    public void setReserveTxKey(@Nullable String reserveTxKey) {
        this.reserveTxKey = reserveTxKey;
    }

    public void setReserveTxKeyImages(@Nullable List<String> reserveTxKeyImages) {
        this.reserveTxKeyImages = reserveTxKeyImages;
    }

    public void setPreparedMultisigHex(@Nullable String preparedMultisigHex) {
        this.preparedMultisigHex = preparedMultisigHex;
    }

    public void setMadeMultisigHex(@Nullable String madeMultisigHex) {
        this.madeMultisigHex = madeMultisigHex;
    }

    public void setExchangedMultisigHex(@Nullable String exchangedMultisigHex) {
        this.exchangedMultisigHex = exchangedMultisigHex;
    }

    public void setDepositTxHash(@Nullable String depositTxHash) {
        this.depositTxHash = depositTxHash;
    }

    public void setDepositTxHex(@Nullable String depositTxHex) {
        this.depositTxHex = depositTxHex;
    }

    public void setDepositTxKey(@Nullable String depositTxKey) {
        this.depositTxKey = depositTxKey;
    }

    public void setUpdatedMultisigHex(@Nullable String updatedMultisigHex) {
        this.updatedMultisigHex = updatedMultisigHex;
    }

    @Deprecated
    public void setDepositsConfirmedMessageAcked(boolean depositsConfirmedMessageAcked) {
        this.depositsConfirmedMessageAcked = depositsConfirmedMessageAcked;
    }

    public void setDelayedPayoutTxSignature(@Nullable byte[] delayedPayoutTxSignature) {
        this.delayedPayoutTxSignature = delayedPayoutTxSignature;
    }

    public void setPreparedDepositTx(@Nullable byte[] preparedDepositTx) {
        this.preparedDepositTx = preparedDepositTx;
    }

    public void setPaymentSentMessage(@Nullable PaymentSentMessage paymentSentMessage) {
        this.paymentSentMessage = paymentSentMessage;
    }

    @Nullable
    public PaymentSentMessage getPaymentSentMessage() {
        return this.paymentSentMessage;
    }

    public void setPaymentReceivedMessage(@Nullable PaymentReceivedMessage paymentReceivedMessage) {
        this.paymentReceivedMessage = paymentReceivedMessage;
    }

    @Nullable
    public PaymentReceivedMessage getPaymentReceivedMessage() {
        return this.paymentReceivedMessage;
    }

    public void setDisputeClosedMessage(@Nullable DisputeClosedMessage disputeClosedMessage) {
        this.disputeClosedMessage = disputeClosedMessage;
    }

    @Nullable
    public DisputeClosedMessage getDisputeClosedMessage() {
        return this.disputeClosedMessage;
    }

    @Nullable
    public AccountAgeWitness getAccountAgeWitness() {
        return this.accountAgeWitness;
    }

    public void setAccountAgeWitness(@Nullable AccountAgeWitness accountAgeWitness) {
        this.accountAgeWitness = accountAgeWitness;
    }

    public void setUnsignedPayoutTxHex(@Nullable String unsignedPayoutTxHex) {
        this.unsignedPayoutTxHex = unsignedPayoutTxHex;
    }

    public void setDepositsConfirmedMessageStateProperty(ObjectProperty<MessageState> depositsConfirmedMessageStateProperty) {
        this.depositsConfirmedMessageStateProperty = depositsConfirmedMessageStateProperty;
    }

    public void setPaymentSentMessageStateProperty(ObjectProperty<MessageState> paymentSentMessageStateProperty) {
        this.paymentSentMessageStateProperty = paymentSentMessageStateProperty;
    }

    public void setPaymentReceivedMessageStateProperty(ObjectProperty<MessageState> paymentReceivedMessageStateProperty) {
        this.paymentReceivedMessageStateProperty = paymentReceivedMessageStateProperty;
    }
}

