/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import com.google.common.base.Preconditions;
import haveno.common.taskrunner.Task;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.TradeProtocol;
import haveno.core.trade.protocol.TradeTaskRunner;
import haveno.core.util.Validator;
import haveno.network.p2p.NodeAddress;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentProtocol {
    private final TradeProtocol tradeProtocol;
    private Condition condition;
    private Setup setup;
    private Consumer<Condition.Result> resultHandler;

    public FluentProtocol(TradeProtocol tradeProtocol) {
        this.tradeProtocol = tradeProtocol;
    }

    protected FluentProtocol condition(Condition condition) {
        this.condition = condition;
        return this;
    }

    protected FluentProtocol setup(Setup setup) {
        this.setup = setup;
        return this;
    }

    public FluentProtocol resultHandler(Consumer<Condition.Result> resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public FluentProtocol run(Runnable runnable) {
        Condition.Result result = this.condition.getResult();
        if (result.isValid) {
            runnable.run();
        } else if (this.resultHandler != null) {
            this.resultHandler.accept(result);
        }
        return this;
    }

    public FluentProtocol executeTasks(boolean newThread) {
        if (newThread) {
            new Thread(() -> this.executeTasks()).start();
        } else {
            this.executeTasks();
        }
        return this;
    }

    public FluentProtocol executeTasks() {
        TradeMessage message;
        NodeAddress peer;
        Condition.Result result = this.condition.getResult();
        if (!result.isValid) {
            if (this.resultHandler != null) {
                this.resultHandler.accept(result);
            }
            return this;
        }
        if (this.setup.getTimeoutSec() > 0) {
            this.tradeProtocol.startTimeout(this.setup.getTimeoutSec());
        }
        if ((peer = this.condition.getPeer()) != null) {
            this.tradeProtocol.processModel.setTempTradePeerNodeAddress(peer);
            this.tradeProtocol.processModel.getTradeManager().requestPersistence();
        }
        if ((message = this.condition.getMessage()) != null) {
            this.tradeProtocol.processModel.setTradeMessage(message);
            this.tradeProtocol.processModel.getTradeManager().requestPersistence();
        }
        TradeTaskRunner taskRunner = this.setup.getTaskRunner(peer, message, this.condition.getEvent());
        taskRunner.addTasks(this.setup.getTasks());
        taskRunner.run();
        return this;
    }

    public static class Condition {
        private static final Logger log = LoggerFactory.getLogger(Condition.class);
        private final Set<Trade.Phase> expectedPhases = new HashSet<Trade.Phase>();
        private final Set<Trade.State> expectedStates = new HashSet<Trade.State>();
        private final Set<Boolean> preConditions = new HashSet<Boolean>();
        private final Trade trade;
        @Nullable
        private Result result;
        @Nullable
        private TradeMessage message;
        @Nullable
        private Event event;
        @Nullable
        private NodeAddress peer;
        @Nullable
        private Runnable preConditionFailedHandler;

        public Condition(Trade trade) {
            this.trade = trade;
        }

        public Condition phase(Trade.Phase expectedPhase) {
            Preconditions.checkArgument((this.result == null ? 1 : 0) != 0);
            this.expectedPhases.add(expectedPhase);
            return this;
        }

        public Condition anyPhase(Trade.Phase ... expectedPhases) {
            Preconditions.checkArgument((this.result == null ? 1 : 0) != 0);
            this.expectedPhases.addAll(Set.of(expectedPhases));
            return this;
        }

        public Condition state(Trade.State state) {
            Preconditions.checkArgument((this.result == null ? 1 : 0) != 0);
            this.expectedStates.add(state);
            return this;
        }

        public Condition anyState(Trade.State ... states) {
            Preconditions.checkArgument((this.result == null ? 1 : 0) != 0);
            this.expectedStates.addAll(Set.of(states));
            return this;
        }

        public Condition with(TradeMessage message) {
            Preconditions.checkArgument((this.result == null ? 1 : 0) != 0);
            this.message = message;
            return this;
        }

        public Condition with(Event event) {
            Preconditions.checkArgument((this.result == null ? 1 : 0) != 0);
            this.event = event;
            return this;
        }

        public Condition from(NodeAddress peer) {
            Preconditions.checkArgument((this.result == null ? 1 : 0) != 0);
            this.peer = peer;
            return this;
        }

        public Condition preCondition(boolean preCondition) {
            Preconditions.checkArgument((this.result == null ? 1 : 0) != 0);
            this.preConditions.add(preCondition);
            return this;
        }

        public Condition preCondition(boolean preCondition, Runnable conditionFailedHandler) {
            Preconditions.checkArgument((this.result == null ? 1 : 0) != 0);
            this.preCondition(preCondition);
            this.preConditionFailedHandler = conditionFailedHandler;
            return this;
        }

        public Result getResult() {
            if (this.result == null) {
                boolean isTradeIdValid;
                boolean bl = isTradeIdValid = this.message == null || Validator.isTradeIdValid(this.trade.getId(), this.message);
                if (!isTradeIdValid) {
                    String info = MessageFormat.format("TradeId does not match tradeId in message, TradeId={0}, tradeId in message={1}", this.trade.getId(), this.message.getOfferId());
                    this.result = Result.INVALID_TRADE_ID.info(info);
                    return this.result;
                }
                Result phaseValidationResult = this.getPhaseResult();
                if (!phaseValidationResult.isValid) {
                    this.result = phaseValidationResult;
                    return this.result;
                }
                Result stateResult = this.getStateResult();
                if (!stateResult.isValid) {
                    this.result = stateResult;
                    return this.result;
                }
                boolean allPreConditionsMet = this.preConditions.stream().allMatch(e -> e);
                if (!allPreConditionsMet) {
                    String info = MessageFormat.format("PreConditions not met. preConditions={0}, this={1}, tradeId={2}", this.preConditions, this, this.trade.getId());
                    this.result = Result.INVALID_PRE_CONDITION.info(info);
                    if (this.preConditionFailedHandler != null) {
                        this.preConditionFailedHandler.run();
                    }
                    return this.result;
                }
                this.result = Result.VALID;
            }
            return this.result;
        }

        private Result getPhaseResult() {
            String trigger;
            if (this.expectedPhases.isEmpty()) {
                return Result.VALID;
            }
            boolean isPhaseValid = this.expectedPhases.stream().anyMatch(e -> e == this.trade.getPhase());
            String string = this.message != null ? ((Object)((Object)this.message)).getClass().getSimpleName() : (trigger = this.event != null ? this.event.name() + " event" : "");
            if (isPhaseValid) {
                String info = MessageFormat.format("We received a {0} at phase {1} and state {2}, tradeId={3}, peer={4}", new Object[]{trigger, this.trade.getPhase(), this.trade.getState(), this.trade.getId(), this.peer});
                log.info(info);
                return Result.VALID.info(info);
            }
            String info = MessageFormat.format("We received a {0} but we are are not in the expected phase.\nThis can be an expected case if we get a repeated PaymentSentMessage after we have already received one as the peer re-sends that message at each startup.\nExpected phases={1},\nTrade phase={2},\nTrade state= {3},\ntradeId={4}", new Object[]{trigger, this.expectedPhases, this.trade.getPhase(), this.trade.getState(), this.trade.getId()});
            return Result.INVALID_PHASE.info(info);
        }

        private Result getStateResult() {
            String trigger;
            if (this.expectedStates.isEmpty()) {
                return Result.VALID;
            }
            boolean isStateValid = this.expectedStates.stream().anyMatch(e -> e == this.trade.getState());
            String string = this.message != null ? ((Object)((Object)this.message)).getClass().getSimpleName() : (trigger = this.event != null ? this.event.name() + " event" : "");
            if (isStateValid) {
                String info = MessageFormat.format("We received a {0} at state {1}, tradeId={2}", new Object[]{trigger, this.trade.getState(), this.trade.getId()});
                log.info(info);
                return Result.VALID.info(info);
            }
            String info = MessageFormat.format("We received a {0} but we are not in the expected state. Expected states={1}, Trade state= {2}, tradeId={3}", new Object[]{trigger, this.expectedStates, this.trade.getState(), this.trade.getId()});
            return Result.INVALID_STATE.info(info);
        }

        @Nullable
        public TradeMessage getMessage() {
            return this.message;
        }

        @Nullable
        public Event getEvent() {
            return this.event;
        }

        @Nullable
        public NodeAddress getPeer() {
            return this.peer;
        }

        static enum Result {
            VALID(true),
            INVALID_PHASE,
            INVALID_STATE,
            INVALID_PRE_CONDITION,
            INVALID_TRADE_ID;

            private boolean isValid;
            private String info;

            private Result() {
            }

            private Result(boolean isValid) {
                this.isValid = isValid;
            }

            public Result info(String info) {
                this.info = info;
                return this;
            }

            public boolean isValid() {
                return this.isValid;
            }

            public String getInfo() {
                return this.info;
            }
        }
    }

    public static class Setup {
        private static final Logger log = LoggerFactory.getLogger(Setup.class);
        private final TradeProtocol tradeProtocol;
        private final Trade trade;
        private Class<? extends Task<Trade>>[] tasks;
        private int timeoutSec;
        @Nullable
        private TradeTaskRunner taskRunner;

        public Setup(TradeProtocol tradeProtocol, Trade trade) {
            this.tradeProtocol = tradeProtocol;
            this.trade = trade;
        }

        @SafeVarargs
        public final Setup tasks(Class<? extends Task<Trade>> ... tasks) {
            this.tasks = tasks;
            return this;
        }

        public Setup withTimeout(int timeoutSec) {
            this.timeoutSec = timeoutSec;
            return this;
        }

        public Setup using(TradeTaskRunner taskRunner) {
            this.taskRunner = taskRunner;
            return this;
        }

        public TradeTaskRunner getTaskRunner(NodeAddress sender, @Nullable TradeMessage message, @Nullable Event event) {
            if (this.taskRunner == null) {
                if (message != null) {
                    this.taskRunner = new TradeTaskRunner(this.trade, () -> this.tradeProtocol.handleTaskRunnerSuccess(sender, message), errorMessage -> this.tradeProtocol.handleTaskRunnerFault(sender, message, errorMessage));
                } else if (event != null) {
                    this.taskRunner = new TradeTaskRunner(this.trade, () -> this.tradeProtocol.handleTaskRunnerSuccess(event), errorMessage -> this.tradeProtocol.handleTaskRunnerFault(event, errorMessage));
                } else {
                    throw new IllegalStateException("addTasks must not be called without message or event set in case no taskRunner has been created yet");
                }
            }
            return this.taskRunner;
        }

        public Class<? extends Task<Trade>>[] getTasks() {
            return this.tasks;
        }

        public int getTimeoutSec() {
            return this.timeoutSec;
        }
    }

    static interface Event {
        public String name();
    }
}

