/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.MediatedPayoutTxPublishedMessage;
import haveno.core.trade.messages.MediatedPayoutTxSignatureMessage;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.FluentProtocol;
import haveno.core.trade.protocol.TradeProtocol;
import haveno.core.trade.protocol.TradeTaskRunner;
import haveno.core.trade.protocol.tasks.ApplyFilter;
import haveno.core.trade.protocol.tasks.mediation.FinalizeMediatedPayoutTx;
import haveno.core.trade.protocol.tasks.mediation.ProcessMediatedPayoutSignatureMessage;
import haveno.core.trade.protocol.tasks.mediation.ProcessMediatedPayoutTxPublishedMessage;
import haveno.core.trade.protocol.tasks.mediation.SendMediatedPayoutSignatureMessage;
import haveno.core.trade.protocol.tasks.mediation.SendMediatedPayoutTxPublishedMessage;
import haveno.core.trade.protocol.tasks.mediation.SetupMediatedPayoutTxListener;
import haveno.core.trade.protocol.tasks.mediation.SignMediatedPayoutTx;
import haveno.network.p2p.NodeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DisputeProtocol
extends TradeProtocol {
    private static final Logger log = LoggerFactory.getLogger(DisputeProtocol.class);

    public DisputeProtocol(Trade trade) {
        super(trade);
    }

    @Override
    protected void onTradeMessage(TradeMessage message, NodeAddress peer) {
        super.onTradeMessage(message, peer);
        if (message instanceof MediatedPayoutTxSignatureMessage) {
            this.handle((MediatedPayoutTxSignatureMessage)message, peer);
        } else if (message instanceof MediatedPayoutTxPublishedMessage) {
            this.handle((MediatedPayoutTxPublishedMessage)message, peer);
        }
    }

    @Override
    protected void onMailboxMessage(TradeMessage message, NodeAddress peer) {
        super.onMailboxMessage(message, peer);
        if (message instanceof MediatedPayoutTxSignatureMessage) {
            this.handle((MediatedPayoutTxSignatureMessage)message, peer);
        } else if (message instanceof MediatedPayoutTxPublishedMessage) {
            this.handle((MediatedPayoutTxPublishedMessage)message, peer);
        }
    }

    public void onAcceptMediationResult(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        DisputeEvent event = DisputeEvent.MEDIATION_RESULT_ACCEPTED;
        this.expect(this.anyPhase(Trade.Phase.DEPOSITS_UNLOCKED, Trade.Phase.DEPOSITS_FINALIZED, Trade.Phase.PAYMENT_SENT, Trade.Phase.PAYMENT_RECEIVED).with(event).preCondition(this.trade.getTradePeer().getMediatedPayoutTxSignature() == null, () -> errorMessageHandler.handleErrorMessage("We have received already the signature from the peer.")).preCondition(this.trade.getPayoutTx() == null, () -> errorMessageHandler.handleErrorMessage("Payout tx is already published."))).setup(this.tasks(ApplyFilter.class, SignMediatedPayoutTx.class, SendMediatedPayoutSignatureMessage.class, SetupMediatedPayoutTxListener.class).using(new TradeTaskRunner(this.trade, () -> {
            resultHandler.handleResult();
            this.handleTaskRunnerSuccess(event);
        }, errorMessage -> {
            errorMessageHandler.handleErrorMessage(errorMessage);
            this.handleTaskRunnerFault(event, errorMessage);
        }))).executeTasks();
    }

    public void onFinalizeMediationResultPayout(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        DisputeEvent event = DisputeEvent.MEDIATION_RESULT_ACCEPTED;
        this.expect(this.anyPhase(Trade.Phase.DEPOSITS_UNLOCKED, Trade.Phase.DEPOSITS_FINALIZED, Trade.Phase.PAYMENT_SENT, Trade.Phase.PAYMENT_RECEIVED).with(event).preCondition(this.trade.getPayoutTx() == null, () -> errorMessageHandler.handleErrorMessage("Payout tx is already published."))).setup(this.tasks(ApplyFilter.class, SignMediatedPayoutTx.class, FinalizeMediatedPayoutTx.class, SendMediatedPayoutTxPublishedMessage.class).using(new TradeTaskRunner(this.trade, () -> {
            resultHandler.handleResult();
            this.handleTaskRunnerSuccess(event);
        }, errorMessage -> {
            errorMessageHandler.handleErrorMessage(errorMessage);
            this.handleTaskRunnerFault(event, errorMessage);
        }))).executeTasks();
    }

    protected void handle(MediatedPayoutTxSignatureMessage message, NodeAddress peer) {
        this.expect(this.anyPhase(Trade.Phase.DEPOSITS_UNLOCKED, Trade.Phase.DEPOSITS_FINALIZED, Trade.Phase.PAYMENT_SENT, Trade.Phase.PAYMENT_RECEIVED).with(message).from(peer)).setup(this.tasks(ProcessMediatedPayoutSignatureMessage.class)).executeTasks();
    }

    protected void handle(MediatedPayoutTxPublishedMessage message, NodeAddress peer) {
        this.expect(this.anyPhase(Trade.Phase.DEPOSITS_UNLOCKED, Trade.Phase.DEPOSITS_FINALIZED, Trade.Phase.PAYMENT_SENT, Trade.Phase.PAYMENT_RECEIVED).with(message).from(peer)).setup(this.tasks(ProcessMediatedPayoutTxPublishedMessage.class)).executeTasks();
    }

    static enum DisputeEvent implements FluentProtocol.Event
    {
        MEDIATION_RESULT_ACCEPTED,
        MEDIATION_RESULT_REJECTED,
        ARBITRATION_REQUESTED;

    }
}

