/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.protocol;

import haveno.common.ThreadUtils;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.DepositRequest;
import haveno.core.trade.messages.DepositResponse;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.messages.SignContractResponse;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.DisputeProtocol;
import haveno.core.trade.protocol.TradeTaskRunner;
import haveno.core.trade.protocol.tasks.ApplyFilter;
import haveno.core.trade.protocol.tasks.ArbitratorProcessDepositRequest;
import haveno.core.trade.protocol.tasks.ArbitratorProcessReserveTx;
import haveno.core.trade.protocol.tasks.ArbitratorSendInitTradeOrMultisigRequests;
import haveno.core.trade.protocol.tasks.ProcessInitTradeRequest;
import haveno.core.trade.protocol.tasks.SendDepositsConfirmedMessageToBuyer;
import haveno.core.trade.protocol.tasks.SendDepositsConfirmedMessageToSeller;
import haveno.core.trade.protocol.tasks.TradeTask;
import haveno.core.util.Validator;
import haveno.network.p2p.NodeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbitratorProtocol
extends DisputeProtocol {
    private static final Logger log = LoggerFactory.getLogger(ArbitratorProtocol.class);

    public ArbitratorProtocol(ArbitratorTrade trade) {
        super(trade);
    }

    @Override
    protected void onTradeMessage(TradeMessage message, NodeAddress peer) {
        super.onTradeMessage(message, peer);
    }

    @Override
    public void onMailboxMessage(TradeMessage message, NodeAddress peer) {
        super.onMailboxMessage(message, peer);
    }

    public void handleInitTradeRequest(InitTradeRequest message, NodeAddress peer, ErrorMessageHandler errorMessageHandler) {
        log.info("handleInitTradeRequest() for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getShortId());
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                this.latchTrade();
                this.errorMessageHandler = errorMessageHandler;
                this.processModel.setTradeMessage(message);
                this.expect(this.phase(Trade.Phase.INIT).with(message).from(peer)).setup(this.tasks(ApplyFilter.class, ProcessInitTradeRequest.class, ArbitratorProcessReserveTx.class, ArbitratorSendInitTradeOrMultisigRequests.class).using(new TradeTaskRunner(this.trade, () -> {
                    this.startTimeout();
                    this.handleTaskRunnerSuccess(peer, message);
                }, errorMessage -> this.handleTaskRunnerFault(peer, message, errorMessage))).withTimeout(TRADE_STEP_TIMEOUT_SECONDS)).executeTasks(true);
                this.awaitTradeLatch();
            }
        }, (String)this.trade.getId());
    }

    @Override
    public void handleSignContractResponse(SignContractResponse message, NodeAddress sender) {
        log.warn("Arbitrator ignoring SignContractResponse");
    }

    public void handleDepositRequest(DepositRequest request, NodeAddress sender) {
        log.info("handleDepositRequest() for {} {}", (Object)this.trade.getClass().getSimpleName(), (Object)this.trade.getShortId());
        ThreadUtils.execute(() -> {
            Object object = this.trade.getLock();
            synchronized (object) {
                this.latchTrade();
                Validator.checkTradeId(this.processModel.getOfferId(), request);
                this.processModel.setTradeMessage(request);
                this.expect(this.anyPhase(Trade.Phase.INIT, Trade.Phase.DEPOSIT_REQUESTED).with(request).from(sender)).setup(this.tasks(ArbitratorProcessDepositRequest.class).using(new TradeTaskRunner(this.trade, () -> {
                    if (this.trade.getState().ordinal() >= Trade.State.ARBITRATOR_PUBLISHED_DEPOSIT_TXS.ordinal()) {
                        this.stopTimeout();
                        this.errorMessageHandler = null;
                    }
                    this.handleTaskRunnerSuccess(sender, request);
                }, errorMessage -> this.handleTaskRunnerFault(sender, request, errorMessage)))).executeTasks(true);
                this.awaitTradeLatch();
            }
        }, (String)this.trade.getId());
    }

    @Override
    public void handleDepositResponse(DepositResponse response, NodeAddress sender) {
        log.warn("Arbitrator ignoring DepositResponse for trade " + response.getOfferId());
    }

    @Override
    public Class<? extends TradeTask>[] getDepositsConfirmedTasks() {
        return new Class[]{SendDepositsConfirmedMessageToBuyer.class, SendDepositsConfirmedMessageToSeller.class};
    }

    @Override
    public void handleError(String errorMessage) {
        if (this.trade instanceof ArbitratorTrade && this.trade.getState() == Trade.State.SAW_ARRIVED_PUBLISH_DEPOSIT_TX_REQUEST) {
            this.trade.setStateIfValidTransitionTo(Trade.State.PUBLISH_DEPOSIT_TX_REQUEST_FAILED);
        }
        super.handleError(errorMessage);
    }
}

