/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import com.google.protobuf.ByteString;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.Utilities;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.messages.TradeMessage;
import haveno.network.p2p.DirectMessage;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import protobuf.NetworkEnvelope;
import protobuf.SignContractRequest;

public final class SignContractRequest
extends TradeMessage
implements DirectMessage {
    private final long currentDate;
    private final String accountId;
    private final byte[] paymentAccountPayloadHash;
    private final String payoutAddress;
    @Nullable
    private final String depositTxHash;
    @Nullable
    private final byte[] accountAgeWitnessSignatureOfDepositHash;

    public SignContractRequest(String tradeId, String uid, String messageVersion, long currentDate, String accountId, byte[] paymentAccountPayloadHash, String payoutAddress, @Nullable String depositTxHash, @Nullable byte[] accountAgeWitnessSignatureOfDepositHash) {
        super(messageVersion, tradeId, uid);
        this.currentDate = currentDate;
        this.accountId = accountId;
        this.paymentAccountPayloadHash = paymentAccountPayloadHash;
        this.payoutAddress = payoutAddress;
        this.depositTxHash = depositTxHash;
        this.accountAgeWitnessSignatureOfDepositHash = accountAgeWitnessSignatureOfDepositHash;
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        SignContractRequest.Builder builder = protobuf.SignContractRequest.newBuilder().setTradeId(this.offerId).setUid(this.uid).setAccountId(this.accountId).setPaymentAccountPayloadHash(ByteString.copyFrom((byte[])this.paymentAccountPayloadHash)).setPayoutAddress(this.payoutAddress);
        Optional.ofNullable(this.accountAgeWitnessSignatureOfDepositHash).ifPresent(e -> builder.setAccountAgeWitnessSignatureOfDepositHash(ByteString.copyFrom((byte[])e)));
        Optional.ofNullable(this.depositTxHash).ifPresent(arg_0 -> ((SignContractRequest.Builder)builder).setDepositTxHash(arg_0));
        builder.setCurrentDate(this.currentDate);
        return this.getNetworkEnvelopeBuilder().setSignContractRequest(builder).build();
    }

    public static SignContractRequest fromProto(protobuf.SignContractRequest proto, CoreProtoResolver coreProtoResolver, String messageVersion) {
        return new SignContractRequest(proto.getTradeId(), proto.getUid(), messageVersion, proto.getCurrentDate(), proto.getAccountId(), proto.getPaymentAccountPayloadHash().toByteArray(), proto.getPayoutAddress(), ProtoUtil.stringOrNullFromProto((String)proto.getDepositTxHash()), ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getAccountAgeWitnessSignatureOfDepositHash()));
    }

    @Override
    public String toString() {
        return "SignContractRequest {,\n     currentDate=" + this.currentDate + ",\n     accountId=" + this.accountId + ",\n     paymentAccountPayloadHash='" + Utilities.bytesAsHexString((byte[])this.paymentAccountPayloadHash) + ",\n     payoutAddress='" + this.payoutAddress + ",\n     depositTxHash='" + this.depositTxHash + ",\n     accountAgeWitnessSignatureOfDepositHash='" + Utilities.bytesAsHexString((byte[])this.accountAgeWitnessSignatureOfDepositHash) + "\n} " + super.toString();
    }

    public long getCurrentDate() {
        return this.currentDate;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public byte[] getPaymentAccountPayloadHash() {
        return this.paymentAccountPayloadHash;
    }

    public String getPayoutAddress() {
        return this.payoutAddress;
    }

    @Nullable
    public String getDepositTxHash() {
        return this.depositTxHash;
    }

    @Nullable
    public byte[] getAccountAgeWitnessSignatureOfDepositHash() {
        return this.accountAgeWitnessSignatureOfDepositHash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignContractRequest)) {
            return false;
        }
        SignContractRequest other = (SignContractRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrentDate() != other.getCurrentDate()) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        if (!Arrays.equals(this.getPaymentAccountPayloadHash(), other.getPaymentAccountPayloadHash())) {
            return false;
        }
        String this$payoutAddress = this.getPayoutAddress();
        String other$payoutAddress = other.getPayoutAddress();
        if (this$payoutAddress == null ? other$payoutAddress != null : !this$payoutAddress.equals(other$payoutAddress)) {
            return false;
        }
        String this$depositTxHash = this.getDepositTxHash();
        String other$depositTxHash = other.getDepositTxHash();
        if (this$depositTxHash == null ? other$depositTxHash != null : !this$depositTxHash.equals(other$depositTxHash)) {
            return false;
        }
        return Arrays.equals(this.getAccountAgeWitnessSignatureOfDepositHash(), other.getAccountAgeWitnessSignatureOfDepositHash());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SignContractRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $currentDate = this.getCurrentDate();
        result = result * 59 + (int)($currentDate >>> 32 ^ $currentDate);
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPaymentAccountPayloadHash());
        String $payoutAddress = this.getPayoutAddress();
        result = result * 59 + ($payoutAddress == null ? 43 : $payoutAddress.hashCode());
        String $depositTxHash = this.getDepositTxHash();
        result = result * 59 + ($depositTxHash == null ? 43 : $depositTxHash.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAccountAgeWitnessSignatureOfDepositHash());
        return result;
    }
}

