/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import com.google.protobuf.ByteString;
import haveno.common.app.Version;
import haveno.common.proto.ProtoUtil;
import haveno.core.trade.messages.TradeMailboxMessage;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import protobuf.AccountAgeWitness;
import protobuf.NetworkEnvelope;
import protobuf.NodeAddress;
import protobuf.PaymentSentMessage;

public final class PaymentSentMessage
extends TradeMailboxMessage {
    private final haveno.network.p2p.NodeAddress senderNodeAddress;
    @Nullable
    private final String counterCurrencyTxId;
    @Nullable
    private final String payoutTxHex;
    @Nullable
    private final String updatedMultisigHex;
    @Nullable
    private final byte[] paymentAccountKey;
    @Nullable
    private haveno.core.account.witness.AccountAgeWitness sellerAccountAgeWitness;
    @Nullable
    private byte[] buyerSignature;
    @Nullable
    private String counterCurrencyExtraData;

    public PaymentSentMessage(String tradeId, haveno.network.p2p.NodeAddress senderNodeAddress, @Nullable String counterCurrencyTxId, @Nullable String counterCurrencyExtraData, String uid, @Nullable String signedPayoutTxHex, @Nullable String updatedMultisigHex, @Nullable byte[] paymentAccountKey, haveno.core.account.witness.AccountAgeWitness sellerAccountAgeWitness) {
        this(tradeId, senderNodeAddress, counterCurrencyTxId, counterCurrencyExtraData, uid, Version.getP2PMessageVersion(), signedPayoutTxHex, updatedMultisigHex, paymentAccountKey, sellerAccountAgeWitness);
    }

    private PaymentSentMessage(String tradeId, haveno.network.p2p.NodeAddress senderNodeAddress, @Nullable String counterCurrencyTxId, @Nullable String counterCurrencyExtraData, String uid, String messageVersion, @Nullable String signedPayoutTxHex, @Nullable String updatedMultisigHex, @Nullable byte[] paymentAccountKey, haveno.core.account.witness.AccountAgeWitness sellerAccountAgeWitness) {
        super(messageVersion, tradeId, uid);
        this.senderNodeAddress = senderNodeAddress;
        this.counterCurrencyTxId = counterCurrencyTxId;
        this.counterCurrencyExtraData = counterCurrencyExtraData;
        this.payoutTxHex = signedPayoutTxHex;
        this.updatedMultisigHex = updatedMultisigHex;
        this.paymentAccountKey = paymentAccountKey;
        this.sellerAccountAgeWitness = sellerAccountAgeWitness;
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        PaymentSentMessage.Builder builder = protobuf.PaymentSentMessage.newBuilder();
        builder.setTradeId(this.offerId).setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setUid(this.uid);
        Optional.ofNullable(this.counterCurrencyTxId).ifPresent(e -> builder.setCounterCurrencyTxId(this.counterCurrencyTxId));
        Optional.ofNullable(this.counterCurrencyExtraData).ifPresent(e -> builder.setCounterCurrencyExtraData(this.counterCurrencyExtraData));
        Optional.ofNullable(this.payoutTxHex).ifPresent(e -> builder.setPayoutTxHex(this.payoutTxHex));
        Optional.ofNullable(this.updatedMultisigHex).ifPresent(e -> builder.setUpdatedMultisigHex(this.updatedMultisigHex));
        Optional.ofNullable(this.paymentAccountKey).ifPresent(e -> builder.setPaymentAccountKey(ByteString.copyFrom((byte[])e)));
        Optional.ofNullable(this.buyerSignature).ifPresent(e -> builder.setBuyerSignature(ByteString.copyFrom((byte[])e)));
        Optional.ofNullable(this.sellerAccountAgeWitness).ifPresent(e -> builder.setSellerAccountAgeWitness(this.sellerAccountAgeWitness.toProtoAccountAgeWitness()));
        return this.getNetworkEnvelopeBuilder().setPaymentSentMessage(builder).build();
    }

    public static PaymentSentMessage fromProto(protobuf.PaymentSentMessage proto, String messageVersion) {
        AccountAgeWitness protoAccountAgeWitness = proto.getSellerAccountAgeWitness();
        haveno.core.account.witness.AccountAgeWitness accountAgeWitness = protoAccountAgeWitness.getHash().isEmpty() ? null : haveno.core.account.witness.AccountAgeWitness.fromProto(protoAccountAgeWitness);
        PaymentSentMessage message = new PaymentSentMessage(proto.getTradeId(), haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getSenderNodeAddress()), ProtoUtil.stringOrNullFromProto((String)proto.getCounterCurrencyTxId()), ProtoUtil.stringOrNullFromProto((String)proto.getCounterCurrencyExtraData()), proto.getUid(), messageVersion, ProtoUtil.stringOrNullFromProto((String)proto.getPayoutTxHex()), ProtoUtil.stringOrNullFromProto((String)proto.getUpdatedMultisigHex()), ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getPaymentAccountKey()), accountAgeWitness);
        message.setBuyerSignature(ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getBuyerSignature()));
        return message;
    }

    @Override
    public String toString() {
        return "PaymentSentMessage{,\n     tradeId=" + this.offerId + ",\n     uid='" + this.uid + "',\n     senderNodeAddress=" + String.valueOf(this.senderNodeAddress) + ",\n     counterCurrencyTxId=" + this.counterCurrencyTxId + ",\n     counterCurrencyExtraData=" + this.counterCurrencyExtraData + ",\n     payoutTxHex=" + this.payoutTxHex + ",\n     updatedMultisigHex=" + this.updatedMultisigHex + ",\n     paymentAccountKey=" + String.valueOf(this.paymentAccountKey) + ",\n     buyerSignature=" + String.valueOf(this.buyerSignature) + "\n} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentSentMessage)) {
            return false;
        }
        PaymentSentMessage other = (PaymentSentMessage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        haveno.network.p2p.NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        haveno.network.p2p.NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !this$senderNodeAddress.equals(other$senderNodeAddress)) {
            return false;
        }
        String this$counterCurrencyTxId = this.getCounterCurrencyTxId();
        String other$counterCurrencyTxId = other.getCounterCurrencyTxId();
        if (this$counterCurrencyTxId == null ? other$counterCurrencyTxId != null : !this$counterCurrencyTxId.equals(other$counterCurrencyTxId)) {
            return false;
        }
        String this$payoutTxHex = this.getPayoutTxHex();
        String other$payoutTxHex = other.getPayoutTxHex();
        if (this$payoutTxHex == null ? other$payoutTxHex != null : !this$payoutTxHex.equals(other$payoutTxHex)) {
            return false;
        }
        String this$updatedMultisigHex = this.getUpdatedMultisigHex();
        String other$updatedMultisigHex = other.getUpdatedMultisigHex();
        if (this$updatedMultisigHex == null ? other$updatedMultisigHex != null : !this$updatedMultisigHex.equals(other$updatedMultisigHex)) {
            return false;
        }
        if (!Arrays.equals(this.getPaymentAccountKey(), other.getPaymentAccountKey())) {
            return false;
        }
        haveno.core.account.witness.AccountAgeWitness this$sellerAccountAgeWitness = this.getSellerAccountAgeWitness();
        haveno.core.account.witness.AccountAgeWitness other$sellerAccountAgeWitness = other.getSellerAccountAgeWitness();
        if (this$sellerAccountAgeWitness == null ? other$sellerAccountAgeWitness != null : !((Object)this$sellerAccountAgeWitness).equals(other$sellerAccountAgeWitness)) {
            return false;
        }
        if (!Arrays.equals(this.getBuyerSignature(), other.getBuyerSignature())) {
            return false;
        }
        String this$counterCurrencyExtraData = this.getCounterCurrencyExtraData();
        String other$counterCurrencyExtraData = other.getCounterCurrencyExtraData();
        return !(this$counterCurrencyExtraData == null ? other$counterCurrencyExtraData != null : !this$counterCurrencyExtraData.equals(other$counterCurrencyExtraData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PaymentSentMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        haveno.network.p2p.NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : $senderNodeAddress.hashCode());
        String $counterCurrencyTxId = this.getCounterCurrencyTxId();
        result = result * 59 + ($counterCurrencyTxId == null ? 43 : $counterCurrencyTxId.hashCode());
        String $payoutTxHex = this.getPayoutTxHex();
        result = result * 59 + ($payoutTxHex == null ? 43 : $payoutTxHex.hashCode());
        String $updatedMultisigHex = this.getUpdatedMultisigHex();
        result = result * 59 + ($updatedMultisigHex == null ? 43 : $updatedMultisigHex.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPaymentAccountKey());
        haveno.core.account.witness.AccountAgeWitness $sellerAccountAgeWitness = this.getSellerAccountAgeWitness();
        result = result * 59 + ($sellerAccountAgeWitness == null ? 43 : ((Object)$sellerAccountAgeWitness).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBuyerSignature());
        String $counterCurrencyExtraData = this.getCounterCurrencyExtraData();
        result = result * 59 + ($counterCurrencyExtraData == null ? 43 : $counterCurrencyExtraData.hashCode());
        return result;
    }

    public haveno.network.p2p.NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    @Nullable
    public String getCounterCurrencyTxId() {
        return this.counterCurrencyTxId;
    }

    @Nullable
    public String getPayoutTxHex() {
        return this.payoutTxHex;
    }

    @Nullable
    public String getUpdatedMultisigHex() {
        return this.updatedMultisigHex;
    }

    @Nullable
    public byte[] getPaymentAccountKey() {
        return this.paymentAccountKey;
    }

    @Nullable
    public haveno.core.account.witness.AccountAgeWitness getSellerAccountAgeWitness() {
        return this.sellerAccountAgeWitness;
    }

    @Nullable
    public byte[] getBuyerSignature() {
        return this.buyerSignature;
    }

    @Nullable
    public String getCounterCurrencyExtraData() {
        return this.counterCurrencyExtraData;
    }

    public void setBuyerSignature(@Nullable byte[] buyerSignature) {
        this.buyerSignature = buyerSignature;
    }
}

