/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import com.google.protobuf.ByteString;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.Utilities;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.messages.TradeProtocolVersion;
import haveno.network.p2p.DirectMessage;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import protobuf.InitTradeRequest;
import protobuf.NetworkEnvelope;
import protobuf.NodeAddress;
import protobuf.PubKeyRing;

public final class InitTradeRequest
extends TradeMessage
implements DirectMessage {
    private final TradeProtocolVersion tradeProtocolVersion;
    private final long tradeAmount;
    private final long tradePrice;
    private final String paymentMethodId;
    @Nullable
    private final String makerAccountId;
    private final String takerAccountId;
    private final String makerPaymentAccountId;
    private final String takerPaymentAccountId;
    private final haveno.common.crypto.PubKeyRing takerPubKeyRing;
    @Nullable
    private final byte[] accountAgeWitnessSignatureOfOfferId;
    private final long currentDate;
    private final haveno.network.p2p.NodeAddress makerNodeAddress;
    private final haveno.network.p2p.NodeAddress takerNodeAddress;
    @Nullable
    private final haveno.network.p2p.NodeAddress arbitratorNodeAddress;
    @Nullable
    private final String reserveTxHash;
    @Nullable
    private final String reserveTxHex;
    @Nullable
    private final String reserveTxKey;
    @Nullable
    private final String payoutAddress;
    @Nullable
    private final String challenge;

    public InitTradeRequest(TradeProtocolVersion tradeProtocolVersion, String offerId, long tradeAmount, long tradePrice, String paymentMethodId, @Nullable String makerAccountId, String takerAccountId, String makerPaymentAccountId, String takerPaymentAccountId, haveno.common.crypto.PubKeyRing takerPubKeyRing, String uid, String messageVersion, @Nullable byte[] accountAgeWitnessSignatureOfOfferId, long currentDate, haveno.network.p2p.NodeAddress makerNodeAddress, haveno.network.p2p.NodeAddress takerNodeAddress, haveno.network.p2p.NodeAddress arbitratorNodeAddress, @Nullable String reserveTxHash, @Nullable String reserveTxHex, @Nullable String reserveTxKey, @Nullable String payoutAddress, @Nullable String challenge) {
        super(messageVersion, offerId, uid);
        this.tradeProtocolVersion = tradeProtocolVersion;
        this.tradeAmount = tradeAmount;
        this.tradePrice = tradePrice;
        this.makerAccountId = makerAccountId;
        this.takerAccountId = takerAccountId;
        this.makerPaymentAccountId = makerPaymentAccountId;
        this.takerPaymentAccountId = takerPaymentAccountId;
        this.takerPubKeyRing = takerPubKeyRing;
        this.paymentMethodId = paymentMethodId;
        this.accountAgeWitnessSignatureOfOfferId = accountAgeWitnessSignatureOfOfferId;
        this.currentDate = currentDate;
        this.makerNodeAddress = makerNodeAddress;
        this.takerNodeAddress = takerNodeAddress;
        this.arbitratorNodeAddress = arbitratorNodeAddress;
        this.reserveTxHash = reserveTxHash;
        this.reserveTxHex = reserveTxHex;
        this.reserveTxKey = reserveTxKey;
        this.payoutAddress = payoutAddress;
        this.challenge = challenge;
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        InitTradeRequest.Builder builder = protobuf.InitTradeRequest.newBuilder().setTradeProtocolVersion(TradeProtocolVersion.toProtoMessage(this.tradeProtocolVersion)).setOfferId(this.offerId).setTakerNodeAddress(this.takerNodeAddress.toProtoMessage()).setMakerNodeAddress(this.makerNodeAddress.toProtoMessage()).setTradeAmount(this.tradeAmount).setTradePrice(this.tradePrice).setTakerPubKeyRing(this.takerPubKeyRing.toProtoMessage()).setMakerPaymentAccountId(this.makerPaymentAccountId).setTakerPaymentAccountId(this.takerPaymentAccountId).setPaymentMethodId(this.paymentMethodId).setTakerAccountId(this.takerAccountId).setUid(this.uid);
        Optional.ofNullable(this.makerAccountId).ifPresent(e -> builder.setMakerAccountId(this.makerAccountId));
        Optional.ofNullable(this.arbitratorNodeAddress).ifPresent(e -> builder.setArbitratorNodeAddress(this.arbitratorNodeAddress.toProtoMessage()));
        Optional.ofNullable(this.reserveTxHash).ifPresent(e -> builder.setReserveTxHash(this.reserveTxHash));
        Optional.ofNullable(this.reserveTxHex).ifPresent(e -> builder.setReserveTxHex(this.reserveTxHex));
        Optional.ofNullable(this.reserveTxKey).ifPresent(e -> builder.setReserveTxKey(this.reserveTxKey));
        Optional.ofNullable(this.payoutAddress).ifPresent(e -> builder.setPayoutAddress(this.payoutAddress));
        Optional.ofNullable(this.challenge).ifPresent(e -> builder.setChallenge(this.challenge));
        Optional.ofNullable(this.accountAgeWitnessSignatureOfOfferId).ifPresent(e -> builder.setAccountAgeWitnessSignatureOfOfferId(ByteString.copyFrom((byte[])e)));
        builder.setCurrentDate(this.currentDate);
        return this.getNetworkEnvelopeBuilder().setInitTradeRequest(builder).build();
    }

    public static InitTradeRequest fromProto(protobuf.InitTradeRequest proto, CoreProtoResolver coreProtoResolver, String messageVersion) {
        return new InitTradeRequest(TradeProtocolVersion.fromProto(proto.getTradeProtocolVersion()), proto.getOfferId(), proto.getTradeAmount(), proto.getTradePrice(), proto.getPaymentMethodId(), ProtoUtil.stringOrNullFromProto((String)proto.getMakerAccountId()), proto.getTakerAccountId(), proto.getMakerPaymentAccountId(), proto.getTakerPaymentAccountId(), haveno.common.crypto.PubKeyRing.fromProto((PubKeyRing)proto.getTakerPubKeyRing()), proto.getUid(), messageVersion, ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getAccountAgeWitnessSignatureOfOfferId()), proto.getCurrentDate(), haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getMakerNodeAddress()), haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getTakerNodeAddress()), proto.hasArbitratorNodeAddress() ? haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getArbitratorNodeAddress()) : null, ProtoUtil.stringOrNullFromProto((String)proto.getReserveTxHash()), ProtoUtil.stringOrNullFromProto((String)proto.getReserveTxHex()), ProtoUtil.stringOrNullFromProto((String)proto.getReserveTxKey()), ProtoUtil.stringOrNullFromProto((String)proto.getPayoutAddress()), ProtoUtil.stringOrNullFromProto((String)proto.getChallenge()));
    }

    @Override
    public String toString() {
        return "InitTradeRequest{\n     tradeProtocolVersion=" + String.valueOf((Object)this.tradeProtocolVersion) + ",\n     offerId=" + this.offerId + ",\n     tradeAmount=" + this.tradeAmount + ",\n     tradePrice=" + this.tradePrice + ",\n     paymentMethodId=" + this.paymentMethodId + ",\n     makerAccountId=" + this.makerAccountId + ",\n     takerAccountId=" + this.takerAccountId + ",\n     makerPaymentAccountId=" + this.makerPaymentAccountId + ",\n     takerPaymentAccountId=" + this.takerPaymentAccountId + ",\n     takerPubKeyRing=" + String.valueOf(this.takerPubKeyRing) + ",\n     accountAgeWitnessSignatureOfOfferId=" + Utilities.bytesAsHexString((byte[])this.accountAgeWitnessSignatureOfOfferId) + ",\n     currentDate=" + this.currentDate + ",\n     makerNodeAddress=" + String.valueOf(this.makerNodeAddress) + ",\n     takerNodeAddress=" + String.valueOf(this.takerNodeAddress) + ",\n     arbitratorNodeAddress=" + String.valueOf(this.arbitratorNodeAddress) + ",\n     reserveTxHash=" + this.reserveTxHash + ",\n     reserveTxHex=" + this.reserveTxHex + ",\n     reserveTxKey=" + this.reserveTxKey + ",\n     payoutAddress=" + this.payoutAddress + ",\n     challenge=" + this.challenge + "\n} " + super.toString();
    }

    public TradeProtocolVersion getTradeProtocolVersion() {
        return this.tradeProtocolVersion;
    }

    public long getTradeAmount() {
        return this.tradeAmount;
    }

    public long getTradePrice() {
        return this.tradePrice;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @Nullable
    public String getMakerAccountId() {
        return this.makerAccountId;
    }

    public String getTakerAccountId() {
        return this.takerAccountId;
    }

    public String getMakerPaymentAccountId() {
        return this.makerPaymentAccountId;
    }

    public String getTakerPaymentAccountId() {
        return this.takerPaymentAccountId;
    }

    public haveno.common.crypto.PubKeyRing getTakerPubKeyRing() {
        return this.takerPubKeyRing;
    }

    @Nullable
    public byte[] getAccountAgeWitnessSignatureOfOfferId() {
        return this.accountAgeWitnessSignatureOfOfferId;
    }

    public long getCurrentDate() {
        return this.currentDate;
    }

    public haveno.network.p2p.NodeAddress getMakerNodeAddress() {
        return this.makerNodeAddress;
    }

    public haveno.network.p2p.NodeAddress getTakerNodeAddress() {
        return this.takerNodeAddress;
    }

    @Nullable
    public haveno.network.p2p.NodeAddress getArbitratorNodeAddress() {
        return this.arbitratorNodeAddress;
    }

    @Nullable
    public String getReserveTxHash() {
        return this.reserveTxHash;
    }

    @Nullable
    public String getReserveTxHex() {
        return this.reserveTxHex;
    }

    @Nullable
    public String getReserveTxKey() {
        return this.reserveTxKey;
    }

    @Nullable
    public String getPayoutAddress() {
        return this.payoutAddress;
    }

    @Nullable
    public String getChallenge() {
        return this.challenge;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InitTradeRequest)) {
            return false;
        }
        InitTradeRequest other = (InitTradeRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTradeAmount() != other.getTradeAmount()) {
            return false;
        }
        if (this.getTradePrice() != other.getTradePrice()) {
            return false;
        }
        if (this.getCurrentDate() != other.getCurrentDate()) {
            return false;
        }
        TradeProtocolVersion this$tradeProtocolVersion = this.getTradeProtocolVersion();
        TradeProtocolVersion other$tradeProtocolVersion = other.getTradeProtocolVersion();
        if (this$tradeProtocolVersion == null ? other$tradeProtocolVersion != null : !((Object)((Object)this$tradeProtocolVersion)).equals((Object)other$tradeProtocolVersion)) {
            return false;
        }
        String this$paymentMethodId = this.getPaymentMethodId();
        String other$paymentMethodId = other.getPaymentMethodId();
        if (this$paymentMethodId == null ? other$paymentMethodId != null : !this$paymentMethodId.equals(other$paymentMethodId)) {
            return false;
        }
        String this$makerAccountId = this.getMakerAccountId();
        String other$makerAccountId = other.getMakerAccountId();
        if (this$makerAccountId == null ? other$makerAccountId != null : !this$makerAccountId.equals(other$makerAccountId)) {
            return false;
        }
        String this$takerAccountId = this.getTakerAccountId();
        String other$takerAccountId = other.getTakerAccountId();
        if (this$takerAccountId == null ? other$takerAccountId != null : !this$takerAccountId.equals(other$takerAccountId)) {
            return false;
        }
        String this$makerPaymentAccountId = this.getMakerPaymentAccountId();
        String other$makerPaymentAccountId = other.getMakerPaymentAccountId();
        if (this$makerPaymentAccountId == null ? other$makerPaymentAccountId != null : !this$makerPaymentAccountId.equals(other$makerPaymentAccountId)) {
            return false;
        }
        String this$takerPaymentAccountId = this.getTakerPaymentAccountId();
        String other$takerPaymentAccountId = other.getTakerPaymentAccountId();
        if (this$takerPaymentAccountId == null ? other$takerPaymentAccountId != null : !this$takerPaymentAccountId.equals(other$takerPaymentAccountId)) {
            return false;
        }
        haveno.common.crypto.PubKeyRing this$takerPubKeyRing = this.getTakerPubKeyRing();
        haveno.common.crypto.PubKeyRing other$takerPubKeyRing = other.getTakerPubKeyRing();
        if (this$takerPubKeyRing == null ? other$takerPubKeyRing != null : !this$takerPubKeyRing.equals(other$takerPubKeyRing)) {
            return false;
        }
        if (!Arrays.equals(this.getAccountAgeWitnessSignatureOfOfferId(), other.getAccountAgeWitnessSignatureOfOfferId())) {
            return false;
        }
        haveno.network.p2p.NodeAddress this$makerNodeAddress = this.getMakerNodeAddress();
        haveno.network.p2p.NodeAddress other$makerNodeAddress = other.getMakerNodeAddress();
        if (this$makerNodeAddress == null ? other$makerNodeAddress != null : !this$makerNodeAddress.equals(other$makerNodeAddress)) {
            return false;
        }
        haveno.network.p2p.NodeAddress this$takerNodeAddress = this.getTakerNodeAddress();
        haveno.network.p2p.NodeAddress other$takerNodeAddress = other.getTakerNodeAddress();
        if (this$takerNodeAddress == null ? other$takerNodeAddress != null : !this$takerNodeAddress.equals(other$takerNodeAddress)) {
            return false;
        }
        haveno.network.p2p.NodeAddress this$arbitratorNodeAddress = this.getArbitratorNodeAddress();
        haveno.network.p2p.NodeAddress other$arbitratorNodeAddress = other.getArbitratorNodeAddress();
        if (this$arbitratorNodeAddress == null ? other$arbitratorNodeAddress != null : !this$arbitratorNodeAddress.equals(other$arbitratorNodeAddress)) {
            return false;
        }
        String this$reserveTxHash = this.getReserveTxHash();
        String other$reserveTxHash = other.getReserveTxHash();
        if (this$reserveTxHash == null ? other$reserveTxHash != null : !this$reserveTxHash.equals(other$reserveTxHash)) {
            return false;
        }
        String this$reserveTxHex = this.getReserveTxHex();
        String other$reserveTxHex = other.getReserveTxHex();
        if (this$reserveTxHex == null ? other$reserveTxHex != null : !this$reserveTxHex.equals(other$reserveTxHex)) {
            return false;
        }
        String this$reserveTxKey = this.getReserveTxKey();
        String other$reserveTxKey = other.getReserveTxKey();
        if (this$reserveTxKey == null ? other$reserveTxKey != null : !this$reserveTxKey.equals(other$reserveTxKey)) {
            return false;
        }
        String this$payoutAddress = this.getPayoutAddress();
        String other$payoutAddress = other.getPayoutAddress();
        if (this$payoutAddress == null ? other$payoutAddress != null : !this$payoutAddress.equals(other$payoutAddress)) {
            return false;
        }
        String this$challenge = this.getChallenge();
        String other$challenge = other.getChallenge();
        return !(this$challenge == null ? other$challenge != null : !this$challenge.equals(other$challenge));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InitTradeRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $tradeAmount = this.getTradeAmount();
        result = result * 59 + (int)($tradeAmount >>> 32 ^ $tradeAmount);
        long $tradePrice = this.getTradePrice();
        result = result * 59 + (int)($tradePrice >>> 32 ^ $tradePrice);
        long $currentDate = this.getCurrentDate();
        result = result * 59 + (int)($currentDate >>> 32 ^ $currentDate);
        TradeProtocolVersion $tradeProtocolVersion = this.getTradeProtocolVersion();
        result = result * 59 + ($tradeProtocolVersion == null ? 43 : ((Object)((Object)$tradeProtocolVersion)).hashCode());
        String $paymentMethodId = this.getPaymentMethodId();
        result = result * 59 + ($paymentMethodId == null ? 43 : $paymentMethodId.hashCode());
        String $makerAccountId = this.getMakerAccountId();
        result = result * 59 + ($makerAccountId == null ? 43 : $makerAccountId.hashCode());
        String $takerAccountId = this.getTakerAccountId();
        result = result * 59 + ($takerAccountId == null ? 43 : $takerAccountId.hashCode());
        String $makerPaymentAccountId = this.getMakerPaymentAccountId();
        result = result * 59 + ($makerPaymentAccountId == null ? 43 : $makerPaymentAccountId.hashCode());
        String $takerPaymentAccountId = this.getTakerPaymentAccountId();
        result = result * 59 + ($takerPaymentAccountId == null ? 43 : $takerPaymentAccountId.hashCode());
        haveno.common.crypto.PubKeyRing $takerPubKeyRing = this.getTakerPubKeyRing();
        result = result * 59 + ($takerPubKeyRing == null ? 43 : $takerPubKeyRing.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAccountAgeWitnessSignatureOfOfferId());
        haveno.network.p2p.NodeAddress $makerNodeAddress = this.getMakerNodeAddress();
        result = result * 59 + ($makerNodeAddress == null ? 43 : $makerNodeAddress.hashCode());
        haveno.network.p2p.NodeAddress $takerNodeAddress = this.getTakerNodeAddress();
        result = result * 59 + ($takerNodeAddress == null ? 43 : $takerNodeAddress.hashCode());
        haveno.network.p2p.NodeAddress $arbitratorNodeAddress = this.getArbitratorNodeAddress();
        result = result * 59 + ($arbitratorNodeAddress == null ? 43 : $arbitratorNodeAddress.hashCode());
        String $reserveTxHash = this.getReserveTxHash();
        result = result * 59 + ($reserveTxHash == null ? 43 : $reserveTxHash.hashCode());
        String $reserveTxHex = this.getReserveTxHex();
        result = result * 59 + ($reserveTxHex == null ? 43 : $reserveTxHex.hashCode());
        String $reserveTxKey = this.getReserveTxKey();
        result = result * 59 + ($reserveTxKey == null ? 43 : $reserveTxKey.hashCode());
        String $payoutAddress = this.getPayoutAddress();
        result = result * 59 + ($payoutAddress == null ? 43 : $payoutAddress.hashCode());
        String $challenge = this.getChallenge();
        result = result * 59 + ($challenge == null ? 43 : $challenge.hashCode());
        return result;
    }
}

