/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import com.google.protobuf.ByteString;
import haveno.common.app.Version;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.Utilities;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.messages.TradeMailboxMessage;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import protobuf.DepositsConfirmedMessage;
import protobuf.NetworkEnvelope;
import protobuf.NodeAddress;
import protobuf.PubKeyRing;

public final class DepositsConfirmedMessage
extends TradeMailboxMessage {
    private final haveno.network.p2p.NodeAddress senderNodeAddress;
    private final haveno.common.crypto.PubKeyRing pubKeyRing;
    @Nullable
    private final byte[] sellerPaymentAccountKey;
    @Nullable
    private final String updatedMultisigHex;

    public DepositsConfirmedMessage(String tradeId, haveno.network.p2p.NodeAddress senderNodeAddress, haveno.common.crypto.PubKeyRing pubKeyRing, String uid, @Nullable byte[] sellerPaymentAccountKey, @Nullable String updatedMultisigHex) {
        super(Version.getP2PMessageVersion(), tradeId, uid);
        this.senderNodeAddress = senderNodeAddress;
        this.pubKeyRing = pubKeyRing;
        this.sellerPaymentAccountKey = sellerPaymentAccountKey;
        this.updatedMultisigHex = updatedMultisigHex;
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        DepositsConfirmedMessage.Builder builder = protobuf.DepositsConfirmedMessage.newBuilder().setTradeId(this.offerId).setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setPubKeyRing(this.pubKeyRing.toProtoMessage()).setUid(this.uid);
        Optional.ofNullable(this.sellerPaymentAccountKey).ifPresent(e -> builder.setSellerPaymentAccountKey(ByteString.copyFrom((byte[])e)));
        Optional.ofNullable(this.updatedMultisigHex).ifPresent(e -> builder.setUpdatedMultisigHex(this.updatedMultisigHex));
        return this.getNetworkEnvelopeBuilder().setDepositsConfirmedMessage(builder).build();
    }

    public static DepositsConfirmedMessage fromProto(protobuf.DepositsConfirmedMessage proto, CoreProtoResolver coreProtoResolver, String messageVersion) {
        return new DepositsConfirmedMessage(proto.getTradeId(), haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getSenderNodeAddress()), haveno.common.crypto.PubKeyRing.fromProto((PubKeyRing)proto.getPubKeyRing()), proto.getUid(), ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getSellerPaymentAccountKey()), ProtoUtil.stringOrNullFromProto((String)proto.getUpdatedMultisigHex()));
    }

    @Override
    public String toString() {
        return "DepositsConfirmedMessage {\n     senderNodeAddress=" + String.valueOf(this.senderNodeAddress) + ",\n     sellerPaymentAccountKey=" + Utilities.bytesAsHexString((byte[])this.sellerPaymentAccountKey) + ",\n     updatedMultisigHex=" + (this.updatedMultisigHex == null ? null : this.updatedMultisigHex.substring(0, Math.max(this.updatedMultisigHex.length(), 1000))) + "\n} " + super.toString();
    }

    public haveno.network.p2p.NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    public haveno.common.crypto.PubKeyRing getPubKeyRing() {
        return this.pubKeyRing;
    }

    @Nullable
    public byte[] getSellerPaymentAccountKey() {
        return this.sellerPaymentAccountKey;
    }

    @Nullable
    public String getUpdatedMultisigHex() {
        return this.updatedMultisigHex;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepositsConfirmedMessage)) {
            return false;
        }
        DepositsConfirmedMessage other = (DepositsConfirmedMessage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        haveno.network.p2p.NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        haveno.network.p2p.NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !this$senderNodeAddress.equals(other$senderNodeAddress)) {
            return false;
        }
        haveno.common.crypto.PubKeyRing this$pubKeyRing = this.getPubKeyRing();
        haveno.common.crypto.PubKeyRing other$pubKeyRing = other.getPubKeyRing();
        if (this$pubKeyRing == null ? other$pubKeyRing != null : !this$pubKeyRing.equals(other$pubKeyRing)) {
            return false;
        }
        if (!Arrays.equals(this.getSellerPaymentAccountKey(), other.getSellerPaymentAccountKey())) {
            return false;
        }
        String this$updatedMultisigHex = this.getUpdatedMultisigHex();
        String other$updatedMultisigHex = other.getUpdatedMultisigHex();
        return !(this$updatedMultisigHex == null ? other$updatedMultisigHex != null : !this$updatedMultisigHex.equals(other$updatedMultisigHex));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DepositsConfirmedMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        haveno.network.p2p.NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : $senderNodeAddress.hashCode());
        haveno.common.crypto.PubKeyRing $pubKeyRing = this.getPubKeyRing();
        result = result * 59 + ($pubKeyRing == null ? 43 : $pubKeyRing.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSellerPaymentAccountKey());
        String $updatedMultisigHex = this.getUpdatedMultisigHex();
        result = result * 59 + ($updatedMultisigHex == null ? 43 : $updatedMultisigHex.hashCode());
        return result;
    }
}

