/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade.messages;

import haveno.common.proto.ProtoUtil;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.messages.TradeMessage;
import haveno.network.p2p.DirectMessage;
import java.util.Optional;
import protobuf.DepositResponse;
import protobuf.NetworkEnvelope;

public final class DepositResponse
extends TradeMessage
implements DirectMessage {
    private final long currentDate;
    private final String errorMessage;
    private final long buyerSecurityDeposit;
    private final long sellerSecurityDeposit;

    public DepositResponse(String tradeId, String uid, String messageVersion, long currentDate, String errorMessage, long buyerSecurityDeposit, long sellerSecurityDeposit) {
        super(messageVersion, tradeId, uid);
        this.currentDate = currentDate;
        this.errorMessage = errorMessage;
        this.buyerSecurityDeposit = buyerSecurityDeposit;
        this.sellerSecurityDeposit = sellerSecurityDeposit;
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        DepositResponse.Builder builder = protobuf.DepositResponse.newBuilder().setTradeId(this.offerId).setUid(this.uid);
        builder.setCurrentDate(this.currentDate);
        builder.setBuyerSecurityDeposit(this.buyerSecurityDeposit);
        builder.setSellerSecurityDeposit(this.sellerSecurityDeposit);
        Optional.ofNullable(this.errorMessage).ifPresent(e -> builder.setErrorMessage(this.errorMessage));
        return this.getNetworkEnvelopeBuilder().setDepositResponse(builder).build();
    }

    public static DepositResponse fromProto(protobuf.DepositResponse proto, CoreProtoResolver coreProtoResolver, String messageVersion) {
        return new DepositResponse(proto.getTradeId(), proto.getUid(), messageVersion, proto.getCurrentDate(), ProtoUtil.stringOrNullFromProto((String)proto.getErrorMessage()), proto.getBuyerSecurityDeposit(), proto.getSellerSecurityDeposit());
    }

    @Override
    public String toString() {
        return "DepositResponse {,\n     currentDate=" + this.currentDate + ",\n     errorMessage=" + this.errorMessage + ",\n     buyerSecurityDeposit=" + this.buyerSecurityDeposit + ",\n     sellerSecurityDeposit=" + this.sellerSecurityDeposit + "\n} " + super.toString();
    }

    public long getCurrentDate() {
        return this.currentDate;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getBuyerSecurityDeposit() {
        return this.buyerSecurityDeposit;
    }

    public long getSellerSecurityDeposit() {
        return this.sellerSecurityDeposit;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepositResponse)) {
            return false;
        }
        DepositResponse other = (DepositResponse)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrentDate() != other.getCurrentDate()) {
            return false;
        }
        if (this.getBuyerSecurityDeposit() != other.getBuyerSecurityDeposit()) {
            return false;
        }
        if (this.getSellerSecurityDeposit() != other.getSellerSecurityDeposit()) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DepositResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $currentDate = this.getCurrentDate();
        result = result * 59 + (int)($currentDate >>> 32 ^ $currentDate);
        long $buyerSecurityDeposit = this.getBuyerSecurityDeposit();
        result = result * 59 + (int)($buyerSecurityDeposit >>> 32 ^ $buyerSecurityDeposit);
        long $sellerSecurityDeposit = this.getSellerSecurityDeposit();
        result = result * 59 + (int)($sellerSecurityDeposit >>> 32 ^ $sellerSecurityDeposit);
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }
}

