/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.crypto.KeyRing;
import haveno.common.util.Tuple2;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.trade.Trade;
import haveno.core.util.FormattingUtils;
import haveno.core.xmr.wallet.BtcWalletService;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TradeUtil {
    private static final Logger log = LoggerFactory.getLogger(TradeUtil.class);
    private final BtcWalletService btcWalletService;
    private final KeyRing keyRing;

    @Inject
    public TradeUtil(BtcWalletService btcWalletService, KeyRing keyRing) {
        this.btcWalletService = btcWalletService;
        this.keyRing = keyRing;
    }

    public Tuple2<String, String> getAvailableAddresses(Trade trade) {
        Tuple2<String, String> addresses = this.getTradeAddresses(trade);
        if (addresses == null) {
            return null;
        }
        if (this.btcWalletService.getAvailableAddressEntries().stream().noneMatch(e -> Objects.equals(e.getAddressString(), addresses.first))) {
            return null;
        }
        if (this.btcWalletService.getAvailableAddressEntries().stream().noneMatch(e -> Objects.equals(e.getAddressString(), addresses.second))) {
            return null;
        }
        return new Tuple2((Object)((String)addresses.first), (Object)((String)addresses.second));
    }

    public Tuple2<String, String> getTradeAddresses(Trade trade) {
        throw new RuntimeException("TradeUtil.getTradeAddresses() not implemented for XMR");
    }

    public long getRemainingTradeDuration(Trade trade) {
        return trade.getMaxTradePeriodDate() != null ? trade.getMaxTradePeriodDate().getTime() - new Date().getTime() : this.getMaxTradePeriod(trade);
    }

    public long getMaxTradePeriod(Trade trade) {
        return trade.getOffer() != null ? trade.getOffer().getPaymentMethod().getMaxTradePeriod() : 0L;
    }

    public double getRemainingTradeDurationAsPercentage(Trade trade) {
        long maxPeriod = this.getMaxTradePeriod(trade);
        long remaining = this.getRemainingTradeDuration(trade);
        if (maxPeriod != 0L) {
            return 1.0 - (double)remaining / (double)maxPeriod;
        }
        return 0.0;
    }

    public String getRemainingTradeDurationAsWords(Trade trade) {
        return FormattingUtils.formatDurationAsWords(Math.max(0L, this.getRemainingTradeDuration(trade)));
    }

    @Nullable
    public Date getHalfTradePeriodDate(Trade trade) {
        return trade != null ? trade.getHalfTradePeriodDate() : null;
    }

    public Date getDateForOpenDispute(Trade trade) {
        return new Date(new Date().getTime() + this.getRemainingTradeDuration(trade));
    }

    public String getMarketDescription(Trade trade) {
        if (trade == null) {
            return "";
        }
        Preconditions.checkNotNull((Object)trade.getOffer());
        Preconditions.checkNotNull((Object)trade.getOffer().getCounterCurrencyCode());
        return CurrencyUtil.getCurrencyPair(trade.getOffer().getCounterCurrencyCode());
    }

    public String getPaymentMethodNameWithCountryCode(Trade trade) {
        if (trade == null) {
            return "";
        }
        Offer offer = trade.getOffer();
        Preconditions.checkNotNull((Object)offer);
        Preconditions.checkNotNull((Object)offer.getPaymentMethod());
        return offer.getPaymentMethodNameWithCountryCode();
    }

    public static String getRole(Trade trade) {
        Offer offer = trade.getOffer();
        if (offer == null) {
            throw new IllegalStateException(String.format("could not get role because no offer was found for trade '%s'", trade.getShortId()));
        }
        return (trade.isArbitrator() ? "Arbitrator for " : "") + TradeUtil.getRole(trade.getBuyer() == trade.getMaker(), trade.isArbitrator() ? true : trade.isMaker(), offer.getCounterCurrencyCode());
    }

    private static String getRole(boolean isBuyerMakerAndSellerTaker, boolean isMaker, String currencyCode) {
        String baseCurrencyCode = Res.getBaseCurrencyCode();
        if (isBuyerMakerAndSellerTaker) {
            return isMaker ? Res.get("formatter.asMaker", baseCurrencyCode, Res.get("shared.buyer")) : Res.get("formatter.asTaker", baseCurrencyCode, Res.get("shared.seller"));
        }
        return isMaker ? Res.get("formatter.asMaker", baseCurrencyCode, Res.get("shared.seller")) : Res.get("formatter.asTaker", baseCurrencyCode, Res.get("shared.buyer"));
    }
}

