/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.common.base.Preconditions;
import haveno.core.support.dispute.Dispute;
import haveno.core.trade.Trade;
import haveno.core.xmr.wallet.BtcWalletService;
import java.math.BigInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeDataValidation {
    private static final Logger log = LoggerFactory.getLogger(TradeDataValidation.class);

    public static void validateDelayedPayoutTx(Trade trade, Transaction delayedPayoutTx, BtcWalletService btcWalletService) throws AddressException, MissingTxException, InvalidTxException, InvalidLockTimeException, InvalidAmountException {
        TradeDataValidation.validateDelayedPayoutTx(trade, delayedPayoutTx, null, btcWalletService, null);
    }

    public static void validateDelayedPayoutTx(Trade trade, Transaction delayedPayoutTx, @Nullable Dispute dispute, BtcWalletService btcWalletService) throws AddressException, MissingTxException, InvalidTxException, InvalidLockTimeException, InvalidAmountException {
        TradeDataValidation.validateDelayedPayoutTx(trade, delayedPayoutTx, dispute, btcWalletService, null);
    }

    public static void validateDelayedPayoutTx(Trade trade, Transaction delayedPayoutTx, BtcWalletService btcWalletService, @Nullable Consumer<String> addressConsumer) throws AddressException, MissingTxException, InvalidTxException, InvalidLockTimeException, InvalidAmountException {
        TradeDataValidation.validateDelayedPayoutTx(trade, delayedPayoutTx, null, btcWalletService, addressConsumer);
    }

    public static void validateDelayedPayoutTx(Trade trade, Transaction delayedPayoutTx, @Nullable Dispute dispute, BtcWalletService btcWalletService, @Nullable Consumer<String> addressConsumer) throws AddressException, MissingTxException, InvalidTxException, InvalidLockTimeException, InvalidAmountException {
        String donationAddressOfDelayedPayoutTx;
        if (delayedPayoutTx == null) {
            String errorMsg = "DelayedPayoutTx must not be null";
            log.error(errorMsg);
            throw new MissingTxException("DelayedPayoutTx must not be null");
        }
        if (delayedPayoutTx.getInputs().size() != 1) {
            String errorMsg = "Number of delayedPayoutTx inputs must be 1";
            log.error(errorMsg);
            log.error(delayedPayoutTx.toString());
            throw new InvalidTxException(errorMsg);
        }
        if (delayedPayoutTx.getOutputs().size() != 1) {
            String errorMsg = "Number of delayedPayoutTx outputs must be 1";
            log.error(errorMsg);
            log.error(delayedPayoutTx.toString());
            throw new InvalidTxException(errorMsg);
        }
        if (delayedPayoutTx.getLockTime() != trade.getLockTime()) {
            String errorMsg = "delayedPayoutTx.getLockTime() must match trade.getLockTime()";
            log.error(errorMsg);
            log.error(delayedPayoutTx.toString());
            throw new InvalidLockTimeException(errorMsg);
        }
        if (delayedPayoutTx.getInput(0L).getSequenceNumber() != 0xFFFFFFFEL) {
            String errorMsg = "Sequence number must be 0xFFFFFFFE";
            log.error(errorMsg);
            log.error(delayedPayoutTx.toString());
            throw new InvalidLockTimeException(errorMsg);
        }
        TransactionOutput output = delayedPayoutTx.getOutput(0L);
        BigInteger msOutputAmount = trade.getBuyerSecurityDepositBeforeMiningFee().add(trade.getSellerSecurityDepositBeforeMiningFee()).add((BigInteger)Preconditions.checkNotNull((Object)trade.getAmount()));
        if (!output.getValue().equals((Object)msOutputAmount)) {
            String errorMsg = "Output value of deposit tx and delayed payout tx is not matching. Output: " + String.valueOf(output) + " / msOutputAmount: " + String.valueOf(msOutputAmount);
            log.error(errorMsg);
            log.error(delayedPayoutTx.toString());
            throw new InvalidAmountException(errorMsg);
        }
        NetworkParameters params = btcWalletService.getParams();
        Address address = output.getScriptPubKey().getToAddress(params);
        if (address == null) {
            String errorMsg = "Donation address cannot be resolved (not of type P2PK nor P2SH nor P2WH). Output: " + String.valueOf(output);
            log.error(errorMsg);
            log.error(delayedPayoutTx.toString());
            throw new AddressException(dispute, errorMsg);
        }
        String addressAsString = address.toString();
        if (addressConsumer != null) {
            addressConsumer.accept(addressAsString);
        }
        if (dispute != null && (donationAddressOfDelayedPayoutTx = dispute.getDonationAddressOfDelayedPayoutTx()) != null) {
            Preconditions.checkArgument((boolean)addressAsString.equals(donationAddressOfDelayedPayoutTx), (Object)"donationAddressOfDelayedPayoutTx from dispute does not match address from delayed payout tx");
        }
    }

    public static void validatePayoutTxInput(Transaction depositTx, Transaction delayedPayoutTx) throws InvalidInputException {
        TransactionInput input = delayedPayoutTx.getInput(0L);
        Preconditions.checkNotNull((Object)input, (Object)"delayedPayoutTx.getInput(0) must not be null");
        TransactionOutPoint outpoint = input.getOutpoint();
        if (!outpoint.getHash().toString().equals(depositTx.getTxId().toString()) || outpoint.getIndex() != 0L) {
            throw new InvalidInputException("Input of delayed payout transaction does not point to output of deposit tx.\nDelayed payout tx=" + String.valueOf(delayedPayoutTx) + "\nDeposit tx=" + String.valueOf(depositTx));
        }
    }

    public static class MissingTxException
    extends ValidationException {
        MissingTxException(String msg) {
            super(msg);
        }
    }

    public static class InvalidTxException
    extends ValidationException {
        InvalidTxException(String msg) {
            super(msg);
        }
    }

    public static class InvalidLockTimeException
    extends ValidationException {
        InvalidLockTimeException(String msg) {
            super(msg);
        }
    }

    public static class InvalidAmountException
    extends ValidationException {
        InvalidAmountException(String msg) {
            super(msg);
        }
    }

    public static class AddressException
    extends ValidationException {
        AddressException(@Nullable Dispute dispute, String msg) {
            super(dispute, msg);
        }
    }

    public static class InvalidInputException
    extends ValidationException {
        InvalidInputException(String msg) {
            super(msg);
        }
    }

    public static class NodeAddressException
    extends ValidationException {
        NodeAddressException(Dispute dispute, String msg) {
            super(dispute, msg);
        }
    }

    public static class DisputeReplayException
    extends ValidationException {
        DisputeReplayException(Dispute dispute, String msg) {
            super(dispute, msg);
        }
    }

    public static class InvalidPaymentAccountPayloadException
    extends ValidationException {
        InvalidPaymentAccountPayloadException(@Nullable Dispute dispute, String msg) {
            super(dispute, msg);
        }
    }

    public static class ValidationException
    extends Exception {
        @Nullable
        private final Dispute dispute;

        ValidationException(String msg) {
            this(null, msg);
        }

        ValidationException(@Nullable Dispute dispute, String msg) {
            super(msg);
            this.dispute = dispute;
        }

        @Nullable
        public Dispute getDispute() {
            return this.dispute;
        }
    }
}

