/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.crypto.Encryption;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtoUtil;
import haveno.common.taskrunner.Model;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.network.MessageState;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OpenOffer;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.proto.network.CoreNetworkProtoResolver;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.mediation.MediationResultState;
import haveno.core.support.dispute.refund.RefundResultState;
import haveno.core.support.messages.ChatMessage;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.SellerTrade;
import haveno.core.trade.TakerTrade;
import haveno.core.trade.Tradable;
import haveno.core.trade.messages.TradeMessage;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.trade.protocol.ProcessModelServiceProvider;
import haveno.core.trade.protocol.SellerProtocol;
import haveno.core.trade.protocol.TradeListener;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.trade.protocol.TradeProtocol;
import haveno.core.util.PriceUtil;
import haveno.core.util.VolumeUtil;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletBase;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.DecryptedDirectMessageListener;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.network.TorNetworkNode;
import java.math.BigInteger;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import monero.common.MoneroError;
import monero.common.MoneroRpcConnection;
import monero.common.TaskLooper;
import monero.daemon.MoneroDaemonRpc;
import monero.daemon.model.MoneroKeyImage;
import monero.daemon.model.MoneroTx;
import monero.wallet.MoneroWallet;
import monero.wallet.MoneroWalletRpc;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroMultisigSignResult;
import monero.wallet.model.MoneroOutputQuery;
import monero.wallet.model.MoneroOutputWallet;
import monero.wallet.model.MoneroSyncResult;
import monero.wallet.model.MoneroTxConfig;
import monero.wallet.model.MoneroTxQuery;
import monero.wallet.model.MoneroTxSet;
import monero.wallet.model.MoneroTxWallet;
import monero.wallet.model.MoneroWalletListener;
import monero.wallet.model.MoneroWalletListenerI;
import org.apache.commons.lang3.StringUtils;
import org.bitcoinj.core.Coin;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Trade;

public abstract class Trade
extends XmrWalletBase
implements Tradable,
Model {
    private static final Logger log = LoggerFactory.getLogger(Trade.class);
    public final Object lock = new Object();
    private static final String MONERO_TRADE_WALLET_PREFIX = "xmr_trade_";
    private static final long SHUTDOWN_TIMEOUT_MS = 60000L;
    private static final long SYNC_EVERY_NUM_BLOCKS = 360L;
    private static final long DELETE_AFTER_NUM_BLOCKS = 2L;
    private static final long EXTENDED_RPC_TIMEOUT = 600000L;
    private static final long DELETE_AFTER_MS = TradeProtocol.TRADE_STEP_TIMEOUT_SECONDS;
    private static final int NUM_CONFIRMATIONS_FOR_SCHEDULED_IMPORT = 5;
    public static final int NUM_BLOCKS_DEPOSITS_FINALIZED = 30;
    public static final int NUM_BLOCKS_PAYOUT_FINALIZED = Config.baseCurrencyNetwork().isTestnet() ? 60 : 720;
    public static final long DEFER_PUBLISH_MS = 25000L;
    private static final long IDLE_SYNC_PERIOD_MS = Config.baseCurrencyNetwork().isTestnet() ? 30000L : 1680000L;
    private static final long MAX_REPROCESS_DELAY_SECONDS = 7200L;
    protected final Object pollLock = new Object();
    private final Object removeTradeOnErrorLock = new Object();
    protected static final Object importMultisigLock = new Object();
    private boolean pollInProgress;
    private boolean restartInProgress;
    private Subscription protocolErrorStateSubscription;
    private Subscription protocolErrorHeightSubscription;
    public static final String PROTOCOL_VERSION = "protocolVersion";
    public BooleanProperty wasWalletPolledProperty = new SimpleBooleanProperty(false);
    public BooleanProperty wasWalletSyncedAndPolledProperty = new SimpleBooleanProperty(false);
    private static final long MISSING_TXS_DELAY_MS = Config.baseCurrencyNetwork().isTestnet() ? 5000L : 30000L;
    private Long lastDepositTxMissingHeight;
    private Long lastPayoutTxMissingHeight;
    private final ProcessModel processModel;
    private final Offer offer;
    private final String uid;
    private long takeOfferDate;
    private static final int TOTAL_INIT_STEPS = 24;
    private int initStep = 0;
    private double initProgress = 0.0;
    private Exception initError;
    private long amount;
    private long price;
    @Nullable
    private State state = State.PREPARATION;
    private PayoutState payoutState = PayoutState.PAYOUT_UNPUBLISHED;
    private DisputeState disputeState = DisputeState.NO_DISPUTE;
    private TradePeriodState periodState = TradePeriodState.FIRST_HALF;
    @Nullable
    private Contract contract;
    @Nullable
    private String contractAsJson;
    @Nullable
    private byte[] contractHash;
    @Nullable
    private String errorMessage;
    @Nullable
    private String counterCurrencyTxId;
    private final ObservableList<ChatMessage> chatMessages = FXCollections.observableArrayList();
    private final transient XmrWalletService xmrWalletService;
    private final transient DoubleProperty initProgressProperty = new SimpleDoubleProperty(0.0);
    private final transient ObjectProperty<State> stateProperty = new SimpleObjectProperty((Object)this.state);
    private final transient ObjectProperty<Phase> phaseProperty;
    private final transient ObjectProperty<PayoutState> payoutStateProperty;
    private final transient ObjectProperty<DisputeState> disputeStateProperty;
    private final transient ObjectProperty<TradePeriodState> tradePeriodStateProperty;
    public final transient IntegerProperty depositTxsUpdateCounter;
    private final transient StringProperty errorMessageProperty;
    private transient Subscription tradeStateSubscription;
    private transient Subscription tradePhaseSubscription;
    private transient Subscription payoutStateSubscription;
    private transient Subscription disputeStateSubscription;
    private transient TaskLooper pollLooper;
    private transient Long pollPeriodMs;
    private transient Long pollNormalStartTimeMs;
    private transient boolean isInitialized;
    private transient boolean isFullyInitialized;
    private transient ObjectProperty<BigInteger> tradeAmountProperty;
    private transient ObjectProperty<Volume> tradeVolumeProperty;
    @Nullable
    private MediationResultState mediationResultState;
    private final transient ObjectProperty<MediationResultState> mediationResultStateProperty;
    private long lockTime;
    private long startTime;
    private final Object startTimeLock;
    @Nullable
    private RefundResultState refundResultState;
    private final transient ObjectProperty<RefundResultState> refundResultStateProperty;
    private String counterCurrencyExtraData;
    private transient List<TradeListener> tradeListeners;
    transient MoneroWalletListener depositTxListener;
    transient MoneroWalletListener payoutTxListener;
    transient Boolean makerDepositLocked;
    transient Boolean takerDepositLocked;
    @Nullable
    private transient MoneroTx payoutTx;
    private String payoutTxId;
    @Nullable
    private String payoutTxHex;
    private String payoutTxKey;
    private long payoutTxFee;
    private Long payoutHeight;
    private IdlePayoutSyncer idlePayoutSyncer;
    private boolean isCompleted;
    private final String challenge;

    protected Trade(Offer offer, BigInteger tradeAmount, long tradePrice, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable NodeAddress makerNodeAddress, @Nullable NodeAddress takerNodeAddress, @Nullable NodeAddress arbitratorNodeAddress, @Nullable String challenge) {
        this.phaseProperty = new SimpleObjectProperty((Object)this.state.phase);
        this.payoutStateProperty = new SimpleObjectProperty((Object)this.payoutState);
        this.disputeStateProperty = new SimpleObjectProperty((Object)this.disputeState);
        this.tradePeriodStateProperty = new SimpleObjectProperty((Object)this.periodState);
        this.depositTxsUpdateCounter = new SimpleIntegerProperty(0);
        this.errorMessageProperty = new SimpleStringProperty();
        this.mediationResultState = MediationResultState.UNDEFINED_MEDIATION_RESULT;
        this.mediationResultStateProperty = new SimpleObjectProperty((Object)this.mediationResultState);
        this.startTimeLock = new Object();
        this.refundResultState = RefundResultState.UNDEFINED_REFUND_RESULT;
        this.refundResultStateProperty = new SimpleObjectProperty((Object)this.refundResultState);
        this.offer = offer;
        this.amount = tradeAmount.longValueExact();
        this.price = tradePrice;
        this.xmrWalletService = xmrWalletService;
        this.xmrConnectionService = xmrWalletService.getXmrConnectionService();
        this.processModel = processModel;
        this.uid = uid;
        this.takeOfferDate = new Date().getTime();
        this.tradeListeners = new ArrayList<TradeListener>();
        this.challenge = challenge;
        this.getMaker().setNodeAddress(makerNodeAddress);
        this.getTaker().setNodeAddress(takerNodeAddress);
        this.getArbitrator().setNodeAddress(arbitratorNodeAddress);
        this.setAmount(tradeAmount);
    }

    protected Trade(Offer offer, BigInteger tradeAmount, BigInteger txFee, long tradePrice, @Nullable NodeAddress mediatorNodeAddress, @Nullable NodeAddress refundAgentNodeAddress, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable NodeAddress makerNodeAddress, @Nullable NodeAddress takerNodeAddress, @Nullable NodeAddress arbitratorNodeAddress, @Nullable String challenge) {
        this(offer, tradeAmount, tradePrice, xmrWalletService, processModel, uid, makerNodeAddress, takerNodeAddress, arbitratorNodeAddress, challenge);
    }

    protected Trade(Offer offer, BigInteger tradeAmount, Coin txFee, long tradePrice, NodeAddress makerNodeAddress, NodeAddress takerNodeAddress, NodeAddress arbitratorNodeAddress, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable String challenge) {
        this(offer, tradeAmount, tradePrice, xmrWalletService, processModel, uid, makerNodeAddress, takerNodeAddress, arbitratorNodeAddress, challenge);
        this.setAmount(tradeAmount);
    }

    public void addListener(TradeListener listener) {
        this.tradeListeners.add(listener);
    }

    public void removeListener(TradeListener listener) {
        if (!this.tradeListeners.remove(listener)) {
            throw new RuntimeException("TradeMessageListener is not registered");
        }
    }

    public void onVerifiedTradeMessage(TradeMessage message, NodeAddress sender) {
        for (TradeListener listener : new ArrayList<TradeListener>(this.tradeListeners)) {
            listener.onVerifiedTradeMessage(message, sender);
        }
    }

    public void onAckMessage(AckMessage ackMessage, NodeAddress sender) {
        for (TradeListener listener : new ArrayList<TradeListener>(this.tradeListeners)) {
            listener.onAckMessage(ackMessage, sender);
        }
    }

    public void initialize(ProcessModelServiceProvider serviceProvider) {
        MessageState expectedState;
        if (this.isInitialized) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " " + this.getId() + " is already initialized");
        }
        this.isShutDownStarted = false;
        this.isShutDown = false;
        if (this.isFinished()) {
            this.clearAndShutDown();
            return;
        }
        serviceProvider.getArbitratorManager().getDisputeAgentByNodeAddress(this.getArbitratorNodeAddress()).ifPresent(arbitrator -> this.getArbitrator().setPubKeyRing(arbitrator.getPubKeyRing()));
        this.xmrConnectionService.addConnectionListener(connection -> ThreadUtils.execute(() -> this.onConnectionChanged(connection), (String)this.getId()));
        if (!this.isPayoutPublished()) {
            if (this instanceof BuyerTrade && (this.getState().ordinal() == State.BUYER_CONFIRMED_PAYMENT_SENT.ordinal() || this.getState() == State.BUYER_SEND_FAILED_PAYMENT_SENT_MSG)) {
                log.warn("Resetting state of {} {} from {} to {} because sending PaymentSentMessage failed", new Object[]{this.getClass().getSimpleName(), this.getId(), this.getState(), State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN});
                this.setState(State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN);
            }
            if (this instanceof SellerTrade && (this.getState().ordinal() == State.SELLER_CONFIRMED_PAYMENT_RECEIPT.ordinal() || this.getState() == State.SELLER_SEND_FAILED_PAYMENT_RECEIVED_MSG)) {
                log.warn("Resetting state of {} {} from {} to {} because sending PaymentReceivedMessage failed", new Object[]{this.getClass().getSimpleName(), this.getId(), this.getState(), State.BUYER_SENT_PAYMENT_SENT_MSG});
                this.resetToPaymentSentState();
            }
        }
        this.tradeStateSubscription = EasyBind.subscribe(this.stateProperty, newValue -> {
            if (!this.isInitialized || this.isShutDownStarted) {
                return;
            }
        });
        this.tradePhaseSubscription = EasyBind.subscribe(this.phaseProperty, newValue -> {
            if (!this.isInitialized || this.isShutDownStarted) {
                return;
            }
            ThreadUtils.submitToPool(() -> {
                if (newValue == Phase.DEPOSIT_REQUESTED) {
                    this.onDepositRequested();
                }
                if (newValue == Phase.DEPOSITS_PUBLISHED) {
                    this.onDepositsPublished();
                }
                if (newValue == Phase.DEPOSITS_CONFIRMED) {
                    this.onDepositsConfirmed();
                }
                if (newValue == Phase.DEPOSITS_UNLOCKED) {
                    this.onDepositsUnlocked();
                }
                if (newValue == Phase.DEPOSITS_FINALIZED) {
                    this.onDepositsFinalized();
                }
                if (newValue == Phase.PAYMENT_SENT) {
                    this.onPaymentSent();
                }
                if (this.isDepositsPublished() && !this.isPayoutFinalized()) {
                    this.updatePollPeriod();
                }
                if (this.isPaymentReceived()) {
                    UserThread.execute(() -> {
                        if (this.tradePhaseSubscription != null) {
                            this.tradePhaseSubscription.unsubscribe();
                            this.tradePhaseSubscription = null;
                        }
                    });
                }
            });
        });
        this.payoutStateSubscription = EasyBind.subscribe(this.payoutStateProperty, newValue -> {
            if (!this.isInitialized || this.isShutDownStarted) {
                return;
            }
            ThreadUtils.submitToPool(() -> {
                this.updatePollPeriod();
                if (newValue == PayoutState.PAYOUT_PUBLISHED) {
                    log.info("Payout published for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                    ThreadUtils.submitToPool(() -> {
                        HavenoUtils.waitFor(1000L);
                        if (this.isPayoutConfirmed()) {
                            return;
                        }
                        if (this.isShutDownStarted) {
                            return;
                        }
                        if (this.xmrConnectionService.isConnected().booleanValue()) {
                            this.syncAndPollWallet();
                        }
                    });
                    if (this.getDisputeState().isDisputed() && !this.getDisputeState().isClosed()) {
                        this.processModel.getTradeManager().closeDisputedTrade(this.getId(), DisputeState.DISPUTE_CLOSED);
                        if (!this.isArbitrator()) {
                            for (Dispute dispute : this.getDisputes()) {
                                dispute.setIsClosed();
                            }
                        }
                    }
                    if (this.isArbitrator() && !this.isCompleted()) {
                        this.processModel.getTradeManager().onTradeCompleted(this);
                    }
                    this.maybePublishTradeStatistics();
                    this.processModel.getXmrWalletService().swapPayoutAddressEntryToAvailable(this.getId());
                }
                if (newValue == PayoutState.PAYOUT_FINALIZED) {
                    if (!this.isInitialized) {
                        return;
                    }
                    log.info("Payout finalized for {} {}, deleting multisig wallet", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                    if (this.isInitialized && this.isFinished()) {
                        this.clearAndShutDown();
                    } else {
                        ThreadUtils.execute(() -> this.deleteWallet(), (String)this.getId());
                    }
                }
            });
        });
        this.disputeStateSubscription = EasyBind.subscribe(this.disputeStateProperty, newValue -> {
            if (!this.isInitialized || this.isShutDownStarted) {
                return;
            }
            ThreadUtils.submitToPool(() -> {
                if (this.isDisputeClosed()) {
                    this.maybePublishTradeStatistics();
                }
            });
        });
        if (this instanceof ArbitratorTrade) {
            this.idlePayoutSyncer = new IdlePayoutSyncer();
            this.xmrWalletService.addWalletListener((MoneroWalletListenerI)this.idlePayoutSyncer);
        }
        if (this.isBuyer() && (expectedState = this.getPaymentSentMessageState()) != null && expectedState != this.getSeller().getPaymentSentMessageStateProperty().get()) {
            log.warn("Updating unexpected payment sent message state for {} {}, expected={}, actual={}", new Object[]{this.getClass().getSimpleName(), this.getId(), expectedState, this.processModel.getPaymentSentMessageStatePropertySeller().get()});
            this.getSeller().getPaymentSentMessageStateProperty().set((Object)expectedState);
        }
        this.walletHeight.addListener((observable, oldValue, newValue) -> this.importMultisigHexIfScheduled());
        if (!this.isDepositRequested() || this.isPayoutFinalized()) {
            this.isInitialized = true;
            this.isFullyInitialized = true;
            return;
        }
        if (!this.walletExists()) {
            MoneroTx payoutTx = this.getPayoutTx();
            if (payoutTx != null) {
                if (!this.isPayoutUnlocked() && payoutTx.getNumConfirmations() >= 10L) {
                    log.warn("Payout state for {} {} is {} but payout is unlocked, updating state", new Object[]{this.getClass().getSimpleName(), this.getId(), this.getPayoutState()});
                    this.setPayoutStateUnlocked();
                }
                if (!this.isPayoutFinalized() && payoutTx.getNumConfirmations() >= (long)NUM_BLOCKS_PAYOUT_FINALIZED) {
                    log.warn("Payout state for {} {} is {} but payout is finalized, updating state", new Object[]{this.getClass().getSimpleName(), this.getId(), this.getPayoutState()});
                    this.setPayoutStateFinalized();
                }
                this.isInitialized = true;
                this.isFullyInitialized = true;
                return;
            }
            throw new RuntimeException("Missing trade wallet for " + this.getClass().getSimpleName() + " " + this.getShortId() + ", state=" + String.valueOf((Object)this.getState()) + ", marked completed=" + this.isCompleted());
        }
        this.getWallet();
        this.walletHeight.set(this.wallet.getHeight());
        this.doPollWallet(true);
        this.isInitialized = true;
        this.maybeInitSyncing();
        this.isFullyInitialized = true;
    }

    public boolean isFinished() {
        if (!this.isCompleted()) {
            return false;
        }
        if (this.isPayoutUnlocked() && !this.walletExistsNoSync()) {
            return true;
        }
        return this.isPayoutFinalized();
    }

    public void resetToPaymentSentState() {
        this.setState(State.BUYER_SENT_PAYMENT_SENT_MSG);
        for (TradePeer peer : this.getAllPeers()) {
            peer.setPaymentReceivedMessage(null);
        }
        this.setPayoutTxHex(null);
    }

    public void initializeAfterMailboxMessages() {
        if (!this.isDepositRequested() || this.isPayoutFinalized() || this.isCompleted()) {
            return;
        }
        this.getProtocol().maybeReprocessPaymentSentMessage(false);
        this.getProtocol().maybeReprocessPaymentReceivedMessage(false);
        HavenoUtils.arbitrationManager.maybeReprocessDisputeClosedMessage(this, false);
        if (this.wasWalletSyncedAndPolledProperty.get()) {
            this.onWalletFirstSynced();
        } else {
            this.wasWalletSyncedAndPolledProperty.addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.onWalletFirstSynced();
                }
            });
        }
    }

    private void onWalletFirstSynced() {
        this.requestSaveWallet();
        this.checkForUnconfirmedTimeout();
    }

    private void checkForUnconfirmedTimeout() {
        if (this.isDepositsConfirmed()) {
            return;
        }
        long unconfirmedHours = Duration.between(this.getDate().toInstant(), Instant.now()).toHours();
        if (unconfirmedHours >= 3L && !this.hasFailed()) {
            String errorMessage = Res.get("portfolio.pending.unconfirmedTooLong", this.getShortId(), unconfirmedHours);
            this.prependErrorMessage(errorMessage);
        }
    }

    public void awaitInitialized() {
        while (!this.isFullyInitialized) {
            HavenoUtils.waitFor(100L);
        }
    }

    public void requestPersistence() {
        if (this.processModel.getTradeManager() != null) {
            this.processModel.getTradeManager().requestPersistence();
        }
    }

    public void persistNow(@Nullable Runnable completeHandler) {
        if (this.processModel.getTradeManager() != null) {
            this.processModel.getTradeManager().persistNow(completeHandler);
        }
    }

    public TradeProtocol getProtocol() {
        return this.processModel.getTradeManager().getTradeProtocol(this);
    }

    public void setMyNodeAddress() {
        this.getSelf().setNodeAddress(P2PService.getMyNodeAddress());
    }

    public NodeAddress getTradePeerNodeAddress() {
        return this.getTradePeer() == null ? null : this.getTradePeer().getNodeAddress();
    }

    public NodeAddress getArbitratorNodeAddress() {
        return this.getArbitrator() == null ? null : this.getArbitrator().getNodeAddress();
    }

    public void setCompleted(boolean completed) {
        this.isCompleted = completed;
        if (this.isInitialized && this.isFinished()) {
            this.clearAndShutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean walletExists() {
        Object object = this.walletLock;
        synchronized (object) {
            return this.xmrWalletService.walletExists(this.getWalletName());
        }
    }

    protected boolean walletExistsNoSync() {
        return this.xmrWalletService.walletExists(this.getWalletName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroWallet createWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.walletExists()) {
                throw new RuntimeException("Cannot create trade wallet because it already exists");
            }
            long time = System.currentTimeMillis();
            this.wallet = this.xmrWalletService.createWallet(this.getWalletName());
            log.info("{} {} created multisig wallet in {} ms", new Object[]{this.getClass().getSimpleName(), this.getId(), System.currentTimeMillis() - time});
            return this.wallet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroWallet getWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.wallet != null) {
                return this.wallet;
            }
            if (!this.walletExists()) {
                return null;
            }
            if (this.isShutDownStarted) {
                throw new RuntimeException("Cannot open wallet for " + this.getClass().getSimpleName() + " " + this.getId() + " because shut down is started");
            }
            this.wallet = this.xmrWalletService.openWallet(this.getWalletName(), this.xmrWalletService.isProxyApplied(this.wasWalletSynced));
            return this.wallet;
        }
    }

    public long getHeight() {
        return this.walletHeight.get();
    }

    private String getWalletName() {
        return MONERO_TRADE_WALLET_PREFIX + this.getShortId() + "_" + this.getShortUid();
    }

    public void verifyDaemonConnection() {
        if (!Boolean.TRUE.equals(this.xmrConnectionService.isConnected())) {
            throw new RuntimeException("Connection service is not connected to a Monero node");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWalletConnectedToDaemon() {
        Object object = this.walletLock;
        synchronized (object) {
            try {
                if (this.wallet == null) {
                    return false;
                }
                return this.wallet.isConnectedToDaemon();
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public boolean isIdling() {
        if (this.isPayoutUnlocked()) {
            return true;
        }
        return this instanceof ArbitratorTrade && this.isDepositsConfirmed() && this.walletExistsNoSync() && this.pollNormalStartTimeMs == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncedWithinTolerance() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.wallet == null) {
                return false;
            }
            if (!this.xmrConnectionService.isSyncedWithinTolerance()) {
                return false;
            }
            Long targetHeight = this.xmrConnectionService.getTargetHeight();
            if (targetHeight == null) {
                return false;
            }
            return targetHeight - this.walletHeight.get() <= 3L;
            {
            }
        }
    }

    public void syncAndPollWallet() {
        this.syncWallet(true);
    }

    public void pollWalletNormallyForMs(long pollNormalDuration) {
        this.pollNormalStartTimeMs = System.currentTimeMillis();
        this.setPollPeriod(this.xmrConnectionService.getRefreshPeriodMs());
        new Thread(() -> {
            HavenoUtils.waitFor(pollNormalDuration);
            Long pollNormalStartTimeMsCopy = this.pollNormalStartTimeMs;
            if (pollNormalStartTimeMsCopy == null) {
                return;
            }
            if (!this.isShutDown && System.currentTimeMillis() >= pollNormalStartTimeMsCopy + pollNormalDuration) {
                this.pollNormalStartTimeMs = null;
                this.updatePollPeriod();
            }
        }).start();
    }

    private boolean isInvalidImportError(String errMsg) {
        return errMsg.contains("Failed to parse hex") || errMsg.contains("Multisig info is for a different account");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeWalletPassword(String oldPassword, String newPassword) {
        Object object = this.walletLock;
        synchronized (object) {
            this.getWallet().changePassword(oldPassword, newPassword);
            this.saveWallet();
        }
    }

    @Override
    public void requestSaveWalletIfElapsedTime() {
        ThreadUtils.submitToPool(() -> {
            Object object = this.walletLock;
            synchronized (object) {
                if (this.walletExists()) {
                    this.saveWalletIfElapsedTime();
                }
            }
        });
    }

    private void requestSaveWallet() {
        ThreadUtils.submitToPool(() -> {
            Object object = this.walletLock;
            synchronized (object) {
                if (this.walletExists()) {
                    this.saveWallet();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            if (!this.walletExists()) {
                log.warn("Cannot save wallet for {} {} because it does not exist", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                return;
            }
            if (this.wallet == null) {
                throw new RuntimeException("Trade wallet is not open for trade " + this.getShortId());
            }
            this.xmrWalletService.saveWallet(this.wallet);
            this.lastSaveTimeMs = System.currentTimeMillis();
            this.maybeBackupWallet();
        }
    }

    private void maybeBackupWallet() {
        boolean createBackup;
        boolean bl = createBackup = !this.isArbitrator() && (!Utilities.isWindows() || !this.isWalletOpen());
        if (createBackup) {
            this.xmrWalletService.backupWallet(this.getWalletName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWalletOpen() {
        Object object = this.walletLock;
        synchronized (object) {
            return this.wallet != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.wallet == null) {
                throw new RuntimeException("Trade wallet to close is not open for trade " + this.getId());
            }
            this.stopPolling();
            this.xmrWalletService.closeWallet(this.wallet, true);
            this.maybeBackupWallet();
            this.wallet = null;
            this.pollPeriodMs = null;
        }
    }

    private void forceCloseWallet() {
        if (this.wallet != null) {
            try {
                this.xmrWalletService.forceCloseWallet(this.wallet, this.wallet.getPath());
            }
            catch (Exception e) {
                log.warn("Error force closing wallet for {} {}: {}", new Object[]{this.getClass().getSimpleName(), this.getId(), e.getMessage()});
            }
            this.stopPolling();
            this.wallet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWallet() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.walletExists()) {
                try {
                    if (this.isDepositRequested() && !this.isPayoutFinalized()) {
                        boolean syncedWallet = false;
                        if (this.wallet == null) {
                            log.warn("Wallet is not initialized for {} {}, opening", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                            this.getWallet();
                            this.syncWallet(true);
                            syncedWallet = true;
                        }
                        if (!syncedWallet) {
                            log.warn("Syncing wallet on deletion for trade {} {}, syncing", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                            this.syncWallet(true);
                        }
                        if (this.isDepositsPublished() && !this.isPayoutFinalized()) {
                            throw new IllegalStateException("Refusing to delete wallet for " + this.getClass().getSimpleName() + " " + this.getId() + " because the deposit txs have been published but payout tx has not finalized");
                        }
                        if (this.wallet.getBalance().compareTo(BigInteger.ZERO) > 0) {
                            log.warn("Rescanning spent outputs for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                            this.rescanSpent(false);
                            if (this.wallet.getBalance().compareTo(BigInteger.ZERO) > 0) {
                                if (this.isBuyer()) {
                                    this.processBuyerPayout(this.payoutTxId);
                                    log.warn("Trade wallet for " + this.getClass().getSimpleName() + " " + this.getId() + " has a balance of " + String.valueOf(this.wallet.getBalance()) + ", but payout tx " + this.payoutTxId + " is verified, so proceeding to delete wallet");
                                } else {
                                    throw new IllegalStateException("Refusing to delete wallet for " + this.getClass().getSimpleName() + " " + this.getId() + " because it has a balance of " + String.valueOf(this.wallet.getBalance()));
                                }
                            }
                        }
                    }
                    this.forceCloseWallet();
                    log.info("Deleting wallet and backups for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                    this.xmrWalletService.deleteWallet(this.getWalletName());
                    this.xmrWalletService.deleteWalletBackups(this.getWalletName());
                }
                catch (Exception e) {
                    log.warn("Error deleting wallet for {} {}: {}\n", new Object[]{this.getClass().getSimpleName(), this.getId(), e.getMessage(), e});
                    this.prependErrorMessage(e.getMessage());
                    this.processModel.getTradeManager().getNotificationService().sendErrorNotification("Error", e.getMessage());
                }
            } else {
                log.warn("Multisig wallet to delete for trade {} does not exist", (Object)this.getId());
            }
        }
    }

    public Contract createContract() {
        boolean isBuyerMakerAndSellerTaker = this.getOffer().getDirection() == OfferDirection.BUY;
        Contract contract = new Contract(this.getOffer().getOfferPayload(), ((BigInteger)Preconditions.checkNotNull((Object)this.getAmount())).longValueExact(), this.getPrice().getValue(), (isBuyerMakerAndSellerTaker ? this.getMaker() : this.getTaker()).getNodeAddress(), (isBuyerMakerAndSellerTaker ? this.getTaker() : this.getMaker()).getNodeAddress(), this.getArbitrator().getNodeAddress(), isBuyerMakerAndSellerTaker, this instanceof MakerTrade ? this.processModel.getAccountId() : this.getMaker().getAccountId(), this instanceof TakerTrade ? this.processModel.getAccountId() : this.getTaker().getAccountId(), (String)Preconditions.checkNotNull((Object)(this instanceof MakerTrade ? this.getMaker().getPaymentAccountPayload().getPaymentMethodId() : this.getOffer().getOfferPayload().getPaymentMethodId())), (String)Preconditions.checkNotNull((Object)(this instanceof TakerTrade ? this.getTaker().getPaymentAccountPayload().getPaymentMethodId() : this.getTaker().getPaymentMethodId())), this instanceof MakerTrade ? this.getMaker().getPaymentAccountPayload().getHash() : this.getMaker().getPaymentAccountPayloadHash(), this instanceof TakerTrade ? this.getTaker().getPaymentAccountPayload().getHash() : this.getTaker().getPaymentAccountPayloadHash(), this.getMaker().getPubKeyRing(), this.getTaker().getPubKeyRing(), this instanceof MakerTrade ? this.xmrWalletService.getAddressEntry(this.getId(), XmrAddressEntry.Context.TRADE_PAYOUT).get().getAddressString() : this.getMaker().getPayoutAddressString(), this instanceof TakerTrade ? this.xmrWalletService.getAddressEntry(this.getId(), XmrAddressEntry.Context.TRADE_PAYOUT).get().getAddressString() : this.getTaker().getPayoutAddressString(), this.getMaker().getDepositTxHash(), this.getTaker().getDepositTxHash());
        return contract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MoneroTxWallet createTx(MoneroTxConfig txConfig) {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                MoneroTxWallet tx = this.wallet.createTx(txConfig);
                this.exportMultisigHex();
                return tx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportMultisigHex() {
        Object object = this.walletLock;
        synchronized (object) {
            log.info("Exporting multisig info for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
            this.getSelf().setUpdatedMultisigHex(this.wallet.exportMultisigHex());
            this.saveWallet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMultisigHexIfNeeded() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.wallet.isMultisigImportNeeded()) {
                this.importMultisigHex();
            }
        }
    }

    public void scheduleImportMultisigHex() {
        this.processModel.setImportMultisigHexScheduled(true);
        this.requestPersistence();
    }

    private void importMultisigHexIfScheduled() {
        if (!this.isInitialized || this.isShutDownStarted) {
            return;
        }
        MoneroTxWallet makerDepositTx = this.getMaker().getDepositTx();
        if (!this.isDepositsConfirmed() || makerDepositTx == null) {
            return;
        }
        if (this.walletHeight.get() - makerDepositTx.getHeight() < 5L) {
            return;
        }
        ThreadUtils.execute(() -> {
            if (!this.isInitialized || this.isShutDownStarted) {
                return;
            }
            Object object = this.getLock();
            synchronized (object) {
                if (this.processModel.isImportMultisigHexScheduled()) {
                    this.importMultisigHex();
                    this.processModel.setImportMultisigHexScheduled(false);
                }
            }
        }, (String)this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMultisigHex() {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getDaemonLock();
            synchronized (object2) {
                Object object3 = importMultisigLock;
                synchronized (object3) {
                    for (int i = 0; i < 5; ++i) {
                        MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                        try {
                            this.doImportMultisigHex();
                            break;
                        }
                        catch (IllegalArgumentException | IllegalStateException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            if (this.isShutDownStarted && this.wallet == null) {
                                log.warn("Aborting import of multisig hex for {} {} because shut down is started and wallet is closed", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                                break;
                            }
                            log.warn("Failed to import multisig hex, tradeId={}, attempt={}/{}, error={}", new Object[]{this.getShortId(), i + 1, 5, e.getMessage()});
                            this.handleWalletError(e, sourceConnection, i + 1);
                            this.doPollWallet();
                            if (this.isPayoutPublished()) break;
                            if (i == 4) {
                                throw e;
                            }
                            HavenoUtils.waitFor(5000L);
                            continue;
                        }
                    }
                }
            }
        }
    }

    private void doImportMultisigHex() {
        if (!this.isDepositsConfirmed() && !this.hasUnlockedTx()) {
            this.syncAndPollWallet();
        }
        ArrayList<String> multisigHexes = new ArrayList<String>();
        for (TradePeer peer : this.getOtherPeers()) {
            if (peer.getUpdatedMultisigHex() == null) continue;
            multisigHexes.add(peer.getUpdatedMultisigHex());
        }
        log.info("Importing multisig hexes for {} {}, count={}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), multisigHexes.size()});
        long startTime = System.currentTimeMillis();
        if (!multisigHexes.isEmpty()) {
            try {
                this.wallet.importMultisigHex(multisigHexes.toArray(new String[0]));
                if (this.wallet.isMultisigImportNeeded()) {
                    String errorMessage = "Multisig import still needed for " + this.getClass().getSimpleName() + " " + this.getShortId() + " after already importing, multisigHexes=" + String.valueOf(multisigHexes);
                    log.warn(errorMessage);
                    int maxLength = 0;
                    String shortestMultisigHex = null;
                    for (String hex : multisigHexes) {
                        if (shortestMultisigHex == null || hex.length() < shortestMultisigHex.length()) {
                            shortestMultisigHex = hex;
                        }
                        if (hex.length() <= maxLength) continue;
                        maxLength = hex.length();
                    }
                    if (shortestMultisigHex.length() < maxLength) {
                        log.warn("Removing multisig hex from " + this.getMultisigHexRole(shortestMultisigHex) + " for " + this.getClass().getSimpleName() + " " + this.getShortId() + " because it's the shortest, multisigHex=" + shortestMultisigHex);
                        multisigHexes.remove(shortestMultisigHex);
                        this.wallet.importMultisigHex(multisigHexes.toArray(new String[0]));
                    }
                    if (this.wallet.isMultisigImportNeeded()) {
                        throw new IllegalStateException(errorMessage);
                    }
                }
                this.processModel.setImportMultisigHexScheduled(false);
            }
            catch (MoneroError e) {
                if (this.isInvalidImportError(e.getMessage())) {
                    log.warn("Peer has invalid multisig hex for {} {}, importing individually", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                    boolean imported = false;
                    MoneroError lastError = null;
                    for (TradePeer peer : this.getOtherPeers()) {
                        if (peer.getUpdatedMultisigHex() == null) continue;
                        try {
                            this.wallet.importMultisigHex(new String[]{peer.getUpdatedMultisigHex()});
                            imported = true;
                        }
                        catch (MoneroError e2) {
                            lastError = e2;
                            if (this.isInvalidImportError(e2.getMessage())) {
                                log.warn("{} has invalid multisig hex for {} {}, error={}, multisigHex={}", new Object[]{this.getPeerRole(peer), this.getClass().getSimpleName(), this.getShortId(), e2.getMessage(), peer.getUpdatedMultisigHex()});
                                continue;
                            }
                            throw e2;
                        }
                    }
                    if (!imported) {
                        throw new IllegalArgumentException("Could not import any multisig hexes for " + this.getClass().getSimpleName() + " " + this.getShortId(), lastError);
                    }
                }
                throw e;
            }
            this.saveWallet();
        }
        log.info("Done importing multisig hexes for {} {} in {} ms, count={}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), System.currentTimeMillis() - startTime, multisigHexes.size()});
    }

    private void handleWalletError(Exception e, MoneroRpcConnection sourceConnection, int numAttempts) {
        if (HavenoUtils.isUnresponsive(e)) {
            this.forceCloseWallet();
        }
        if (numAttempts % 2 == 0 && !HavenoUtils.isIllegal(e) && this.xmrConnectionService.isConnected().booleanValue()) {
            this.requestSwitchToNextBestConnection(sourceConnection);
        }
        if (!this.isShutDownStarted) {
            this.getWallet();
        }
    }

    private String getMultisigHexRole(String multisigHex) {
        if (multisigHex.equals(this.getArbitrator().getUpdatedMultisigHex())) {
            return "arbitrator";
        }
        if (multisigHex.equals(this.getBuyer().getUpdatedMultisigHex())) {
            return "buyer";
        }
        if (multisigHex.equals(this.getSeller().getUpdatedMultisigHex())) {
            return "seller";
        }
        throw new IllegalArgumentException("Multisig hex does not belong to any peer");
    }

    public MoneroTxWallet createPayoutTx() {
        this.verifyDaemonConnection();
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                this.importMultisigHexIfNeeded();
                for (int i = 0; i < 5; ++i) {
                    MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                    try {
                        MoneroTxWallet unsignedPayoutTx = this.doCreatePayoutTx();
                        log.info("Done creating unsigned payout tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                        return unsignedPayoutTx;
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.handleWalletError(e, sourceConnection, i + 1);
                        this.doPollWallet();
                        if (this.isPayoutPublished()) break;
                        log.warn("Failed to create payout tx, tradeId={}, attempt={}/{}, error={}", new Object[]{this.getShortId(), i + 1, 5, e.getMessage()});
                        if (i == 4) {
                            throw e;
                        }
                        HavenoUtils.waitFor(5000L);
                        continue;
                    }
                }
                throw new RuntimeException("Failed to create payout tx for " + this.getClass().getSimpleName() + " " + this.getId());
            }
        }
    }

    private MoneroTxWallet doCreatePayoutTx() {
        MoneroTxWallet payoutTx;
        if (this.wallet.isMultisigImportNeeded()) {
            throw new IllegalStateException("Cannot create payout tx because multisig import is needed for " + this.getClass().getSimpleName() + " " + this.getShortId());
        }
        this.recoverIfMissingWalletData();
        String sellerPayoutAddress = this.getSeller().getPayoutAddressString();
        String buyerPayoutAddress = this.getBuyer().getPayoutAddressString();
        Preconditions.checkNotNull((Object)sellerPayoutAddress, (Object)"Seller payout address must not be null");
        Preconditions.checkNotNull((Object)buyerPayoutAddress, (Object)"Buyer payout address must not be null");
        BigInteger sellerDepositAmount = this.getSeller().getDepositTx().getIncomingAmount();
        BigInteger buyerDepositAmount = this.hasBuyerAsTakerWithoutDeposit() ? BigInteger.ZERO : this.getBuyer().getDepositTx().getIncomingAmount();
        BigInteger tradeAmount = this.getAmount();
        BigInteger buyerPayoutAmount = buyerDepositAmount.add(tradeAmount);
        BigInteger sellerPayoutAmount = sellerDepositAmount.subtract(tradeAmount);
        try {
            payoutTx = this.createTx(new MoneroTxConfig().setAccountIndex(Integer.valueOf(0)).addDestination(buyerPayoutAddress, buyerPayoutAmount).addDestination(sellerPayoutAddress, sellerPayoutAmount).setSubtractFeeFrom(new Integer[]{0, 1}).setRelay(Boolean.valueOf(false)).setPriority(XmrWalletService.PROTOCOL_FEE_PRIORITY));
        }
        catch (Exception e) {
            if (HavenoUtils.isMultisigError(e)) {
                throw new IllegalStateException(e);
            }
            throw e;
        }
        BigInteger payoutTxFeeSplit = payoutTx.getFee().divide(BigInteger.valueOf(2L));
        this.getBuyer().setPayoutTxFee(payoutTxFeeSplit);
        this.getBuyer().setPayoutAmount(HavenoUtils.getDestination(buyerPayoutAddress, payoutTx).getAmount());
        this.getSeller().setPayoutTxFee(payoutTxFeeSplit);
        this.getSeller().setPayoutAmount(HavenoUtils.getDestination(sellerPayoutAddress, payoutTx).getAmount());
        return payoutTx;
    }

    public MoneroTxWallet createDisputePayoutTx(MoneroTxConfig txConfig) {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                for (int i = 0; i < 5; ++i) {
                    MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                    try {
                        if (this.wallet.isMultisigImportNeeded()) {
                            throw new IllegalStateException("Cannot create dispute payout tx because multisig import is needed for " + this.getClass().getSimpleName() + " " + this.getShortId());
                        }
                        return this.createTx(txConfig);
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (HavenoUtils.isMultisigError(e)) {
                            throw new IllegalStateException(e);
                        }
                        if (e.getMessage().contains("not possible")) {
                            throw new IllegalArgumentException("Loser payout is too small to cover the mining fee");
                        }
                        this.handleWalletError(e, sourceConnection, i + 1);
                        this.doPollWallet();
                        if (this.isPayoutPublished()) break;
                        log.warn("Failed to create dispute payout tx, tradeId={}, attempt={}/{}, error={}", new Object[]{this.getShortId(), i + 1, 5, e.getMessage()});
                        if (i == 4) {
                            throw e;
                        }
                        HavenoUtils.waitFor(5000L);
                        continue;
                    }
                }
                throw new RuntimeException("Failed to create payout tx for " + this.getClass().getSimpleName() + " " + this.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPayoutTx(String payoutTxHex, boolean sign, boolean publish) {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                for (int i = 0; i < 5; ++i) {
                    MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                    try {
                        this.doProcessPayoutTx(payoutTxHex, sign, publish);
                        break;
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.handleWalletError(e, sourceConnection, i + 1);
                        this.doPollWallet();
                        if (this.isPayoutPublished()) break;
                        log.warn("Failed to process payout tx, tradeId={}, attempt={}/{}, error={}", new Object[]{this.getShortId(), i + 1, 5, e.getMessage(), e});
                        if (i == 4) {
                            throw e;
                        }
                        HavenoUtils.waitFor(5000L);
                        continue;
                    }
                    finally {
                        this.saveWallet();
                        this.persistNow(null);
                    }
                }
            }
        }
    }

    private void doProcessPayoutTx(String payoutTxHex, boolean sign, boolean publish) {
        block20: {
            boolean doPublish;
            boolean doSign;
            log.info("Processing payout tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
            this.recoverIfMissingWalletData();
            MoneroWallet wallet = this.getWallet();
            Contract contract = this.getContract();
            BigInteger sellerDepositAmount = this.getSeller().getDepositTx().getIncomingAmount();
            BigInteger buyerDepositAmount = this.hasBuyerAsTakerWithoutDeposit() ? BigInteger.ZERO : this.getBuyer().getDepositTx().getIncomingAmount();
            BigInteger tradeAmount = this.getAmount();
            MoneroTxSet describedTxSet = wallet.describeTxSet(new MoneroTxSet().setMultisigTxHex(payoutTxHex));
            if (describedTxSet.getTxs() == null || describedTxSet.getTxs().size() != 1) {
                throw new IllegalArgumentException("Bad payout tx");
            }
            MoneroTxWallet payoutTx = (MoneroTxWallet)describedTxSet.getTxs().get(0);
            if (this.payoutTxId == null) {
                this.setPayoutTx((MoneroTx)payoutTx);
            }
            if (payoutTx.getOutgoingTransfer() == null || payoutTx.getOutgoingTransfer().getDestinations() == null || payoutTx.getOutgoingTransfer().getDestinations().size() != 2) {
                throw new IllegalArgumentException("Payout tx does not have exactly two destinations");
            }
            boolean buyerFirst = ((MoneroDestination)payoutTx.getOutgoingTransfer().getDestinations().get(0)).getAddress().equals(contract.getBuyerPayoutAddressString());
            MoneroDestination buyerPayoutDestination = (MoneroDestination)payoutTx.getOutgoingTransfer().getDestinations().get(buyerFirst ? 0 : 1);
            MoneroDestination sellerPayoutDestination = (MoneroDestination)payoutTx.getOutgoingTransfer().getDestinations().get(buyerFirst ? 1 : 0);
            if (!buyerPayoutDestination.getAddress().equals(contract.getBuyerPayoutAddressString())) {
                throw new IllegalArgumentException("Buyer payout address does not match contract");
            }
            if (!sellerPayoutDestination.getAddress().equals(contract.getSellerPayoutAddressString())) {
                throw new IllegalArgumentException("Seller payout address does not match contract");
            }
            if (!payoutTx.getChangeAmount().equals(BigInteger.ZERO)) {
                log.warn("Dust left in multisig wallet for {} {}: {}", new Object[]{this.getClass().getSimpleName(), this.getId(), payoutTx.getChangeAmount()});
            }
            if (!payoutTx.getChangeAmount().equals(BigInteger.ZERO) && !payoutTx.getChangeAddress().equals(wallet.getPrimaryAddress())) {
                throw new IllegalArgumentException("Change address is not multisig wallet's primary address");
            }
            if (!payoutTx.getOutputSum().equals(buyerPayoutDestination.getAmount().add(sellerPayoutDestination.getAmount()).add(payoutTx.getChangeAmount()))) {
                throw new IllegalArgumentException("Sum of outputs != destination amounts + change amount");
            }
            BigInteger txCost = payoutTx.getFee().add(payoutTx.getChangeAmount());
            BigInteger txCostSplit = txCost.divide(BigInteger.valueOf(2L));
            BigInteger expectedBuyerPayout = buyerDepositAmount.add(tradeAmount).subtract(txCostSplit);
            if (!buyerPayoutDestination.getAmount().equals(expectedBuyerPayout)) {
                throw new IllegalArgumentException("Buyer destination amount is not deposit amount + trade amount - 1/2 tx costs, " + String.valueOf(buyerPayoutDestination.getAmount()) + " vs " + String.valueOf(expectedBuyerPayout));
            }
            BigInteger expectedSellerPayout = sellerDepositAmount.subtract(tradeAmount).subtract(txCostSplit);
            if (!sellerPayoutDestination.getAmount().equals(expectedSellerPayout)) {
                throw new IllegalArgumentException("Seller destination amount is not deposit amount - trade amount - 1/2 tx costs, " + String.valueOf(sellerPayoutDestination.getAmount()) + " vs " + String.valueOf(expectedSellerPayout));
            }
            this.setPayoutTx((MoneroTx)payoutTx);
            boolean bl = doSign = sign && this.getPayoutTxHex() == null;
            if (doSign || publish) {
                this.verifyDaemonConnection();
            }
            if (doSign) {
                String signedPayoutTxHex;
                try {
                    MoneroMultisigSignResult result = wallet.signMultisigTxHex(payoutTxHex);
                    if (result.getSignedMultisigTxHex() == null) {
                        throw new IllegalArgumentException("Error signing payout tx, signed multisig hex is null");
                    }
                    signedPayoutTxHex = result.getSignedMultisigTxHex();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                if (this.getOffer().getOfferPayload().getProtocolVersion() >= 2) {
                    log.info("Creating fee estimate tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                    this.saveWallet();
                    MoneroTxWallet feeEstimateTx = this.createPayoutTx();
                    HavenoUtils.verifyMinerFee(feeEstimateTx.getFee(), payoutTx.getFee());
                    log.info("Payout tx fee is within tolerance for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                }
                this.setPayoutTxHex(signedPayoutTxHex);
                describedTxSet = wallet.describeMultisigTxSet(this.getPayoutTxHex());
                payoutTx = (MoneroTxWallet)describedTxSet.getTxs().get(0);
                this.setPayoutTx((MoneroTx)payoutTx);
            }
            this.saveWallet();
            this.requestPersistence();
            boolean bl2 = doPublish = publish && !this.isPayoutPublished();
            if (doPublish) {
                try {
                    wallet.submitMultisigTxHex(this.getPayoutTxHex());
                    this.setPayoutStatePublished();
                }
                catch (Exception e) {
                    if (this.isPayoutPublished()) break block20;
                    if (HavenoUtils.isTransactionRejected(e) || HavenoUtils.isMultisigError(e)) {
                        throw new IllegalArgumentException(e);
                    }
                    throw new RuntimeException("Failed to submit payout tx for " + this.getClass().getSimpleName() + " " + this.getId() + ", error=" + e.getMessage(), e);
                }
            }
        }
    }

    public void processBuyerPayout(String payoutTxId) {
        if (payoutTxId == null) {
            throw new IllegalArgumentException("Payout tx id cannot be null");
        }
        if (!this.isBuyer()) {
            throw new IllegalStateException("Only buyer can process buyer payout tx for " + this.getClass().getSimpleName() + " " + this.getShortId());
        }
        log.warn("Processing payout tx for {} {} by polling main wallet", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
        this.xmrWalletService.doPollWallet(true);
        MoneroTxWallet payoutTx = this.xmrWalletService.getWallet().getTx(payoutTxId);
        if (payoutTx == null) {
            throw new RuntimeException("Payout tx id " + payoutTxId + " not found for " + this.getClass().getSimpleName() + " " + this.getId());
        }
        if (payoutTx.isFailed().booleanValue()) {
            throw new RuntimeException("Payout tx " + payoutTxId + " is failed for " + this.getClass().getSimpleName() + " " + this.getId());
        }
        BigInteger txCost = payoutTx.getFee();
        BigInteger txCostSplit = txCost.divide(BigInteger.valueOf(2L));
        BigInteger expectedAmount = this.getBuyer().getSecurityDeposit().add(this.getAmount()).subtract(txCostSplit);
        if (!payoutTx.getIncomingAmount().equals(expectedAmount)) {
            throw new IllegalStateException("Payout tx incoming amount is not deposit amount + trade amount - 1/2 tx costs, " + String.valueOf(payoutTx.getIncomingAmount()) + " vs " + String.valueOf(this.getBuyer().getSecurityDeposit().add(this.getAmount()).subtract(txCostSplit)));
        }
        this.setPayoutTx((MoneroTx)payoutTx);
    }

    public void decryptPeerPaymentAccountPayload(byte[] paymentAccountKey) {
        try {
            byte[] peerPaymentAccountPayloadHash;
            this.getTradePeer().setPaymentAccountKey(paymentAccountKey);
            SecretKey sk = Encryption.getSecretKeyFromBytes((byte[])this.getTradePeer().getPaymentAccountKey());
            byte[] decryptedPaymentAccountPayload = Encryption.decrypt((byte[])this.getTradePeer().getEncryptedPaymentAccountPayload(), (SecretKey)sk);
            CoreNetworkProtoResolver resolver = new CoreNetworkProtoResolver(Clock.systemDefaultZone());
            PaymentAccountPayload paymentAccountPayload = resolver.fromProto(protobuf.PaymentAccountPayload.parseFrom((byte[])decryptedPaymentAccountPayload));
            byte[] byArray = peerPaymentAccountPayloadHash = this instanceof MakerTrade ? this.getContract().getTakerPaymentAccountPayloadHash() : this.getContract().getMakerPaymentAccountPayloadHash();
            if (!Arrays.equals(paymentAccountPayload.getHash(), peerPaymentAccountPayloadHash)) {
                throw new RuntimeException("Hash of peer's payment account payload does not match contract");
            }
            this.getTradePeer().setPaymentAccountPayload(paymentAccountPayload);
            this.processModel.getPaymentAccountDecryptedProperty().set((Object)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public MoneroTxWallet getTakerDepositTx() {
        return this.getTaker().getDepositTx();
    }

    @Nullable
    public MoneroTxWallet getMakerDepositTx() {
        return this.getMaker().getDepositTx();
    }

    private Long getMinDepositTxConfirmations() {
        MoneroTxWallet makerDepositTx = this.getMakerDepositTx();
        if (makerDepositTx == null) {
            return null;
        }
        if (this.hasBuyerAsTakerWithoutDeposit()) {
            return makerDepositTx.getNumConfirmations();
        }
        MoneroTxWallet takerDepositTx = this.getTakerDepositTx();
        if (takerDepositTx == null) {
            return null;
        }
        return Math.min(makerDepositTx.getNumConfirmations(), takerDepositTx.getNumConfirmations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndPersistChatMessage(ChatMessage chatMessage) {
        ObservableList<ChatMessage> observableList = this.chatMessages;
        synchronized (observableList) {
            if (!this.chatMessages.contains((Object)chatMessage)) {
                this.chatMessages.add((Object)chatMessage);
            } else {
                log.error("Trade ChatMessage already exists");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllChatMessages() {
        ObservableList<ChatMessage> observableList = this.chatMessages;
        synchronized (observableList) {
            if (this.chatMessages.size() > 0) {
                this.chatMessages.clear();
                return true;
            }
            return false;
        }
    }

    public boolean mediationResultAppliedPenaltyToSeller() {
        long normalPayoutAmount;
        long payoutAmountFromMediation = this.processModel.getSellerPayoutAmountFromMediation();
        return payoutAmountFromMediation < (normalPayoutAmount = this.getSeller().getSecurityDeposit().longValueExact());
    }

    public void clearAndShutDown() {
        this.removeDecryptedDirectMessageListener();
        ThreadUtils.execute(() -> {
            this.clearProcessData();
            this.onShutDownStarted();
            ThreadUtils.submitToPool(() -> this.shutDown());
        }, (String)this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProcessData() {
        Iterator<TradePeer> iterator = this.walletLock;
        synchronized (iterator) {
            if (!this.walletExists()) {
                return;
            }
            this.deleteWallet();
        }
        if (this.processModel.isPaymentReceivedMessagesAckedOrStored()) {
            this.setPayoutTxHex(null);
        }
        for (TradePeer peer : this.getAllPeers()) {
            peer.setUpdatedMultisigHex(null);
            peer.setDisputeClosedMessage(null);
            peer.setPaymentSentMessage(null);
            peer.setDepositTxHex(null);
            peer.setDepositTxKey(null);
            if (!peer.isPaymentReceivedMessageAckedOrStored()) continue;
            peer.setUnsignedPayoutTxHex(null);
            peer.setPaymentReceivedMessage(null);
        }
    }

    private void removeDecryptedDirectMessageListener() {
        if (this.getProcessModel() == null || this.getProcessModel().getProvider() == null || this.getProcessModel().getP2PService() == null) {
            return;
        }
        this.getProcessModel().getP2PService().removeDecryptedDirectMessageListener((DecryptedDirectMessageListener)this.getProtocol());
    }

    public void maybeClearSensitiveData() {
        String edited;
        Object change = "";
        if (this.contract != null && this.contract.maybeClearSensitiveData()) {
            change = (String)change + "contract;";
        }
        if (this.processModel != null && this.processModel.maybeClearSensitiveData()) {
            change = (String)change + "processModel;";
        }
        if (this.contractAsJson != null && !(edited = Contract.sanitizeContractAsJson(this.contractAsJson)).equals(this.contractAsJson)) {
            this.contractAsJson = edited;
            change = (String)change + "contractAsJson;";
        }
        if (this.removeAllChatMessages()) {
            change = (String)change + "chat messages;";
        }
        if (((String)change).length() > 0) {
            log.info("Cleared sensitive data from {} of {} {}", new Object[]{change, this.getClass().getSimpleName(), this.getShortId()});
        }
    }

    public void onShutDownStarted() {
        if (!this.isShutDownStarted) {
            if (this.wallet != null) {
                log.info("Preparing to shut down {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
            }
            this.isShutDownStarted = true;
            this.stopPolling();
        }
    }

    public void shutDown() {
        if (this.isShutDown) {
            return;
        }
        this.onShutDownStarted();
        if (!this.isPayoutFinalized() || !this.isPayoutUnlocked() || this.walletExistsNoSync()) {
            log.info("Shutting down {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
        }
        this.removeDecryptedDirectMessageListener();
        Runnable shutDownTask = () -> {
            for (int i = 0; i < 20; ++i) {
                Object object = this.getLock();
                synchronized (object) {
                    HavenoUtils.waitFor(10L);
                    continue;
                }
            }
            this.isShutDown = true;
            ArrayList<Runnable> shutDownThreads = new ArrayList<Runnable>();
            shutDownThreads.add(() -> ThreadUtils.shutDown((String)this.getId()));
            ThreadUtils.awaitTasks(shutDownThreads);
            this.stopProtocolTimeout();
            this.isInitialized = false;
            if (this.wallet != null) {
                try {
                    this.closeWallet();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        try {
            ThreadUtils.awaitTask((Runnable)shutDownTask, (Long)60000L);
        }
        catch (Exception e) {
            log.warn("Error shutting down {} {}: {}\n", new Object[]{this.getClass().getSimpleName(), this.getId(), e.getMessage(), e});
            this.forceCloseWallet();
        }
        if (this.idlePayoutSyncer != null) {
            this.xmrWalletService.removeWalletListener((MoneroWalletListenerI)this.idlePayoutSyncer);
            this.idlePayoutSyncer = null;
        }
        UserThread.execute(() -> {
            if (this.tradeStateSubscription != null) {
                this.tradeStateSubscription.unsubscribe();
            }
            if (this.tradePhaseSubscription != null) {
                this.tradePhaseSubscription.unsubscribe();
            }
            if (this.payoutStateSubscription != null) {
                this.payoutStateSubscription.unsubscribe();
            }
            if (this.disputeStateSubscription != null) {
                this.disputeStateSubscription.unsubscribe();
            }
        });
    }

    public void onProtocolInitializationError() {
        if (this.isDepositsPublished()) {
            this.restoreDepositsPublishedTrade();
            return;
        }
        if (!this.isDepositRequested() || this.isDepositRequestFailed()) {
            this.removeTradeOnError();
            return;
        }
        if (!this.walletExists()) {
            this.removeTradeOnError();
            return;
        }
        if (this.processModel.getTradeProtocolErrorHeight() == 0L) {
            log.warn("Scheduling to remove trade if unfunded for {} {} from height {}", new Object[]{this.getClass().getSimpleName(), this.getId(), this.xmrConnectionService.getLastInfo().getHeight()});
            this.processModel.setTradeProtocolErrorHeight(this.xmrConnectionService.getLastInfo().getHeight());
        }
        this.processModel.getTradeManager().onMoveInvalidTradeToFailedTrades(this);
        this.requestPersistence();
        this.protocolErrorStateSubscription = EasyBind.subscribe(this.stateProperty(), state -> {
            if (this.isDepositsPublished()) {
                this.restoreDepositsPublishedTrade();
                if (this.protocolErrorStateSubscription != null) {
                    this.protocolErrorStateSubscription.unsubscribe();
                    this.protocolErrorStateSubscription = null;
                }
            }
        });
        long startTime = System.currentTimeMillis();
        this.protocolErrorHeightSubscription = EasyBind.subscribe((ObservableValue)this.walletHeight, lastWalletHeight -> {
            if (this.isShutDown || this.isDepositsPublished()) {
                return;
            }
            if (lastWalletHeight.longValue() < this.processModel.getTradeProtocolErrorHeight() + 2L) {
                return;
            }
            if (System.currentTimeMillis() - startTime < DELETE_AFTER_MS) {
                return;
            }
            ThreadUtils.execute(() -> {
                MoneroTx takerDepositTx;
                MoneroTx makerDepositTx = this.getMaker().getDepositTxHash() == null ? null : this.xmrWalletService.getMonerod().getTx(this.getMaker().getDepositTxHash());
                MoneroTx moneroTx = takerDepositTx = this.getTaker().getDepositTxHash() == null ? null : this.xmrWalletService.getMonerod().getTx(this.getTaker().getDepositTxHash());
                if (makerDepositTx == null && takerDepositTx == null) {
                    log.warn("Deleting {} {} after protocol error", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                    if (this instanceof ArbitratorTrade && (this.getMaker().getReserveTxHash() != null || this.getTaker().getReserveTxHash() != null)) {
                        this.processModel.getTradeManager().onMoveInvalidTradeToFailedTrades(this);
                        this.deleteWallet();
                        this.onShutDownStarted();
                        ThreadUtils.submitToPool(() -> this.shutDown());
                    } else {
                        this.removeTradeOnError();
                    }
                } else if (!this.isPayoutPublished()) {
                    String errorMessage = "Refusing to delete " + this.getClass().getSimpleName() + " " + this.getId() + " after protocol error because its wallet might be funded";
                    this.prependErrorMessage(errorMessage);
                    log.warn(errorMessage);
                }
                if (this.protocolErrorHeightSubscription != null) {
                    this.protocolErrorHeightSubscription.unsubscribe();
                    this.protocolErrorHeightSubscription = null;
                }
            }, (String)this.getId());
        });
    }

    public boolean isProtocolErrorHandlingScheduled() {
        return this.processModel.getTradeProtocolErrorHeight() > 0L;
    }

    private void restoreDepositsPublishedTrade() {
        if (this instanceof MakerTrade && this.processModel.getOpenOfferManager().getOpenOffer(this.getId()).isPresent()) {
            log.info("Closing open offer because {} {} was restored after protocol error", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
            this.processModel.getOpenOfferManager().closeSpentOffer((Offer)Preconditions.checkNotNull((Object)this.getOffer()));
        }
        this.xmrWalletService.freezeOutputs(this.getSelf().getReserveTxKeyImages());
        this.processModel.getTradeManager().onMoveFailedTradeToPendingTrades(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTradeOnError() {
        Object object = this.removeTradeOnErrorLock;
        synchronized (object) {
            if (this.isShutDown || !this.processModel.getTradeManager().hasTrade(this.getId())) {
                return;
            }
            log.warn("removeTradeOnError() trade={}, tradeId={}, state={}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), this.getState()});
            this.forceCloseWallet();
            if (this.isDepositRequested()) {
                this.getWallet();
            }
            if (this instanceof TakerTrade) {
                ThreadUtils.submitToPool(() -> this.xmrWalletService.thawOutputs(this.getSelf().getReserveTxKeyImages()));
            }
            Optional<OpenOffer> openOffer = this.processModel.getOpenOfferManager().getOpenOffer(this.getId());
            if (this instanceof MakerTrade && openOffer.isPresent()) {
                this.processModel.getOpenOfferManager().unreserveOpenOffer(openOffer.get());
            }
            this.onShutDownStarted();
            this.clearAndShutDown();
            try {
                ThreadUtils.shutDown((String)this.getId(), (Long)5000L);
            }
            catch (Exception e) {
                log.warn("Error shutting down trade thread for {} {}: {}", new Object[]{this.getClass().getSimpleName(), this.getId(), e.getMessage()});
            }
            this.processModel.getTradeManager().unregisterTrade(this);
        }
    }

    public void onComplete() {
    }

    public abstract BigInteger getPayoutAmountBeforeCost();

    public abstract boolean confirmPermitted();

    public void setStateIfValidTransitionTo(State newState) {
        if (this.state.isValidTransitionTo(newState)) {
            this.setState(newState);
        }
    }

    public void addInitProgressStep() {
        this.startProtocolTimeout();
        this.initProgress = Math.min(1.0, (double)(++this.initStep) / 24.0);
        UserThread.execute(() -> this.initProgressProperty.set(this.initProgress));
    }

    public void startProtocolTimeout() {
        this.getProtocol().startTimeout(TradeProtocol.TRADE_STEP_TIMEOUT_SECONDS);
    }

    public void stopProtocolTimeout() {
        if (!this.isInitialized) {
            return;
        }
        TradeProtocol protocol = this.getProtocol();
        if (protocol == null) {
            return;
        }
        protocol.stopTimeout();
    }

    public void setState(State state) {
        Long minDepositTxConfirmations;
        if (state.ordinal() == this.state.ordinal()) {
            return;
        }
        if (this.isInitialized) {
            log.info("Set new state for trade {} {}: {}", new Object[]{this.getShortId(), this.getClass().getSimpleName(), state});
        }
        if (state.getPhase().ordinal() < this.state.getPhase().ordinal()) {
            String message = "We got a state change to a previous phase (id=" + this.getShortId() + ").\nOld state is: " + String.valueOf((Object)this.state) + ". New state is: " + String.valueOf((Object)state);
            log.warn(message);
        }
        this.state = state;
        this.persistNow(null);
        UserThread.execute(() -> {
            this.stateProperty.set((Object)state);
            this.phaseProperty.set((Object)state.getPhase());
        });
        if (state == State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN && (minDepositTxConfirmations = this.getMinDepositTxConfirmations()) != null && minDepositTxConfirmations >= 30L) {
            log.info("Auto-advancing state to {} for {} {} because deposits are unlocked and have at least {} confirmations", new Object[]{State.DEPOSIT_TXS_FINALIZED_IN_BLOCKCHAIN, this.getClass().getSimpleName(), this.getShortId(), 30});
            this.setStateDepositsFinalized();
        }
    }

    public void advanceState(State state) {
        if (state.ordinal() > this.getState().ordinal()) {
            this.setState(state);
        }
    }

    public void setPayoutStateIfValidTransitionTo(PayoutState newPayoutState) {
        if (this.payoutState.isValidTransitionTo(newPayoutState)) {
            this.setPayoutState(newPayoutState);
        } else {
            log.warn("Payout state change is not getting applied because it would cause an invalid transition. Trade payout state={}, intended payout state={}", (Object)this.payoutState, (Object)newPayoutState);
        }
    }

    public void setPayoutState(PayoutState payoutState) {
        if (payoutState.ordinal() == this.payoutState.ordinal()) {
            return;
        }
        if (payoutState.ordinal() < this.payoutState.ordinal()) {
            log.warn("Reverting payout state from {} to {} for trade {} {}. Possible reorg?", new Object[]{this.payoutState, payoutState, this.getClass().getSimpleName(), this.getShortId()});
        }
        if (this.isInitialized) {
            log.info("Set new payout state for trade {} {}: {}", new Object[]{this.getShortId(), this.getClass().getSimpleName(), payoutState});
        }
        this.payoutState = payoutState;
        this.persistNow(null);
        UserThread.execute(() -> this.payoutStateProperty.set((Object)payoutState));
    }

    public void setDisputeState(DisputeState disputeState) {
        if (disputeState.ordinal() == this.disputeState.ordinal()) {
            return;
        }
        if (this.isInitialized) {
            log.info("Set new dispute state for trade {} {}: {}", new Object[]{this.getShortId(), this.getClass().getSimpleName(), disputeState});
        }
        if (disputeState.ordinal() < this.disputeState.ordinal()) {
            String message = "We got a dispute state change to a previous state (id=" + this.getShortId() + ").\nOld dispute state is: " + String.valueOf((Object)this.disputeState) + ". New dispute state is: " + String.valueOf((Object)disputeState);
            log.warn(message);
        }
        this.disputeState = disputeState;
        this.persistNow(null);
        UserThread.execute(() -> this.disputeStateProperty.set((Object)disputeState));
    }

    public void advanceDisputeState(DisputeState disputeState) {
        if (disputeState.ordinal() > this.getDisputeState().ordinal()) {
            this.setDisputeState(disputeState);
        }
    }

    public List<Dispute> getDisputes() {
        return HavenoUtils.arbitrationManager.findDisputes(this.getId());
    }

    public void setMediationResultState(MediationResultState mediationResultState) {
        this.mediationResultState = mediationResultState;
        this.mediationResultStateProperty.set((Object)mediationResultState);
    }

    public void setRefundResultState(RefundResultState refundResultState) {
        this.refundResultState = refundResultState;
        this.refundResultStateProperty.set((Object)refundResultState);
    }

    public void setPeriodState(TradePeriodState tradePeriodState) {
        this.periodState = tradePeriodState;
        this.tradePeriodStateProperty.set((Object)tradePeriodState);
    }

    public void setAmount(BigInteger tradeAmount) {
        this.amount = tradeAmount.longValueExact();
        this.getAmountProperty().set((Object)this.getAmount());
        this.getVolumeProperty().set((Object)this.getVolume());
    }

    public DisputeResult getDisputeResult() {
        if (this.getDisputes().isEmpty()) {
            return null;
        }
        return (DisputeResult)this.getDisputes().get(this.getDisputes().size() - 1).getDisputeResultProperty().get();
    }

    @Nullable
    public MoneroTx getPayoutTx() {
        if (this.payoutTx == null && this.payoutTxId != null) {
            if (this instanceof ArbitratorTrade) {
                this.payoutTx = this.xmrWalletService.getDaemonTxWithCache(this.payoutTxId);
            } else {
                this.payoutTx = this.xmrWalletService.getTx(this.payoutTxId);
                if (this.payoutTx == null) {
                    log.warn("Main wallet is missing payout tx for {} {}, fetching from daemon", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                    this.payoutTx = this.xmrWalletService.getDaemonTxWithCache(this.payoutTxId);
                }
            }
        }
        return this.payoutTx;
    }

    public void setPayoutTxFee(BigInteger payoutTxFee) {
        this.payoutTxFee = payoutTxFee.longValueExact();
    }

    public BigInteger getPayoutTxFee() {
        return BigInteger.valueOf(this.payoutTxFee);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.errorMessageProperty.set((Object)errorMessage);
    }

    public void prependErrorMessage(String errorMessage) {
        String appendedErrorMessage;
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        if (this.errorMessage != null && !this.errorMessage.isEmpty()) {
            sb.append("\n\n---- Previous Error -----\n\n");
            sb.append(this.errorMessage);
        }
        this.errorMessage = appendedErrorMessage = sb.toString();
        this.errorMessageProperty.set((Object)appendedErrorMessage);
    }

    public boolean isArbitrator() {
        return this instanceof ArbitratorTrade;
    }

    public boolean isBuyer() {
        return this.getBuyer() == this.getSelf();
    }

    public boolean isSeller() {
        return this.getSeller() == this.getSelf();
    }

    public boolean isMaker() {
        return this instanceof MakerTrade;
    }

    public boolean isTaker() {
        return this instanceof TakerTrade;
    }

    public TradePeer getSelf() {
        if (this instanceof MakerTrade) {
            return this.processModel.getMaker();
        }
        if (this instanceof TakerTrade) {
            return this.processModel.getTaker();
        }
        if (this instanceof ArbitratorTrade) {
            return this.processModel.getArbitrator();
        }
        throw new RuntimeException("Trade is not maker, taker, or arbitrator");
    }

    public List<TradePeer> getOtherPeers() {
        List<TradePeer> peers = this.getAllPeers();
        if (!peers.remove(this.getSelf())) {
            throw new IllegalStateException("Failed to remove self from list of peers");
        }
        return peers;
    }

    public List<TradePeer> getAllPeers() {
        ArrayList<TradePeer> peers = new ArrayList<TradePeer>();
        peers.add(this.getMaker());
        peers.add(this.getTaker());
        peers.add(this.getArbitrator());
        return peers;
    }

    public TradePeer getArbitrator() {
        return this.processModel.getArbitrator();
    }

    public TradePeer getMaker() {
        return this.processModel.getMaker();
    }

    public TradePeer getTaker() {
        return this.processModel.getTaker();
    }

    public TradePeer getBuyer() {
        return this.offer.getDirection() == OfferDirection.BUY ? this.processModel.getMaker() : this.processModel.getTaker();
    }

    public TradePeer getSeller() {
        return this.offer.getDirection() == OfferDirection.BUY ? this.processModel.getTaker() : this.processModel.getMaker();
    }

    public TradePeer getOtherPeer(TradePeer peer) {
        List<TradePeer> peers = this.getAllPeers();
        if (!peers.remove(peer)) {
            throw new IllegalArgumentException("Peer is not maker, taker, or arbitrator");
        }
        if (!peers.remove(this.getSelf())) {
            throw new IllegalStateException("Self is not maker, taker, or arbitrator");
        }
        if (peers.size() != 1) {
            throw new IllegalStateException("There should be exactly one other peer");
        }
        return peers.get(0);
    }

    public TradePeer getTradePeer() {
        if (this instanceof MakerTrade) {
            return this.processModel.getTaker();
        }
        if (this instanceof TakerTrade) {
            return this.processModel.getMaker();
        }
        if (this instanceof ArbitratorTrade) {
            return null;
        }
        throw new RuntimeException("Unknown trade type: " + this.getClass().getName());
    }

    public TradePeer getTradePeer(NodeAddress address) {
        if (address.equals((Object)this.getMaker().getNodeAddress())) {
            return this.processModel.getMaker();
        }
        if (address.equals((Object)this.getTaker().getNodeAddress())) {
            return this.processModel.getTaker();
        }
        if (address.equals((Object)this.getArbitrator().getNodeAddress())) {
            return this.processModel.getArbitrator();
        }
        return null;
    }

    public TradePeer getTradePeer(PubKeyRing pubKeyRing) {
        if (this.getMaker() != null && this.getMaker().getPubKeyRing().equals((Object)pubKeyRing)) {
            return this.getMaker();
        }
        if (this.getTaker() != null && this.getTaker().getPubKeyRing().equals((Object)pubKeyRing)) {
            return this.getTaker();
        }
        if (this.getArbitrator() != null && this.getArbitrator().getPubKeyRing().equals((Object)pubKeyRing)) {
            return this.getArbitrator();
        }
        return null;
    }

    public String getRole() {
        if (this.isBuyer()) {
            return "Buyer";
        }
        if (this.isSeller()) {
            return "Seller";
        }
        if (this.isArbitrator()) {
            return "Arbitrator";
        }
        throw new IllegalArgumentException("Trade is not buyer, seller, or arbitrator");
    }

    private MessageState getPaymentSentMessageState() {
        if (this.isPaymentReceived()) {
            return MessageState.ACKNOWLEDGED;
        }
        if (this.getSeller().getPaymentSentMessageStateProperty().get() == MessageState.ACKNOWLEDGED) {
            return MessageState.ACKNOWLEDGED;
        }
        if (this.getSeller().getPaymentSentMessageStateProperty().get() == MessageState.NACKED) {
            return MessageState.NACKED;
        }
        switch (this.state.ordinal()) {
            case 17: {
                return MessageState.SENT;
            }
            case 20: {
                return MessageState.ARRIVED;
            }
            case 19: {
                return MessageState.STORED_IN_MAILBOX;
            }
            case 21: {
                return MessageState.ACKNOWLEDGED;
            }
            case 18: {
                return MessageState.FAILED;
            }
        }
        return null;
    }

    public String getPeerRole(TradePeer peer) {
        if (peer == this.getBuyer()) {
            return "Buyer";
        }
        if (peer == this.getSeller()) {
            return "Seller";
        }
        if (peer == this.getArbitrator()) {
            return "Arbitrator";
        }
        throw new IllegalArgumentException("Peer is not buyer, seller, or arbitrator");
    }

    public Date getTakeOfferDate() {
        return new Date(this.takeOfferDate);
    }

    public Phase getPhase() {
        return this.state.getPhase();
    }

    @Nullable
    public Volume getVolume() {
        try {
            if (this.getAmount() != null && this.getPrice() != null) {
                Volume volumeByAmount = this.getPrice().getVolumeByAmount(this.getAmount());
                if (this.offer != null) {
                    volumeByAmount = VolumeUtil.getAdjustedVolume(volumeByAmount, this.offer.getPaymentMethod().getId());
                }
                return volumeByAmount;
            }
            return null;
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdateTradePeriod() {
        Object object = this.startTimeLock;
        synchronized (object) {
            if (this.startTime > 0L) {
                return;
            }
            if (this.getTakeOfferDate() == null) {
                return;
            }
            if (!this.isDepositsFinalized()) {
                return;
            }
            long now = System.currentTimeMillis();
            long tradeTime = this.getTakeOfferDate().getTime();
            MoneroDaemonRpc monerod = this.xmrWalletService.getMonerod();
            if (monerod == null) {
                throw new RuntimeException("Cannot set start time for trade " + this.getId() + " because it has no connection to monerod");
            }
            long finalizeHeight = this.getDepositsFinalizedHeight();
            long finalizeTime = monerod.getBlockByHeight(finalizeHeight).getTimestamp() * 1000L;
            this.startTime = finalizeTime > now ? now : Math.max(finalizeTime, tradeTime);
            log.debug("We set the start for the trade period to {}. Trade started at: {}. Block got mined at: {}", new Object[]{new Date(this.startTime), new Date(tradeTime), new Date(finalizeTime)});
        }
    }

    private long getDepositsFinalizedHeight() {
        MoneroTxWallet makerDepositTx = this.getMakerDepositTx();
        MoneroTxWallet takerDepositTx = this.getTakerDepositTx();
        if (makerDepositTx == null || takerDepositTx == null && !this.hasBuyerAsTakerWithoutDeposit()) {
            throw new RuntimeException("Cannot get finalized height for trade " + this.getId() + " because its deposit tx is null. Is client connected to a daemon?");
        }
        return Math.max(makerDepositTx.getHeight() + 30L - 1L, this.hasBuyerAsTakerWithoutDeposit() ? 0L : takerDepositTx.getHeight() + 30L - 1L);
    }

    public long getMaxTradePeriod() {
        return this.getOffer().getPaymentMethod().getMaxTradePeriod();
    }

    public Date getHalfTradePeriodDate() {
        return new Date(this.getEffectiveStartTime() + this.getMaxTradePeriod() / 2L);
    }

    public Date getMaxTradePeriodDate() {
        return new Date(this.getEffectiveStartTime() + this.getMaxTradePeriod());
    }

    public Date getStartDate() {
        return new Date(this.getEffectiveStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getEffectiveStartTime() {
        Object object = this.startTimeLock;
        synchronized (object) {
            return this.startTime > 0L ? this.startTime : System.currentTimeMillis();
        }
    }

    public boolean hasFailed() {
        return this.errorMessageProperty().get() != null;
    }

    public boolean isInPreparation() {
        return this.getState().getPhase().ordinal() == Phase.INIT.ordinal();
    }

    public boolean isFundsLockedIn() {
        return this.isDepositsPublished() && !this.isPayoutPublished();
    }

    public boolean isDepositRequested() {
        return this.getState().getPhase().ordinal() >= Phase.DEPOSIT_REQUESTED.ordinal();
    }

    public boolean isDepositRequestFailed() {
        return this.getState() == State.PUBLISH_DEPOSIT_TX_REQUEST_FAILED;
    }

    public boolean isDepositTxMissing() {
        boolean hasUnlockedDepositTx;
        if (!this.wasWalletPolledProperty.get()) {
            throw new IllegalStateException("Cannot determine if deposit tx is missing because wallet has not been polled");
        }
        MoneroTxWallet makerDepositTx = this.getMakerDepositTx();
        MoneroTxWallet takerDepositTx = this.getTakerDepositTx();
        boolean bl = hasUnlockedDepositTx = makerDepositTx != null && Boolean.FALSE.equals(makerDepositTx.isLocked()) || takerDepositTx != null && Boolean.FALSE.equals(takerDepositTx.isLocked());
        if (!hasUnlockedDepositTx) {
            return false;
        }
        boolean hasMissingDepositTx = makerDepositTx == null || !this.hasBuyerAsTakerWithoutDeposit() && takerDepositTx == null;
        return hasMissingDepositTx;
    }

    public boolean isDepositsPublished() {
        if (this.isDepositRequestFailed()) {
            return false;
        }
        return this.getState().getPhase().ordinal() >= Phase.DEPOSITS_PUBLISHED.ordinal() && this.getMaker().getDepositTxHash() != null && (this.getTaker().getDepositTxHash() != null || this.hasBuyerAsTakerWithoutDeposit());
    }

    public boolean isDepositsSeen() {
        return this.isDepositsPublished() && this.getState().ordinal() >= State.DEPOSIT_TXS_SEEN_IN_NETWORK.ordinal();
    }

    public boolean isDepositsConfirmed() {
        return this.isDepositsPublished() && this.getState().getPhase().ordinal() >= Phase.DEPOSITS_CONFIRMED.ordinal();
    }

    public boolean isDepositsConfirmedAcked() {
        if (this instanceof BuyerTrade) {
            return this.getArbitrator().isDepositsConfirmedMessageAcked();
        }
        for (TradePeer peer : this.getOtherPeers()) {
            if (peer.isDepositsConfirmedMessageAcked()) continue;
            return false;
        }
        return true;
    }

    public boolean isDepositsUnlocked() {
        return this.isDepositsPublished() && this.getState().getPhase().ordinal() >= Phase.DEPOSITS_UNLOCKED.ordinal();
    }

    public boolean isDepositsFinalized() {
        if (this.getState().getPhase().ordinal() < Phase.DEPOSITS_FINALIZED.ordinal()) {
            return false;
        }
        if (this.getState().getPhase() == Phase.DEPOSITS_FINALIZED) {
            return true;
        }
        if (this.isPayoutFinalized()) {
            return true;
        }
        Long minDepositTxConfirmations = this.getMinDepositTxConfirmations();
        if (minDepositTxConfirmations == null) {
            log.warn("Assuming that deposit txs are finalized for trade {} {} because trade is in phase {} but has unknown confirmations", new Object[]{this.getClass().getSimpleName(), this.getShortId(), this.getState().getPhase()});
            Thread.dumpStack();
            return true;
        }
        return minDepositTxConfirmations >= 30L;
    }

    public boolean isPaymentSent() {
        return this.getState().getPhase().ordinal() >= Phase.PAYMENT_SENT.ordinal() && this.getState() != State.BUYER_SEND_FAILED_PAYMENT_SENT_MSG;
    }

    public boolean hasPaymentSentMessage() {
        return (this.isBuyer() ? this.getSeller() : this.getBuyer()).getPaymentSentMessage() != null;
    }

    public boolean hasPaymentReceivedMessage() {
        return (this.isSeller() ? this.getBuyer() : this.getSeller()).getPaymentReceivedMessage() != null;
    }

    public boolean hasDisputeClosedMessage() {
        return this.isArbitrator() ? this.getBuyer().getDisputeClosedMessage() != null || this.getSeller().getDisputeClosedMessage() != null : this.getArbitrator().getDisputeClosedMessage() != null;
    }

    public boolean isDisputeClosed() {
        return this.getDisputeState().isClosed();
    }

    public boolean isPaymentMarkedSent() {
        return this.getState().getPhase().ordinal() >= Phase.PAYMENT_SENT.ordinal();
    }

    public boolean isPaymentMarkedReceived() {
        return this.getState().getPhase().ordinal() >= Phase.PAYMENT_RECEIVED.ordinal();
    }

    public boolean isPaymentReceived() {
        return this.getState().getPhase().ordinal() >= Phase.PAYMENT_RECEIVED.ordinal() && this.getState() != State.SELLER_SEND_FAILED_PAYMENT_RECEIVED_MSG;
    }

    public boolean isPayoutPublished() {
        return this.getPayoutState().ordinal() >= PayoutState.PAYOUT_PUBLISHED.ordinal();
    }

    public boolean isPayoutConfirmed() {
        return this.getPayoutState().ordinal() >= PayoutState.PAYOUT_CONFIRMED.ordinal();
    }

    public boolean isPayoutUnlocked() {
        return this.getPayoutState().ordinal() >= PayoutState.PAYOUT_UNLOCKED.ordinal();
    }

    public boolean isPayoutFinalized() {
        return this.getPayoutState().ordinal() >= PayoutState.PAYOUT_FINALIZED.ordinal();
    }

    public ReadOnlyDoubleProperty initProgressProperty() {
        return this.initProgressProperty;
    }

    public ReadOnlyObjectProperty<State> stateProperty() {
        return this.stateProperty;
    }

    public ReadOnlyObjectProperty<Phase> statePhaseProperty() {
        return this.phaseProperty;
    }

    public ReadOnlyObjectProperty<PayoutState> payoutStateProperty() {
        return this.payoutStateProperty;
    }

    public ReadOnlyObjectProperty<DisputeState> disputeStateProperty() {
        return this.disputeStateProperty;
    }

    public ReadOnlyObjectProperty<MediationResultState> mediationResultStateProperty() {
        return this.mediationResultStateProperty;
    }

    public ReadOnlyObjectProperty<RefundResultState> refundResultStateProperty() {
        return this.refundResultStateProperty;
    }

    public ReadOnlyObjectProperty<TradePeriodState> tradePeriodStateProperty() {
        return this.tradePeriodStateProperty;
    }

    public ReadOnlyObjectProperty<BigInteger> tradeAmountProperty() {
        return this.tradeAmountProperty;
    }

    public ReadOnlyObjectProperty<Volume> tradeVolumeProperty() {
        return this.tradeVolumeProperty;
    }

    public ReadOnlyStringProperty errorMessageProperty() {
        return this.errorMessageProperty;
    }

    @Override
    public Date getDate() {
        return this.getTakeOfferDate();
    }

    @Override
    public String getId() {
        return this.offer.getId();
    }

    @Override
    public String getShortId() {
        return this.offer.getShortId();
    }

    public String getShortUid() {
        return Utilities.getShortId((String)this.getUid());
    }

    public BigInteger getFrozenAmount() {
        BigInteger sum = BigInteger.ZERO;
        if (this.getSelf().getReserveTxKeyImages() != null) {
            for (String keyImage : this.getSelf().getReserveTxKeyImages()) {
                List<MoneroOutputWallet> outputs = this.xmrWalletService.getOutputs(new MoneroOutputQuery().setIsFrozen(Boolean.valueOf(true)).setIsSpent(Boolean.valueOf(false)).setKeyImage(new MoneroKeyImage(keyImage)));
                if (outputs.isEmpty()) continue;
                sum = sum.add(outputs.get(0).getAmount());
            }
        }
        return sum;
    }

    public BigInteger getReservedAmount() {
        if (this.isArbitrator() || !this.isDepositsPublished() || this.isPayoutPublished()) {
            return BigInteger.ZERO;
        }
        return this.isBuyer() ? this.getBuyer().getSecurityDeposit() : this.getAmount().add(this.getSeller().getSecurityDeposit());
    }

    public Price getPrice() {
        boolean isInverted = this.getOffer().isInverted();
        return Price.valueOf(this.offer.getCounterCurrencyCode(), isInverted ? PriceUtil.invertLongPrice(this.price, this.offer.getCounterCurrencyCode()) : this.price);
    }

    public Price getRawPrice() {
        return Price.valueOf(this.offer.getCounterCurrencyCode(), this.price);
    }

    @Nullable
    public BigInteger getAmount() {
        return BigInteger.valueOf(this.amount);
    }

    public BigInteger getMakerFee() {
        return this.offer.getMakerFee(this.getAmount());
    }

    public BigInteger getTakerFee() {
        return this.hasBuyerAsTakerWithoutDeposit() ? BigInteger.ZERO : this.offer.getTakerFee(this.getAmount());
    }

    public BigInteger getSecurityDepositBeforeMiningFee() {
        return this.isBuyer() ? this.getBuyerSecurityDepositBeforeMiningFee() : this.getSellerSecurityDepositBeforeMiningFee();
    }

    public BigInteger getBuyerSecurityDepositBeforeMiningFee() {
        return this.offer.getOfferPayload().getBuyerSecurityDepositForTradeAmount(this.getAmount());
    }

    public BigInteger getSellerSecurityDepositBeforeMiningFee() {
        return this.offer.getOfferPayload().getSellerSecurityDepositForTradeAmount(this.getAmount());
    }

    public boolean isBuyerAsTakerWithoutDeposit() {
        return this.isBuyer() && this.isTaker() && BigInteger.ZERO.equals(this.getBuyerSecurityDepositBeforeMiningFee());
    }

    public boolean hasBuyerAsTakerWithoutDeposit() {
        return this.getOffer().getOfferPayload().isBuyerAsTakerWithoutDeposit();
    }

    @Override
    public BigInteger getTotalTxFee() {
        return this.getSelf().getDepositTxFee().add(this.getSelf().getPayoutTxFee());
    }

    public boolean hasErrorMessage() {
        return this.getErrorMessage() != null && !this.getErrorMessage().isEmpty();
    }

    @Nullable
    public String getErrorMessage() {
        return (String)this.errorMessageProperty.get();
    }

    public boolean isTxChainInvalid() {
        return this.processModel.getMaker().getDepositTxHash() == null || this.processModel.getTaker().getDepositTxHash() == null && !this.hasBuyerAsTakerWithoutDeposit();
    }

    public long getReprocessDelayInSeconds(int reprocessCount) {
        int retryCycles = 3;
        if (reprocessCount < retryCycles) {
            return this.xmrConnectionService.getRefreshPeriodMs() / 1000L;
        }
        long delay = 60L;
        for (int i = retryCycles; i < reprocessCount; ++i) {
            delay *= 2L;
        }
        return Math.min(7200L, delay);
    }

    public void maybePublishTradeStatistics() {
        if (this.shouldPublishTradeStatistics()) {
            UserThread.runAfterRandomDelay(() -> {
                if (!this.isShutDownStarted) {
                    this.doPublishTradeStatistics();
                }
            }, (long)0L, (long)86400000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public boolean shouldPublishTradeStatistics() {
        if (!this.tradeAmountTransferred()) {
            return false;
        }
        if (!this.isSeller() && !this.isArbitrator()) {
            return false;
        }
        return this.getOffer().getOfferPayload().getProtocolVersion() >= 3 || this.isSeller();
    }

    private boolean tradeAmountTransferred() {
        return this.isPayoutPublished() && (this.isPaymentReceived() || this.getDisputeResult() != null && this.getDisputeResult().getWinner() == DisputeResult.Winner.SELLER);
    }

    private void doPublishTradeStatistics() {
        String referralId = this.processModel.getReferralIdService().getOptionalReferralId().orElse(null);
        boolean isTorNetworkNode = this.getProcessModel().getP2PService().getNetworkNode() instanceof TorNetworkNode;
        HavenoUtils.tradeStatisticsManager.maybePublishTradeStatistics(this, referralId, isTorNetworkNode);
    }

    private ObjectProperty<BigInteger> getAmountProperty() {
        if (this.tradeAmountProperty == null) {
            this.tradeAmountProperty = this.getAmount() != null ? new SimpleObjectProperty((Object)this.getAmount()) : new SimpleObjectProperty();
        }
        return this.tradeAmountProperty;
    }

    private ObjectProperty<Volume> getVolumeProperty() {
        if (this.tradeVolumeProperty == null) {
            this.tradeVolumeProperty = this.getVolume() != null ? new SimpleObjectProperty((Object)this.getVolume()) : new SimpleObjectProperty();
        }
        return this.tradeVolumeProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onConnectionChanged(MoneroRpcConnection connection) {
        Object object = this.walletLock;
        synchronized (object) {
            connection = this.xmrConnectionService.getConnection();
            if (this.isShutDownStarted) {
                return;
            }
            if (this.getWallet() == null) {
                return;
            }
            if (HavenoUtils.connectionConfigsEqual(connection, this.wallet.getDaemonConnection())) {
                this.updatePollPeriod();
                return;
            }
            String oldProxyUri = this.wallet.getDaemonConnection() == null ? null : this.wallet.getDaemonConnection().getProxyUri();
            String newProxyUri = connection == null ? null : connection.getProxyUri();
            log.info("Setting daemon connection for {} {}: uri={}, proxyUri={}", new Object[]{this.getClass().getSimpleName(), this.getId(), connection == null ? null : connection.getUri(), newProxyUri});
            if (this.xmrWalletService.isProxyApplied(this.wasWalletSynced) && this.wallet instanceof MoneroWalletRpc && !StringUtils.equals((CharSequence)oldProxyUri, (CharSequence)newProxyUri)) {
                log.info("Restarting trade wallet {} because proxy URI has changed, old={}, new={}", new Object[]{this.getId(), oldProxyUri, newProxyUri});
                this.closeWallet();
                this.wallet = this.getWallet();
            } else {
                this.wallet.setDaemonConnection(connection);
            }
            if (this.isInitialized && connection != null && !Boolean.FALSE.equals(this.xmrConnectionService.isConnected())) {
                ThreadUtils.execute(() -> this.maybeInitSyncing(), (String)this.getId());
            }
            log.info("Done setting daemon connection for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
        }
    }

    private void maybeInitSyncing() {
        if (this.isShutDownStarted || !this.isDepositRequested()) {
            return;
        }
        this.doPollWallet(true);
        if (this.isIdling()) {
            long startSyncingInSec = Math.max(1L, ThreadLocalRandom.current().nextLong(0L, this.getPollPeriod()) / 1000L);
            UserThread.runAfter(() -> ThreadUtils.execute(() -> {
                if (!this.isShutDownStarted) {
                    this.doTryInitSyncing();
                }
            }, (String)this.getId()), (long)startSyncingInSec);
        } else {
            this.doTryInitSyncing();
        }
    }

    private void doTryInitSyncing() {
        if (!this.wasWalletSynced) {
            this.trySyncWallet(true);
        }
        this.updatePollPeriod();
        this.startPolling();
    }

    private void trySyncWallet(boolean pollWallet) {
        block2: {
            try {
                this.syncWallet(pollWallet);
            }
            catch (Exception e) {
                if (this.isShutDownStarted || !this.walletExists()) break block2;
                log.warn("Error syncing trade wallet for {} {}: {}", new Object[]{this.getClass().getSimpleName(), this.getId(), e.getMessage()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncWallet(boolean pollWallet) {
        MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
        try {
            Object object = this.walletLock;
            synchronized (object) {
                if (this.getWallet() == null) {
                    throw new IllegalStateException("Cannot sync trade wallet because it doesn't exist for " + this.getClass().getSimpleName() + ", " + this.getId());
                }
                if (this.getWallet().getDaemonConnection() == null) {
                    throw new RuntimeException("Cannot sync trade wallet because it's not connected to a Monero daemon for " + this.getClass().getSimpleName() + ", " + this.getId());
                }
                if (!this.isDepositRequested()) {
                    throw new IllegalStateException("Cannot sync trade wallet because deposit txs are not requested for " + this.getClass().getSimpleName() + ", " + this.getId());
                }
                if (this.isWalletBehind()) {
                    log.info("Syncing wallet for {} {} from height {}", new Object[]{this.getShortId(), this.getClass().getSimpleName(), this.walletHeight.get()});
                    long startTime = System.currentTimeMillis();
                    this.syncWalletIfBehind();
                    log.info("Done syncing wallet for {} {} in {} ms", new Object[]{this.getShortId(), this.getClass().getSimpleName(), System.currentTimeMillis() - startTime});
                }
            }
            if (!this.wasWalletSynced) {
                this.wasWalletSynced = true;
                if (this.xmrWalletService.isProxyApplied(this.wasWalletSynced)) {
                    this.onConnectionChanged(this.xmrConnectionService.getConnection());
                }
            }
            if (pollWallet) {
                this.doPollWallet();
            }
        }
        catch (Exception e) {
            if (!(e instanceof IllegalStateException) && !this.isShutDownStarted) {
                ThreadUtils.execute(() -> this.requestSwitchToNextBestConnection(sourceConnection), (String)this.getId());
            }
            if (HavenoUtils.isUnresponsive(e)) {
                if (this.isShutDownStarted) {
                    this.forceCloseWallet();
                } else {
                    this.forceRestartTradeWallet();
                }
            }
            throw e;
        }
    }

    public void updatePollPeriod() {
        if (this.isShutDownStarted) {
            return;
        }
        this.setPollPeriod(this.getPollPeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPollPeriod(long pollPeriodMs) {
        Object object = this.pollLock;
        synchronized (object) {
            if (this.isShutDownStarted) {
                return;
            }
            if (this.pollPeriodMs != null && this.pollPeriodMs == pollPeriodMs) {
                return;
            }
            this.pollPeriodMs = pollPeriodMs;
            if (this.isPolling()) {
                this.stopPolling();
                this.startPolling();
            }
        }
    }

    private long getPollPeriod() {
        if (this.isIdling()) {
            return IDLE_SYNC_PERIOD_MS;
        }
        return this.xmrConnectionService.getRefreshPeriodMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPolling() {
        Object object = this.pollLock;
        synchronized (object) {
            if (this.isShutDownStarted || this.isPolling()) {
                return;
            }
            this.updatePollPeriod();
            log.info("Starting to poll wallet for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
            this.pollLooper = new TaskLooper(() -> new Thread(() -> this.pollWallet()).start());
            this.pollLooper.start(this.pollPeriodMs.longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPolling() {
        Object object = this.pollLock;
        synchronized (object) {
            if (this.isPolling()) {
                this.pollLooper.stop();
                this.pollLooper = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPolling() {
        Object object = this.pollLock;
        synchronized (object) {
            return this.pollLooper != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollWallet() {
        Object object = this.pollLock;
        synchronized (object) {
            if (this.pollInProgress) {
                return;
            }
        }
        this.doPollWallet();
    }

    private void doPollWallet() {
        this.doPollWallet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPollWallet(boolean offlinePoll) {
        if (this.isShutDownStarted) {
            return;
        }
        boolean pollInProgressSet = false;
        Object object = this.pollLock;
        synchronized (object) {
            if (!this.pollInProgress) {
                pollInProgressSet = true;
            }
            this.pollInProgress = true;
        }
        MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
        try {
            boolean depositTxsUninitialized;
            if (this.isShutDownStarted) {
                return;
            }
            if (this.isPayoutFinalized()) {
                return;
            }
            if (!this.isDepositRequested() || this.isDepositRequestFailed() || this.processModel.getMaker().getDepositTxHash() == null || this.processModel.getTaker().getDepositTxHash() == null && !this.hasBuyerAsTakerWithoutDeposit()) {
                return;
            }
            if (!(offlinePoll || this.xmrConnectionService.getTargetHeight() != null && this.xmrConnectionService.isSyncedWithinTolerance())) {
                return;
            }
            if (!offlinePoll && this.walletHeight.get() < this.xmrConnectionService.getTargetHeight() - 360L) {
                this.syncWallet(false);
            }
            boolean bl = depositTxsUninitialized = this.isDepositRequested() && (this.getMaker().getDepositTx() == null || this.getTaker().getDepositTx() == null && !this.hasBuyerAsTakerWithoutDeposit());
            if (depositTxsUninitialized || !this.isDepositsFinalized()) {
                List<MoneroTxWallet> txs;
                if (!offlinePoll) {
                    this.syncWalletIfBehind();
                }
                if (this.hasDepositTxs(txs = this.getTxs(false))) {
                    this.setDepositTxs(txs, false);
                } else if (!offlinePoll) {
                    txs = this.getTxs(true);
                    if (this.isDepositsSeen() && !this.hasDepositTxs(txs)) {
                        log.info("Deposits are missing for {} {} after being published, resyncing", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                        HavenoUtils.waitFor(MISSING_TXS_DELAY_MS);
                        this.sync();
                        txs = this.getTxs(true);
                    }
                    this.setDepositTxs(txs, true);
                }
            }
            boolean hasUnlockedDeposit = this.hasUnlockedTx();
            if (this.isDepositsUnlocked() || hasUnlockedDeposit) {
                boolean isPayoutExpected;
                boolean bl2 = isPayoutExpected = this.isPaymentReceived() || this.hasPaymentReceivedMessage() || this.hasDisputeClosedMessage() || this.disputeState.ordinal() >= DisputeState.ARBITRATOR_SENT_DISPUTE_CLOSED_MSG.ordinal();
                if (!offlinePoll && (isPayoutExpected || this.isPayoutPublished())) {
                    this.syncWalletIfBehind();
                }
                if (this.getPayoutState() == PayoutState.PAYOUT_PUBLISHED || isPayoutExpected && this.wallet.getBalance().compareTo(BigInteger.ZERO) > 0) {
                    try {
                        this.rescanSpent(true);
                    }
                    catch (Exception e) {
                        ThreadUtils.submitToPool(() -> this.requestSwitchToNextBestConnection(sourceConnection));
                    }
                }
                boolean checkPool = !offlinePoll && isPayoutExpected && !this.isPayoutConfirmed();
                List<MoneroTxWallet> txs = this.getTxs(checkPool);
                if (!offlinePoll && this.isPayoutPublished() && this.getPayoutTxId() != null && !this.hasPayoutTx(txs)) {
                    log.info("Payout is missing for {} {} after being published, resyncing", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                    HavenoUtils.waitFor(MISSING_TXS_DELAY_MS);
                    this.sync();
                    txs = this.getTxs(true);
                    checkPool = true;
                }
                this.setDepositTxs(txs, checkPool);
                this.setPayoutTx(txs, checkPool);
            }
            this.maybeUpdateTradePeriod();
            this.wasWalletPolledProperty.set(true);
            if (!offlinePoll) {
                this.wasWalletSyncedAndPolledProperty.set(true);
            }
        }
        catch (Exception e) {
            if (!(e instanceof IllegalStateException || this.isShutDownStarted || offlinePoll || this.wasWalletSyncedAndPolledProperty.get())) {
                ThreadUtils.execute(() -> this.requestSwitchToNextBestConnection(sourceConnection), (String)this.getId());
            }
            if (HavenoUtils.isUnresponsive(e)) {
                if (this.wallet != null && !this.isShutDownStarted) {
                    log.warn("Error polling unresponsive trade wallet for {} {}, errorMessage={}. Monerod={}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), e.getMessage(), this.wallet.getDaemonConnection()});
                }
                if (this.isShutDownStarted) {
                    this.forceCloseWallet();
                } else {
                    this.forceRestartTradeWallet();
                }
            } else {
                boolean isWalletConnected = this.isWalletConnectedToDaemon();
                if (this.wallet != null && !this.isShutDownStarted && isWalletConnected) {
                    log.warn("Error polling trade wallet for {} {}, errorMessage={}. Monerod={}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), e.getMessage(), this.wallet.getDaemonConnection()});
                }
            }
        }
        finally {
            if (pollInProgressSet) {
                Object object2 = this.pollLock;
                synchronized (object2) {
                    this.pollInProgress = false;
                }
            }
            this.requestSaveWalletIfElapsedTime();
        }
    }

    private boolean isWalletBehind() {
        return this.walletHeight.get() < this.xmrConnectionService.getTargetHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncWalletIfBehind() {
        Object object = this.walletLock;
        synchronized (object) {
            if (!this.isDepositRequested()) {
                throw new IllegalStateException("Cannot sync trade wallet because deposit txs are not requested for " + this.getClass().getSimpleName() + ", " + this.getId());
            }
            if (this.isWalletBehind()) {
                this.syncWithProgress();
                this.walletHeight.set(this.wallet.getHeight());
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MoneroSyncResult sync() {
        Object object = this.walletLock;
        synchronized (object) {
            if (!this.isDepositRequested()) {
                throw new IllegalStateException("Cannot sync trade wallet because deposit txs are not requested for " + this.getClass().getSimpleName() + ", " + this.getId());
            }
            log.info("Syncing wallet directly for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
            MoneroSyncResult result = super.sync();
            log.info("Done syncing wallet directly for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MoneroTxWallet> getTxs(boolean checkPool) {
        MoneroTxQuery query = new MoneroTxQuery().setIncludeOutputs(Boolean.valueOf(true));
        if (!checkPool) {
            query.setInTxPool(Boolean.valueOf(false));
        }
        if (checkPool) {
            Object object = this.walletLock;
            synchronized (object) {
                Object object2 = HavenoUtils.getDaemonLock();
                synchronized (object2) {
                    return this.wallet.getTxs(query);
                }
            }
        }
        return this.wallet.getTxs(query);
    }

    private void setDepositTxs(List<MoneroTxWallet> txs, boolean poolChecked) {
        State minDepositsState;
        MoneroTxWallet makerDepositTx = this.getMakerDepositTx(txs);
        MoneroTxWallet takerDepositTx = this.getTakerDepositTx(txs);
        MoneroTxWallet buyerDepositTx = this.getBuyerDepositTx(txs);
        MoneroTxWallet sellerDepositTx = this.getSellerDepositTx(txs);
        if (makerDepositTx != null) {
            this.getMaker().setDepositTx(makerDepositTx);
        }
        if (takerDepositTx != null) {
            this.getTaker().setDepositTx(takerDepositTx);
        }
        if (Trade.isSeen((MoneroTx)buyerDepositTx)) {
            BigInteger buyerSecurityDeposit = buyerDepositTx.getIncomingAmount();
            if (!this.getBuyer().getSecurityDeposit().equals(BigInteger.ZERO) && !buyerSecurityDeposit.equals(this.getBuyer().getSecurityDeposit())) {
                log.warn("Overwriting buyer security deposit for {} {}, old={}, new={}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), this.getBuyer().getSecurityDeposit(), buyerSecurityDeposit});
            }
            this.getBuyer().setSecurityDeposit(buyerSecurityDeposit);
        }
        if (Trade.isSeen((MoneroTx)sellerDepositTx)) {
            BigInteger sellerSecurityDeposit = sellerDepositTx.getIncomingAmount().subtract(this.getAmount());
            if (!this.getSeller().getSecurityDeposit().equals(BigInteger.ZERO) && !sellerSecurityDeposit.equals(this.getSeller().getSecurityDeposit())) {
                log.warn("Overwriting seller security deposit for {} {}, old={}, new={}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), this.getSeller().getSecurityDeposit(), sellerSecurityDeposit});
            }
            this.getSeller().setSecurityDeposit(sellerSecurityDeposit);
        }
        if (Trade.isSeen((MoneroTx)makerDepositTx) && (this.hasBuyerAsTakerWithoutDeposit() || Trade.isSeen((MoneroTx)takerDepositTx))) {
            this.setStateDepositsSeen();
            if (makerDepositTx.isConfirmed().booleanValue() && (this.hasBuyerAsTakerWithoutDeposit() || takerDepositTx.isConfirmed().booleanValue())) {
                this.setStateDepositsConfirmed();
            }
            if (makerDepositTx.getNumConfirmations() >= 10L && (this.hasBuyerAsTakerWithoutDeposit() || takerDepositTx.getNumConfirmations() >= 10L)) {
                this.setStateDepositsUnlocked();
            }
            if (makerDepositTx.getNumConfirmations() >= 30L && (this.hasBuyerAsTakerWithoutDeposit() || takerDepositTx.getNumConfirmations() >= 30L)) {
                this.setStateDepositsFinalized();
            }
        }
        State depositsState = this.getDepositsState(makerDepositTx, takerDepositTx);
        State state = minDepositsState = this.isPaymentSent() ? State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN : this.getState();
        if (poolChecked && depositsState.ordinal() < minDepositsState.ordinal()) {
            if (this.lastDepositTxMissingHeight == null || this.lastDepositTxMissingHeight <= this.walletHeight.get()) {
                if (this.lastDepositTxMissingHeight == null) {
                    log.warn("Missing deposit txs for {} {} at height {}, waiting for a block before reverting state", new Object[]{this.getClass().getSimpleName(), this.getShortId(), this.lastDepositTxMissingHeight});
                }
                this.lastDepositTxMissingHeight = this.wallet.getHeight();
            } else {
                log.warn("Reverting deposits state from {} to {} for {} {}. Possible reorg?", new Object[]{minDepositsState, depositsState, this.getClass().getSimpleName(), this.getShortId()});
                this.getMaker().setDepositTx(makerDepositTx);
                this.getTaker().setDepositTx(takerDepositTx);
                if (depositsState == State.ARBITRATOR_PUBLISHED_DEPOSIT_TXS) {
                    this.setErrorMessage("Deposit transactions are missing for trade " + this.getShortId() + ". This can happen after a blockchain reorganization.\n\nIf the issue continues, you can contact support or mark the trade as failed.");
                }
                if (!this.isPaymentSent()) {
                    this.setState(depositsState);
                }
            }
        } else {
            this.lastDepositTxMissingHeight = null;
        }
        this.depositTxsUpdateCounter.set(this.depositTxsUpdateCounter.get() + 1);
    }

    private void setPayoutTx(List<MoneroTxWallet> txs, boolean poolChecked) {
        boolean hasPayoutTx = false;
        MoneroTxWallet payoutTx = null;
        for (MoneroTxWallet tx : txs) {
            if (!Boolean.TRUE.equals(tx.isIncoming()) && !tx.isFailed().booleanValue()) {
                payoutTx = tx;
                hasPayoutTx = true;
                break;
            }
            for (MoneroOutputWallet output : tx.getOutputsWallet()) {
                if (!Boolean.TRUE.equals(output.isSpent())) continue;
                hasPayoutTx = true;
            }
        }
        if (payoutTx != null) {
            this.setPayoutTx((MoneroTx)payoutTx);
        } else if (hasPayoutTx) {
            this.setPayoutState(PayoutState.PAYOUT_PUBLISHED);
        } else if (poolChecked && this.isPayoutPublished()) {
            if (this.lastPayoutTxMissingHeight == null || this.lastPayoutTxMissingHeight <= this.walletHeight.get()) {
                if (this.lastPayoutTxMissingHeight == null) {
                    log.warn("Missing payout tx for {} {} at height {}, waiting for a block before reverting state", new Object[]{this.getClass().getSimpleName(), this.getShortId(), this.lastPayoutTxMissingHeight});
                }
                this.lastPayoutTxMissingHeight = this.wallet.getHeight();
            } else {
                for (TradePeer peer : this.getAllPeers()) {
                    peer.setPaymentReceivedMessage(null);
                    peer.setPaymentReceivedMessageState(MessageState.UNDEFINED);
                    peer.setDisputeClosedMessage(null);
                }
                this.setPayoutState(PayoutState.PAYOUT_UNPUBLISHED);
                String errorMsg = "The payout transaction is not seen for trade " + this.getShortId() + ". This can happen after a blockchain reorganization..\n\nIf the payout does not confirm automatically, you can contact support or mark the trade as failed.";
                if (this.isSeller() && this.getState().ordinal() >= State.BUYER_RECEIVED_PAYMENT_RECEIVED_MSG.ordinal()) {
                    log.warn("Reverting state of {} {} from {} to {} because payout is unseen. Possible reorg?", new Object[]{this.getClass().getSimpleName(), this.getId(), this.getState(), State.BUYER_SENT_PAYMENT_SENT_MSG});
                    this.setState(State.SELLER_SENT_PAYMENT_RECEIVED_MSG);
                    this.onPayoutError(false, true, null);
                    this.setErrorMessage(errorMsg);
                } else if (this.getState().ordinal() >= State.SELLER_SENT_PAYMENT_RECEIVED_MSG.ordinal()) {
                    log.warn("Reverting state of {} {} from {} to {} because payout is unseen. Possible reorg?", new Object[]{this.getClass().getSimpleName(), this.getId(), this.getState(), State.SELLER_CONFIRMED_PAYMENT_RECEIPT});
                    this.setState(State.SELLER_CONFIRMED_PAYMENT_RECEIPT);
                    this.setErrorMessage(errorMsg);
                }
                if (this.isCompleted()) {
                    this.processModel.getTradeManager().onMoveClosedTradeToPendingTrades(this);
                }
            }
        }
    }

    public void setPayoutTx(MoneroTx payoutTx) {
        this.payoutTx = payoutTx;
        this.payoutTxId = payoutTx.getHash();
        this.payoutTxFee = payoutTx.getFee() == null ? 0L : payoutTx.getFee().longValueExact();
        this.payoutTxKey = payoutTx.getKey();
        if ("".equals(this.payoutTxId)) {
            this.payoutTxId = null;
        }
        for (Dispute dispute : this.getDisputes()) {
            dispute.setDisputePayoutTxId(this.payoutTxId);
        }
        if (this.isPaymentReceived()) {
            BigInteger splitTxFee = payoutTx.getFee().divide(BigInteger.valueOf(2L));
            this.getBuyer().setPayoutTxFee(splitTxFee);
            this.getSeller().setPayoutTxFee(splitTxFee);
            this.getBuyer().setPayoutAmount(this.getBuyer().getSecurityDeposit().subtract(this.getBuyer().getPayoutTxFee()).add(this.getAmount()));
            this.getSeller().setPayoutAmount(this.getSeller().getSecurityDeposit().subtract(this.getSeller().getPayoutTxFee()));
        } else {
            DisputeResult disputeResult = this.getDisputeResult();
            if (disputeResult != null) {
                BigInteger[] buyerSellerPayoutTxFees = ArbitrationManager.getBuyerSellerPayoutTxCost(disputeResult, payoutTx.getFee());
                this.getBuyer().setPayoutTxFee(buyerSellerPayoutTxFees[0]);
                this.getSeller().setPayoutTxFee(buyerSellerPayoutTxFees[1]);
                this.getBuyer().setPayoutAmount(disputeResult.getBuyerPayoutAmountBeforeCost().subtract(this.getBuyer().getPayoutTxFee()));
                this.getSeller().setPayoutAmount(disputeResult.getSellerPayoutAmountBeforeCost().subtract(this.getSeller().getPayoutTxFee()));
            }
        }
        if (Boolean.TRUE.equals(payoutTx.isRelayed()) || Boolean.TRUE.equals(payoutTx.inTxPool())) {
            this.setPayoutStatePublished();
        }
        if (payoutTx.isConfirmed().booleanValue()) {
            this.setPayoutStateConfirmed();
        }
        if (payoutTx.getNumConfirmations() != null) {
            if (payoutTx.getNumConfirmations() >= 10L) {
                this.setPayoutStateUnlocked();
            }
            if (payoutTx.getNumConfirmations() >= (long)NUM_BLOCKS_PAYOUT_FINALIZED) {
                this.setPayoutStateFinalized();
            }
        }
        if (this.getPayoutState() != Trade.getPayoutState(payoutTx)) {
            this.setPayoutState(Trade.getPayoutState(payoutTx));
        }
    }

    public boolean onPayoutError(boolean syncAndPoll, boolean resendPaymentReceivedMessages, TradePeer paymentReceivedNackSender) {
        log.warn("Handling payout error for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
        if (syncAndPoll) {
            try {
                this.syncAndPollWallet();
            }
            catch (Exception e) {
                log.warn("Error syncing and polling wallet for {} {}: {}", new Object[]{this.getClass().getSimpleName(), this.getId(), e.getMessage()});
            }
        }
        log.warn("Resetting trade state after payout error for {} {}, nackSender={}", new Object[]{this.getClass().getSimpleName(), this.getId(), paymentReceivedNackSender == null ? null : this.getPeerRole(paymentReceivedNackSender)});
        this.processModel.setPaymentSentPayoutTxStale(true);
        if (paymentReceivedNackSender != null) {
            paymentReceivedNackSender.setPaymentReceivedMessage(null);
            paymentReceivedNackSender.setPaymentReceivedMessageState(MessageState.NACKED);
        }
        if (!this.isPayoutPublished()) {
            this.getSelf().setUnsignedPayoutTxHex(null);
            this.setPayoutTxHex(null);
            this.setPayoutTxId(null);
        }
        this.persistNow(null);
        if (resendPaymentReceivedMessages && this.walletExists()) {
            if (!this.isSeller()) {
                throw new IllegalArgumentException("Only the seller can resend PaymentReceivedMessages after a payout error for " + this.getClass().getSimpleName() + " " + this.getId());
            }
            if (!this.isPaymentReceived()) {
                throw new IllegalStateException("Cannot resend PaymentReceivedMessages after a payout error for " + this.getClass().getSimpleName() + " " + this.getId() + " because payment not marked received");
            }
            log.warn("Sending updated PaymentReceivedMessages for {} {} after payout error", (Object)this.getClass().getSimpleName(), (Object)this.getId());
            ((SellerProtocol)this.getProtocol()).onPaymentReceived(() -> log.info("Done sending updated PaymentReceivedMessages on payout error for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId()), errorMessage -> log.warn("Error sending updated PaymentReceivedMessages on payout error for {} {}: {}", new Object[]{this.getClass().getSimpleName(), this.getId(), errorMessage}));
            return true;
        }
        return false;
    }

    private boolean hasDepositTxs(List<MoneroTxWallet> txs) {
        return this.getMakerDepositTx(txs) != null && (this.getTakerDepositTx(txs) != null || this.hasBuyerAsTakerWithoutDeposit());
    }

    private boolean hasPayoutTx(List<MoneroTxWallet> txs) {
        for (MoneroTxWallet tx : txs) {
            if (!tx.getHash().equals(this.getPayoutTxId())) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnlocked(MoneroTx tx) {
        if (tx == null) {
            return false;
        }
        return tx.getNumConfirmations() != null && tx.getNumConfirmations() >= 10L;
    }

    private boolean hasUnlockedTx() {
        return Trade.isUnlocked((MoneroTx)this.getMaker().getDepositTx()) || Trade.isUnlocked((MoneroTx)this.getTaker().getDepositTx());
    }

    private MoneroTxWallet getMakerDepositTx(List<MoneroTxWallet> txs) {
        return this.getValidDepositTx(txs, this.getMaker());
    }

    private MoneroTxWallet getTakerDepositTx(List<MoneroTxWallet> txs) {
        return this.getValidDepositTx(txs, this.getTaker());
    }

    private MoneroTxWallet getBuyerDepositTx(List<MoneroTxWallet> txs) {
        return this.getValidDepositTx(txs, this.getBuyer());
    }

    private MoneroTxWallet getSellerDepositTx(List<MoneroTxWallet> txs) {
        return this.getValidDepositTx(txs, this.getSeller());
    }

    private MoneroTxWallet getValidDepositTx(List<MoneroTxWallet> txs, TradePeer peer) {
        for (MoneroTxWallet tx : txs) {
            if (!tx.getHash().equals(peer.getDepositTxHash()) || Boolean.TRUE.equals(tx.isFailed())) continue;
            return tx;
        }
        return null;
    }

    private static boolean isSeen(MoneroTx tx) {
        if (tx == null) {
            return false;
        }
        if (Boolean.TRUE.equals(tx.isFailed())) {
            return false;
        }
        return Boolean.TRUE.equals(tx.inTxPool()) || Boolean.TRUE.equals(tx.isConfirmed());
    }

    private State getDepositsState(MoneroTxWallet makerDepositTx, MoneroTxWallet takerDepositTx) {
        if (makerDepositTx == null || !this.hasBuyerAsTakerWithoutDeposit() && takerDepositTx == null) {
            return State.ARBITRATOR_PUBLISHED_DEPOSIT_TXS;
        }
        if (makerDepositTx.isFailed().booleanValue() || !this.hasBuyerAsTakerWithoutDeposit() && takerDepositTx.isFailed().booleanValue()) {
            return State.ARBITRATOR_PUBLISHED_DEPOSIT_TXS;
        }
        if (makerDepositTx.getNumConfirmations() == null || !this.hasBuyerAsTakerWithoutDeposit() && takerDepositTx.getNumConfirmations() == null) {
            return State.ARBITRATOR_PUBLISHED_DEPOSIT_TXS;
        }
        if (makerDepositTx.getNumConfirmations() >= 30L && (this.hasBuyerAsTakerWithoutDeposit() || takerDepositTx.getNumConfirmations() >= 30L)) {
            return State.DEPOSIT_TXS_FINALIZED_IN_BLOCKCHAIN;
        }
        if (makerDepositTx.getNumConfirmations() >= 10L && (this.hasBuyerAsTakerWithoutDeposit() || takerDepositTx.getNumConfirmations() >= 10L)) {
            return State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN;
        }
        if (makerDepositTx.isConfirmed().booleanValue() && (this.hasBuyerAsTakerWithoutDeposit() || takerDepositTx.isConfirmed().booleanValue())) {
            return State.DEPOSIT_TXS_CONFIRMED_IN_BLOCKCHAIN;
        }
        if (Trade.isSeen((MoneroTx)makerDepositTx) && (this.hasBuyerAsTakerWithoutDeposit() || Trade.isSeen((MoneroTx)takerDepositTx))) {
            return State.DEPOSIT_TXS_SEEN_IN_NETWORK;
        }
        return State.ARBITRATOR_PUBLISHED_DEPOSIT_TXS;
    }

    private static PayoutState getPayoutState(MoneroTx payoutTx) {
        if (payoutTx.getHash() == null) {
            return PayoutState.PAYOUT_UNPUBLISHED;
        }
        if (Boolean.TRUE.equals(payoutTx.isFailed())) {
            return PayoutState.PAYOUT_UNPUBLISHED;
        }
        if (payoutTx.getNumConfirmations() != null) {
            if (payoutTx.getNumConfirmations() >= (long)NUM_BLOCKS_PAYOUT_FINALIZED) {
                return PayoutState.PAYOUT_FINALIZED;
            }
            if (payoutTx.getNumConfirmations() >= 10L) {
                return PayoutState.PAYOUT_UNLOCKED;
            }
        }
        if (payoutTx.isConfirmed().booleanValue()) {
            return PayoutState.PAYOUT_CONFIRMED;
        }
        if (Boolean.TRUE.equals(payoutTx.isRelayed()) || Boolean.TRUE.equals(payoutTx.inTxPool())) {
            return PayoutState.PAYOUT_PUBLISHED;
        }
        return PayoutState.PAYOUT_UNPUBLISHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverIfMissingWalletData() {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.isWalletMissingData()) {
                log.warn("Wallet is missing data for {} {}, attempting to recover", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                this.forceRestartTradeWallet();
                if (this.isPayoutPublished()) {
                    return;
                }
                this.rescanBlockchain();
                log.warn("Importing multisig hex after rescanning blockchain for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                this.importMultisigHex();
                this.doPollWallet();
                if (this.isWalletMissingData()) {
                    throw new IllegalStateException("Wallet is still missing data after attempting recovery for " + this.getClass().getSimpleName() + " " + this.getShortId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanBlockchain() {
        Object object = this.walletLock;
        synchronized (object) {
            Object object2 = HavenoUtils.getDaemonLock();
            synchronized (object2) {
                if (this.getWallet() == null) {
                    throw new IllegalStateException("Cannot rescan blockchain because trade wallet doesn't exist for " + this.getClass().getSimpleName() + ", " + this.getId());
                }
                if (this.getWallet().getDaemonConnection() == null) {
                    throw new RuntimeException("Cannot rescan blockchain because trade wallet is not connected to a Monero daemon for " + this.getClass().getSimpleName() + ", " + this.getId());
                }
                Long timeout = null;
                try {
                    if (this.wallet instanceof MoneroWalletRpc) {
                        timeout = ((MoneroWalletRpc)this.wallet).getRpcConnection().getTimeout();
                        ((MoneroWalletRpc)this.wallet).getRpcConnection().setTimeout(Long.valueOf(600000L));
                    }
                    log.warn("Rescanning blockchain for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                    this.wallet.rescanBlockchain();
                }
                catch (Exception e) {
                    log.warn("Error rescanning blockchain for {} {}, errorMessage={}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), e.getMessage()});
                    if (HavenoUtils.isUnresponsive(e)) {
                        this.forceRestartTradeWallet();
                    }
                    throw e;
                }
                finally {
                    if (this.wallet instanceof MoneroWalletRpc) {
                        ((MoneroWalletRpc)this.wallet).getRpcConnection().setTimeout(timeout);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanSpent(boolean skipLog) {
        Object object = this.walletLock;
        synchronized (object) {
            if (this.getWallet() == null) {
                throw new IllegalStateException("Cannot rescan spent outputs because trade wallet doesn't exist for " + this.getClass().getSimpleName() + ", " + this.getId());
            }
            if (this.getWallet().getDaemonConnection() == null) {
                throw new RuntimeException("Cannot rescan spent outputs because trade wallet is not connected to a Monero daemon for " + this.getClass().getSimpleName() + ", " + this.getId());
            }
            Long timeout = null;
            try {
                if (this.wallet instanceof MoneroWalletRpc) {
                    timeout = ((MoneroWalletRpc)this.wallet).getRpcConnection().getTimeout();
                    ((MoneroWalletRpc)this.wallet).getRpcConnection().setTimeout(Long.valueOf(600000L));
                }
                if (!skipLog) {
                    log.info("Rescanning spent outputs for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                }
                this.wallet.rescanSpent();
                if (!skipLog) {
                    log.info("Done rescanning spent outputs for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getShortId());
                }
                this.saveWalletIfElapsedTime();
            }
            catch (Exception e) {
                log.warn("Error rescanning spent outputs for {} {}, errorMessage={}", new Object[]{this.getClass().getSimpleName(), this.getShortId(), e.getMessage()});
                if (HavenoUtils.isUnresponsive(e)) {
                    this.forceRestartTradeWallet();
                }
                throw e;
            }
            finally {
                if (this.wallet instanceof MoneroWalletRpc) {
                    ((MoneroWalletRpc)this.wallet).getRpcConnection().setTimeout(timeout);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWalletMissingData() {
        Object object = this.walletLock;
        synchronized (object) {
            if (!this.isDepositsUnlocked() || this.isPayoutPublished()) {
                return false;
            }
            if (this.getMakerDepositTx() == null) {
                log.warn("Missing maker deposit tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                return true;
            }
            if (this.getTakerDepositTx() == null && !this.hasBuyerAsTakerWithoutDeposit()) {
                log.warn("Missing taker deposit tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                return true;
            }
            if (this.wallet.getBalance().equals(BigInteger.ZERO)) {
                this.doPollWallet();
                if (this.isPayoutPublished()) {
                    return false;
                }
                log.warn("Wallet balance is zero for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
                return true;
            }
            return false;
        }
    }

    private void forceRestartTradeWallet() {
        if (this.isShutDownStarted || this.restartInProgress) {
            return;
        }
        log.warn("Force restarting trade wallet for {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
        this.restartInProgress = true;
        this.stopPolling();
        this.forceCloseWallet();
        if (!this.isShutDownStarted) {
            this.wallet = this.getWallet();
        }
        this.restartInProgress = false;
        ThreadUtils.execute(() -> this.maybeInitSyncing(), (String)this.getId());
    }

    private void setStateDepositsSeen() {
        if (this.getState().ordinal() < State.DEPOSIT_TXS_SEEN_IN_NETWORK.ordinal()) {
            this.setState(State.DEPOSIT_TXS_SEEN_IN_NETWORK);
        }
    }

    private void setStateDepositsConfirmed() {
        if (!this.isDepositsConfirmed()) {
            this.setState(State.DEPOSIT_TXS_CONFIRMED_IN_BLOCKCHAIN);
        }
    }

    private void setStateDepositsUnlocked() {
        if (!this.isDepositsUnlocked()) {
            this.setState(State.DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN);
        }
    }

    private void setStateDepositsFinalized() {
        if (!this.isDepositsFinalized()) {
            this.setState(State.DEPOSIT_TXS_FINALIZED_IN_BLOCKCHAIN);
        }
        try {
            this.maybeUpdateTradePeriod();
        }
        catch (Exception e) {
            log.warn("Error updating trade period after deposits finalized for {} {}: {}", new Object[]{this.getClass().getSimpleName(), this.getId(), e.getMessage()});
        }
    }

    private void setPayoutStatePublished() {
        if (!this.isPayoutPublished()) {
            this.setPayoutState(PayoutState.PAYOUT_PUBLISHED);
        }
    }

    private void setPayoutStateConfirmed() {
        if (!this.isPayoutConfirmed()) {
            this.setPayoutState(PayoutState.PAYOUT_CONFIRMED);
        }
    }

    private void setPayoutStateUnlocked() {
        if (!this.isPayoutUnlocked()) {
            this.setPayoutState(PayoutState.PAYOUT_UNLOCKED);
        }
    }

    private void setPayoutStateFinalized() {
        if (!this.isPayoutFinalized()) {
            this.setPayoutState(PayoutState.PAYOUT_FINALIZED);
        }
    }

    private Trade getTrade() {
        return this;
    }

    private void onDepositRequested() {
        if (!this.isArbitrator()) {
            this.startPolling();
        }
    }

    private void onDepositsPublished() {
        if (this.isArbitrator()) {
            this.startPolling();
            return;
        }
        if (this instanceof MakerTrade) {
            this.processModel.getOpenOfferManager().closeSpentOffer(this.getOffer());
            HavenoUtils.notificationService.sendTradeNotification(this, Phase.DEPOSITS_PUBLISHED, "Offer Taken", "Your offer " + this.offer.getId() + " has been accepted");
        } else {
            this.getXmrWalletService().resetAddressEntriesForOpenOffer(this.getId());
        }
        ThreadUtils.submitToPool(() -> this.xmrWalletService.freezeOutputs(this.getSelf().getReserveTxKeyImages()));
    }

    private void onDepositsConfirmed() {
        HavenoUtils.notificationService.sendTradeNotification(this, Phase.DEPOSITS_CONFIRMED, "Trade Deposits Confirmed", "The deposit transactions have confirmed");
    }

    private void onDepositsUnlocked() {
        HavenoUtils.notificationService.sendTradeNotification(this, Phase.DEPOSITS_UNLOCKED, "Trade Deposits Unlocked", "The deposit transactions have unlocked");
    }

    private void onDepositsFinalized() {
        HavenoUtils.notificationService.sendTradeNotification(this, Phase.DEPOSITS_FINALIZED, "Trade Deposits Finalized", "The deposit transactions have finalized");
    }

    private void onPaymentSent() {
        HavenoUtils.notificationService.sendTradeNotification(this, Phase.PAYMENT_SENT, "Payment Sent", "The buyer has sent the payment");
    }

    public Message toProtoMessage() {
        Trade.Builder builder = protobuf.Trade.newBuilder().setOffer(this.offer.toProtoMessage()).setTakeOfferDate(this.takeOfferDate).setProcessModel(this.processModel.toProtoMessage()).setAmount(this.amount).setPrice(this.price).setState(State.toProtoMessage(this.state)).setPayoutState(PayoutState.toProtoMessage(this.payoutState)).setDisputeState(DisputeState.toProtoMessage(this.disputeState)).setPeriodState(TradePeriodState.toProtoMessage(this.periodState)).addAllChatMessage((Iterable)this.getChatMessages().stream().map(msg -> msg.toProtoNetworkEnvelope().getChatMessage()).collect(Collectors.toList())).setLockTime(this.lockTime).setStartTime(this.startTime).setUid(this.uid).setIsCompleted(this.isCompleted);
        Optional.ofNullable(this.payoutTxId).ifPresent(arg_0 -> ((Trade.Builder)builder).setPayoutTxId(arg_0));
        Optional.ofNullable(this.contract).ifPresent(e -> builder.setContract(this.contract.toProtoMessage()));
        Optional.ofNullable(this.contractAsJson).ifPresent(arg_0 -> ((Trade.Builder)builder).setContractAsJson(arg_0));
        Optional.ofNullable(this.contractHash).ifPresent(e -> builder.setContractHash(ByteString.copyFrom((byte[])this.contractHash)));
        Optional.ofNullable(this.errorMessage).ifPresent(arg_0 -> ((Trade.Builder)builder).setErrorMessage(arg_0));
        Optional.ofNullable(this.counterCurrencyTxId).ifPresent(e -> builder.setCounterCurrencyTxId(this.counterCurrencyTxId));
        Optional.ofNullable(this.mediationResultState).ifPresent(e -> builder.setMediationResultState(MediationResultState.toProtoMessage(this.mediationResultState)));
        Optional.ofNullable(this.refundResultState).ifPresent(e -> builder.setRefundResultState(RefundResultState.toProtoMessage(this.refundResultState)));
        Optional.ofNullable(this.payoutTxHex).ifPresent(e -> builder.setPayoutTxHex(this.payoutTxHex));
        Optional.ofNullable(this.payoutTxKey).ifPresent(e -> builder.setPayoutTxKey(this.payoutTxKey));
        Optional.ofNullable(this.counterCurrencyExtraData).ifPresent(e -> builder.setCounterCurrencyExtraData(this.counterCurrencyExtraData));
        Optional.ofNullable(this.challenge).ifPresent(e -> builder.setChallenge(this.challenge));
        return builder.build();
    }

    public static Trade fromProto(Trade trade, protobuf.Trade proto, CoreProtoResolver coreProtoResolver) {
        trade.setTakeOfferDate(proto.getTakeOfferDate());
        trade.setState(State.fromProto(proto.getState()));
        trade.setPayoutState(PayoutState.fromProto(proto.getPayoutState()));
        trade.setDisputeState(DisputeState.fromProto(proto.getDisputeState()));
        trade.setPeriodState(TradePeriodState.fromProto(proto.getPeriodState()));
        trade.setPayoutTxId(ProtoUtil.stringOrNullFromProto((String)proto.getPayoutTxId()));
        trade.setPayoutTxHex(ProtoUtil.stringOrNullFromProto((String)proto.getPayoutTxHex()));
        trade.setPayoutTxKey(ProtoUtil.stringOrNullFromProto((String)proto.getPayoutTxKey()));
        trade.setContract(proto.hasContract() ? Contract.fromProto(proto.getContract(), coreProtoResolver) : null);
        trade.setContractAsJson(ProtoUtil.stringOrNullFromProto((String)proto.getContractAsJson()));
        trade.setContractHash(ProtoUtil.byteArrayOrNullFromProto((ByteString)proto.getContractHash()));
        trade.setErrorMessage(ProtoUtil.stringOrNullFromProto((String)proto.getErrorMessage()));
        trade.setCounterCurrencyTxId(proto.getCounterCurrencyTxId().isEmpty() ? null : proto.getCounterCurrencyTxId());
        trade.setMediationResultState(MediationResultState.fromProto(proto.getMediationResultState()));
        trade.setRefundResultState(RefundResultState.fromProto(proto.getRefundResultState()));
        trade.setLockTime(proto.getLockTime());
        trade.setStartTime(proto.getStartTime());
        trade.setCounterCurrencyExtraData(ProtoUtil.stringOrNullFromProto((String)proto.getCounterCurrencyExtraData()));
        trade.setCompleted(proto.getIsCompleted());
        trade.chatMessages.addAll((Collection)proto.getChatMessageList().stream().map(ChatMessage::fromPayloadProto).collect(Collectors.toList()));
        return trade;
    }

    public String toString() {
        return "Trade{\n     offer=" + String.valueOf(this.offer) + ",\n     totalTxFee=" + String.valueOf(this.getTotalTxFee()) + ",\n     takeOfferDate=" + this.takeOfferDate + ",\n     processModel=" + String.valueOf(this.processModel) + ",\n     payoutTxId='" + this.payoutTxId + "',\n     amount=" + this.amount + ",\n     tradePrice=" + this.price + ",\n     state=" + String.valueOf((Object)this.state) + ",\n     payoutState=" + String.valueOf((Object)this.payoutState) + ",\n     disputeState=" + String.valueOf((Object)this.disputeState) + ",\n     tradePeriodState=" + String.valueOf((Object)this.periodState) + ",\n     contract=" + String.valueOf(this.contract) + ",\n     contractAsJson='" + this.contractAsJson + "',\n     contractHash=" + Utilities.bytesAsHexString((byte[])this.contractHash) + ",\n     errorMessage='" + this.errorMessage + "',\n     counterCurrencyTxId='" + this.counterCurrencyTxId + "',\n     counterCurrencyExtraData='" + this.counterCurrencyExtraData + "',\n     chatMessages=" + String.valueOf(this.chatMessages) + ",\n     xmrWalletService=" + String.valueOf(this.xmrWalletService) + ",\n     stateProperty=" + String.valueOf(this.stateProperty) + ",\n     statePhaseProperty=" + String.valueOf(this.phaseProperty) + ",\n     disputeStateProperty=" + String.valueOf(this.disputeStateProperty) + ",\n     tradePeriodStateProperty=" + String.valueOf(this.tradePeriodStateProperty) + ",\n     errorMessageProperty=" + String.valueOf(this.errorMessageProperty) + ",\n     payoutTx=" + String.valueOf(this.payoutTx) + ",\n     amount=" + this.amount + ",\n     tradeAmountProperty=" + String.valueOf(this.tradeAmountProperty) + ",\n     tradeVolumeProperty=" + String.valueOf(this.tradeVolumeProperty) + ",\n     mediationResultState=" + String.valueOf((Object)this.mediationResultState) + ",\n     mediationResultStateProperty=" + String.valueOf(this.mediationResultStateProperty) + ",\n     lockTime=" + this.lockTime + ",\n     startTime=" + this.startTime + ",\n     refundResultState=" + String.valueOf((Object)this.refundResultState) + ",\n     refundResultStateProperty=" + String.valueOf(this.refundResultStateProperty) + ",\n     isCompleted=" + this.isCompleted + ",\n     challenge='" + this.challenge + "'\n}";
    }

    public Object getLock() {
        return this.lock;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    public String getUid() {
        return this.uid;
    }

    public void setTakeOfferDate(long takeOfferDate) {
        this.takeOfferDate = takeOfferDate;
    }

    public double getInitProgress() {
        return this.initProgress;
    }

    public Exception getInitError() {
        return this.initError;
    }

    public void setInitError(Exception initError) {
        this.initError = initError;
    }

    public void setPrice(long price) {
        this.price = price;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public PayoutState getPayoutState() {
        return this.payoutState;
    }

    public DisputeState getDisputeState() {
        return this.disputeState;
    }

    public TradePeriodState getPeriodState() {
        return this.periodState;
    }

    @Nullable
    public Contract getContract() {
        return this.contract;
    }

    public void setContract(@Nullable Contract contract) {
        this.contract = contract;
    }

    @Nullable
    public String getContractAsJson() {
        return this.contractAsJson;
    }

    public void setContractAsJson(@Nullable String contractAsJson) {
        this.contractAsJson = contractAsJson;
    }

    @Nullable
    public byte[] getContractHash() {
        return this.contractHash;
    }

    public void setContractHash(@Nullable byte[] contractHash) {
        this.contractHash = contractHash;
    }

    @Nullable
    public String getCounterCurrencyTxId() {
        return this.counterCurrencyTxId;
    }

    public void setCounterCurrencyTxId(@Nullable String counterCurrencyTxId) {
        this.counterCurrencyTxId = counterCurrencyTxId;
    }

    public ObservableList<ChatMessage> getChatMessages() {
        return this.chatMessages;
    }

    public XmrWalletService getXmrWalletService() {
        return this.xmrWalletService;
    }

    public IntegerProperty getDepositTxsUpdateCounter() {
        return this.depositTxsUpdateCounter;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Nullable
    public MediationResultState getMediationResultState() {
        return this.mediationResultState;
    }

    public long getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(long lockTime) {
        this.lockTime = lockTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Nullable
    public RefundResultState getRefundResultState() {
        return this.refundResultState;
    }

    public String getCounterCurrencyExtraData() {
        return this.counterCurrencyExtraData;
    }

    public void setCounterCurrencyExtraData(String counterCurrencyExtraData) {
        this.counterCurrencyExtraData = counterCurrencyExtraData;
    }

    public String getPayoutTxId() {
        return this.payoutTxId;
    }

    public void setPayoutTxId(String payoutTxId) {
        this.payoutTxId = payoutTxId;
    }

    @Nullable
    public String getPayoutTxHex() {
        return this.payoutTxHex;
    }

    public void setPayoutTxHex(@Nullable String payoutTxHex) {
        this.payoutTxHex = payoutTxHex;
    }

    public String getPayoutTxKey() {
        return this.payoutTxKey;
    }

    public void setPayoutTxKey(String payoutTxKey) {
        this.payoutTxKey = payoutTxKey;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public static enum State {
        PREPARATION(Phase.INIT),
        MULTISIG_PREPARED(Phase.INIT),
        MULTISIG_MADE(Phase.INIT),
        MULTISIG_EXCHANGED(Phase.INIT),
        MULTISIG_COMPLETED(Phase.INIT),
        CONTRACT_SIGNATURE_REQUESTED(Phase.INIT),
        CONTRACT_SIGNED(Phase.INIT),
        SENT_PUBLISH_DEPOSIT_TX_REQUEST(Phase.DEPOSIT_REQUESTED),
        SEND_FAILED_PUBLISH_DEPOSIT_TX_REQUEST(Phase.DEPOSIT_REQUESTED),
        SAW_ARRIVED_PUBLISH_DEPOSIT_TX_REQUEST(Phase.DEPOSIT_REQUESTED),
        PUBLISH_DEPOSIT_TX_REQUEST_FAILED(Phase.DEPOSIT_REQUESTED),
        ARBITRATOR_PUBLISHED_DEPOSIT_TXS(Phase.DEPOSITS_PUBLISHED),
        DEPOSIT_TXS_SEEN_IN_NETWORK(Phase.DEPOSITS_PUBLISHED),
        DEPOSIT_TXS_CONFIRMED_IN_BLOCKCHAIN(Phase.DEPOSITS_CONFIRMED),
        DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN(Phase.DEPOSITS_UNLOCKED),
        DEPOSIT_TXS_FINALIZED_IN_BLOCKCHAIN(Phase.DEPOSITS_FINALIZED),
        BUYER_CONFIRMED_PAYMENT_SENT(Phase.PAYMENT_SENT),
        BUYER_SENT_PAYMENT_SENT_MSG(Phase.PAYMENT_SENT),
        BUYER_SEND_FAILED_PAYMENT_SENT_MSG(Phase.PAYMENT_SENT),
        BUYER_STORED_IN_MAILBOX_PAYMENT_SENT_MSG(Phase.PAYMENT_SENT),
        BUYER_SAW_ARRIVED_PAYMENT_SENT_MSG(Phase.PAYMENT_SENT),
        SELLER_RECEIVED_PAYMENT_SENT_MSG(Phase.PAYMENT_SENT),
        SELLER_CONFIRMED_PAYMENT_RECEIPT(Phase.PAYMENT_RECEIVED),
        SELLER_SENT_PAYMENT_RECEIVED_MSG(Phase.PAYMENT_RECEIVED),
        SELLER_SEND_FAILED_PAYMENT_RECEIVED_MSG(Phase.PAYMENT_RECEIVED),
        SELLER_STORED_IN_MAILBOX_PAYMENT_RECEIVED_MSG(Phase.PAYMENT_RECEIVED),
        SELLER_SAW_ARRIVED_PAYMENT_RECEIVED_MSG(Phase.PAYMENT_RECEIVED),
        BUYER_RECEIVED_PAYMENT_RECEIVED_MSG(Phase.PAYMENT_RECEIVED);

        @NotNull
        private final Phase phase;

        @NotNull
        public Phase getPhase() {
            return this.phase;
        }

        private State(Phase phase) {
            this.phase = phase;
        }

        public static State fromProto(Trade.State state) {
            return (State)ProtoUtil.enumFromProto(State.class, (String)state.name());
        }

        public static Trade.State toProtoMessage(State state) {
            return Trade.State.valueOf((String)state.name());
        }

        public boolean isValidTransitionTo(State newState) {
            Phase newPhase = newState.getPhase();
            Phase currentPhase = this.getPhase();
            return currentPhase.isValidTransitionTo(newPhase) || newPhase.equals((Object)currentPhase);
        }
    }

    public static enum PayoutState {
        PAYOUT_UNPUBLISHED,
        PAYOUT_PUBLISHED,
        PAYOUT_CONFIRMED,
        PAYOUT_UNLOCKED,
        PAYOUT_FINALIZED;


        public static PayoutState fromProto(Trade.PayoutState state) {
            return (PayoutState)ProtoUtil.enumFromProto(PayoutState.class, (String)state.name());
        }

        public static Trade.PayoutState toProtoMessage(PayoutState state) {
            return Trade.PayoutState.valueOf((String)state.name());
        }

        public boolean isValidTransitionTo(PayoutState newState) {
            return newState.ordinal() > this.ordinal();
        }
    }

    public static enum DisputeState {
        NO_DISPUTE,
        DISPUTE_PREPARING,
        DISPUTE_REQUESTED,
        DISPUTE_OPENED,
        ARBITRATOR_SENT_DISPUTE_CLOSED_MSG,
        ARBITRATOR_SEND_FAILED_DISPUTE_CLOSED_MSG,
        ARBITRATOR_STORED_IN_MAILBOX_DISPUTE_CLOSED_MSG,
        ARBITRATOR_SAW_ARRIVED_DISPUTE_CLOSED_MSG,
        DISPUTE_CLOSED,
        MEDIATION_REQUESTED,
        MEDIATION_STARTED_BY_PEER,
        MEDIATION_CLOSED,
        REFUND_REQUESTED,
        REFUND_REQUEST_STARTED_BY_PEER,
        REFUND_REQUEST_CLOSED;


        public static DisputeState fromProto(Trade.DisputeState disputeState) {
            return (DisputeState)ProtoUtil.enumFromProto(DisputeState.class, (String)disputeState.name());
        }

        public static Trade.DisputeState toProtoMessage(DisputeState disputeState) {
            return Trade.DisputeState.valueOf((String)disputeState.name());
        }

        public boolean isMediated() {
            return this == MEDIATION_REQUESTED || this == MEDIATION_STARTED_BY_PEER || this == MEDIATION_CLOSED;
        }

        public boolean isDisputed() {
            return this.ordinal() >= DISPUTE_PREPARING.ordinal();
        }

        public boolean isPreparing() {
            return this == DISPUTE_PREPARING;
        }

        public boolean isRequested() {
            return this.ordinal() >= DISPUTE_REQUESTED.ordinal();
        }

        public boolean isOpen() {
            return this.ordinal() >= DISPUTE_OPENED.ordinal() && !this.isClosed();
        }

        public boolean isCloseRequested() {
            return this.ordinal() >= ARBITRATOR_SENT_DISPUTE_CLOSED_MSG.ordinal();
        }

        public boolean isClosed() {
            return this == DISPUTE_CLOSED;
        }
    }

    public static enum TradePeriodState {
        FIRST_HALF,
        SECOND_HALF,
        TRADE_PERIOD_OVER;


        public static TradePeriodState fromProto(Trade.TradePeriodState tradePeriodState) {
            return (TradePeriodState)ProtoUtil.enumFromProto(TradePeriodState.class, (String)tradePeriodState.name());
        }

        public static Trade.TradePeriodState toProtoMessage(TradePeriodState tradePeriodState) {
            return Trade.TradePeriodState.valueOf((String)tradePeriodState.name());
        }
    }

    public static enum Phase {
        INIT,
        DEPOSIT_REQUESTED,
        DEPOSITS_PUBLISHED,
        DEPOSITS_CONFIRMED,
        DEPOSITS_UNLOCKED,
        DEPOSITS_FINALIZED,
        PAYMENT_SENT,
        PAYMENT_RECEIVED;


        public static Phase fromProto(Trade.Phase phase) {
            return (Phase)ProtoUtil.enumFromProto(Phase.class, (String)phase.name());
        }

        public static Trade.Phase toProtoMessage(Phase phase) {
            return Trade.Phase.valueOf((String)phase.name());
        }

        public boolean isValidTransitionTo(Phase newPhase) {
            return newPhase.ordinal() > this.ordinal();
        }
    }

    private class IdlePayoutSyncer
    extends MoneroWalletListener {
        boolean processing = false;

        private IdlePayoutSyncer() {
        }

        public void onNewBlock(long height) {
            ThreadUtils.execute(() -> {
                block10: {
                    if (this.processing) {
                        return;
                    }
                    this.processing = true;
                    if (!Trade.this.isIdling() || !Trade.this.isPayoutPublished() || Trade.this.isPayoutFinalized()) {
                        this.processing = false;
                        return;
                    }
                    try {
                        if (Trade.this.payoutHeight == null && Trade.this.getPayoutTxId() != null && Trade.this.isPayoutPublished()) {
                            MoneroTx tx = Trade.this.xmrWalletService.getMonerod().getTx(Trade.this.getPayoutTxId());
                            if (tx == null) {
                                log.warn("Payout tx not found for {} {}, txId={}", new Object[]{Trade.this.getTrade().getClass().getSimpleName(), Trade.this.getId(), Trade.this.getPayoutTxId()});
                            } else if (tx.isConfirmed().booleanValue()) {
                                Trade.this.payoutHeight = tx.getHeight();
                            }
                        }
                        long currentHeight = Trade.this.xmrWalletService.getMonerod().getHeight();
                        if (!Trade.this.isPayoutConfirmed() || Trade.this.payoutHeight != null && (!Trade.this.isPayoutUnlocked() && currentHeight >= Trade.this.payoutHeight + 10L || !Trade.this.isPayoutFinalized() && currentHeight >= Trade.this.payoutHeight + (long)NUM_BLOCKS_PAYOUT_FINALIZED)) {
                            log.info("Syncing idle trade wallet to update payout tx, tradeId={}", (Object)Trade.this.getId());
                            Trade.this.syncAndPollWallet();
                        }
                        this.processing = false;
                    }
                    catch (Exception e) {
                        this.processing = false;
                        if (!Trade.this.isInitialized || Trade.this.isShutDownStarted) {
                            return;
                        }
                        if (!Trade.this.isWalletConnectedToDaemon()) break block10;
                        log.warn("Error polling idle trade for {} {}: {}. Monerod={}\n", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Trade.this.getId(), e.getMessage(), Trade.this.getXmrWalletService().getXmrConnectionService().getConnection(), e});
                    }
                }
            }, (String)Trade.this.getId());
        }
    }
}

