/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import haveno.core.offer.Offer;
import haveno.core.trade.Trade;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.util.Date;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SellerTrade
extends Trade {
    private static final Logger log = LoggerFactory.getLogger(SellerTrade.class);
    private static final long resendPaymentReceivedMessagesDurationMs = 2592000000L;

    SellerTrade(Offer offer, BigInteger tradeAmount, long tradePrice, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable NodeAddress makerNodeAddress, @Nullable NodeAddress takerNodeAddress, @Nullable NodeAddress arbitratorNodeAddress, @Nullable String challenge) {
        super(offer, tradeAmount, tradePrice, xmrWalletService, processModel, uid, makerNodeAddress, takerNodeAddress, arbitratorNodeAddress, challenge);
    }

    @Override
    public BigInteger getPayoutAmountBeforeCost() {
        return this.getSellerSecurityDepositBeforeMiningFee();
    }

    @Override
    public boolean confirmPermitted() {
        return true;
    }

    @Override
    public boolean isFinished() {
        return super.isFinished() && !this.needsToResendPaymentReceivedMessages();
    }

    public boolean needsToResendPaymentReceivedMessages() {
        boolean hasNoPaymentReceivedMessages;
        boolean bl = hasNoPaymentReceivedMessages = this.getBuyer().getPaymentReceivedMessage() == null && this.getArbitrator().getPaymentReceivedMessage() == null;
        if (!this.walletExistsNoSync() && !hasNoPaymentReceivedMessages) {
            return false;
        }
        return !this.isShutDownStarted() && this.getState().ordinal() >= Trade.State.SELLER_SENT_PAYMENT_RECEIVED_MSG.ordinal() && !this.getProcessModel().isPaymentReceivedMessagesAckedOrStored() && this.resendPaymentReceivedMessagesEnabled() && this.resendPaymentReceivedMessagesWithinDuration();
    }

    private boolean resendPaymentReceivedMessagesEnabled() {
        return this.getOffer().getOfferPayload().getProtocolVersion() >= 2;
    }

    public boolean resendPaymentReceivedMessagesWithinDuration() {
        Date startDate = this.getMaxTradePeriodDate();
        return new Date().getTime() <= startDate.getTime() + 2592000000L;
    }
}

