/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import haveno.common.crypto.KeyRing;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.core.offer.Offer;
import haveno.core.offer.OpenOffer;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.CleanupMailboxMessagesService;
import haveno.core.trade.ClosedTradableUtil;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.Tradable;
import haveno.core.trade.TradableList;
import haveno.core.trade.Trade;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.Preferences;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosedTradableManager
implements PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(ClosedTradableManager.class);
    private final KeyRing keyRing;
    private final PriceFeedService priceFeedService;
    private final Preferences preferences;
    private final TradeStatisticsManager tradeStatisticsManager;
    private final PersistenceManager<TradableList<Tradable>> persistenceManager;
    private final CleanupMailboxMessagesService cleanupMailboxMessagesService;
    private final TradableList<Tradable> closedTradables = new TradableList();

    @Inject
    public ClosedTradableManager(KeyRing keyRing, PriceFeedService priceFeedService, Preferences preferences, TradeStatisticsManager tradeStatisticsManager, PersistenceManager<TradableList<Tradable>> persistenceManager, CleanupMailboxMessagesService cleanupMailboxMessagesService) {
        this.keyRing = keyRing;
        this.priceFeedService = priceFeedService;
        this.preferences = preferences;
        this.tradeStatisticsManager = tradeStatisticsManager;
        this.cleanupMailboxMessagesService = cleanupMailboxMessagesService;
        this.persistenceManager = persistenceManager;
        this.persistenceManager.initialize(this.closedTradables, "ClosedTrades", PersistenceManager.Source.PRIVATE);
    }

    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persisted -> {
            List list = persisted.getList();
            synchronized (list) {
                this.closedTradables.setAll(persisted.getList());
                this.closedTradables.stream().filter(tradable -> tradable.getOffer() != null).forEach(tradable -> tradable.getOffer().setPriceFeedService(this.priceFeedService));
            }
            completeHandler.run();
        }, completeHandler);
    }

    public void onAllServicesInitialized() {
        this.cleanupMailboxMessagesService.handleTrades(this.getClosedTrades());
        this.maybeClearSensitiveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Tradable tradable) {
        List list = this.closedTradables.getList();
        synchronized (list) {
            if (this.closedTradables.add(tradable)) {
                this.maybeClearSensitiveData();
                this.requestPersistence();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Tradable tradable) {
        List list = this.closedTradables.getList();
        synchronized (list) {
            if (this.closedTradables.remove(tradable)) {
                this.requestPersistence();
            }
        }
    }

    public boolean wasMyOffer(Offer offer) {
        return offer.isMyOffer(this.keyRing);
    }

    public ObservableList<Tradable> getObservableList() {
        return this.closedTradables.getObservableList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tradable> getTradableList() {
        List list = this.closedTradables.getList();
        synchronized (list) {
            return ImmutableList.copyOf(new ArrayList<Tradable>((Collection<Tradable>)this.getObservableList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Trade> getClosedTrades() {
        List list = this.closedTradables.getList();
        synchronized (list) {
            return ImmutableList.copyOf((Collection)this.getObservableList().stream().filter(e -> e instanceof Trade).map(e -> (Trade)e).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpenOffer> getCanceledOpenOffers() {
        List list = this.closedTradables.getList();
        synchronized (list) {
            return ImmutableList.copyOf((Collection)this.getObservableList().stream().filter(e -> e instanceof OpenOffer && ((OpenOffer)e).getState().equals((Object)OpenOffer.State.CANCELED)).map(e -> (OpenOffer)e).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Tradable> getTradableById(String id) {
        List list = this.closedTradables.getList();
        synchronized (list) {
            return this.closedTradables.stream().filter(e -> e.getId().equals(id)).findFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Trade> getTradeById(String id) {
        List list = this.closedTradables.getList();
        synchronized (list) {
            return this.getClosedTrades().stream().filter(e -> e.getId().equals(id)).findFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeClearSensitiveData() {
        List list = this.closedTradables.getList();
        synchronized (list) {
            log.info("checking closed trades eligibility for having sensitive data cleared");
            this.closedTradables.stream().filter(e -> e instanceof Trade).map(e -> (Trade)e).filter(e -> this.canTradeHaveSensitiveDataCleared(e.getId())).forEach(Trade::maybeClearSensitiveData);
            this.requestPersistence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canTradeHaveSensitiveDataCleared(String tradeId) {
        Instant safeDate = this.getSafeDateForSensitiveDataClearing();
        List list = this.closedTradables.getList();
        synchronized (list) {
            return this.closedTradables.stream().filter(e -> e.getId().equals(tradeId)).filter(e -> e.getDate().toInstant().isBefore(safeDate)).count() > 0L;
        }
    }

    public Instant getSafeDateForSensitiveDataClearing() {
        return Instant.ofEpochSecond(Instant.now().getEpochSecond() - TimeUnit.DAYS.toSeconds(this.preferences.getClearDataAfterDays()));
    }

    public Stream<Trade> getTradesStreamWithFundsLockedIn() {
        return this.getClosedTrades().stream().filter(Trade::isFundsLockedIn);
    }

    public Stream<Trade> getTradeModelStream() {
        return this.getClosedTrades().stream();
    }

    public int getNumPastTrades(Tradable tradable) {
        if (ClosedTradableUtil.isOpenOffer(tradable)) {
            return 0;
        }
        NodeAddress addressInTrade = ClosedTradableUtil.castToTradeModel(tradable).getTradePeerNodeAddress();
        return (int)this.getTradeModelStream().map(Trade::getTradePeerNodeAddress).filter(Objects::nonNull).filter(address -> address.equals((Object)addressInTrade)).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getTotalTradeFee(List<Tradable> tradableList) {
        List<Tradable> list = tradableList;
        synchronized (list) {
            return BigInteger.valueOf(tradableList.stream().mapToLong(tradable -> this.getTradeFee((Tradable)tradable).longValueExact()).sum());
        }
    }

    private BigInteger getTradeFee(Tradable tradable) {
        return this.getXmrTradeFee(tradable);
    }

    public BigInteger getXmrTradeFee(Tradable tradable) {
        return this.isMaker(tradable) ? tradable.getOptionalMakerFee().orElse(BigInteger.ZERO) : tradable.getOptionalTakerFee().orElse(BigInteger.ZERO);
    }

    public boolean isMaker(Tradable tradable) {
        return tradable instanceof MakerTrade || tradable.getOffer().isMyOffer(this.keyRing);
    }

    private void requestPersistence() {
        this.persistenceManager.requestPersistence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrade(Trade trade) {
        List list = this.closedTradables.getList();
        synchronized (list) {
            if (this.closedTradables.remove(trade)) {
                this.requestPersistence();
            }
        }
    }
}

