/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.CryptoMoney;
import haveno.core.monetary.TraditionalMoney;
import haveno.core.monetary.Volume;
import haveno.core.offer.OpenOffer;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.ClosedTradableUtil;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Tradable;
import haveno.core.trade.Trade;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bitcoinj.core.Monetary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ClosedTradableFormatter {
    private static final Logger log = LoggerFactory.getLogger(ClosedTradableFormatter.class);
    private static final String I18N_KEY_TOTAL_AMOUNT = "closedTradesSummaryWindow.totalAmount.value";
    private static final String I18N_KEY_TOTAL_TX_FEE = "closedTradesSummaryWindow.totalMinerFee.value";
    private static final String I18N_KEY_TOTAL_TRADE_FEE_BTC = "closedTradesSummaryWindow.totalTradeFeeInXmr.value";
    private final ClosedTradableManager closedTradableManager;

    @Inject
    public ClosedTradableFormatter(ClosedTradableManager closedTradableManager) {
        this.closedTradableManager = closedTradableManager;
    }

    public String getAmountAsString(Tradable tradable) {
        return tradable.getOptionalAmount().map(HavenoUtils::formatXmr).orElse("");
    }

    public String getTotalAmountWithVolumeAsString(BigInteger totalTradeAmount, Volume volume) {
        return Res.get(I18N_KEY_TOTAL_AMOUNT, HavenoUtils.formatXmr(totalTradeAmount, true), VolumeUtil.formatVolumeWithCode(volume));
    }

    public String getTotalTxFeeAsString(Tradable tradable) {
        return HavenoUtils.formatXmr(ClosedTradableUtil.getTotalTxFee(tradable));
    }

    public String getTotalTxFeeAsString(BigInteger totalTradeAmount, BigInteger totalTxFee) {
        double percentage = totalTradeAmount.equals(BigInteger.ZERO) ? 0.0 : HavenoUtils.divide(totalTxFee, totalTradeAmount);
        return Res.get(I18N_KEY_TOTAL_TX_FEE, HavenoUtils.formatXmr(totalTxFee, true), FormattingUtils.formatToPercentWithSymbol(percentage));
    }

    public String getBuyerSecurityDepositAsString(Tradable tradable) {
        if (tradable instanceof Trade) {
            Trade trade = ClosedTradableUtil.castToTrade(tradable);
            return HavenoUtils.formatXmr(trade.getBuyerSecurityDepositBeforeMiningFee());
        }
        return HavenoUtils.formatXmr(tradable.getOffer().getMaxBuyerSecurityDeposit());
    }

    public String getSellerSecurityDepositAsString(Tradable tradable) {
        if (tradable instanceof Trade) {
            Trade trade = ClosedTradableUtil.castToTrade(tradable);
            return HavenoUtils.formatXmr(trade.getSellerSecurityDepositBeforeMiningFee());
        }
        return HavenoUtils.formatXmr(tradable.getOffer().getMaxSellerSecurityDeposit());
    }

    public String getTradeFeeAsString(Tradable tradable, boolean appendCode) {
        BigInteger tradeFee = this.closedTradableManager.getXmrTradeFee(tradable);
        return HavenoUtils.formatXmr(tradeFee, appendCode);
    }

    public String getTotalTradeFeeAsString(BigInteger totalTradeAmount, BigInteger totalTradeFee) {
        double percentage = totalTradeAmount.equals(BigInteger.ZERO) ? 0.0 : HavenoUtils.divide(totalTradeFee, totalTradeAmount);
        return Res.get(I18N_KEY_TOTAL_TRADE_FEE_BTC, HavenoUtils.formatXmr(totalTradeFee, true), FormattingUtils.formatToPercentWithSymbol(percentage));
    }

    public String getPriceDeviationAsString(Tradable tradable) {
        if (tradable.getOffer().isUseMarketBasedPrice()) {
            return FormattingUtils.formatPercentagePrice(tradable.getOffer().getMarketPriceMarginPct());
        }
        return Res.get("shared.na");
    }

    public String getVolumeAsString(Tradable tradable, boolean appendCode) {
        return tradable.getOptionalVolume().map(volume -> VolumeUtil.formatVolume(volume, appendCode)).orElse("");
    }

    public String getVolumeCurrencyAsString(Tradable tradable) {
        return tradable.getOptionalVolume().map(Volume::getCurrencyCode).orElse("");
    }

    public String getPriceAsString(Tradable tradable) {
        return tradable.getOptionalPrice().map(FormattingUtils::formatPrice).orElse("");
    }

    public Map<String, String> getTotalVolumeByCurrencyAsString(List<Tradable> tradableList) {
        return ClosedTradableUtil.getTotalVolumeByCurrency(tradableList).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            String currencyCode = (String)entry.getKey();
            Comparable<CryptoMoney> monetary = CurrencyUtil.isCryptoCurrency(currencyCode) ? CryptoMoney.valueOf(currencyCode, (Long)entry.getValue()) : TraditionalMoney.valueOf(currencyCode, (Long)entry.getValue());
            return VolumeUtil.formatVolumeWithCode(new Volume((Monetary)monetary));
        }));
    }

    public String getStateAsString(Tradable tradable) {
        if (tradable == null) {
            return "";
        }
        if (ClosedTradableUtil.isHavenoV1Trade(tradable)) {
            Trade trade = ClosedTradableUtil.castToTrade(tradable);
            if (trade.isCompleted() || trade.isPayoutPublished()) {
                return Res.get("portfolio.closed.completed");
            }
            if (trade.getDisputeState() == Trade.DisputeState.DISPUTE_CLOSED) {
                return Res.get("portfolio.closed.ticketClosed");
            }
            if (trade.getDisputeState() == Trade.DisputeState.MEDIATION_CLOSED) {
                return Res.get("portfolio.closed.mediationTicketClosed");
            }
            if (trade.getDisputeState() == Trade.DisputeState.REFUND_REQUEST_CLOSED) {
                return Res.get("portfolio.closed.ticketClosed");
            }
            log.error("That must not happen. We got a pending state but we are in the closed trades list. state={}", (Object)trade.getState().name());
            return Res.get("shared.na");
        }
        if (ClosedTradableUtil.isOpenOffer(tradable)) {
            OpenOffer.State state = ((OpenOffer)tradable).getState();
            log.trace("OpenOffer state={}", (Object)state);
            switch (state) {
                case AVAILABLE: 
                case RESERVED: 
                case CLOSED: 
                case DEACTIVATED: {
                    log.error("Invalid state {}", (Object)state);
                    return state.name();
                }
                case CANCELED: {
                    return Res.get("portfolio.closed.canceled");
                }
            }
            log.error("Unhandled state {}", (Object)state);
            return state.name();
        }
        return Res.get("shared.na");
    }
}

