/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import com.google.inject.Inject;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.core.trade.Trade;
import haveno.core.trade.messages.TradeMessage;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.mailbox.MailboxMessage;
import haveno.network.p2p.mailbox.MailboxMessageService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupMailboxMessages {
    private static final Logger log = LoggerFactory.getLogger(CleanupMailboxMessages.class);
    private final P2PService p2PService;
    private final MailboxMessageService mailboxMessageService;

    @Inject
    public CleanupMailboxMessages(P2PService p2PService, MailboxMessageService mailboxMessageService) {
        this.p2PService = p2PService;
        this.mailboxMessageService = mailboxMessageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTrades(final List<Trade> trades) {
        List<Trade> list = trades;
        synchronized (list) {
            try {
                if (this.p2PService.isBootstrapped()) {
                    this.cleanupMailboxMessages(trades);
                } else {
                    this.p2PService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

                        public void onDataReceived() {
                            CleanupMailboxMessages.this.cleanupMailboxMessages(trades);
                        }
                    });
                }
            }
            catch (Throwable t) {
                log.error("Cleanup mailbox messages failed. {}", (Object)t.toString());
            }
        }
    }

    private void cleanupMailboxMessages(List<Trade> trades) {
        this.mailboxMessageService.getMyDecryptedMailboxMessages().forEach(message -> this.handleDecryptedMessageWithPubKey((DecryptedMessageWithPubKey)message, trades));
    }

    private void handleDecryptedMessageWithPubKey(DecryptedMessageWithPubKey decryptedMessageWithPubKey, List<Trade> trades) {
        trades.stream().filter(trade -> this.isMessageForTrade(decryptedMessageWithPubKey, (Trade)trade)).filter(trade -> this.isPubKeyValid(decryptedMessageWithPubKey, (Trade)trade)).filter(trade -> decryptedMessageWithPubKey.getNetworkEnvelope() instanceof MailboxMessage).forEach(trade -> this.removeEntryFromMailbox((MailboxMessage)decryptedMessageWithPubKey.getNetworkEnvelope(), (Trade)trade));
    }

    private boolean isMessageForTrade(DecryptedMessageWithPubKey decryptedMessageWithPubKey, Trade trade) {
        NetworkEnvelope networkEnvelope = decryptedMessageWithPubKey.getNetworkEnvelope();
        if (networkEnvelope instanceof TradeMessage) {
            return this.isMyMessage((TradeMessage)networkEnvelope, trade);
        }
        if (networkEnvelope instanceof AckMessage) {
            return this.isMyMessage((AckMessage)networkEnvelope, trade);
        }
        return false;
    }

    private void removeEntryFromMailbox(MailboxMessage mailboxMessage, Trade trade) {
        log.info("We found a pending mailbox message ({}) for trade {}. As the trade is closed we remove the mailbox message.", (Object)mailboxMessage.getClass().getSimpleName(), (Object)trade.getId());
        this.mailboxMessageService.removeMailboxMsg(mailboxMessage);
    }

    private boolean isMyMessage(TradeMessage message, Trade trade) {
        return message.getOfferId().equals(trade.getId());
    }

    private boolean isMyMessage(AckMessage ackMessage, Trade trade) {
        return ackMessage.getSourceType() == AckMessageSourceType.TRADE_MESSAGE && ackMessage.getSourceId().equals(trade.getId());
    }

    private boolean isPubKeyValid(DecryptedMessageWithPubKey decryptedMessageWithPubKey, Trade trade) {
        PubKeyRing peersPubKeyRing = trade.getTradePeer().getPubKeyRing();
        boolean isValid = true;
        if (peersPubKeyRing != null && !decryptedMessageWithPubKey.getSignaturePubKey().equals(peersPubKeyRing.getSignaturePubKey())) {
            isValid = false;
            log.warn("SignaturePubKey in decryptedMessageWithPubKey does not match the SignaturePubKey we have set for our trading peer.");
        }
        return isValid;
    }
}

