/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.trade;

import haveno.common.proto.ProtoUtil;
import haveno.core.offer.Offer;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.TakerTrade;
import haveno.core.trade.Tradable;
import haveno.core.trade.protocol.ProcessModel;
import haveno.core.xmr.wallet.XmrWalletService;
import java.math.BigInteger;
import java.util.UUID;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.NodeAddress;
import protobuf.Trade;

public final class BuyerAsTakerTrade
extends BuyerTrade
implements TakerTrade {
    private static final Logger log = LoggerFactory.getLogger(BuyerAsTakerTrade.class);

    public BuyerAsTakerTrade(Offer offer, BigInteger tradeAmount, long tradePrice, XmrWalletService xmrWalletService, ProcessModel processModel, String uid, @Nullable haveno.network.p2p.NodeAddress makerNodeAddress, @Nullable haveno.network.p2p.NodeAddress takerNodeAddress, @Nullable haveno.network.p2p.NodeAddress arbitratorNodeAddress, @Nullable String challenge) {
        super(offer, tradeAmount, tradePrice, xmrWalletService, processModel, uid, makerNodeAddress, takerNodeAddress, arbitratorNodeAddress, challenge);
    }

    public protobuf.Tradable toProtoMessage() {
        return protobuf.Tradable.newBuilder().setBuyerAsTakerTrade(protobuf.BuyerAsTakerTrade.newBuilder().setTrade((Trade)super.toProtoMessage())).build();
    }

    public static Tradable fromProto(protobuf.BuyerAsTakerTrade buyerAsTakerTradeProto, XmrWalletService xmrWalletService, CoreProtoResolver coreProtoResolver) {
        Trade proto = buyerAsTakerTradeProto.getTrade();
        ProcessModel processModel = ProcessModel.fromProto(proto.getProcessModel(), coreProtoResolver);
        String uid = ProtoUtil.stringOrNullFromProto((String)proto.getUid());
        if (uid == null) {
            uid = UUID.randomUUID().toString();
        }
        return BuyerAsTakerTrade.fromProto(new BuyerAsTakerTrade(Offer.fromProto(proto.getOffer()), BigInteger.valueOf(proto.getAmount()), proto.getPrice(), xmrWalletService, processModel, uid, proto.getProcessModel().getMaker().hasNodeAddress() ? haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getProcessModel().getMaker().getNodeAddress()) : null, proto.getProcessModel().getTaker().hasNodeAddress() ? haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getProcessModel().getTaker().getNodeAddress()) : null, proto.getProcessModel().getArbitrator().hasNodeAddress() ? haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getProcessModel().getArbitrator().getNodeAddress()) : null, ProtoUtil.stringOrNullFromProto((String)proto.getChallenge())), proto, coreProtoResolver);
    }
}

