/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.messages;

import haveno.common.UserThread;
import haveno.common.app.Version;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Attachment;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.messages.SupportMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.ChatMessage;
import protobuf.NetworkEnvelope;
import protobuf.NodeAddress;

public final class ChatMessage
extends SupportMessage {
    private static final Logger log = LoggerFactory.getLogger(ChatMessage.class);
    public static final long TTL = TimeUnit.DAYS.toMillis(7L);
    private final String tradeId;
    private final int traderId;
    private final boolean senderIsTrader;
    private final String message;
    private final ArrayList<Attachment> attachments = new ArrayList();
    private final haveno.network.p2p.NodeAddress senderNodeAddress;
    private final long date;
    private boolean isSystemMessage;
    private boolean wasDisplayed;
    private final BooleanProperty arrivedProperty;
    private final BooleanProperty storedInMailboxProperty;
    private final BooleanProperty acknowledgedProperty;
    private final StringProperty sendMessageErrorProperty;
    private final StringProperty ackErrorProperty;
    private transient WeakReference<Listener> listener;

    public ChatMessage(SupportType supportType, String tradeId, int traderId, boolean senderIsTrader, String message, haveno.network.p2p.NodeAddress senderNodeAddress) {
        this(supportType, tradeId, traderId, senderIsTrader, message, null, senderNodeAddress, new Date().getTime(), false, false, UUID.randomUUID().toString(), Version.getP2PMessageVersion(), false, null, null, false);
    }

    public ChatMessage(SupportType supportType, String tradeId, int traderId, boolean senderIsTrader, String message, haveno.network.p2p.NodeAddress senderNodeAddress, ArrayList<Attachment> attachments) {
        this(supportType, tradeId, traderId, senderIsTrader, message, attachments, senderNodeAddress, new Date().getTime(), false, false, UUID.randomUUID().toString(), Version.getP2PMessageVersion(), false, null, null, false);
    }

    public ChatMessage(SupportType supportType, String tradeId, int traderId, boolean senderIsTrader, String message, haveno.network.p2p.NodeAddress senderNodeAddress, long date) {
        this(supportType, tradeId, traderId, senderIsTrader, message, null, senderNodeAddress, date, false, false, UUID.randomUUID().toString(), Version.getP2PMessageVersion(), false, null, null, false);
    }

    public ChatMessage copy() {
        return new ChatMessage(this.supportType, this.tradeId, this.traderId, this.senderIsTrader, this.message, new ArrayList<Attachment>(this.attachments), this.senderNodeAddress, this.date, this.arrivedProperty.get(), this.storedInMailboxProperty.get(), this.uid, this.messageVersion, this.acknowledgedProperty.get(), (String)this.sendMessageErrorProperty.get(), (String)this.ackErrorProperty.get(), this.wasDisplayed);
    }

    private ChatMessage(SupportType supportType, String tradeId, int traderId, boolean senderIsTrader, String message, @Nullable List<Attachment> attachments, haveno.network.p2p.NodeAddress senderNodeAddress, long date, boolean arrived, boolean storedInMailbox, String uid, String messageVersion, boolean acknowledged, @Nullable String sendMessageError, @Nullable String ackError, boolean wasDisplayed) {
        super(messageVersion, uid, supportType);
        this.tradeId = tradeId;
        this.traderId = traderId;
        this.senderIsTrader = senderIsTrader;
        this.message = message;
        this.wasDisplayed = wasDisplayed;
        Optional.ofNullable(attachments).ifPresent(e -> this.addAllAttachments(attachments));
        this.senderNodeAddress = senderNodeAddress;
        this.date = date;
        this.arrivedProperty = new SimpleBooleanProperty(arrived);
        this.storedInMailboxProperty = new SimpleBooleanProperty(storedInMailbox);
        this.acknowledgedProperty = new SimpleBooleanProperty(acknowledged);
        this.sendMessageErrorProperty = new SimpleStringProperty(sendMessageError);
        this.ackErrorProperty = new SimpleStringProperty(ackError);
        this.notifyChangeListener();
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        ChatMessage.Builder builder = protobuf.ChatMessage.newBuilder().setType(SupportType.toProtoMessage(this.supportType)).setTradeId(this.tradeId).setTraderId(this.traderId).setSenderIsTrader(this.senderIsTrader).setMessage(this.message).addAllAttachments((Iterable)this.attachments.stream().map(Attachment::toProtoMessage).collect(Collectors.toList())).setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setDate(this.date).setArrived(this.arrivedProperty.get()).setStoredInMailbox(this.storedInMailboxProperty.get()).setIsSystemMessage(this.isSystemMessage).setUid(this.uid).setAcknowledged(this.acknowledgedProperty.get()).setWasDisplayed(this.wasDisplayed);
        Optional.ofNullable((String)this.sendMessageErrorProperty.get()).ifPresent(arg_0 -> ((ChatMessage.Builder)builder).setSendMessageError(arg_0));
        Optional.ofNullable((String)this.ackErrorProperty.get()).ifPresent(arg_0 -> ((ChatMessage.Builder)builder).setAckError(arg_0));
        return this.getNetworkEnvelopeBuilder().setChatMessage(builder).build();
    }

    public static ChatMessage fromProto(protobuf.ChatMessage proto, String messageVersion) {
        ChatMessage chatMessage = new ChatMessage(SupportType.fromProto(proto.getType()), proto.getTradeId(), proto.getTraderId(), proto.getSenderIsTrader(), proto.getMessage(), new ArrayList<Attachment>(proto.getAttachmentsList().stream().map(Attachment::fromProto).collect(Collectors.toList())), haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getSenderNodeAddress()), proto.getDate(), proto.getArrived(), proto.getStoredInMailbox(), proto.getUid(), messageVersion, proto.getAcknowledged(), proto.getSendMessageError().isEmpty() ? null : proto.getSendMessageError(), proto.getAckError().isEmpty() ? null : proto.getAckError(), proto.getWasDisplayed());
        chatMessage.setSystemMessage(proto.getIsSystemMessage());
        return chatMessage;
    }

    public static ChatMessage fromPayloadProto(protobuf.ChatMessage proto) {
        return ChatMessage.fromProto(proto, "-1");
    }

    private void addAllAttachments(List<Attachment> attachments) {
        this.attachments.addAll(attachments);
    }

    public void setArrived(boolean arrived) {
        this.arrivedProperty.set(arrived);
        this.notifyChangeListener();
    }

    public ReadOnlyBooleanProperty arrivedProperty() {
        return this.arrivedProperty;
    }

    public void setStoredInMailbox(boolean storedInMailbox) {
        this.storedInMailboxProperty.set(storedInMailbox);
        this.notifyChangeListener();
    }

    public ReadOnlyBooleanProperty storedInMailboxProperty() {
        return this.storedInMailboxProperty;
    }

    public void setAcknowledged(boolean acknowledged) {
        this.acknowledgedProperty.set(acknowledged);
        this.notifyChangeListener();
    }

    public void startAckTimer() {
        UserThread.runAfter(() -> {
            if (!this.getAcknowledgedProperty().get() && !this.getStoredInMailboxProperty().get()) {
                this.setArrived(false);
                this.setAckError(Res.get("support.errorTimeout"));
            }
        }, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    public ReadOnlyBooleanProperty acknowledgedProperty() {
        return this.acknowledgedProperty;
    }

    public void setSendMessageError(String sendMessageError) {
        this.sendMessageErrorProperty.set((Object)sendMessageError);
        this.notifyChangeListener();
    }

    public ReadOnlyStringProperty sendMessageErrorProperty() {
        return this.sendMessageErrorProperty;
    }

    public void setAckError(String ackError) {
        this.ackErrorProperty.set((Object)ackError);
        this.notifyChangeListener();
    }

    public ReadOnlyStringProperty ackErrorProperty() {
        return this.ackErrorProperty;
    }

    @Override
    public String getTradeId() {
        return this.tradeId;
    }

    public String getShortId() {
        return Utilities.getShortId((String)this.tradeId);
    }

    public void addWeakMessageStateListener(Listener listener) {
        this.listener = new WeakReference<Listener>(listener);
    }

    public boolean isResultMessage(Dispute dispute) {
        DisputeResult disputeResult = (DisputeResult)dispute.getDisputeResultProperty().get();
        if (disputeResult == null) {
            return false;
        }
        ChatMessage resultChatMessage = disputeResult.getChatMessage();
        return resultChatMessage != null && resultChatMessage.getUid().equals(this.uid);
    }

    public long getTTL() {
        return TTL;
    }

    private void notifyChangeListener() {
        Listener listener;
        if (this.listener != null && (listener = (Listener)this.listener.get()) != null) {
            listener.onMessageStateChanged();
        }
    }

    @Override
    public String toString() {
        return "ChatMessage{\n     tradeId='" + this.tradeId + "',\n     traderId=" + this.traderId + ",\n     senderIsTrader=" + this.senderIsTrader + ",\n     message='" + this.message + "',\n     attachments=" + String.valueOf(this.attachments) + ",\n     senderNodeAddress=" + String.valueOf(this.senderNodeAddress) + ",\n     date=" + this.date + ",\n     isSystemMessage=" + this.isSystemMessage + ",\n     wasDisplayed=" + this.wasDisplayed + ",\n     arrivedProperty=" + String.valueOf(this.arrivedProperty) + ",\n     storedInMailboxProperty=" + String.valueOf(this.storedInMailboxProperty) + ",\n     acknowledgedProperty=" + String.valueOf(this.acknowledgedProperty) + ",\n     sendMessageErrorProperty=" + String.valueOf(this.sendMessageErrorProperty) + ",\n     ackErrorProperty=" + String.valueOf(this.ackErrorProperty) + "\n} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTraderId() != other.getTraderId()) {
            return false;
        }
        if (this.isSenderIsTrader() != other.isSenderIsTrader()) {
            return false;
        }
        if (this.getDate() != other.getDate()) {
            return false;
        }
        if (this.isSystemMessage() != other.isSystemMessage()) {
            return false;
        }
        if (this.isWasDisplayed() != other.isWasDisplayed()) {
            return false;
        }
        String this$tradeId = this.getTradeId();
        String other$tradeId = other.getTradeId();
        if (this$tradeId == null ? other$tradeId != null : !this$tradeId.equals(other$tradeId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        ArrayList<Attachment> this$attachments = this.getAttachments();
        ArrayList<Attachment> other$attachments = other.getAttachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        haveno.network.p2p.NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        haveno.network.p2p.NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !this$senderNodeAddress.equals(other$senderNodeAddress)) {
            return false;
        }
        BooleanProperty this$arrivedProperty = this.getArrivedProperty();
        BooleanProperty other$arrivedProperty = other.getArrivedProperty();
        if (this$arrivedProperty == null ? other$arrivedProperty != null : !this$arrivedProperty.equals(other$arrivedProperty)) {
            return false;
        }
        BooleanProperty this$storedInMailboxProperty = this.getStoredInMailboxProperty();
        BooleanProperty other$storedInMailboxProperty = other.getStoredInMailboxProperty();
        if (this$storedInMailboxProperty == null ? other$storedInMailboxProperty != null : !this$storedInMailboxProperty.equals(other$storedInMailboxProperty)) {
            return false;
        }
        BooleanProperty this$acknowledgedProperty = this.getAcknowledgedProperty();
        BooleanProperty other$acknowledgedProperty = other.getAcknowledgedProperty();
        if (this$acknowledgedProperty == null ? other$acknowledgedProperty != null : !this$acknowledgedProperty.equals(other$acknowledgedProperty)) {
            return false;
        }
        StringProperty this$sendMessageErrorProperty = this.getSendMessageErrorProperty();
        StringProperty other$sendMessageErrorProperty = other.getSendMessageErrorProperty();
        if (this$sendMessageErrorProperty == null ? other$sendMessageErrorProperty != null : !this$sendMessageErrorProperty.equals(other$sendMessageErrorProperty)) {
            return false;
        }
        StringProperty this$ackErrorProperty = this.getAckErrorProperty();
        StringProperty other$ackErrorProperty = other.getAckErrorProperty();
        return !(this$ackErrorProperty == null ? other$ackErrorProperty != null : !this$ackErrorProperty.equals(other$ackErrorProperty));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTraderId();
        result = result * 59 + (this.isSenderIsTrader() ? 79 : 97);
        long $date = this.getDate();
        result = result * 59 + (int)($date >>> 32 ^ $date);
        result = result * 59 + (this.isSystemMessage() ? 79 : 97);
        result = result * 59 + (this.isWasDisplayed() ? 79 : 97);
        String $tradeId = this.getTradeId();
        result = result * 59 + ($tradeId == null ? 43 : $tradeId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        ArrayList<Attachment> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        haveno.network.p2p.NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : $senderNodeAddress.hashCode());
        BooleanProperty $arrivedProperty = this.getArrivedProperty();
        result = result * 59 + ($arrivedProperty == null ? 43 : $arrivedProperty.hashCode());
        BooleanProperty $storedInMailboxProperty = this.getStoredInMailboxProperty();
        result = result * 59 + ($storedInMailboxProperty == null ? 43 : $storedInMailboxProperty.hashCode());
        BooleanProperty $acknowledgedProperty = this.getAcknowledgedProperty();
        result = result * 59 + ($acknowledgedProperty == null ? 43 : $acknowledgedProperty.hashCode());
        StringProperty $sendMessageErrorProperty = this.getSendMessageErrorProperty();
        result = result * 59 + ($sendMessageErrorProperty == null ? 43 : $sendMessageErrorProperty.hashCode());
        StringProperty $ackErrorProperty = this.getAckErrorProperty();
        result = result * 59 + ($ackErrorProperty == null ? 43 : $ackErrorProperty.hashCode());
        return result;
    }

    public int getTraderId() {
        return this.traderId;
    }

    public boolean isSenderIsTrader() {
        return this.senderIsTrader;
    }

    public String getMessage() {
        return this.message;
    }

    public ArrayList<Attachment> getAttachments() {
        return this.attachments;
    }

    public haveno.network.p2p.NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    public long getDate() {
        return this.date;
    }

    public boolean isSystemMessage() {
        return this.isSystemMessage;
    }

    public boolean isWasDisplayed() {
        return this.wasDisplayed;
    }

    public BooleanProperty getArrivedProperty() {
        return this.arrivedProperty;
    }

    public BooleanProperty getStoredInMailboxProperty() {
        return this.storedInMailboxProperty;
    }

    public BooleanProperty getAcknowledgedProperty() {
        return this.acknowledgedProperty;
    }

    public StringProperty getSendMessageErrorProperty() {
        return this.sendMessageErrorProperty;
    }

    public StringProperty getAckErrorProperty() {
        return this.ackErrorProperty;
    }

    public WeakReference<Listener> getListener() {
        return this.listener;
    }

    public void setSystemMessage(boolean isSystemMessage) {
        this.isSystemMessage = isSystemMessage;
    }

    public void setWasDisplayed(boolean wasDisplayed) {
        this.wasDisplayed = wasDisplayed;
    }

    public static interface Listener {
        public void onMessageStateChanged();
    }
}

