/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.refund.refundagent;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.filter.FilterManager;
import haveno.core.support.dispute.agent.DisputeAgentService;
import haveno.core.support.dispute.refund.refundagent.RefundAgent;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
public class RefundAgentService
extends DisputeAgentService<RefundAgent> {
    @Inject
    public RefundAgentService(P2PService p2PService, FilterManager filterManager) {
        super(p2PService, filterManager);
    }

    @Override
    protected Set<RefundAgent> getDisputeAgentSet(List<String> bannedDisputeAgents) {
        return this.p2PService.getDataMap().values().stream().filter(data -> data.getProtectedStoragePayload() instanceof RefundAgent).map(data -> (RefundAgent)data.getProtectedStoragePayload()).filter(a -> bannedDisputeAgents == null || !bannedDisputeAgents.contains(a.getNodeAddress().getFullAddress())).collect(Collectors.toSet());
    }

    @Override
    protected List<String> getDisputeAgentsFromFilter() {
        return this.filterManager.getFilter() != null ? this.filterManager.getFilter().getRefundAgents() : new ArrayList();
    }

    public Map<NodeAddress, RefundAgent> getRefundAgents() {
        return super.getDisputeAgents();
    }
}

