/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.refund.refundagent;

import com.google.protobuf.ByteString;
import haveno.common.app.Capabilities;
import haveno.common.app.Capability;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.CollectionUtils;
import haveno.core.support.dispute.agent.DisputeAgent;
import haveno.network.p2p.storage.payload.CapabilityRequiringPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.NodeAddress;
import protobuf.RefundAgent;
import protobuf.StoragePayload;

public final class RefundAgent
extends DisputeAgent
implements CapabilityRequiringPayload {
    private static final Logger log = LoggerFactory.getLogger(RefundAgent.class);

    public RefundAgent(haveno.network.p2p.NodeAddress nodeAddress, PubKeyRing pubKeyRing, List<String> languageCodes, long registrationDate, byte[] registrationPubKey, String registrationSignature, @Nullable String emailAddress, @Nullable String info, @Nullable Map<String, String> extraDataMap) {
        super(nodeAddress, pubKeyRing, languageCodes, registrationDate, registrationPubKey, registrationSignature, emailAddress, info, extraDataMap);
    }

    public StoragePayload toProtoMessage() {
        RefundAgent.Builder builder = protobuf.RefundAgent.newBuilder().setNodeAddress(this.nodeAddress.toProtoMessage()).setPubKeyRing(this.pubKeyRing.toProtoMessage()).addAllLanguageCodes((Iterable)this.languageCodes).setRegistrationDate(this.registrationDate).setRegistrationPubKey(ByteString.copyFrom((byte[])this.registrationPubKey)).setRegistrationSignature(this.registrationSignature);
        Optional.ofNullable(this.emailAddress).ifPresent(arg_0 -> ((RefundAgent.Builder)builder).setEmailAddress(arg_0));
        Optional.ofNullable(this.info).ifPresent(arg_0 -> ((RefundAgent.Builder)builder).setInfo(arg_0));
        Optional.ofNullable(this.extraDataMap).ifPresent(arg_0 -> ((RefundAgent.Builder)builder).putAllExtraData(arg_0));
        return StoragePayload.newBuilder().setRefundAgent(builder).build();
    }

    public static RefundAgent fromProto(protobuf.RefundAgent proto) {
        return new RefundAgent(haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getNodeAddress()), PubKeyRing.fromProto((protobuf.PubKeyRing)proto.getPubKeyRing()), new ArrayList<String>((Collection<String>)proto.getLanguageCodesList()), proto.getRegistrationDate(), proto.getRegistrationPubKey().toByteArray(), proto.getRegistrationSignature(), ProtoUtil.stringOrNullFromProto((String)proto.getEmailAddress()), ProtoUtil.stringOrNullFromProto((String)proto.getInfo()), CollectionUtils.isEmpty((Map)proto.getExtraDataMap()) ? null : proto.getExtraDataMap());
    }

    @Override
    public String toString() {
        return "RefundAgent{} " + super.toString();
    }

    public Capabilities getRequiredCapabilities() {
        return new Capabilities(new Capability[]{Capability.REFUND_AGENT});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefundAgent)) {
            return false;
        }
        RefundAgent other = (RefundAgent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RefundAgent;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

