/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.refund;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.crypto.KeyRing;
import haveno.core.api.CoreNotificationService;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.messages.DisputeClosedMessage;
import haveno.core.support.dispute.messages.DisputeOpenedMessage;
import haveno.core.support.dispute.refund.RefundDisputeList;
import haveno.core.support.dispute.refund.RefundDisputeListService;
import haveno.core.support.messages.ChatMessage;
import haveno.core.support.messages.SupportMessage;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.xmr.wallet.TradeWalletService;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class RefundManager
extends DisputeManager<RefundDisputeList> {
    private static final Logger log = LoggerFactory.getLogger(RefundManager.class);

    @Inject
    public RefundManager(P2PService p2PService, TradeWalletService tradeWalletService, XmrWalletService walletService, XmrConnectionService xmrConnectionService, CoreNotificationService notificationService, TradeManager tradeManager, ClosedTradableManager closedTradableManager, OpenOfferManager openOfferManager, KeyRing keyRing, RefundDisputeListService refundDisputeListService, Config config, PriceFeedService priceFeedService) {
        super(p2PService, tradeWalletService, walletService, xmrConnectionService, notificationService, tradeManager, closedTradableManager, openOfferManager, keyRing, refundDisputeListService, config, priceFeedService);
    }

    @Override
    public SupportType getSupportType() {
        return SupportType.REFUND;
    }

    @Override
    public void onSupportMessage(SupportMessage message) {
        if (this.canProcessMessage(message)) {
            log.info("Received {} with tradeId {} and uid {}", new Object[]{((Object)((Object)message)).getClass().getSimpleName(), message.getTradeId(), message.getUid()});
            if (message instanceof DisputeOpenedMessage) {
                this.handle((DisputeOpenedMessage)message);
            } else if (message instanceof ChatMessage) {
                this.handle((ChatMessage)message);
            } else if (message instanceof DisputeClosedMessage) {
                this.handle((DisputeClosedMessage)message);
            } else {
                log.warn("Unsupported message at dispatchMessage. message={}", (Object)message);
            }
        }
    }

    @Override
    protected AckMessageSourceType getAckMessageSourceType() {
        return AckMessageSourceType.REFUND_MESSAGE;
    }

    @Override
    public void cleanupDisputes() {
        this.disputeListService.cleanupDisputes(tradeId -> this.tradeManager.closeDisputedTrade((String)tradeId, Trade.DisputeState.REFUND_REQUEST_CLOSED));
    }

    @Override
    protected String getDisputeInfo(Dispute dispute) {
        String role = Res.get("shared.refundAgent").toLowerCase();
        String link = "https://docs.haveno.exchange/trading-rules.html#arbitration";
        return Res.get("support.initialInfo", role, role, link);
    }

    @Override
    protected String getDisputeIntroForPeer(String disputeInfo) {
        return Res.get("support.peerOpenedDispute", disputeInfo, "1.2.2");
    }

    @Override
    protected String getDisputeIntroForDisputeCreator(String disputeInfo) {
        return Res.get("support.youOpenedDispute", disputeInfo, "1.2.2");
    }

    @Override
    protected void addPriceInfoMessage(Dispute dispute, int counter) {
    }

    @Override
    public void handle(DisputeClosedMessage disputeResultMessage) {
        Optional<OpenOffer> openOfferOptional;
        DisputeResult disputeResult = disputeResultMessage.getDisputeResult();
        String tradeId = disputeResult.getTradeId();
        ChatMessage chatMessage = disputeResult.getChatMessage();
        Preconditions.checkNotNull((Object)((Object)chatMessage), (Object)"chatMessage must not be null");
        Optional<Dispute> disputeOptional = this.findDispute(disputeResult);
        String uid = disputeResultMessage.getUid();
        if (!disputeOptional.isPresent()) {
            log.warn("We got a dispute result msg but we don't have a matching dispute. That might happen when we get the disputeResultMessage before the dispute was created. We try again after 2 sec. to apply the disputeResultMessage. TradeId = " + tradeId);
            if (!this.delayMsgMap.containsKey(uid)) {
                Timer timer = UserThread.runAfter(() -> this.handle(disputeResultMessage), (long)2L);
                this.delayMsgMap.put(uid, timer);
            } else {
                log.warn("We got a dispute result msg after we already repeated to apply the message after a delay. That should never happen. TradeId = " + tradeId);
            }
            return;
        }
        Dispute dispute = disputeOptional.get();
        this.cleanupRetryMap(uid);
        if (!dispute.getChatMessages().contains((Object)chatMessage)) {
            dispute.addAndPersistChatMessage(chatMessage);
        } else {
            log.warn("We got a dispute mail msg that we have already stored. TradeId = " + chatMessage.getTradeId());
        }
        dispute.setIsClosed();
        if (dispute.disputeResultProperty().get() != null) {
            log.warn("We got already a dispute result. That should only happen if a dispute needs to be closed again because the first close did not succeed. TradeId = " + tradeId);
        }
        dispute.setDisputeResult(disputeResult);
        Optional<Trade> tradeOptional = this.tradeManager.getOpenTrade(tradeId);
        if (tradeOptional.isPresent()) {
            Trade trade = tradeOptional.get();
            if (trade.getDisputeState() == Trade.DisputeState.REFUND_REQUESTED || trade.getDisputeState() == Trade.DisputeState.REFUND_REQUEST_STARTED_BY_PEER) {
                trade.setDisputeState(Trade.DisputeState.REFUND_REQUEST_CLOSED);
                this.tradeManager.requestPersistence();
            }
        } else {
            openOfferOptional = this.openOfferManager.getOpenOffer(tradeId);
            openOfferOptional.ifPresent(openOffer -> this.openOfferManager.closeSpentOffer(openOffer.getOffer()));
        }
        this.sendAckMessage(chatMessage, dispute.getAgentPubKeyRing(), true, null);
        if (this.tradeManager.getOpenTrade(tradeId).isPresent()) {
            this.tradeManager.closeDisputedTrade(tradeId, Trade.DisputeState.REFUND_REQUEST_CLOSED);
        } else {
            openOfferOptional = this.openOfferManager.getOpenOffer(tradeId);
            openOfferOptional.ifPresent(openOffer -> this.openOfferManager.closeSpentOffer(openOffer.getOffer()));
        }
        this.requestPersistence();
    }

    @Override
    @Nullable
    public NodeAddress getAgentNodeAddress(Dispute dispute) {
        throw new RuntimeException("Refund manager not used in XMR adapation");
    }
}

