/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.messages;

import com.google.common.base.Preconditions;
import haveno.common.app.Version;
import haveno.common.proto.ProtoUtil;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.messages.DisputeMessage;
import java.util.Optional;
import javax.annotation.Nullable;
import protobuf.DisputeClosedMessage;
import protobuf.NetworkEnvelope;
import protobuf.NodeAddress;

public final class DisputeClosedMessage
extends DisputeMessage {
    private final DisputeResult disputeResult;
    private final haveno.network.p2p.NodeAddress senderNodeAddress;
    @Nullable
    private final String updatedMultisigHex;
    @Nullable
    private final String unsignedPayoutTxHex;
    private final boolean deferPublishPayout;

    public DisputeClosedMessage(DisputeResult disputeResult, haveno.network.p2p.NodeAddress senderNodeAddress, String uid, SupportType supportType, @Nullable String updatedMultisigHex, @Nullable String unsignedPayoutTxHex, boolean deferPublishPayout) {
        this(disputeResult, senderNodeAddress, uid, Version.getP2PMessageVersion(), supportType, updatedMultisigHex, unsignedPayoutTxHex, deferPublishPayout);
    }

    private DisputeClosedMessage(DisputeResult disputeResult, haveno.network.p2p.NodeAddress senderNodeAddress, String uid, String messageVersion, SupportType supportType, String updatedMultisigHex, String unsignedPayoutTxHex, boolean deferPublishPayout) {
        super(messageVersion, uid, supportType);
        this.disputeResult = disputeResult;
        this.senderNodeAddress = senderNodeAddress;
        this.updatedMultisigHex = updatedMultisigHex;
        this.unsignedPayoutTxHex = unsignedPayoutTxHex;
        this.deferPublishPayout = deferPublishPayout;
    }

    public NetworkEnvelope toProtoNetworkEnvelope() {
        DisputeClosedMessage.Builder builder = protobuf.DisputeClosedMessage.newBuilder().setDisputeResult(this.disputeResult.toProtoMessage()).setSenderNodeAddress(this.senderNodeAddress.toProtoMessage()).setUid(this.uid).setType(SupportType.toProtoMessage(this.supportType)).setDeferPublishPayout(this.deferPublishPayout);
        Optional.ofNullable(this.unsignedPayoutTxHex).ifPresent(e -> builder.setUnsignedPayoutTxHex(this.unsignedPayoutTxHex));
        Optional.ofNullable(this.updatedMultisigHex).ifPresent(e -> builder.setUpdatedMultisigHex(this.updatedMultisigHex));
        return this.getNetworkEnvelopeBuilder().setDisputeClosedMessage(builder).build();
    }

    public static DisputeClosedMessage fromProto(protobuf.DisputeClosedMessage proto, String messageVersion) {
        Preconditions.checkArgument((boolean)proto.hasDisputeResult(), (Object)"DisputeResult must be set");
        return new DisputeClosedMessage(DisputeResult.fromProto(proto.getDisputeResult()), haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getSenderNodeAddress()), proto.getUid(), messageVersion, SupportType.fromProto(proto.getType()), ProtoUtil.stringOrNullFromProto((String)proto.getUpdatedMultisigHex()), ProtoUtil.stringOrNullFromProto((String)proto.getUnsignedPayoutTxHex()), proto.getDeferPublishPayout());
    }

    @Override
    public String getTradeId() {
        return this.disputeResult.getTradeId();
    }

    @Override
    public String toString() {
        return "DisputeClosedMessage{\n     disputeResult=" + String.valueOf(this.disputeResult) + ",\n     senderNodeAddress=" + String.valueOf(this.senderNodeAddress) + ",\n     DisputeClosedMessage.uid='" + this.uid + "',\n     messageVersion=" + this.messageVersion + ",\n     supportType=" + String.valueOf((Object)this.supportType) + ",\n     deferPublishPayout=" + this.deferPublishPayout + "\n} " + super.toString();
    }

    public DisputeResult getDisputeResult() {
        return this.disputeResult;
    }

    public haveno.network.p2p.NodeAddress getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    @Nullable
    public String getUpdatedMultisigHex() {
        return this.updatedMultisigHex;
    }

    @Nullable
    public String getUnsignedPayoutTxHex() {
        return this.unsignedPayoutTxHex;
    }

    public boolean isDeferPublishPayout() {
        return this.deferPublishPayout;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisputeClosedMessage)) {
            return false;
        }
        DisputeClosedMessage other = (DisputeClosedMessage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDeferPublishPayout() != other.isDeferPublishPayout()) {
            return false;
        }
        DisputeResult this$disputeResult = this.getDisputeResult();
        DisputeResult other$disputeResult = other.getDisputeResult();
        if (this$disputeResult == null ? other$disputeResult != null : !((Object)this$disputeResult).equals(other$disputeResult)) {
            return false;
        }
        haveno.network.p2p.NodeAddress this$senderNodeAddress = this.getSenderNodeAddress();
        haveno.network.p2p.NodeAddress other$senderNodeAddress = other.getSenderNodeAddress();
        if (this$senderNodeAddress == null ? other$senderNodeAddress != null : !this$senderNodeAddress.equals(other$senderNodeAddress)) {
            return false;
        }
        String this$updatedMultisigHex = this.getUpdatedMultisigHex();
        String other$updatedMultisigHex = other.getUpdatedMultisigHex();
        if (this$updatedMultisigHex == null ? other$updatedMultisigHex != null : !this$updatedMultisigHex.equals(other$updatedMultisigHex)) {
            return false;
        }
        String this$unsignedPayoutTxHex = this.getUnsignedPayoutTxHex();
        String other$unsignedPayoutTxHex = other.getUnsignedPayoutTxHex();
        return !(this$unsignedPayoutTxHex == null ? other$unsignedPayoutTxHex != null : !this$unsignedPayoutTxHex.equals(other$unsignedPayoutTxHex));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DisputeClosedMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDeferPublishPayout() ? 79 : 97);
        DisputeResult $disputeResult = this.getDisputeResult();
        result = result * 59 + ($disputeResult == null ? 43 : ((Object)$disputeResult).hashCode());
        haveno.network.p2p.NodeAddress $senderNodeAddress = this.getSenderNodeAddress();
        result = result * 59 + ($senderNodeAddress == null ? 43 : $senderNodeAddress.hashCode());
        String $updatedMultisigHex = this.getUpdatedMultisigHex();
        result = result * 59 + ($updatedMultisigHex == null ? 43 : $updatedMultisigHex.hashCode());
        String $unsignedPayoutTxHex = this.getUnsignedPayoutTxHex();
        result = result * 59 + ($unsignedPayoutTxHex == null ? 43 : $unsignedPayoutTxHex.hashCode());
        return result;
    }
}

