/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.mediation;

import com.google.protobuf.ByteString;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.file.FileUtil;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.util.Utilities;
import haveno.core.support.dispute.mediation.FileTransferSession;
import haveno.network.p2p.FileTransferPart;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferSender
extends FileTransferSession {
    private static final Logger log = LoggerFactory.getLogger(FileTransferSender.class);
    protected final String zipFilePath;
    private final boolean isTest;

    public FileTransferSender(NetworkNode networkNode, NodeAddress peerNodeAddress, String tradeId, int traderId, String traderRole, boolean isTest, @Nullable FileTransferSession.FtpCallback callback) {
        super(networkNode, peerNodeAddress, tradeId, traderId, traderRole, callback);
        this.zipFilePath = String.valueOf(Utilities.getUserDataDir()) + FileSystems.getDefault().getSeparator() + this.zipId + ".zip";
        this.isTest = isTest;
        this.updateProgress();
    }

    public void createZipFileToSend() {
        FileTransferSender.createZipFileOfLogs(this.zipFilePath, this.zipId, this.fullTradeId);
    }

    public static void createZipFileOfLogs(String zipFilePath, String zipId, String fullTradeId) {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            URI uri = URI.create("jar:file:///" + zipFilePath.replace('\\', '/').replaceAll(" ", "%20"));
            FileSystem zipfs = FileSystems.newFileSystem(uri, env);
            Files.createDirectory(zipfs.getPath(zipId, new String[0]), new FileAttribute[0]);
            Stream<Path> paths = Files.walk(Paths.get(Config.appDataDir().toString(), new String[0]), 1, new FileVisitOption[0]);
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(externalTxtFile -> {
                try {
                    if (externalTxtFile.getFileName().toString().equals("haveno.log") || fullTradeId == null && externalTxtFile.getFileName().toString().matches(".*.log") || externalTxtFile.getFileName().toString().matches(".*.log") && FileUtil.doesFileContainKeyword((File)externalTxtFile.toFile(), (String)fullTradeId)) {
                        Path pathInZipfile = zipfs.getPath(zipId + "/" + externalTxtFile.getFileName().toString(), new String[0]);
                        log.info("adding {} to zip file {}", (Object)pathInZipfile, (Object)zipfs);
                        Files.copy(externalTxtFile, pathInZipfile, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    log.error(e.toString());
                    e.printStackTrace();
                }
            });
            zipfs.close();
        }
        catch (IOException | IllegalArgumentException ex) {
            log.error(ex.toString());
            ex.printStackTrace();
        }
    }

    public void initSend() throws IOException {
        this.initSessionTimer();
        this.networkNode.addMessageListener((MessageListener)this);
        RandomAccessFile file = new RandomAccessFile(this.zipFilePath, "r");
        this.expectedFileLength = file.length();
        file.close();
        this.dataAwaitingAck = Optional.of(new FileTransferPart(this.networkNode.getNodeAddress(), this.fullTradeId, this.traderId, UUID.randomUUID().toString(), this.expectedFileLength, ByteString.EMPTY));
        this.uploadData();
    }

    public void sendNextBlock() throws IOException, IllegalStateException {
        if (this.dataAwaitingAck.isPresent()) {
            log.warn("prepNextBlockToSend invoked, but we are still waiting for a previous ACK");
            throw new IllegalStateException("prepNextBlockToSend invoked, but we are still waiting for a previous ACK");
        }
        RandomAccessFile file = new RandomAccessFile(this.zipFilePath, "r");
        file.seek(this.fileOffsetBytes);
        byte[] buff = new byte[FILE_BLOCK_SIZE];
        int nBytesRead = file.read(buff, 0, FILE_BLOCK_SIZE);
        file.close();
        if (nBytesRead < 0) {
            log.info("Success!  We have reached the EOF, {} bytes sent.  Removing zip file {}", (Object)this.fileOffsetBytes, (Object)this.zipFilePath);
            Files.delete(Paths.get(this.zipFilePath, new String[0]));
            this.ftpCallback.ifPresent(c -> c.onFtpComplete(this));
            UserThread.runAfter(this::resetSession, (long)1L);
            return;
        }
        this.dataAwaitingAck = Optional.of(new FileTransferPart(this.networkNode.getNodeAddress(), this.fullTradeId, this.traderId, UUID.randomUUID().toString(), this.currentBlockSeqNum, ByteString.copyFrom((byte[])buff, (int)0, (int)nBytesRead)));
        this.uploadData();
    }

    public void retrySend() {
        if (this.transferIsInProgress()) {
            log.info("Retry send of current block");
            this.initSessionTimer();
            this.uploadData();
        } else {
            UserThread.runAfter(() -> this.ftpCallback.ifPresent(f -> f.onFtpTimeout("Could not re-send", this)), (long)1L);
        }
    }

    protected void uploadData() {
        if (this.dataAwaitingAck.isEmpty()) {
            return;
        }
        FileTransferPart ftp = (FileTransferPart)this.dataAwaitingAck.get();
        log.info("Send FileTransferPart seq {} length {} to peer {}, UID={}", new Object[]{ftp.seqNumOrFileLength, ftp.messageData.size(), this.peerNodeAddress, ftp.uid});
        this.sendMessage((NetworkEnvelope)ftp, this.networkNode, this.peerNodeAddress);
    }

    public boolean processAckForFilePart(String ackUid) {
        if (this.dataAwaitingAck.isEmpty()) {
            log.warn("We received an ACK we were not expecting. {}", (Object)ackUid);
            return false;
        }
        if (!((FileTransferPart)this.dataAwaitingAck.get()).uid.equals(ackUid)) {
            log.warn("We received an ACK that has a different UID to what we were expecting.  We ignore and wait for the correct ACK");
            log.info("Received {} expecting {}", (Object)ackUid, (Object)((FileTransferPart)this.dataAwaitingAck.get()).uid);
            return false;
        }
        this.fileOffsetBytes += (long)((FileTransferPart)this.dataAwaitingAck.get()).messageData.size();
        ++this.currentBlockSeqNum;
        this.dataAwaitingAck = Optional.empty();
        this.checkpointLastActivity();
        this.updateProgress();
        if (this.isTest) {
            return true;
        }
        UserThread.runAfter(() -> {
            try {
                this.sendNextBlock();
            }
            catch (IOException e) {
                log.error(e.toString());
                e.printStackTrace();
            }
        }, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        return true;
    }

    public void updateProgress() {
        double progressPct = this.expectedFileLength > 0L ? (double)this.fileOffsetBytes / (double)this.expectedFileLength : 0.0;
        this.ftpCallback.ifPresent(c -> c.onFtpProgress(progressPct));
        log.info("ftp progress: {}", (Object)String.format("%.0f%%", progressPct * 100.0));
    }
}

