/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.mediation;

import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.util.Utilities;
import haveno.core.support.dispute.mediation.FileTransferSession;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.FileTransferPart;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.FileSystems;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferReceiver
extends FileTransferSession {
    private static final Logger log = LoggerFactory.getLogger(FileTransferReceiver.class);
    protected final String zipFilePath;

    public FileTransferReceiver(NetworkNode networkNode, NodeAddress peerNodeAddress, String tradeId, int traderId, String traderRole, @Nullable FileTransferSession.FtpCallback callback) throws IOException {
        super(networkNode, peerNodeAddress, tradeId, traderId, traderRole, callback);
        this.zipFilePath = FileTransferReceiver.ensureReceivingDirectoryExists().getAbsolutePath() + FileSystems.getDefault().getSeparator() + this.zipId + ".zip";
    }

    public void processFilePartReceived(FileTransferPart ftp) {
        this.checkpointLastActivity();
        if (this.currentBlockSeqNum < 0L) {
            this.initReceiveSession(ftp.uid, ftp.seqNumOrFileLength);
        } else if (this.currentBlockSeqNum == ftp.seqNumOrFileLength) {
            this.processReceivedBlock(ftp, this.networkNode, this.peerNodeAddress);
        } else {
            log.error("ftp sequence num mismatch, expected {} received {}", (Object)this.currentBlockSeqNum, (Object)ftp.seqNumOrFileLength);
            this.resetSession();
        }
    }

    public void initReceiveSession(String uid, long expectedFileBytes) {
        this.networkNode.addMessageListener((MessageListener)this);
        this.expectedFileLength = expectedFileBytes;
        this.fileOffsetBytes = 0L;
        this.currentBlockSeqNum = 0L;
        this.initSessionTimer();
        log.info("Received a start file transfer request, tradeId={}, traderId={}, size={}", new Object[]{this.fullTradeId, this.traderId, expectedFileBytes});
        log.info("New file will be written to {}", (Object)this.zipFilePath);
        UserThread.execute(() -> this.ackReceivedPart(uid, this.networkNode, this.peerNodeAddress));
    }

    private void processReceivedBlock(FileTransferPart ftp, NetworkNode networkNode, NodeAddress peerNodeAddress) {
        try {
            RandomAccessFile file = new RandomAccessFile(this.zipFilePath, "rwd");
            file.seek(this.fileOffsetBytes);
            file.write(ftp.messageData.toByteArray(), 0, ftp.messageData.size());
            this.fileOffsetBytes += (long)ftp.messageData.size();
            log.info("Sequence number {} for {}, received data {} / {}", new Object[]{ftp.seqNumOrFileLength, Utilities.getShortId((String)ftp.tradeId), this.fileOffsetBytes, this.expectedFileLength});
            ++this.currentBlockSeqNum;
            UserThread.runAfter(() -> {
                this.ackReceivedPart(ftp.uid, networkNode, peerNodeAddress);
                if (this.fileOffsetBytes >= this.expectedFileLength) {
                    log.info("Success!  We have reached the EOF, received {} expected {}", (Object)this.fileOffsetBytes, (Object)this.expectedFileLength);
                    this.ftpCallback.ifPresent(c -> c.onFtpComplete(this));
                    this.resetSession();
                }
            }, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            log.error(e.toString());
            e.printStackTrace();
        }
    }

    private void ackReceivedPart(String uid, NetworkNode networkNode, NodeAddress peerNodeAddress) {
        AckMessage ackMessage = new AckMessage(peerNodeAddress, AckMessageSourceType.LOG_TRANSFER, FileTransferPart.class.getSimpleName(), uid, Utilities.getShortId((String)this.fullTradeId), true, null);
        log.info("Send AckMessage for {} to peer {}. id={}, uid={}", new Object[]{ackMessage.getSourceMsgClassName(), peerNodeAddress, ackMessage.getSourceId(), ackMessage.getSourceUid()});
        this.sendMessage((NetworkEnvelope)ackMessage, networkNode, peerNodeAddress);
    }

    private static File ensureReceivingDirectoryExists() throws IOException {
        File directory = new File(String.valueOf(Config.appDataDir()) + "/clientLogs");
        if (!directory.exists() && !directory.mkdirs()) {
            log.error("Could not create directory {}", (Object)directory.getAbsolutePath());
            throw new IOException("Could not create directory: " + directory.getAbsolutePath());
        }
        return directory;
    }
}

