/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.arbitration.arbitrator;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.filter.FilterManager;
import haveno.core.support.dispute.agent.DisputeAgentService;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
public class ArbitratorService
extends DisputeAgentService<Arbitrator> {
    @Inject
    public ArbitratorService(P2PService p2PService, FilterManager filterManager) {
        super(p2PService, filterManager);
    }

    @Override
    protected Set<Arbitrator> getDisputeAgentSet(List<String> bannedDisputeAgents) {
        return this.p2PService.getDataMap().values().stream().filter(data -> data.getProtectedStoragePayload() instanceof Arbitrator).map(data -> (Arbitrator)data.getProtectedStoragePayload()).filter(a -> bannedDisputeAgents == null || !bannedDisputeAgents.contains(a.getNodeAddress().getFullAddress())).collect(Collectors.toSet());
    }

    @Override
    protected List<String> getDisputeAgentsFromFilter() {
        return this.filterManager.getFilter() != null ? this.filterManager.getFilter().getArbitrators() : new ArrayList();
    }

    public Map<NodeAddress, Arbitrator> getArbitrators() {
        return super.getDisputeAgents();
    }
}

