/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.arbitration.arbitrator;

import com.google.protobuf.ByteString;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.CollectionUtils;
import haveno.core.support.dispute.agent.DisputeAgent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Arbitrator;
import protobuf.NodeAddress;
import protobuf.PubKeyRing;
import protobuf.StoragePayload;

public final class Arbitrator
extends DisputeAgent {
    private static final Logger log = LoggerFactory.getLogger(Arbitrator.class);

    public Arbitrator(haveno.network.p2p.NodeAddress nodeAddress, haveno.common.crypto.PubKeyRing pubKeyRing, List<String> languageCodes, long registrationDate, byte[] registrationPubKey, String registrationSignature, @Nullable String emailAddress, @Nullable String info, @Nullable Map<String, String> extraDataMap) {
        super(nodeAddress, pubKeyRing, languageCodes, registrationDate, registrationPubKey, registrationSignature, emailAddress, info, extraDataMap);
    }

    public StoragePayload toProtoMessage() {
        Arbitrator.Builder builder = protobuf.Arbitrator.newBuilder().setNodeAddress(this.nodeAddress.toProtoMessage()).setPubKeyRing(this.pubKeyRing.toProtoMessage()).addAllLanguageCodes((Iterable)this.languageCodes).setRegistrationDate(this.registrationDate).setRegistrationPubKey(ByteString.copyFrom((byte[])this.registrationPubKey)).setRegistrationSignature(this.registrationSignature);
        Optional.ofNullable(this.emailAddress).ifPresent(arg_0 -> ((Arbitrator.Builder)builder).setEmailAddress(arg_0));
        Optional.ofNullable(this.info).ifPresent(arg_0 -> ((Arbitrator.Builder)builder).setInfo(arg_0));
        Optional.ofNullable(this.extraDataMap).ifPresent(arg_0 -> ((Arbitrator.Builder)builder).putAllExtraData(arg_0));
        return StoragePayload.newBuilder().setArbitrator(builder).build();
    }

    public static Arbitrator fromProto(protobuf.Arbitrator proto) {
        return new Arbitrator(haveno.network.p2p.NodeAddress.fromProto((NodeAddress)proto.getNodeAddress()), haveno.common.crypto.PubKeyRing.fromProto((PubKeyRing)proto.getPubKeyRing()), new ArrayList<String>((Collection<String>)proto.getLanguageCodesList()), proto.getRegistrationDate(), proto.getRegistrationPubKey().toByteArray(), proto.getRegistrationSignature(), ProtoUtil.stringOrNullFromProto((String)proto.getEmailAddress()), ProtoUtil.stringOrNullFromProto((String)proto.getInfo()), CollectionUtils.isEmpty((Map)proto.getExtraDataMap()) ? null : proto.getExtraDataMap());
    }

    @Override
    public String toString() {
        return "Arbitrator{} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Arbitrator)) {
            return false;
        }
        Arbitrator other = (Arbitrator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Arbitrator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

