/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.arbitration;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.ThreadUtils;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.crypto.KeyRing;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.core.api.CoreNotificationService;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOfferManager;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.DisputeSummaryVerification;
import haveno.core.support.dispute.arbitration.ArbitrationDisputeList;
import haveno.core.support.dispute.arbitration.ArbitrationDisputeListService;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.FileTransferReceiver;
import haveno.core.support.dispute.mediation.FileTransferSender;
import haveno.core.support.dispute.mediation.FileTransferSession;
import haveno.core.support.dispute.messages.DisputeClosedMessage;
import haveno.core.support.dispute.messages.DisputeOpenedMessage;
import haveno.core.support.messages.ChatMessage;
import haveno.core.support.messages.SupportMessage;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.xmr.wallet.TradeWalletService;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.FileTransferPart;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.MessageListener;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.collections.ObservableList;
import monero.common.MoneroRpcConnection;
import monero.daemon.model.MoneroTx;
import monero.wallet.MoneroWallet;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroMultisigSignResult;
import monero.wallet.model.MoneroTxSet;
import monero.wallet.model.MoneroTxWallet;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class ArbitrationManager
extends DisputeManager<ArbitrationDisputeList>
implements MessageListener,
FileTransferSession.FtpCallback {
    private static final Logger log = LoggerFactory.getLogger(ArbitrationManager.class);
    private final ArbitratorManager arbitratorManager;
    private Map<String, Integer> reprocessDisputeClosedMessageCounts = new HashMap<String, Integer>();

    @Inject
    public ArbitrationManager(P2PService p2PService, TradeWalletService tradeWalletService, XmrWalletService walletService, XmrConnectionService xmrConnectionService, CoreNotificationService notificationService, ArbitratorManager arbitratorManager, TradeManager tradeManager, ClosedTradableManager closedTradableManager, OpenOfferManager openOfferManager, KeyRing keyRing, ArbitrationDisputeListService arbitrationDisputeListService, Config config, PriceFeedService priceFeedService) {
        super(p2PService, tradeWalletService, walletService, xmrConnectionService, notificationService, tradeManager, closedTradableManager, openOfferManager, keyRing, arbitrationDisputeListService, config, priceFeedService);
        this.arbitratorManager = arbitratorManager;
        HavenoUtils.arbitrationManager = this;
        p2PService.getNetworkNode().addMessageListener((MessageListener)this);
    }

    @Override
    public SupportType getSupportType() {
        return SupportType.ARBITRATION;
    }

    @Override
    public void onSupportMessage(SupportMessage message) {
        if (this.canProcessMessage(message)) {
            log.info("Received {} from {} with tradeId {} and uid {}", new Object[]{((Object)((Object)message)).getClass().getSimpleName(), message.getSenderNodeAddress(), message.getTradeId(), message.getUid()});
            if (message instanceof DisputeOpenedMessage) {
                this.handle((DisputeOpenedMessage)message);
            } else if (message instanceof ChatMessage) {
                this.handle((ChatMessage)message);
            } else if (message instanceof DisputeClosedMessage) {
                this.handle((DisputeClosedMessage)message);
            } else {
                log.warn("Unsupported message at dispatchMessage. message={}", (Object)message);
            }
        }
    }

    @Override
    public NodeAddress getAgentNodeAddress(Dispute dispute) {
        return dispute.getContract().getArbitratorNodeAddress();
    }

    @Override
    protected AckMessageSourceType getAckMessageSourceType() {
        return AckMessageSourceType.ARBITRATION_MESSAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupDisputes() {
        List disputes;
        List list = disputes = ((ArbitrationDisputeList)((Object)this.getDisputeList())).getList();
        synchronized (list) {
            Trade trade;
            HashSet<Dispute> toRemoves = new HashSet<Dispute>();
            for (Dispute dispute : disputes) {
                trade = this.tradeManager.getTrade(dispute.getTradeId());
                if (trade == null) {
                    log.warn("Dispute trade {} does not exist", (Object)dispute.getTradeId());
                    return;
                }
                if (dispute.getTraderPubKeyRing().equals((Object)trade.getArbitrator().getPubKeyRing())) {
                    log.warn("Removing invalid dispute opened by arbitrator, disputeId={}", (Object)trade.getId(), (Object)dispute.getId());
                    toRemoves.add(dispute);
                }
                if (trade.getDisputeState() == Trade.DisputeState.DISPUTE_PREPARING) {
                    log.warn("Removing dispute for {} {} with disputeState={}, disputeId={}", new Object[]{trade.getClass().getSimpleName(), trade.getId(), trade.getDisputeState(), dispute.getId()});
                    toRemoves.add(dispute);
                }
                if (trade.getDisputeState() != Trade.DisputeState.DISPUTE_REQUESTED) continue;
                boolean storedInMailbox = false;
                for (ChatMessage msg : dispute.getChatMessages()) {
                    if (!Boolean.TRUE.equals(msg.getStoredInMailboxProperty().get())) continue;
                    storedInMailbox = true;
                    log.info("Keeping dispute for {} {} with disputeState={}, disputeId={}. Stored in mailbox", new Object[]{trade.getClass().getSimpleName(), trade.getId(), trade.getDisputeState(), dispute.getId()});
                    break;
                }
                if (storedInMailbox) continue;
                log.warn("Removing dispute for {} {} with disputeState={}, disputeId={}. Not stored in mailbox", new Object[]{trade.getClass().getSimpleName(), trade.getId(), trade.getDisputeState(), dispute.getId()});
                toRemoves.add(dispute);
            }
            for (Dispute dispute : toRemoves) {
                ((ArbitrationDisputeList)((Object)this.getDisputeList())).remove(dispute);
                trade = this.tradeManager.getTrade(dispute.getTradeId());
                if (trade == null) {
                    log.warn("Dispute trade {} does not exist", (Object)dispute.getTradeId());
                    continue;
                }
                trade.setDisputeState(Trade.DisputeState.NO_DISPUTE);
            }
            for (Dispute dispute : disputes) {
                if (dispute.isClosed()) continue;
                trade = this.tradeManager.getTrade(dispute.getTradeId());
                if (trade == null) {
                    log.warn("Dispute trade {} does not exist", (Object)dispute.getTradeId());
                    continue;
                }
                if (!trade.isPayoutPublished()) continue;
                Optional<Dispute> peersDisputeOptional = null;
                if (trade.isArbitrator()) {
                    peersDisputeOptional = this.getDisputesAsObservableList().stream().filter(d -> dispute.getTradeId().equals(d.getTradeId()) && dispute.getTraderId() != d.getTraderId()).findFirst();
                    if (peersDisputeOptional.isPresent()) {
                        if (peersDisputeOptional.get().isClosed()) {
                            continue;
                        }
                    } else {
                        log.warn("No peer dispute found for disputeId={}, tradeId={}", (Object)dispute.getId(), (Object)dispute.getTradeId());
                        continue;
                    }
                }
                log.warn("Auto-closing dispute for {} {} with published payout, disputeId={}", new Object[]{trade.getClass().getSimpleName(), trade.getId(), dispute.getId()});
                dispute.setIsClosed();
                if (peersDisputeOptional != null && peersDisputeOptional.isPresent()) {
                    peersDisputeOptional.get().setIsClosed();
                }
                trade.setDisputeState(Trade.DisputeState.DISPUTE_CLOSED);
            }
        }
    }

    @Override
    protected String getDisputeInfo(Dispute dispute) {
        String role = Res.get("shared.arbitrator").toLowerCase();
        String link = "https://docs.haveno.exchange/trading-rules.html#legacy-arbitration";
        return Res.get("support.initialInfo", role, role, link);
    }

    @Override
    protected String getDisputeIntroForPeer(String disputeInfo) {
        return Res.get("support.peerOpenedDispute", disputeInfo, "1.2.2");
    }

    @Override
    protected String getDisputeIntroForDisputeCreator(String disputeInfo) {
        return Res.get("support.youOpenedDispute", disputeInfo, "1.2.2");
    }

    @Override
    protected void addPriceInfoMessage(Dispute dispute, int counter) {
    }

    @Override
    public void handle(DisputeClosedMessage disputeClosedMessage) {
        this.handle(disputeClosedMessage, true);
    }

    private void handle(DisputeClosedMessage disputeClosedMessage, boolean reprocessOnError) {
        Trade trade = this.tradeManager.getTrade(disputeClosedMessage.getTradeId());
        if (trade == null) {
            log.warn("Dispute trade {} does not exist", (Object)disputeClosedMessage.getTradeId());
            return;
        }
        trade.getArbitrator().setDisputeClosedMessage(disputeClosedMessage);
        this.persistNow(null);
        ThreadUtils.execute(() -> {
            ChatMessage chatMessage = null;
            Dispute dispute = null;
            Object object = trade.getLock();
            synchronized (object) {
                block38: {
                    try {
                        DisputeResult disputeResult = disputeClosedMessage.getDisputeResult();
                        chatMessage = disputeResult.getChatMessage();
                        Preconditions.checkNotNull((Object)((Object)chatMessage), (Object)"chatMessage must not be null");
                        String tradeId = disputeResult.getTradeId();
                        log.info("Processing {} for {} {}", new Object[]{((Object)((Object)disputeClosedMessage)).getClass().getSimpleName(), trade.getClass().getSimpleName(), disputeResult.getTradeId()});
                        Optional<Dispute> disputeOptional = this.findDispute(disputeResult);
                        String uid = disputeClosedMessage.getUid();
                        if (!disputeOptional.isPresent()) {
                            log.warn("We got a dispute closed msg but we don't have a matching dispute. That might happen when we get the DisputeClosedMessage before the dispute was created. We try again after 2 sec. to apply the DisputeClosedMessage. TradeId = " + tradeId);
                            if (!this.delayMsgMap.containsKey(uid)) {
                                Timer timer = UserThread.runAfter(() -> this.handle(disputeClosedMessage), (long)2L);
                                this.delayMsgMap.put(uid, timer);
                            } else {
                                log.warn("We got a dispute closed msg after we already repeated to apply the message after a delay. That should never happen. TradeId = " + tradeId);
                            }
                            return;
                        }
                        dispute = disputeOptional.get();
                        String summaryText = chatMessage.getMessage();
                        if (summaryText == null || summaryText.isEmpty()) {
                            throw new IllegalArgumentException("Summary text for dispute is missing, tradeId=" + tradeId + (String)(dispute == null ? "" : ", disputeId=" + dispute.getId()));
                        }
                        if (dispute != null) {
                            DisputeSummaryVerification.verifySignature(summaryText, dispute.getAgentPubKeyRing());
                        } else {
                            DisputeSummaryVerification.verifySignature(summaryText, this.arbitratorManager);
                        }
                        if (this.keyRing.getPubKeyRing().equals((Object)dispute.getAgentPubKeyRing())) {
                            log.error("Arbitrator received disputeResultMessage. That should never happen.");
                            trade.getArbitrator().setDisputeClosedMessage(null);
                            return;
                        }
                        this.cleanupRetryMap(uid);
                        ObservableList<ChatMessage> observableList = dispute.getChatMessages();
                        synchronized (observableList) {
                            if (!dispute.getChatMessages().contains((Object)chatMessage)) {
                                dispute.addAndPersistChatMessage(chatMessage);
                            } else {
                                log.warn("We got a dispute mail msg that we have already stored. TradeId = " + chatMessage.getTradeId());
                            }
                        }
                        dispute.setIsClosed();
                        if (dispute.disputeResultProperty().get() != null) {
                            log.info("We already got a dispute result, indicating the message was resent after updating multisig info. TradeId = " + tradeId);
                        }
                        dispute.setDisputeResult(disputeResult);
                        if (disputeClosedMessage.getUpdatedMultisigHex() != null) {
                            trade.getArbitrator().setUpdatedMultisigHex(disputeClosedMessage.getUpdatedMultisigHex());
                        }
                        if (trade.walletExists()) {
                            trade.importMultisigHex();
                        }
                        if (!trade.isPayoutPublished()) {
                            trade.syncAndPollWallet();
                        }
                        if (!trade.isPayoutPublished() && disputeClosedMessage.getUnsignedPayoutTxHex() != null) {
                            if (disputeClosedMessage.isDeferPublishPayout()) {
                                log.info("Deferring signing and publishing dispute payout tx for {} {}", (Object)trade.getClass().getSimpleName(), (Object)trade.getId());
                                for (int i = 0; i < 5 && !trade.isPayoutPublished(); ++i) {
                                    HavenoUtils.waitFor(5000L);
                                }
                                if (!trade.isPayoutPublished()) {
                                    trade.syncAndPollWallet();
                                }
                            }
                            if (trade.isPayoutPublished()) {
                                log.info("Dispute payout tx already published for {} {}", (Object)trade.getClass().getSimpleName(), (Object)trade.getId());
                            } else {
                                try {
                                    log.info("Signing and publishing dispute payout tx for {} {}", (Object)trade.getClass().getSimpleName(), (Object)trade.getId());
                                    this.processDisputePayoutTx(trade);
                                }
                                catch (Exception e) {
                                    trade.syncAndPollWallet();
                                    if (trade.isPayoutPublished()) {
                                        log.warn("Payout tx already published for {} {}, skipping dispute processing", (Object)trade.getClass().getSimpleName(), (Object)trade.getId());
                                    }
                                    if (e instanceof IllegalArgumentException || e instanceof IllegalStateException) {
                                        throw e;
                                    }
                                    throw new RuntimeException("Failed to sign and publish dispute payout tx from arbitrator for " + trade.getClass().getSimpleName() + " " + tradeId + ": " + e.getMessage(), e);
                                }
                            }
                        } else if (trade.isPayoutPublished()) {
                            log.info("Dispute payout tx already published for {} {}", (Object)trade.getClass().getSimpleName(), (Object)trade.getId());
                        } else if (disputeClosedMessage.getUnsignedPayoutTxHex() == null) {
                            log.info("{} did not receive unsigned dispute payout tx for trade {} because the arbitrator did not have their updated multisig info (can happen if trader went offline after trade started)", (Object)trade.getClass().getSimpleName(), (Object)trade.getId());
                        }
                        if (trade.isPayoutPublished()) {
                            this.tradeManager.closeDisputedTrade(trade.getId(), Trade.DisputeState.DISPUTE_CLOSED);
                        }
                        this.sendAckMessage(chatMessage, dispute.getAgentPubKeyRing(), true, null);
                        this.requestPersistence(trade);
                    }
                    catch (Exception e) {
                        log.warn("Error processing dispute closed message: {}", (Object)e.getMessage());
                        log.warn(ExceptionUtils.getStackTrace((Throwable)e));
                        this.requestPersistence(trade);
                        if (HavenoUtils.isIllegal(e)) {
                            trade.setPayoutTxHex(null);
                            trade.getArbitrator().setDisputeClosedMessage(null);
                            trade.setDisputeState(Trade.DisputeState.DISPUTE_CLOSED);
                            String warningMsg = "Error processing dispute closed message: " + e.getMessage() + "\n\nOpen another dispute to try again (ctrl+o).";
                            trade.prependErrorMessage(warningMsg);
                            this.sendAckMessage(chatMessage, dispute.getAgentPubKeyRing(), false, e.getMessage());
                            HavenoUtils.havenoSetup.getTopErrorMsg().set((Object)warningMsg);
                            this.requestPersistence(trade);
                            throw e;
                        }
                        if (trade.getArbitrator().getDisputeClosedMessage() == null || !reprocessOnError) break block38;
                        if (!this.reprocessDisputeClosedMessageCounts.containsKey(trade.getId())) {
                            this.reprocessDisputeClosedMessageCounts.put(trade.getId(), 0);
                        }
                        UserThread.runAfter(() -> {
                            this.reprocessDisputeClosedMessageCounts.put(trade.getId(), this.reprocessDisputeClosedMessageCounts.get(trade.getId()) + 1);
                            this.maybeReprocessDisputeClosedMessage(trade, reprocessOnError);
                        }, (long)trade.getReprocessDelayInSeconds(this.reprocessDisputeClosedMessageCounts.get(trade.getId())));
                    }
                }
            }
        }, (String)trade.getId());
    }

    public void maybeReprocessDisputeClosedMessage(Trade trade, boolean reprocessOnError) {
        if (trade.isShutDownStarted()) {
            return;
        }
        ThreadUtils.execute(() -> {
            Object object = trade.getLock();
            synchronized (object) {
                if (trade.isArbitrator() || trade.getArbitrator().getDisputeClosedMessage() == null || trade.getArbitrator().getDisputeClosedMessage().getUnsignedPayoutTxHex() == null || trade.getDisputeState().ordinal() >= Trade.DisputeState.DISPUTE_CLOSED.ordinal()) {
                    return;
                }
                log.warn("Reprocessing dispute closed message for {} {}", (Object)trade.getClass().getSimpleName(), (Object)trade.getId());
                this.handle(trade.getArbitrator().getDisputeClosedMessage(), reprocessOnError);
            }
        }, (String)trade.getId());
    }

    private MoneroTxSet processDisputePayoutTx(Trade trade) {
        MoneroDestination sellerPayoutDestination;
        MoneroDestination buyerPayoutDestination;
        int numDestinations;
        trade.recoverIfMissingWalletData();
        MoneroWallet multisigWallet = trade.getWallet();
        Optional<Dispute> disputeOptional = this.findDispute(trade.getId());
        if (!disputeOptional.isPresent()) {
            throw new IllegalArgumentException("Trader has no dispute when signing dispute payout tx. This should never happen. TradeId = " + trade.getId());
        }
        Dispute dispute = disputeOptional.get();
        Contract contract = dispute.getContract();
        DisputeResult disputeResult = (DisputeResult)dispute.getDisputeResultProperty().get();
        String unsignedPayoutTxHex = trade.getArbitrator().getDisputeClosedMessage().getUnsignedPayoutTxHex();
        MoneroTxSet disputeTxSet = multisigWallet.describeTxSet(new MoneroTxSet().setMultisigTxHex(unsignedPayoutTxHex));
        if (disputeTxSet.getTxs() == null || disputeTxSet.getTxs().size() != 1) {
            throw new IllegalArgumentException("Bad arbitrator-signed payout tx");
        }
        MoneroTxWallet arbitratorSignedPayoutTx = (MoneroTxWallet)disputeTxSet.getTxs().get(0);
        int n = numDestinations = arbitratorSignedPayoutTx.getOutgoingTransfer() == null || arbitratorSignedPayoutTx.getOutgoingTransfer().getDestinations() == null ? 0 : arbitratorSignedPayoutTx.getOutgoingTransfer().getDestinations().size();
        if (numDestinations != 1 && numDestinations != 2) {
            throw new IllegalArgumentException("Buyer-signed payout tx does not have 1 or 2 destinations");
        }
        List destinations = arbitratorSignedPayoutTx.getOutgoingTransfer().getDestinations();
        boolean buyerFirst = ((MoneroDestination)destinations.get(0)).getAddress().equals(contract.getBuyerPayoutAddressString());
        Object object = buyerFirst ? (MoneroDestination)destinations.get(0) : (buyerPayoutDestination = numDestinations == 2 ? (MoneroDestination)destinations.get(1) : null);
        MoneroDestination moneroDestination = buyerFirst ? (numDestinations == 2 ? (MoneroDestination)destinations.get(1) : null) : (sellerPayoutDestination = (MoneroDestination)destinations.get(0));
        if (buyerPayoutDestination != null && !buyerPayoutDestination.getAddress().equals(contract.getBuyerPayoutAddressString())) {
            throw new IllegalArgumentException("Buyer payout address does not match contract");
        }
        if (sellerPayoutDestination != null && !sellerPayoutDestination.getAddress().equals(contract.getSellerPayoutAddressString())) {
            throw new IllegalArgumentException("Seller payout address does not match contract");
        }
        if (!arbitratorSignedPayoutTx.getChangeAmount().equals(BigInteger.ZERO) && !arbitratorSignedPayoutTx.getChangeAddress().equals(multisigWallet.getPrimaryAddress())) {
            throw new IllegalArgumentException("Change address is not multisig wallet's primary address");
        }
        BigInteger destinationSum = (buyerPayoutDestination == null ? BigInteger.ZERO : buyerPayoutDestination.getAmount()).add(sellerPayoutDestination == null ? BigInteger.ZERO : sellerPayoutDestination.getAmount());
        if (!arbitratorSignedPayoutTx.getOutputSum().equals(destinationSum.add(arbitratorSignedPayoutTx.getChangeAmount()))) {
            throw new IllegalArgumentException("Sum of outputs != destination amounts + change amount");
        }
        BigInteger actualBuyerAmount = buyerPayoutDestination == null ? BigInteger.ZERO : buyerPayoutDestination.getAmount();
        BigInteger actualSellerAmount = sellerPayoutDestination == null ? BigInteger.ZERO : sellerPayoutDestination.getAmount();
        BigInteger txCost = arbitratorSignedPayoutTx.getFee().add(arbitratorSignedPayoutTx.getChangeAmount());
        if (!arbitratorSignedPayoutTx.getChangeAmount().equals(BigInteger.ZERO)) {
            log.warn("Dust left in multisig wallet for {} {}: {}", new Object[]{this.getClass().getSimpleName(), trade.getId(), arbitratorSignedPayoutTx.getChangeAmount()});
        }
        if (trade.getWallet().getUnlockedBalance().subtract(actualBuyerAmount.add(actualSellerAmount).add(txCost)).compareTo(BigInteger.ZERO) > 0) {
            throw new IllegalArgumentException("The dispute payout amounts do not sum to the wallet's unlocked balance while verifying the dispute payout tx, unlocked balance=" + String.valueOf(trade.getWallet().getUnlockedBalance()) + " vs sum payout amount=" + String.valueOf(actualBuyerAmount.add(actualSellerAmount)) + ", buyer payout=" + String.valueOf(actualBuyerAmount) + ", seller payout=" + String.valueOf(actualSellerAmount));
        }
        BigInteger[] buyerSellerPayoutTxCost = ArbitrationManager.getBuyerSellerPayoutTxCost(disputeResult, txCost);
        BigInteger expectedBuyerAmount = disputeResult.getBuyerPayoutAmountBeforeCost().subtract(buyerSellerPayoutTxCost[0]);
        BigInteger expectedSellerAmount = disputeResult.getSellerPayoutAmountBeforeCost().subtract(buyerSellerPayoutTxCost[1]);
        if (!expectedBuyerAmount.equals(actualBuyerAmount)) {
            throw new IllegalArgumentException("Unexpected buyer payout: " + String.valueOf(expectedBuyerAmount) + " vs " + String.valueOf(actualBuyerAmount));
        }
        if (!expectedSellerAmount.equals(actualSellerAmount)) {
            throw new IllegalArgumentException("Unexpected seller payout: " + String.valueOf(expectedSellerAmount) + " vs " + String.valueOf(actualSellerAmount));
        }
        trade.verifyDaemonConnection();
        if (trade.getPayoutTxHex() == null) {
            try {
                log.info("Signing dispute payout tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)trade.getShortId());
                MoneroMultisigSignResult result = multisigWallet.signMultisigTxHex(unsignedPayoutTxHex);
                if (result.getSignedMultisigTxHex() == null) {
                    throw new RuntimeException("Error signing arbitrator-signed payout tx");
                }
                String signedMultisigTxHex = result.getSignedMultisigTxHex();
                disputeTxSet.setMultisigTxHex(signedMultisigTxHex);
                trade.setPayoutTxHex(signedMultisigTxHex);
                this.requestPersistence(trade);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage());
            }
            MoneroTxWallet feeEstimateTx = null;
            try {
                log.info("Creating dispute fee estimate tx for {} {}", (Object)this.getClass().getSimpleName(), (Object)trade.getShortId());
                feeEstimateTx = this.createDisputePayoutTx(trade, dispute.getContract(), disputeResult, false);
            }
            catch (Exception e) {
                if (trade.isPayoutPublished()) {
                    log.warn("Payout tx already published for {} {}, skipping fee verification", (Object)this.getClass().getSimpleName(), (Object)trade.getShortId());
                }
                throw new RuntimeException("Could not recreate dispute payout tx to verify fee: " + e.getMessage(), e);
            }
            if (feeEstimateTx != null) {
                HavenoUtils.verifyMinerFee(feeEstimateTx.getFee(), arbitratorSignedPayoutTx.getFee());
                log.info("Dispute payout tx fee is within tolerance for {} {}", (Object)this.getClass().getSimpleName(), (Object)trade.getShortId());
            }
        } else {
            log.warn("Payout tx already signed for {} {}, skipping signing", (Object)this.getClass().getSimpleName(), (Object)trade.getShortId());
            disputeTxSet.setMultisigTxHex(trade.getPayoutTxHex());
        }
        for (int i = 0; i < 5; ++i) {
            MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
            try {
                List txHashes = multisigWallet.submitMultisigTxHex(disputeTxSet.getMultisigTxHex());
                ((MoneroTxWallet)disputeTxSet.getTxs().get(0)).setHash((String)txHashes.get(0));
                break;
            }
            catch (Exception e) {
                if (trade.isPayoutPublished()) {
                    return null;
                }
                if (HavenoUtils.isMultisigError(e)) {
                    throw new IllegalArgumentException(e);
                }
                log.warn("Failed to submit dispute payout tx, tradeId={}, attempt={}/{}, error={}", new Object[]{trade.getShortId(), i + 1, 5, e.getMessage()});
                if (i == 4) {
                    throw e;
                }
                if (trade.getXmrConnectionService().isConnected().booleanValue()) {
                    trade.requestSwitchToNextBestConnection(sourceConnection);
                }
                HavenoUtils.waitFor(5000L);
                continue;
            }
        }
        trade.setPayoutTx((MoneroTx)disputeTxSet.getTxs().get(0));
        trade.setPayoutState(Trade.PayoutState.PAYOUT_PUBLISHED);
        dispute.setDisputePayoutTxId(((MoneroTxWallet)disputeTxSet.getTxs().get(0)).getHash());
        this.requestPersistence(trade);
        return disputeTxSet;
    }

    public static BigInteger[] getBuyerSellerPayoutTxCost(DisputeResult disputeResult, BigInteger payoutTxCost) {
        BigInteger loserAmount;
        boolean isBuyerWinner = disputeResult.getWinner() == DisputeResult.Winner.BUYER;
        BigInteger bigInteger = loserAmount = isBuyerWinner ? disputeResult.getSellerPayoutAmountBeforeCost() : disputeResult.getBuyerPayoutAmountBeforeCost();
        if (loserAmount.equals(BigInteger.ZERO)) {
            BigInteger buyerPayoutTxFee = isBuyerWinner ? payoutTxCost : BigInteger.ZERO;
            BigInteger sellerPayoutTxFee = isBuyerWinner ? BigInteger.ZERO : payoutTxCost;
            return new BigInteger[]{buyerPayoutTxFee, sellerPayoutTxFee};
        }
        switch (disputeResult.getSubtractFeeFrom()) {
            case BUYER_AND_SELLER: {
                BigInteger payoutTxFeeSplit = payoutTxCost.divide(BigInteger.valueOf(2L));
                return new BigInteger[]{payoutTxFeeSplit, payoutTxFeeSplit};
            }
            case BUYER_ONLY: {
                return new BigInteger[]{payoutTxCost, BigInteger.ZERO};
            }
            case SELLER_ONLY: {
                return new BigInteger[]{BigInteger.ZERO, payoutTxCost};
            }
        }
        throw new RuntimeException("Unsupported subtract fee from: " + String.valueOf((Object)disputeResult.getSubtractFeeFrom()));
    }

    public FileTransferSender initLogUpload(FileTransferSession.FtpCallback callback, String tradeId, int traderId) throws IOException {
        Dispute dispute = this.findDispute(tradeId, traderId).orElseThrow(() -> new IOException("could not locate Dispute for tradeId/traderId"));
        return dispute.createFileTransferSender(this.p2PService.getNetworkNode(), dispute.getContract().getArbitratorNodeAddress(), callback);
    }

    private void processFilePartReceived(FileTransferPart ftp) {
        if (!ftp.isInitialRequest()) {
            return;
        }
        Optional<Dispute> dispute = this.findDispute(ftp.getTradeId(), ftp.getTraderId());
        if (dispute.isEmpty()) {
            log.error("Received log upload request for unknown TradeId/TraderId {}/{}", (Object)ftp.getTradeId(), (Object)ftp.getTraderId());
            return;
        }
        if (dispute.get().isClosed()) {
            log.error("Received a file transfer request for closed dispute {}", (Object)ftp.getTradeId());
            return;
        }
        try {
            FileTransferReceiver session = dispute.get().createOrGetFileTransferReceiver(this.p2PService.getNetworkNode(), ftp.getSenderNodeAddress(), this);
            session.processFilePartReceived(ftp);
        }
        catch (IOException e) {
            log.error("Unable to process a received file message" + String.valueOf(e));
        }
    }

    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof FileTransferPart) {
            FileTransferPart ftp = (FileTransferPart)networkEnvelope;
            this.processFilePartReceived(ftp);
        }
    }

    @Override
    public void onFtpProgress(double progressPct) {
        log.trace("ftp progress: {}", (Object)progressPct);
    }

    @Override
    public void onFtpComplete(FileTransferSession session) {
        Optional<Dispute> dispute = this.findDispute(session.getFullTradeId(), session.getTraderId());
        dispute.ifPresent(d -> this.addMediationLogsReceivedMessage((Dispute)d, session.getZipId()));
    }

    @Override
    public void onFtpTimeout(String statusMsg, FileTransferSession session) {
        session.resetSession();
    }
}

