/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.agent;

import haveno.common.crypto.Hash;
import haveno.common.crypto.PubKeyRing;
import haveno.common.util.Tuple2;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.user.DontShowAgainLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleHolderNameDetection {
    private static final Logger log = LoggerFactory.getLogger(MultipleHolderNameDetection.class);
    private static final String ACK_KEY = "Ack-";
    private final DisputeManager<? extends DisputeList<Dispute>> disputeManager;
    private final Map<String, List<Dispute>> suspiciousDisputesByTraderMap = new HashMap<String, List<Dispute>>();
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    private static String getSigPuKeyHashAsHex(PubKeyRing pubKeyRing) {
        return Utilities.encodeToHex((byte[])Hash.getRipemd160hash((byte[])pubKeyRing.getSignaturePubKeyBytes()));
    }

    private static String getSigPubKeyHashAsHex(Dispute dispute) {
        return MultipleHolderNameDetection.getSigPuKeyHashAsHex(dispute.getTraderPubKeyRing());
    }

    private static boolean isBuyer(Dispute dispute) {
        String traderSigPubKeyHashAsHex = MultipleHolderNameDetection.getSigPubKeyHashAsHex(dispute);
        String buyerSigPubKeyHashAsHex = MultipleHolderNameDetection.getSigPuKeyHashAsHex(dispute.getContract().getBuyerPubKeyRing());
        return buyerSigPubKeyHashAsHex.equals(traderSigPubKeyHashAsHex);
    }

    private static PayloadWithHolderName getPayloadWithHolderName(Dispute dispute) {
        return (PayloadWithHolderName)((Object)MultipleHolderNameDetection.getPaymentAccountPayload(dispute));
    }

    public static PaymentAccountPayload getPaymentAccountPayload(Dispute dispute) {
        return MultipleHolderNameDetection.isBuyer(dispute) ? dispute.getBuyerPaymentAccountPayload() : dispute.getSellerPaymentAccountPayload();
    }

    public static String getAddress(Dispute dispute) {
        return MultipleHolderNameDetection.isBuyer(dispute) ? dispute.getContract().getBuyerNodeAddress().getHostName() : dispute.getContract().getSellerNodeAddress().getHostName();
    }

    public static String getAckKey(Dispute dispute) {
        return ACK_KEY + MultipleHolderNameDetection.getSigPubKeyHashAsHex(dispute).substring(0, 4) + "/" + dispute.getShortTradeId();
    }

    private static String getIsBuyerSubString(boolean isBuyer) {
        return "'\n        Role: " + (isBuyer ? "'Buyer'" : "'Seller'");
    }

    public MultipleHolderNameDetection(DisputeManager<? extends DisputeList<Dispute>> disputeManager) {
        this.disputeManager = disputeManager;
        disputeManager.getDisputesAsObservableList().addListener(c -> {
            c.next();
            if (c.wasAdded()) {
                this.detectMultipleHolderNames();
            }
        });
    }

    public void detectMultipleHolderNames() {
        String previous = this.suspiciousDisputesByTraderMap.toString();
        this.getAllDisputesByTraderMap().forEach((key, value) -> {
            Set userNames = value.stream().map(dispute -> MultipleHolderNameDetection.getPayloadWithHolderName(dispute).getHolderName()).collect(Collectors.toSet());
            if (userNames.size() > 1) {
                value.sort(Comparator.comparing(Dispute::getId));
                this.suspiciousDisputesByTraderMap.put((String)key, (List<Dispute>)value);
            }
        });
        String updated = this.suspiciousDisputesByTraderMap.toString();
        if (!previous.equals(updated)) {
            this.listeners.forEach(Listener::onSuspiciousDisputeDetected);
        }
    }

    public boolean hasSuspiciousDisputesDetected() {
        return !this.suspiciousDisputesByTraderMap.isEmpty();
    }

    public List<Dispute> getDisputesForTrader(Dispute dispute) {
        String traderPubKeyHash = MultipleHolderNameDetection.getSigPubKeyHashAsHex(dispute);
        if (this.suspiciousDisputesByTraderMap.containsKey(traderPubKeyHash)) {
            return this.suspiciousDisputesByTraderMap.get(traderPubKeyHash);
        }
        return new ArrayList<Dispute>();
    }

    public String getReportForAllDisputes() {
        return this.getReport(this.suspiciousDisputesByTraderMap.values());
    }

    public String getReportForDisputeOfTrader(List<Dispute> disputes) {
        ArrayList<List<Dispute>> values = new ArrayList<List<Dispute>>();
        values.add(disputes);
        return this.getReport(values);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private Map<String, List<Dispute>> getAllDisputesByTraderMap() {
        HashMap<String, List<Dispute>> allDisputesByTraderMap = new HashMap<String, List<Dispute>>();
        this.disputeManager.getDisputesAsObservableList().stream().filter(dispute -> {
            PaymentAccountPayload paymentAccountPayload = MultipleHolderNameDetection.isBuyer(dispute) ? dispute.getBuyerPaymentAccountPayload() : dispute.getSellerPaymentAccountPayload();
            return paymentAccountPayload instanceof PayloadWithHolderName;
        }).forEach(dispute -> {
            String traderPubKeyHash = MultipleHolderNameDetection.getSigPubKeyHashAsHex(dispute);
            allDisputesByTraderMap.putIfAbsent(traderPubKeyHash, new ArrayList());
            List disputes = (List)allDisputesByTraderMap.get(traderPubKeyHash);
            disputes.add(dispute);
        });
        return allDisputesByTraderMap;
    }

    private String getReport(Collection<List<Dispute>> collectionOfDisputesOfTrader) {
        return collectionOfDisputesOfTrader.stream().map(disputes -> {
            HashSet addresses = new HashSet();
            HashSet isBuyerHashSet = new HashSet();
            HashSet names = new HashSet();
            String disputesReport = disputes.stream().map(dispute -> {
                addresses.add(MultipleHolderNameDetection.getAddress(dispute));
                String ackKey = MultipleHolderNameDetection.getAckKey(dispute);
                String ackSubString = "    ";
                if (!DontShowAgainLookup.showAgain(ackKey)) {
                    ackSubString = "[ACK]   ";
                }
                String holderName = MultipleHolderNameDetection.getPayloadWithHolderName(dispute).getHolderName();
                names.add(holderName);
                boolean isBuyer = MultipleHolderNameDetection.isBuyer(dispute);
                isBuyerHashSet.add(isBuyer);
                String isBuyerSubString = MultipleHolderNameDetection.getIsBuyerSubString(isBuyer);
                DisputeResult disputeResult = (DisputeResult)dispute.disputeResultProperty().get();
                String summaryNotes = disputeResult != null ? ((String)disputeResult.getSummaryNotesProperty().get()).trim() : "Not closed yet";
                return ackSubString + "Trade ID: '" + dispute.getShortTradeId() + "'\n        Account holder name: '" + holderName + "'\n        Payment method: '" + Res.get(MultipleHolderNameDetection.getPaymentAccountPayload(dispute).getPaymentMethodId()) + isBuyerSubString + "'\n        Summary: '" + summaryNotes;
            }).collect(Collectors.joining("\n"));
            String addressSubString = addresses.size() > 1 ? "used multiple addresses " + String.valueOf(addresses) + " with" : "with address " + (String)new ArrayList(addresses).get(0) + " used";
            String roleSubString = "Trader ";
            if (isBuyerHashSet.size() == 1) {
                boolean isBuyer = (Boolean)new ArrayList(isBuyerHashSet).get(0);
                String isBuyerSubString = MultipleHolderNameDetection.getIsBuyerSubString(isBuyer);
                disputesReport = disputesReport.replace(isBuyerSubString, "");
                roleSubString = isBuyer ? "Buyer " : "Seller ";
            }
            String traderReport = roleSubString + addressSubString + " multiple names: " + ((Object)names).toString() + "\n" + disputesReport;
            return new Tuple2((Object)roleSubString, (Object)traderReport);
        }).sorted(Comparator.comparing(o -> (String)o.first)).map(e -> (String)e.second).collect(Collectors.joining("\n\n"));
    }

    public Map<String, List<Dispute>> getSuspiciousDisputesByTraderMap() {
        return this.suspiciousDisputesByTraderMap;
    }

    public static interface Listener {
        public void onSuspiciousDisputeDetected();
    }
}

