/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.agent;

import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.crypto.KeyRing;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.util.Utilities;
import haveno.core.filter.FilterManager;
import haveno.core.support.dispute.agent.DisputeAgent;
import haveno.core.support.dispute.agent.DisputeAgentService;
import haveno.core.user.User;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.storage.HashMapChangedListener;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javax.annotation.Nullable;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DisputeAgentManager<T extends DisputeAgent> {
    private static final Logger log = LoggerFactory.getLogger(DisputeAgentManager.class);
    protected static final long REPUBLISH_MILLIS = DisputeAgent.TTL / 2L;
    protected static final long RETRY_REPUBLISH_SEC = 5L;
    protected static final long REPEATED_REPUBLISH_AT_STARTUP_SEC = 60L;
    protected final List<String> publicKeys;
    protected final KeyRing keyRing;
    protected final DisputeAgentService<T> disputeAgentService;
    protected final User user;
    protected final FilterManager filterManager;
    protected final ObservableMap<NodeAddress, T> observableMap = FXCollections.observableHashMap();
    protected List<T> persistedAcceptedDisputeAgents;
    protected Timer republishTimer;
    protected Timer retryRepublishTimer;

    public DisputeAgentManager(KeyRing keyRing, DisputeAgentService<T> disputeAgentService, User user, FilterManager filterManager) {
        this.keyRing = keyRing;
        this.disputeAgentService = disputeAgentService;
        this.user = user;
        this.filterManager = filterManager;
        this.publicKeys = this.getPubKeyList();
    }

    protected abstract List<String> getPubKeyList();

    protected abstract boolean isExpectedInstance(ProtectedStorageEntry var1);

    protected abstract void addAcceptedDisputeAgentToUser(T var1);

    protected abstract T getRegisteredDisputeAgentFromUser();

    protected abstract void clearAcceptedDisputeAgentsAtUser();

    protected abstract List<T> getAcceptedDisputeAgentsFromUser();

    protected abstract void removeAcceptedDisputeAgentFromUser(ProtectedStorageEntry var1);

    protected abstract void setRegisteredDisputeAgentAtUser(T var1);

    public void onAllServicesInitialized() {
        this.disputeAgentService.addHashSetChangedListener(new HashMapChangedListener(){

            public void onAdded(Collection<ProtectedStorageEntry> protectedStorageEntries) {
                protectedStorageEntries.forEach(protectedStorageEntry -> {
                    if (DisputeAgentManager.this.isExpectedInstance((ProtectedStorageEntry)protectedStorageEntry)) {
                        DisputeAgentManager.this.updateMap();
                    }
                });
            }

            public void onRemoved(Collection<ProtectedStorageEntry> protectedStorageEntries) {
                protectedStorageEntries.forEach(protectedStorageEntry -> {
                    if (DisputeAgentManager.this.isExpectedInstance((ProtectedStorageEntry)protectedStorageEntry)) {
                        DisputeAgentManager.this.updateMap();
                        DisputeAgentManager.this.removeAcceptedDisputeAgentFromUser((ProtectedStorageEntry)protectedStorageEntry);
                    }
                });
            }
        });
        this.persistedAcceptedDisputeAgents = new ArrayList<T>(this.getAcceptedDisputeAgentsFromUser());
        this.clearAcceptedDisputeAgentsAtUser();
        if (this.getRegisteredDisputeAgentFromUser() != null) {
            P2PService p2PService = this.disputeAgentService.getP2PService();
            if (p2PService.isBootstrapped()) {
                this.startRepublishDisputeAgent();
            } else {
                p2PService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

                    public void onDataReceived() {
                        DisputeAgentManager.this.startRepublishDisputeAgent();
                    }
                });
            }
        }
        this.filterManager.filterProperty().addListener((observable, oldValue, newValue) -> this.updateMap());
        this.updateMap();
    }

    public void shutDown() {
        this.stopRepublishTimer();
        this.stopRetryRepublishTimer();
    }

    protected void startRepublishDisputeAgent() {
        if (this.republishTimer == null) {
            this.republishTimer = UserThread.runPeriodically(this::republish, (long)REPUBLISH_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS);
            UserThread.runAfter(this::republish, (long)60L);
            this.republish();
        }
    }

    public void updateMap() {
        Map<NodeAddress, T> map = this.disputeAgentService.getDisputeAgents();
        this.observableMap.clear();
        Map filtered = map.values().stream().filter(e -> {
            boolean isSigValid;
            String pubKeyAsHex = Utils.HEX.encode(e.getRegistrationPubKey());
            boolean isInPublicKeyInList = this.isPublicKeyInList(pubKeyAsHex);
            if (!isInPublicKeyInList) {
                if ("027a381b5333a56e1cc3d90d3a7d07f26509adf7029ed06fc997c656621f8da1ee".equals(pubKeyAsHex)) {
                    log.info("We got the DEV_PRIVILEGE_PUB_KEY in our list of publicKeys. RegistrationPubKey={}, nodeAddress={}", (Object)Utilities.bytesAsHexString((byte[])e.getRegistrationPubKey()), (Object)e.getNodeAddress().getFullAddress());
                } else {
                    log.warn("We got an disputeAgent which is not in our list of publicKeys. RegistrationPubKey={}, nodeAddress={}", (Object)Utilities.bytesAsHexString((byte[])e.getRegistrationPubKey()), (Object)e.getNodeAddress().getFullAddress());
                }
            }
            if (!(isSigValid = this.verifySignature(e.getPubKeyRing().getSignaturePubKey(), e.getRegistrationPubKey(), e.getRegistrationSignature()))) {
                log.warn("Sig check for disputeAgent failed. DisputeAgent={}", (Object)e.toString());
            }
            return isInPublicKeyInList && isSigValid;
        }).collect(Collectors.toMap(DisputeAgent::getNodeAddress, Function.identity()));
        this.observableMap.putAll(filtered);
        this.observableMap.values().forEach(this::addAcceptedDisputeAgentToUser);
    }

    public void addDisputeAgent(T disputeAgent, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.setRegisteredDisputeAgentAtUser(disputeAgent);
        this.observableMap.put((Object)((DisputeAgent)disputeAgent).getNodeAddress(), disputeAgent);
        this.disputeAgentService.addDisputeAgent(disputeAgent, () -> {
            log.info("DisputeAgent successfully saved in P2P network");
            resultHandler.handleResult();
            if (this.observableMap.size() > 0) {
                UserThread.runAfter(this::updateMap, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }, errorMessageHandler);
    }

    public void removeDisputeAgent(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        T registeredDisputeAgent = this.getRegisteredDisputeAgentFromUser();
        if (registeredDisputeAgent != null) {
            this.setRegisteredDisputeAgentAtUser(null);
            this.observableMap.remove((Object)((DisputeAgent)registeredDisputeAgent).getNodeAddress());
            this.disputeAgentService.removeDisputeAgent(registeredDisputeAgent, () -> {
                log.debug("DisputeAgent successfully removed from P2P network");
                resultHandler.handleResult();
            }, errorMessageHandler);
        } else {
            errorMessageHandler.handleErrorMessage("User is not registered dispute agent");
        }
    }

    public ObservableMap<NodeAddress, T> getObservableMap() {
        return this.observableMap;
    }

    public String signStorageSignaturePubKey(ECKey key) {
        String keyToSignAsHex = Utils.HEX.encode(this.keyRing.getPubKeyRing().getSignaturePubKey().getEncoded());
        return key.signMessage(keyToSignAsHex);
    }

    @Nullable
    public ECKey getRegistrationKey(String privKeyBigIntString) {
        try {
            return ECKey.fromPrivate((BigInteger)new BigInteger(1, Utils.HEX.decode((CharSequence)privKeyBigIntString)));
        }
        catch (Throwable t) {
            return null;
        }
    }

    public boolean isPublicKeyInList(String pubKeyAsHex) {
        return this.publicKeys.contains(pubKeyAsHex);
    }

    public boolean isAgentAvailableForLanguage(String languageCode) {
        return this.observableMap.values().stream().anyMatch(agent -> agent.getLanguageCodes().stream().anyMatch(lc -> lc.equals(languageCode)));
    }

    public List<String> getDisputeAgentLanguages(List<NodeAddress> nodeAddresses) {
        return this.observableMap.values().stream().filter(disputeAgent -> nodeAddresses.stream().anyMatch(nodeAddress -> nodeAddress.equals((Object)disputeAgent.getNodeAddress()))).flatMap(disputeAgent -> disputeAgent.getLanguageCodes().stream()).distinct().collect(Collectors.toList());
    }

    public Optional<T> getDisputeAgentByNodeAddress(NodeAddress nodeAddress) {
        return this.observableMap.containsKey((Object)nodeAddress) ? Optional.of((DisputeAgent)this.observableMap.get((Object)nodeAddress)) : Optional.empty();
    }

    protected void republish() {
        T registeredDisputeAgent = this.getRegisteredDisputeAgentFromUser();
        if (registeredDisputeAgent != null) {
            this.addDisputeAgent(registeredDisputeAgent, this::updateMap, errorMessage -> {
                if (this.retryRepublishTimer == null) {
                    this.retryRepublishTimer = UserThread.runPeriodically(() -> {
                        this.stopRetryRepublishTimer();
                        this.republish();
                    }, (long)5L);
                }
            });
        }
    }

    protected boolean verifySignature(PublicKey storageSignaturePubKey, byte[] registrationPubKey, String signature) {
        String keyToSignAsHex = Utils.HEX.encode(storageSignaturePubKey.getEncoded());
        try {
            ECKey key = ECKey.fromPublicOnly((byte[])registrationPubKey);
            key.verifyMessage(keyToSignAsHex, signature);
            return true;
        }
        catch (SignatureException e) {
            log.warn("verifySignature failed");
            return false;
        }
    }

    protected void stopRetryRepublishTimer() {
        if (this.retryRepublishTimer != null) {
            this.retryRepublishTimer.stop();
            this.retryRepublishTimer = null;
        }
    }

    protected void stopRepublishTimer() {
        if (this.republishTimer != null) {
            this.republishTimer.stop();
            this.republishTimer = null;
        }
    }
}

