/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.agent;

import haveno.core.locale.Res;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisputeAgentLookupMap {
    private static final Logger log = LoggerFactory.getLogger(DisputeAgentLookupMap.class);

    @Nullable
    public static String getMatrixUserName(String fullAddress) {
        if (fullAddress.matches("localhost(.*)")) {
            return fullAddress;
        }
        switch (fullAddress) {
            case "7hkpotiyaukuzcfy6faihjaols5r2mkysz7bm3wrhhbpbphzz3zbwyqd.onion:9999": {
                return "leo816";
            }
            case "wizhavenozd7ku25di7p2ztsajioabihlnyp5lq5av66tmu7do2dke2tid.onion:9999": {
                return "wiz";
            }
            case "apbp7ubuyezav4hy.onion:9999": {
                return "haveno_knight";
            }
            case "a56olqlmmpxrn5q34itq5g5tb5d3fg7vxekpbceq7xqvfl3cieocgsyd.onion:9999": {
                return "huey735";
            }
            case "3z5jnirlccgxzoxc6zwkcgwj66bugvqplzf6z2iyd5oxifiaorhnanqd.onion:9999": {
                return "refundagent2";
            }
            case "6c4cim7h7t3bm4bnchbf727qrhdfrfr6lhod25wjtizm2sifpkktvwad.onion:9999": {
                return "pazza83";
            }
        }
        log.warn("No username for dispute agent with address {} found.", (Object)fullAddress);
        return Res.get("shared.na");
    }

    public static String getMatrixLinkForAgent(String onion) {
        String agentName = DisputeAgentLookupMap.getMatrixUserName(onion).replaceAll(Res.get("shared.na"), "haveno");
        return "https://matrix.to/#/@" + agentName + ":matrix.org";
    }
}

