/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute.agent;

import haveno.common.crypto.PubKeyRing;
import haveno.common.util.ExtraDataMapValidator;
import haveno.common.util.Utilities;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.storage.payload.ExpirablePayload;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DisputeAgent
implements ProtectedStoragePayload,
ExpirablePayload {
    private static final Logger log = LoggerFactory.getLogger(DisputeAgent.class);
    public static final long TTL = TimeUnit.DAYS.toMillis(10L);
    protected final NodeAddress nodeAddress;
    protected final PubKeyRing pubKeyRing;
    protected final List<String> languageCodes;
    protected final long registrationDate;
    protected final byte[] registrationPubKey;
    protected final String registrationSignature;
    @Nullable
    protected final String emailAddress;
    @Nullable
    protected final String info;
    @Nullable
    protected Map<String, String> extraDataMap;

    public DisputeAgent(NodeAddress nodeAddress, PubKeyRing pubKeyRing, List<String> languageCodes, long registrationDate, byte[] registrationPubKey, String registrationSignature, @Nullable String emailAddress, @Nullable String info, @Nullable Map<String, String> extraDataMap) {
        this.nodeAddress = nodeAddress;
        this.pubKeyRing = pubKeyRing;
        this.languageCodes = languageCodes;
        this.registrationDate = registrationDate;
        this.registrationPubKey = registrationPubKey;
        this.registrationSignature = registrationSignature;
        this.emailAddress = emailAddress;
        this.info = info;
        this.extraDataMap = ExtraDataMapValidator.getValidatedExtraDataMap(extraDataMap);
    }

    public long getTTL() {
        return TTL;
    }

    public PublicKey getOwnerPubKey() {
        return this.pubKeyRing.getSignaturePubKey();
    }

    public String toString() {
        return "DisputeAgent{\n     nodeAddress=" + String.valueOf(this.nodeAddress) + ",\n     pubKeyRing=" + String.valueOf(this.pubKeyRing) + ",\n     languageCodes=" + String.valueOf(this.languageCodes) + ",\n     registrationDate=" + this.registrationDate + ",\n     registrationPubKey=" + Utilities.bytesAsHexString((byte[])this.registrationPubKey) + ",\n     registrationSignature='" + this.registrationSignature + "',\n     emailAddress='" + this.emailAddress + "',\n     info='" + this.info + "',\n     extraDataMap=" + String.valueOf(this.extraDataMap) + "\n}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisputeAgent)) {
            return false;
        }
        DisputeAgent other = (DisputeAgent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRegistrationDate() != other.getRegistrationDate()) {
            return false;
        }
        NodeAddress this$nodeAddress = this.getNodeAddress();
        NodeAddress other$nodeAddress = other.getNodeAddress();
        if (this$nodeAddress == null ? other$nodeAddress != null : !this$nodeAddress.equals(other$nodeAddress)) {
            return false;
        }
        PubKeyRing this$pubKeyRing = this.getPubKeyRing();
        PubKeyRing other$pubKeyRing = other.getPubKeyRing();
        if (this$pubKeyRing == null ? other$pubKeyRing != null : !this$pubKeyRing.equals(other$pubKeyRing)) {
            return false;
        }
        List<String> this$languageCodes = this.getLanguageCodes();
        List<String> other$languageCodes = other.getLanguageCodes();
        if (this$languageCodes == null ? other$languageCodes != null : !((Object)this$languageCodes).equals(other$languageCodes)) {
            return false;
        }
        if (!Arrays.equals(this.getRegistrationPubKey(), other.getRegistrationPubKey())) {
            return false;
        }
        String this$registrationSignature = this.getRegistrationSignature();
        String other$registrationSignature = other.getRegistrationSignature();
        if (this$registrationSignature == null ? other$registrationSignature != null : !this$registrationSignature.equals(other$registrationSignature)) {
            return false;
        }
        String this$emailAddress = this.getEmailAddress();
        String other$emailAddress = other.getEmailAddress();
        if (this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress)) {
            return false;
        }
        String this$info = this.getInfo();
        String other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        Map<String, String> this$extraDataMap = this.getExtraDataMap();
        Map<String, String> other$extraDataMap = other.getExtraDataMap();
        return !(this$extraDataMap == null ? other$extraDataMap != null : !((Object)this$extraDataMap).equals(other$extraDataMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DisputeAgent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $registrationDate = this.getRegistrationDate();
        result = result * 59 + (int)($registrationDate >>> 32 ^ $registrationDate);
        NodeAddress $nodeAddress = this.getNodeAddress();
        result = result * 59 + ($nodeAddress == null ? 43 : $nodeAddress.hashCode());
        PubKeyRing $pubKeyRing = this.getPubKeyRing();
        result = result * 59 + ($pubKeyRing == null ? 43 : $pubKeyRing.hashCode());
        List<String> $languageCodes = this.getLanguageCodes();
        result = result * 59 + ($languageCodes == null ? 43 : ((Object)$languageCodes).hashCode());
        result = result * 59 + Arrays.hashCode(this.getRegistrationPubKey());
        String $registrationSignature = this.getRegistrationSignature();
        result = result * 59 + ($registrationSignature == null ? 43 : $registrationSignature.hashCode());
        String $emailAddress = this.getEmailAddress();
        result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
        String $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        Map<String, String> $extraDataMap = this.getExtraDataMap();
        result = result * 59 + ($extraDataMap == null ? 43 : ((Object)$extraDataMap).hashCode());
        return result;
    }

    public NodeAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public PubKeyRing getPubKeyRing() {
        return this.pubKeyRing;
    }

    public List<String> getLanguageCodes() {
        return this.languageCodes;
    }

    public long getRegistrationDate() {
        return this.registrationDate;
    }

    public byte[] getRegistrationPubKey() {
        return this.registrationPubKey;
    }

    public String getRegistrationSignature() {
        return this.registrationSignature;
    }

    @Nullable
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Nullable
    public String getInfo() {
        return this.info;
    }

    @Nullable
    public Map<String, String> getExtraDataMap() {
        return this.extraDataMap;
    }
}

