/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute;

import haveno.core.support.SupportSession;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.messages.ChatMessage;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DisputeSession
extends SupportSession {
    private static final Logger log = LoggerFactory.getLogger(DisputeSession.class);
    @Nullable
    private Dispute dispute;
    private final boolean isTrader;

    public DisputeSession(@Nullable Dispute dispute, boolean isTrader) {
        this.dispute = dispute;
        this.isTrader = isTrader;
    }

    @Override
    public boolean isClient() {
        return this.isTrader;
    }

    @Override
    public String getTradeId() {
        return this.dispute != null ? this.dispute.getTradeId() : "";
    }

    @Override
    public int getClientId() {
        try {
            return this.dispute.getTraderPubKeyRing().hashCode();
        }
        catch (NullPointerException e) {
            log.warn("Unable to get traderPubKeyRing from Dispute - {}", (Object)e.toString());
            return 0;
        }
    }

    @Override
    public ObservableList<ChatMessage> getObservableChatMessageList() {
        return this.dispute != null ? this.dispute.getChatMessages() : FXCollections.observableArrayList();
    }

    @Override
    public boolean chatIsOpen() {
        return this.dispute != null && this.dispute.isOpen();
    }

    @Override
    public boolean isDisputeAgent() {
        return !this.isClient();
    }
}

