/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support.dispute;

import com.google.common.base.Preconditions;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.config.Config;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.handlers.FaultHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.util.MathUtils;
import haveno.common.util.Tuple2;
import haveno.core.api.CoreNotificationService;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.OpenOfferManager;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.support.SupportManager;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeAlreadyOpenException;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeListService;
import haveno.core.support.dispute.DisputeMessageDeliveryFailedException;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.DisputeValidation;
import haveno.core.support.dispute.messages.DisputeClosedMessage;
import haveno.core.support.dispute.messages.DisputeOpenedMessage;
import haveno.core.support.messages.ChatMessage;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.SellerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.trade.protocol.TradePeer;
import haveno.core.xmr.wallet.Restrictions;
import haveno.core.xmr.wallet.TradeWalletService;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.SendMailboxMessageListener;
import haveno.network.p2p.mailbox.MailboxMessage;
import java.math.BigInteger;
import java.security.KeyPair;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroTxConfig;
import monero.wallet.model.MoneroTxWallet;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DisputeManager<T extends DisputeList<Dispute>>
extends SupportManager {
    private static final Logger log = LoggerFactory.getLogger(DisputeManager.class);
    protected final TradeWalletService tradeWalletService;
    protected final XmrWalletService xmrWalletService;
    protected final ClosedTradableManager closedTradableManager;
    protected final OpenOfferManager openOfferManager;
    protected final KeyRing keyRing;
    protected final DisputeListService<T> disputeListService;
    private final Config config;
    private final PriceFeedService priceFeedService;
    protected String pendingOutgoingMessage;
    protected final ObservableList<DisputeValidation.ValidationException> validationExceptions = FXCollections.observableArrayList();

    public DisputeManager(P2PService p2PService, TradeWalletService tradeWalletService, XmrWalletService xmrWalletService, XmrConnectionService xmrConnectionService, CoreNotificationService notificationService, TradeManager tradeManager, ClosedTradableManager closedTradableManager, OpenOfferManager openOfferManager, KeyRing keyRing, DisputeListService<T> disputeListService, Config config, PriceFeedService priceFeedService) {
        super(p2PService, xmrConnectionService, xmrWalletService, notificationService, tradeManager);
        this.tradeWalletService = tradeWalletService;
        this.xmrWalletService = xmrWalletService;
        this.closedTradableManager = closedTradableManager;
        this.openOfferManager = openOfferManager;
        this.keyRing = keyRing;
        this.disputeListService = disputeListService;
        this.config = config;
        this.priceFeedService = priceFeedService;
        this.clearPendingMessage();
    }

    public KeyPair getSignatureKeyPair() {
        return this.keyRing.getSignatureKeyPair();
    }

    @Override
    public void requestPersistence() {
        this.tradeManager.requestPersistence();
        this.disputeListService.requestPersistence();
    }

    protected void requestPersistence(Trade trade) {
        trade.requestPersistence();
        this.disputeListService.requestPersistence();
    }

    @Override
    public void persistNow(@Nullable Runnable completeHandler) {
        this.tradeManager.persistNow(null);
        this.disputeListService.persistNow(completeHandler);
    }

    @Override
    public NodeAddress getPeerNodeAddress(ChatMessage message) {
        Optional<Dispute> disputeOptional = this.findDispute(message);
        if (disputeOptional.isEmpty()) {
            log.warn("Could not find dispute for tradeId = {} traderId = {}", (Object)message.getTradeId(), (Object)message.getTraderId());
            return null;
        }
        return (NodeAddress)this.getNodeAddressPubKeyRingTuple((Dispute)disputeOptional.get()).first;
    }

    @Override
    public PubKeyRing getPeerPubKeyRing(ChatMessage message) {
        Optional<Dispute> disputeOptional = this.findDispute(message);
        if (disputeOptional.isEmpty()) {
            log.warn("Could not find dispute for tradeId = {} traderId = {}", (Object)message.getTradeId(), (Object)message.getTraderId());
            return null;
        }
        return (PubKeyRing)this.getNodeAddressPubKeyRingTuple((Dispute)disputeOptional.get()).second;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChatMessage> getAllChatMessages(String tradeId) {
        ObservableList observableList = this.getDisputeList().getObservableList();
        synchronized (observableList) {
            return this.getDisputeList().stream().filter(dispute -> dispute.getTradeId().equals(tradeId)).flatMap(dispute -> dispute.getChatMessages().stream()).collect(Collectors.toList());
        }
    }

    @Override
    public boolean channelOpen(ChatMessage message) {
        return this.findDispute(message).isPresent();
    }

    @Override
    public void addAndPersistChatMessage(ChatMessage message) {
        this.findDispute(message).ifPresent(dispute -> {
            if (dispute.getChatMessages().stream().noneMatch(m -> m.getUid().equals(message.getUid()))) {
                dispute.addAndPersistChatMessage(message);
                this.requestPersistence();
            } else {
                log.warn("We got a chatMessage that we have already stored. UId = {} TradeId = {}", (Object)message.getUid(), (Object)message.getTradeId());
            }
        });
    }

    public abstract void handle(DisputeClosedMessage var1);

    public abstract NodeAddress getAgentNodeAddress(Dispute var1);

    public abstract void cleanupDisputes();

    protected abstract String getDisputeInfo(Dispute var1);

    protected abstract String getDisputeIntroForPeer(String var1);

    protected abstract String getDisputeIntroForDisputeCreator(String var1);

    public IntegerProperty getNumOpenDisputes() {
        return this.disputeListService.getNumOpenDisputes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservableList<Dispute> getDisputesAsObservableList() {
        ObservableList observableList = this.disputeListService.getDisputeList().getObservableList();
        synchronized (observableList) {
            return this.disputeListService.getObservableList();
        }
    }

    public String getNrOfDisputes(boolean isBuyer, Contract contract) {
        return this.disputeListService.getNrOfDisputes(isBuyer, contract);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getDisputeList() {
        ObservableList observableList = this.disputeListService.getDisputeList().getObservableList();
        synchronized (observableList) {
            return this.disputeListService.getDisputeList();
        }
    }

    public Set<String> getDisputedTradeIds() {
        return this.disputeListService.getDisputedTradeIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAllServicesInitialized() {
        List disputes;
        super.onAllServicesInitialized();
        this.disputeListService.onAllServicesInitialized();
        this.p2PService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

            public void onDataReceived() {
                DisputeManager.this.tryApplyMessages();
            }
        });
        this.xmrWalletService.downloadPercentageProperty().addListener((observable, oldValue, newValue) -> {
            if (this.xmrWalletService.isSyncedWithinTolerance()) {
                this.tryApplyMessages();
            }
        });
        this.tryApplyMessages();
        this.cleanupDisputes();
        List list = disputes = this.getDisputeList().getList();
        synchronized (list) {
            disputes.forEach(dispute -> {
                try {
                    DisputeValidation.validateNodeAddresses(dispute, this.config);
                }
                catch (DisputeValidation.ValidationException e) {
                    log.error(e.toString());
                    this.validationExceptions.add((Object)e);
                }
            });
        }
        this.maybeClearSensitiveData();
    }

    public boolean isTrader(Dispute dispute) {
        return this.keyRing.getPubKeyRing().equals((Object)dispute.getTraderPubKeyRing());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Dispute> findOwnDispute(String tradeId) {
        T t = this.getDisputeList();
        synchronized (t) {
            T disputeList = this.getDisputeList();
            if (disputeList == null) {
                log.warn("disputes is null");
                return Optional.empty();
            }
            return disputeList.stream().filter(e -> e.getTradeId().equals(tradeId)).findAny();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeClearSensitiveData() {
        log.info("{} checking closed disputes eligibility for having sensitive data cleared", (Object)super.getClass().getSimpleName());
        Instant safeDate = this.closedTradableManager.getSafeDateForSensitiveDataClearing();
        List list = this.getDisputeList().getList();
        synchronized (list) {
            this.getDisputeList().getList().stream().filter(e -> e.isClosed()).filter(e -> e.getOpeningDate().toInstant().isBefore(safeDate)).forEach(Dispute::maybeClearSensitiveData);
            this.requestPersistence();
        }
    }

    public void sendDisputeOpenedMessage(Dispute dispute, ResultHandler resultHandler, FaultHandler faultHandler) {
        Trade trade = this.tradeManager.getTrade(dispute.getTradeId());
        if (trade == null) {
            String errorMsg = "Dispute trade does not exist, tradeId=" + dispute.getTradeId();
            faultHandler.handleFault(errorMsg, (Throwable)new IllegalStateException(errorMsg));
            return;
        }
        trade.setDisputeState(Trade.DisputeState.DISPUTE_PREPARING);
        ThreadUtils.execute(() -> {
            try {
                this.sendDisputeOpenedMessageAux(trade, dispute, resultHandler, (errorMessage, throwable) -> {
                    log.warn("Failed to open dispute for trade: " + dispute.getTradeId() + ": " + errorMessage, throwable);
                    this.removeDisputes(trade);
                    faultHandler.handleFault(errorMessage, throwable);
                });
            }
            catch (Exception e) {
                String errorMsg = "Failed to open dispute for trade " + dispute.getTradeId() + ": " + e.getMessage();
                log.error(errorMsg, (Throwable)e);
                this.removeDisputes(trade);
                faultHandler.handleFault(errorMsg, (Throwable)e);
            }
        }, (String)trade.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDisputeOpenedMessageAux(final Trade trade, Dispute dispute, final ResultHandler resultHandler, final FaultHandler faultHandler) {
        ChatMessage chatMessage;
        block18: {
            block17: {
                log.info("Opening dispute for {} {}, dispute {}", new Object[]{trade.getClass().getSimpleName(), dispute.getTradeId(), dispute.getId()});
                if (trade.isArbitrator()) {
                    String errorMsg = "Arbitrators cannot open disputes.";
                    faultHandler.handleFault(errorMsg, (Throwable)new IllegalStateException(errorMsg));
                    return;
                }
                if (trade.getPhase().ordinal() < Trade.Phase.DEPOSITS_UNLOCKED.ordinal() && !trade.isDepositTxMissing()) {
                    String errorMsg = Res.get("portfolio.pending.error.depositTxNotConfirmed");
                    faultHandler.handleFault(errorMsg, (Throwable)new IllegalStateException(errorMsg));
                    return;
                }
                if (trade.isPayoutConfirmed()) {
                    String errorMsg = "Cannot open dispute because payout is already confirmed for " + trade.getClass().getSimpleName() + " " + trade.getId();
                    faultHandler.handleFault(errorMsg, (Throwable)new IllegalStateException(errorMsg));
                    return;
                }
                T disputeList = this.getDisputeList();
                ObservableList observableList = disputeList.getObservableList();
                synchronized (observableList) {
                    if (disputeList.contains((PersistablePayload)dispute)) {
                        String msg = "We got a dispute msg that we have already stored. TradeId = " + dispute.getTradeId() + ", DisputeId = " + dispute.getId();
                        log.warn(msg);
                        faultHandler.handleFault(msg, (Throwable)new DisputeAlreadyOpenException());
                        return;
                    }
                    Optional<Dispute> storedDisputeOptional = this.findDispute(dispute);
                    boolean reOpen = storedDisputeOptional.isPresent();
                    if (reOpen) {
                        dispute = storedDisputeOptional.get();
                    } else {
                        disputeList.add((PersistablePayload)dispute);
                    }
                }
                this.persistNow(null);
                boolean hasSystemMessage = dispute.getChatMessages().stream().anyMatch(ChatMessage::isSystemMessage);
                if (!hasSystemMessage) {
                    String disputeInfo = this.getDisputeInfo(dispute);
                    String sysMsg = dispute.isSupportTicket() ? Res.get("support.youOpenedTicket", disputeInfo, "1.2.2") : Res.get("support.youOpenedDispute", disputeInfo, "1.2.2");
                    ChatMessage chatMessage2 = new ChatMessage(this.getSupportType(), dispute.getTradeId(), this.keyRing.getPubKeyRing().hashCode(), false, Res.get("support.systemMsg", sysMsg), this.p2PService.getAddress());
                    chatMessage2.setSystemMessage(true);
                    dispute.addAndPersistChatMessage(chatMessage2);
                }
                chatMessage = (ChatMessage)((Object)dispute.getChatMessages().get(dispute.getChatMessages().size() - 1));
                try {
                    trade.importMultisigHex();
                }
                catch (Exception e) {
                    if (trade.isShutDownStarted()) break block17;
                    log.error("Failed to import multisig hex", (Throwable)e);
                }
            }
            if (trade.isShutDownStarted()) {
                String errorMsg = "Aborting opening dispute for " + trade.getClass().getSimpleName() + " " + trade.getId() + " because shut down is started";
                faultHandler.handleFault(errorMsg, (Throwable)new IllegalStateException(errorMsg));
                return;
            }
            try {
                trade.exportMultisigHex();
                if (trade instanceof SellerTrade) {
                    trade.getProcessModel().setPaymentSentPayoutTxStale(true);
                    trade.getSelf().setUnsignedPayoutTxHex(null);
                }
            }
            catch (Exception e) {
                if (trade.isShutDownStarted()) break block18;
                log.error("Failed to export multisig hex", (Throwable)e);
            }
        }
        if (trade.isShutDownStarted()) {
            String errorMsg = "Aborting opening dispute for " + trade.getClass().getSimpleName() + " " + trade.getId() + " because shut down is started";
            faultHandler.handleFault(errorMsg, (Throwable)new IllegalStateException(errorMsg));
            return;
        }
        final NodeAddress agentNodeAddress = this.getAgentNodeAddress(dispute);
        final DisputeOpenedMessage disputeOpenedMessage = new DisputeOpenedMessage(dispute, this.p2PService.getAddress(), UUID.randomUUID().toString(), this.getSupportType(), trade.getSelf().getUpdatedMultisigHex(), trade.getArbitrator().getPaymentSentMessage());
        log.info("Send {} to peer {}. tradeId={}, openNewDisputeMessage.uid={}, chatMessage.uid={}", new Object[]{((Object)((Object)disputeOpenedMessage)).getClass().getSimpleName(), agentNodeAddress, disputeOpenedMessage.getTradeId(), disputeOpenedMessage.getUid(), chatMessage.getUid()});
        this.recordPendingMessage(((Object)((Object)disputeOpenedMessage)).getClass().getSimpleName());
        this.mailboxMessageService.sendEncryptedMailboxMessage(agentNodeAddress, dispute.getAgentPubKeyRing(), (MailboxMessage)disputeOpenedMessage, new SendMailboxMessageListener(){

            public void onArrived() {
                log.info("{} arrived at peer {}. tradeId={}, openNewDisputeMessage.uid={}, chatMessage.uid={}", new Object[]{((Object)((Object)disputeOpenedMessage)).getClass().getSimpleName(), agentNodeAddress, disputeOpenedMessage.getTradeId(), disputeOpenedMessage.getUid(), chatMessage.getUid()});
                DisputeManager.this.clearPendingMessage();
                chatMessage.setArrived(true);
                trade.advanceDisputeState(Trade.DisputeState.DISPUTE_REQUESTED);
                DisputeManager.this.persistNow(null);
                if (resultHandler != null) {
                    resultHandler.handleResult();
                }
            }

            public void onStoredInMailbox() {
                log.info("{} stored in mailbox for peer {}. tradeId={}, openNewDisputeMessage.uid={}, chatMessage.uid={}", new Object[]{((Object)((Object)disputeOpenedMessage)).getClass().getSimpleName(), agentNodeAddress, disputeOpenedMessage.getTradeId(), disputeOpenedMessage.getUid(), chatMessage.getUid()});
                DisputeManager.this.clearPendingMessage();
                chatMessage.setStoredInMailbox(true);
                trade.advanceDisputeState(Trade.DisputeState.DISPUTE_REQUESTED);
                trade.persistNow(null);
                DisputeManager.this.persistNow(null);
                if (resultHandler != null) {
                    resultHandler.handleResult();
                }
            }

            public void onFault(String errorMessage) {
                log.error("{} failed: Peer {}. tradeId={}, openNewDisputeMessage.uid={}, chatMessage.uid={}, errorMessage={}", new Object[]{((Object)((Object)disputeOpenedMessage)).getClass().getSimpleName(), agentNodeAddress, disputeOpenedMessage.getTradeId(), disputeOpenedMessage.getUid(), chatMessage.getUid(), errorMessage});
                DisputeManager.this.clearPendingMessage();
                chatMessage.setSendMessageError(errorMessage);
                trade.setDisputeState(Trade.DisputeState.NO_DISPUTE);
                DisputeManager.this.persistNow(null);
                faultHandler.handleFault("Sending dispute message failed: " + errorMessage, (Throwable)new DisputeMessageDeliveryFailedException());
            }
        });
        this.persistNow(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisputes(Trade trade) {
        T disputeList = this.getDisputeList();
        ObservableList observableList = disputeList.getObservableList();
        synchronized (observableList) {
            for (Dispute dispute : trade.getDisputes()) {
                disputeList.remove((PersistablePayload)dispute);
            }
        }
        trade.setDisputeState(Trade.DisputeState.NO_DISPUTE);
        this.clearPendingMessage();
        this.requestPersistence();
    }

    protected void handle(DisputeOpenedMessage message) {
        Dispute msgDispute = message.getDispute();
        log.info("Processing {} with trade {}, dispute {}", new Object[]{((Object)((Object)message)).getClass().getSimpleName(), msgDispute.getTradeId(), msgDispute.getId()});
        Trade trade = this.tradeManager.getTrade(msgDispute.getTradeId());
        if (trade == null) {
            log.warn("Ignoring DisputeOpenedMessage for trade {} because it does not exist", (Object)msgDispute.getTradeId());
            return;
        }
        Optional<Dispute> storedDisputeOptional = this.findDispute(msgDispute);
        boolean reOpen = storedDisputeOptional.isPresent();
        Dispute dispute = reOpen ? storedDisputeOptional.get() : msgDispute;
        ThreadUtils.execute(() -> {
            Object object = trade.getLock();
            synchronized (object) {
                ObservableList<ChatMessage> messages;
                PubKeyRing senderPubKeyRing;
                String errorMessage;
                block34: {
                    errorMessage = null;
                    senderPubKeyRing = null;
                    try {
                        TradePeer opener;
                        TradePeer sender;
                        T disputeList = this.getDisputeList();
                        if (disputeList == null) {
                            log.warn("disputes is null");
                            return;
                        }
                        dispute.setSupportType(message.getSupportType());
                        dispute.setState(Dispute.State.NEW);
                        Contract contract = dispute.getContract();
                        try {
                            DisputeValidation.validateDisputeData(dispute);
                            DisputeValidation.validateNodeAddresses(dispute, this.config);
                            DisputeValidation.validateSenderNodeAddress(dispute, message.getSenderNodeAddress(), this.config);
                        }
                        catch (DisputeValidation.ValidationException e) {
                            log.error(ExceptionUtils.getStackTrace((Throwable)e));
                            this.validationExceptions.add((Object)e);
                            throw e;
                        }
                        try {
                            DisputeValidation.validatePaymentAccountPayloads(dispute);
                        }
                        catch (Exception e) {
                            log.error(ExceptionUtils.getStackTrace((Throwable)e));
                            trade.prependErrorMessage(e.getMessage());
                            throw e;
                        }
                        if (trade.isArbitrator()) {
                            if (trade.getBuyer().getPaymentAccountPayload() == null) {
                                trade.getBuyer().setPaymentAccountPayload(dispute.getBuyerPaymentAccountPayload());
                            }
                            if (trade.getSeller().getPaymentAccountPayload() == null) {
                                trade.getSeller().setPaymentAccountPayload(dispute.getSellerPaymentAccountPayload());
                            }
                        }
                        if (reOpen) {
                            sender = trade.isArbitrator() ? trade.getTradePeer(message.getSenderNodeAddress()) : trade.getArbitrator();
                            senderPubKeyRing = sender.getPubKeyRing();
                        } else {
                            senderPubKeyRing = trade.isArbitrator() ? (dispute.isDisputeOpenerIsBuyer() ? contract.getBuyerPubKeyRing() : contract.getSellerPubKeyRing()) : trade.getArbitrator().getPubKeyRing();
                            sender = trade.getTradePeer(senderPubKeyRing);
                        }
                        if (sender == null) {
                            throw new RuntimeException("Pub key ring is not from arbitrator, buyer, or seller");
                        }
                        sender.setNodeAddress(message.getSenderNodeAddress());
                        if (!trade.isArbitrator() && sender != trade.getArbitrator()) {
                            throw new RuntimeException(((Object)((Object)message)).getClass().getSimpleName() + " to trader is expected only from arbitrator");
                        }
                        if (trade.isArbitrator() && message.getPaymentSentMessage() != null) {
                            HavenoUtils.verifyPaymentSentMessage(trade, message.getPaymentSentMessage());
                            trade.getBuyer().setUpdatedMultisigHex(message.getPaymentSentMessage().getUpdatedMultisigHex());
                            trade.advanceState(Trade.State.BUYER_SENT_PAYMENT_SENT_MSG);
                        }
                        TradePeer tradePeer = opener = sender == trade.getArbitrator() ? trade.getTradePeer() : sender;
                        if (message.getOpenerUpdatedMultisigHex() != null) {
                            opener.setUpdatedMultisigHex(message.getOpenerUpdatedMultisigHex());
                        }
                        if (!trade.isPayoutFinalized()) {
                            trade.syncAndPollWallet();
                            trade.recoverIfMissingWalletData();
                        }
                        if (trade.isPayoutPublished()) {
                            throw new RuntimeException("Ignoring DisputeOpenedMessage because payout is already published for " + trade.getClass().getSimpleName() + " " + trade.getId() + ", payoutTxId=" + trade.getPayoutTxId());
                        }
                        if (trade instanceof ArbitratorTrade) {
                            this.addPriceInfoMessage(dispute, 0);
                        }
                        T t = disputeList;
                        synchronized (t) {
                            if (!disputeList.contains((PersistablePayload)msgDispute)) {
                                if (!storedDisputeOptional.isPresent() || reOpen) {
                                    if (reOpen) {
                                        trade.setDisputeState(Trade.DisputeState.DISPUTE_OPENED);
                                    } else {
                                        disputeList.add((PersistablePayload)dispute);
                                        trade.advanceDisputeState(Trade.DisputeState.DISPUTE_OPENED);
                                    }
                                    trade.getBuyer().setUnsignedPayoutTxHex(null);
                                    trade.getSeller().setUnsignedPayoutTxHex(null);
                                    if (trade.isArbitrator()) {
                                        TradePeer senderPeer;
                                        TradePeer tradePeer2 = senderPeer = sender == trade.getMaker() ? trade.getTaker() : trade.getMaker();
                                        if (senderPeer != trade.getMaker() && senderPeer != trade.getTaker()) {
                                            throw new RuntimeException("Sender peer is not maker or taker, address=" + String.valueOf(senderPeer.getNodeAddress()));
                                        }
                                        this.sendDisputeOpenedMessageToPeer(dispute, contract, senderPeer.getPubKeyRing(), opener.getUpdatedMultisigHex());
                                    }
                                    this.tradeManager.requestPersistence();
                                    errorMessage = null;
                                } else {
                                    log.debug("We got a dispute already open for that trade and trading peer. TradeId = {}", (Object)dispute.getTradeId());
                                }
                            } else {
                                throw new RuntimeException("We got a dispute msg that we have already stored. TradeId = " + msgDispute.getTradeId());
                            }
                            this.addMediationResultMessage(dispute);
                        }
                    }
                    catch (Exception e) {
                        log.error(ExceptionUtils.getStackTrace((Throwable)e));
                        errorMessage = e.getMessage();
                        if (trade == null) break block34;
                        trade.setErrorMessage(errorMessage);
                    }
                }
                if (!(messages = message.getDispute().getChatMessages()).isEmpty()) {
                    ChatMessage msg = (ChatMessage)((Object)((Object)messages.get(messages.size() - 1)));
                    this.sendAckMessage(msg, senderPubKeyRing, errorMessage == null, errorMessage);
                }
                this.requestPersistence();
            }
        }, (String)trade.getId());
    }

    private void sendDisputeOpenedMessageToPeer(Dispute disputeFromOpener, Contract contractFromOpener, PubKeyRing pubKeyRing, String updatedMultisigHex) {
        log.info("{} sendPeerOpenedDisputeMessage() with trade {}, dispute {}", new Object[]{this.getClass().getSimpleName(), disputeFromOpener.getTradeId(), disputeFromOpener.getId()});
        UserThread.runAfter(() -> this.doSendPeerOpenedDisputeMessage(disputeFromOpener, contractFromOpener, pubKeyRing, updatedMultisigHex), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendPeerOpenedDisputeMessage(Dispute disputeFromOpener, Contract contractFromOpener, PubKeyRing pubKeyRing, String updatedMultisigHex) {
        boolean reOpen;
        T disputeList = this.getDisputeList();
        if (disputeList == null) {
            log.warn("disputes is null");
            return;
        }
        Dispute dispute = new Dispute(new Date().getTime(), disputeFromOpener.getTradeId(), pubKeyRing.hashCode(), false, disputeFromOpener.isDisputeOpenerIsBuyer(), disputeFromOpener.isDisputeOpenerIsMaker(), pubKeyRing, disputeFromOpener.getTradeDate().getTime(), disputeFromOpener.getTradePeriodEnd().getTime(), contractFromOpener, disputeFromOpener.getContractHash(), disputeFromOpener.getPayoutTxSerialized(), disputeFromOpener.getPayoutTxId(), disputeFromOpener.getContractAsJson(), disputeFromOpener.getMakerContractSignature(), disputeFromOpener.getTakerContractSignature(), disputeFromOpener.getMakerPaymentAccountPayload(), disputeFromOpener.getTakerPaymentAccountPayload(), disputeFromOpener.getAgentPubKeyRing(), disputeFromOpener.isSupportTicket(), disputeFromOpener.getSupportType());
        dispute.setExtraDataMap(disputeFromOpener.getExtraDataMap());
        dispute.setDelayedPayoutTxId(disputeFromOpener.getDelayedPayoutTxId());
        dispute.setDonationAddressOfDelayedPayoutTx(disputeFromOpener.getDonationAddressOfDelayedPayoutTx());
        Optional<Dispute> storedDisputeOptional = this.findDispute(dispute);
        if (storedDisputeOptional.isPresent() && !storedDisputeOptional.get().isClosed()) {
            log.info("We got a dispute already open for that trade and trading peer. TradeId = {}", (Object)dispute.getTradeId());
            return;
        }
        String disputeInfo = this.getDisputeInfo(dispute);
        String disputeMessage = this.getDisputeIntroForPeer(disputeInfo);
        String sysMsg = dispute.isSupportTicket() ? Res.get("support.peerOpenedTicket", disputeInfo, "1.2.2") : disputeMessage;
        final ChatMessage chatMessage = new ChatMessage(this.getSupportType(), dispute.getTradeId(), pubKeyRing.hashCode(), false, Res.get("support.systemMsg", sysMsg), this.p2PService.getAddress());
        chatMessage.setSystemMessage(true);
        dispute.addAndPersistChatMessage(chatMessage);
        this.addPriceInfoMessage(dispute, 0);
        boolean bl = reOpen = storedDisputeOptional.isPresent() && storedDisputeOptional.get().isClosed();
        if (reOpen) {
            dispute = storedDisputeOptional.get();
            dispute.reOpen();
        } else {
            T t = disputeList;
            synchronized (t) {
                disputeList.add((PersistablePayload)dispute);
            }
        }
        Trade trade = this.tradeManager.getTrade(dispute.getTradeId());
        if (trade == null) {
            log.warn("Dispute trade {} does not exist", (Object)dispute.getTradeId());
            return;
        }
        TradePeer peer = trade.getTradePeer(pubKeyRing);
        PubKeyRing peersPubKeyRing = peer.getPubKeyRing();
        final NodeAddress peersNodeAddress = peer.getNodeAddress();
        final DisputeOpenedMessage peerOpenedDisputeMessage = new DisputeOpenedMessage(dispute, this.p2PService.getAddress(), UUID.randomUUID().toString(), this.getSupportType(), updatedMultisigHex, trade.getArbitrator().getPaymentSentMessage());
        log.info("Send {} to peer {}. tradeId={}, peerOpenedDisputeMessage.uid={}, chatMessage.uid={}", new Object[]{((Object)((Object)peerOpenedDisputeMessage)).getClass().getSimpleName(), peersNodeAddress, peerOpenedDisputeMessage.getTradeId(), peerOpenedDisputeMessage.getUid(), chatMessage.getUid()});
        this.recordPendingMessage(((Object)((Object)peerOpenedDisputeMessage)).getClass().getSimpleName());
        this.mailboxMessageService.sendEncryptedMailboxMessage(peersNodeAddress, peersPubKeyRing, (MailboxMessage)peerOpenedDisputeMessage, new SendMailboxMessageListener(){

            public void onArrived() {
                log.info("{} arrived at peer {}. tradeId={}, peerOpenedDisputeMessage.uid={}, chatMessage.uid={}", new Object[]{((Object)((Object)peerOpenedDisputeMessage)).getClass().getSimpleName(), peersNodeAddress, peerOpenedDisputeMessage.getTradeId(), peerOpenedDisputeMessage.getUid(), chatMessage.getUid()});
                DisputeManager.this.clearPendingMessage();
                chatMessage.setArrived(true);
                DisputeManager.this.persistNow(null);
            }

            public void onStoredInMailbox() {
                log.info("{} stored in mailbox for peer {}. tradeId={}, peerOpenedDisputeMessage.uid={}, chatMessage.uid={}", new Object[]{((Object)((Object)peerOpenedDisputeMessage)).getClass().getSimpleName(), peersNodeAddress, peerOpenedDisputeMessage.getTradeId(), peerOpenedDisputeMessage.getUid(), chatMessage.getUid()});
                DisputeManager.this.clearPendingMessage();
                chatMessage.setStoredInMailbox(true);
                DisputeManager.this.persistNow(null);
            }

            public void onFault(String errorMessage) {
                log.error("{} failed: Peer {}. tradeId={}, peerOpenedDisputeMessage.uid={}, chatMessage.uid={}, errorMessage={}", new Object[]{((Object)((Object)peerOpenedDisputeMessage)).getClass().getSimpleName(), peersNodeAddress, peerOpenedDisputeMessage.getTradeId(), peerOpenedDisputeMessage.getUid(), chatMessage.getUid(), errorMessage});
                DisputeManager.this.clearPendingMessage();
                chatMessage.setSendMessageError(errorMessage);
                DisputeManager.this.persistNow(null);
            }
        });
        this.persistNow(null);
    }

    public void closeDisputeTicket(final DisputeResult disputeResult, final Dispute dispute, String summaryText, final ResultHandler resultHandler, final FaultHandler faultHandler) {
        try {
            boolean exists;
            final Trade trade = this.tradeManager.getTrade(dispute.getTradeId());
            if (trade == null) {
                throw new RuntimeException("Dispute trade " + dispute.getTradeId() + " does not exist");
            }
            boolean bl = exists = disputeResult.getChatMessage() != null && disputeResult.getChatMessage().getMessage() != null && !disputeResult.getChatMessage().getMessage().isEmpty();
            if (!exists) {
                ChatMessage chatMessage = new ChatMessage(this.getSupportType(), dispute.getTradeId(), dispute.getTraderPubKeyRing().hashCode(), false, summaryText, this.p2PService.getAddress());
                disputeResult.setChatMessage(chatMessage);
                dispute.addAndPersistChatMessage(chatMessage);
            }
            final TradePeer receiver = trade.getTradePeer(dispute.getTraderPubKeyRing());
            if (!trade.isPayoutPublished() && receiver.getUpdatedMultisigHex() != null && receiver.getUnsignedPayoutTxHex() == null) {
                this.createDisputePayoutTx(trade, dispute.getContract(), disputeResult, true);
            }
            TradePeer receiverPeer = receiver == trade.getBuyer() ? trade.getSeller() : trade.getBuyer();
            boolean deferPublishPayout = !exists && receiver.getUnsignedPayoutTxHex() != null && receiverPeer.getUpdatedMultisigHex() != null && (trade.getDisputeState() == Trade.DisputeState.ARBITRATOR_SENT_DISPUTE_CLOSED_MSG || trade.getDisputeState().ordinal() >= Trade.DisputeState.ARBITRATOR_SAW_ARRIVED_DISPUTE_CLOSED_MSG.ordinal());
            final DisputeClosedMessage disputeClosedMessage = new DisputeClosedMessage(disputeResult, this.p2PService.getAddress(), UUID.randomUUID().toString(), this.getSupportType(), trade.getSelf().getUpdatedMultisigHex(), receiver.getUnsignedPayoutTxHex(), deferPublishPayout);
            receiverPeer.setDisputeClosedMessage(disputeClosedMessage);
            log.info("Send {} to trader {}. tradeId={}, {}.uid={}, chatMessage.uid={}", new Object[]{((Object)((Object)disputeClosedMessage)).getClass().getSimpleName(), receiver.getNodeAddress(), ((Object)((Object)disputeClosedMessage)).getClass().getSimpleName(), disputeClosedMessage.getTradeId(), disputeClosedMessage.getUid(), disputeResult.getChatMessage().getUid()});
            this.recordPendingMessage(((Object)((Object)disputeClosedMessage)).getClass().getSimpleName());
            this.mailboxMessageService.sendEncryptedMailboxMessage(receiver.getNodeAddress(), dispute.getTraderPubKeyRing(), (MailboxMessage)disputeClosedMessage, new SendMailboxMessageListener(){

                public void onArrived() {
                    log.info("{} arrived at trader {}. tradeId={}, disputeClosedMessage.uid={}, chatMessage.uid={}", new Object[]{((Object)((Object)disputeClosedMessage)).getClass().getSimpleName(), receiver.getNodeAddress(), disputeClosedMessage.getTradeId(), disputeClosedMessage.getUid(), disputeResult.getChatMessage().getUid()});
                    DisputeManager.this.clearPendingMessage();
                    dispute.setIsClosed();
                    disputeResult.getChatMessage().setArrived(true);
                    trade.advanceDisputeState(Trade.DisputeState.ARBITRATOR_SAW_ARRIVED_DISPUTE_CLOSED_MSG);
                    trade.pollWalletNormallyForMs(60000L);
                    DisputeManager.this.requestPersistence(trade);
                    resultHandler.handleResult();
                }

                public void onStoredInMailbox() {
                    log.info("{} stored in mailbox for trader {}. tradeId={}, DisputeClosedMessage.uid={}, chatMessage.uid={}", new Object[]{((Object)((Object)disputeClosedMessage)).getClass().getSimpleName(), receiver.getNodeAddress(), disputeClosedMessage.getTradeId(), disputeClosedMessage.getUid(), disputeResult.getChatMessage().getUid()});
                    DisputeManager.this.clearPendingMessage();
                    dispute.setIsClosed();
                    disputeResult.getChatMessage().setStoredInMailbox(true);
                    Trade trade2 = DisputeManager.this.tradeManager.getTrade(dispute.getTradeId());
                    trade2.advanceDisputeState(Trade.DisputeState.ARBITRATOR_STORED_IN_MAILBOX_DISPUTE_CLOSED_MSG);
                    DisputeManager.this.requestPersistence(trade2);
                    resultHandler.handleResult();
                }

                public void onFault(String errorMessage) {
                    log.error("{} failed: Trader {}. tradeId={}, DisputeClosedMessage.uid={}, chatMessage.uid={}, errorMessage={}", new Object[]{((Object)((Object)disputeClosedMessage)).getClass().getSimpleName(), receiver.getNodeAddress(), disputeClosedMessage.getTradeId(), disputeClosedMessage.getUid(), disputeResult.getChatMessage().getUid(), errorMessage});
                    DisputeManager.this.clearPendingMessage();
                    disputeResult.getChatMessage().setSendMessageError(errorMessage);
                    trade.advanceDisputeState(Trade.DisputeState.ARBITRATOR_SEND_FAILED_DISPUTE_CLOSED_MSG);
                    DisputeManager.this.requestPersistence(trade);
                    faultHandler.handleFault(errorMessage, (Throwable)new RuntimeException(errorMessage));
                }
            });
            trade.advanceDisputeState(Trade.DisputeState.ARBITRATOR_SENT_DISPUTE_CLOSED_MSG);
            this.requestPersistence(trade);
        }
        catch (Exception e) {
            faultHandler.handleFault(e.getMessage(), (Throwable)e);
        }
    }

    public MoneroTxWallet createDisputePayoutTx(Trade trade, Contract contract, DisputeResult disputeResult, boolean updateState) {
        trade.importMultisigHex();
        trade.syncAndPollWallet();
        trade.recoverIfMissingWalletData();
        String alreadyPublishedMsg = "Cannot create dispute payout tx because payout tx is already published for trade " + trade.getId();
        if (trade.isPayoutPublished()) {
            throw new RuntimeException(alreadyPublishedMsg);
        }
        if (updateState) {
            log.info("Creating unsigned dispute payout tx for trade {}", (Object)trade.getId());
        }
        try {
            BigInteger loserPayoutAmount;
            if (trade.getWallet().isMultisigImportNeeded()) {
                throw new RuntimeException("Arbitrator's wallet needs updated multisig hex to create payout tx which means a trader must have already broadcast the payout tx for trade " + trade.getId());
            }
            if (disputeResult.getBuyerPayoutAmountBeforeCost().compareTo(BigInteger.ZERO) < 0) {
                throw new RuntimeException("Buyer payout cannot be negative");
            }
            if (disputeResult.getSellerPayoutAmountBeforeCost().compareTo(BigInteger.ZERO) < 0) {
                throw new RuntimeException("Seller payout cannot be negative");
            }
            if (disputeResult.getBuyerPayoutAmountBeforeCost().add(disputeResult.getSellerPayoutAmountBeforeCost()).compareTo(trade.getWallet().getUnlockedBalance()) > 0) {
                throw new RuntimeException("The payout amounts are more than the wallet's unlocked balance, unlocked balance=" + String.valueOf(trade.getWallet().getUnlockedBalance()) + " vs " + String.valueOf(disputeResult.getBuyerPayoutAmountBeforeCost()) + " + " + String.valueOf(disputeResult.getSellerPayoutAmountBeforeCost()) + " = " + String.valueOf(disputeResult.getBuyerPayoutAmountBeforeCost().add(disputeResult.getSellerPayoutAmountBeforeCost())));
            }
            MoneroTxConfig txConfig = new MoneroTxConfig().setAccountIndex(Integer.valueOf(0));
            String buyerPayoutAddress = contract.isBuyerMakerAndSellerTaker() ? contract.getMakerPayoutAddressString() : contract.getTakerPayoutAddressString();
            String sellerPayoutAddress = contract.isBuyerMakerAndSellerTaker() ? contract.getTakerPayoutAddressString() : contract.getMakerPayoutAddressString();
            txConfig.setPriority(XmrWalletService.PROTOCOL_FEE_PRIORITY);
            if (disputeResult.getBuyerPayoutAmountBeforeCost().compareTo(BigInteger.ZERO) > 0) {
                txConfig.addDestination(buyerPayoutAddress, disputeResult.getBuyerPayoutAmountBeforeCost());
            }
            if (disputeResult.getSellerPayoutAmountBeforeCost().compareTo(BigInteger.ZERO) > 0) {
                txConfig.addDestination(sellerPayoutAddress, disputeResult.getSellerPayoutAmountBeforeCost());
            }
            BigInteger bigInteger = loserPayoutAmount = disputeResult.getWinner() == DisputeResult.Winner.BUYER ? disputeResult.getSellerPayoutAmountBeforeCost() : disputeResult.getBuyerPayoutAmountBeforeCost();
            if (loserPayoutAmount.equals(BigInteger.ZERO)) {
                txConfig.setSubtractFeeFrom(new Integer[]{0});
            } else {
                switch (disputeResult.getSubtractFeeFrom()) {
                    case BUYER_AND_SELLER: {
                        txConfig.setSubtractFeeFrom(new Integer[]{0, 1});
                        break;
                    }
                    case BUYER_ONLY: {
                        txConfig.setSubtractFeeFrom(new Integer[]{0});
                        break;
                    }
                    case SELLER_ONLY: {
                        txConfig.setSubtractFeeFrom(new Integer[]{1});
                    }
                }
            }
            MoneroTxWallet payoutTx = trade.createDisputePayoutTx(txConfig);
            if (updateState) {
                trade.getProcessModel().setUnsignedPayoutTx(payoutTx);
                trade.setPayoutTx((MoneroTx)payoutTx);
                if (trade.getBuyer().getUpdatedMultisigHex() != null) {
                    trade.getBuyer().setUnsignedPayoutTxHex(payoutTx.getTxSet().getMultisigTxHex());
                }
                if (trade.getSeller().getUpdatedMultisigHex() != null) {
                    trade.getSeller().setUnsignedPayoutTxHex(payoutTx.getTxSet().getMultisigTxHex());
                }
            }
            trade.requestPersistence();
            return payoutTx;
        }
        catch (Exception e) {
            trade.syncAndPollWallet();
            if (trade.isPayoutPublished()) {
                throw new IllegalStateException(alreadyPublishedMsg);
            }
            throw e;
        }
        catch (AssertionError e) {
            trade.syncAndPollWallet();
            if (trade.isPayoutPublished()) {
                throw new IllegalStateException(alreadyPublishedMsg);
            }
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    private Tuple2<NodeAddress, PubKeyRing> getNodeAddressPubKeyRingTuple(Dispute dispute) {
        PubKeyRing receiverPubKeyRing = null;
        NodeAddress peerNodeAddress = null;
        if (this.isTrader(dispute)) {
            receiverPubKeyRing = dispute.getAgentPubKeyRing();
            peerNodeAddress = this.getAgentNodeAddress(dispute);
        } else if (this.isAgent(dispute)) {
            receiverPubKeyRing = dispute.getTraderPubKeyRing();
            Contract contract = dispute.getContract();
            peerNodeAddress = contract.getBuyerPubKeyRing().equals((Object)receiverPubKeyRing) ? contract.getBuyerNodeAddress() : contract.getSellerNodeAddress();
        } else {
            log.error("That must not happen. Trader cannot communicate to other trader.");
        }
        return new Tuple2((Object)peerNodeAddress, (Object)receiverPubKeyRing);
    }

    public boolean isAgent(Dispute dispute) {
        return this.keyRing.getPubKeyRing().equals((Object)dispute.getAgentPubKeyRing());
    }

    public Optional<Dispute> findDispute(Dispute dispute) {
        return this.findDispute(dispute.getTradeId(), dispute.getTraderId());
    }

    public Optional<Dispute> findDispute(DisputeResult disputeResult) {
        ChatMessage chatMessage = disputeResult.getChatMessage();
        Preconditions.checkNotNull((Object)((Object)chatMessage), (Object)"chatMessage must not be null");
        return this.findDispute(disputeResult.getTradeId(), disputeResult.getTraderId());
    }

    public Optional<Dispute> findDispute(ChatMessage message) {
        return this.findDispute(message.getTradeId(), message.getTraderId());
    }

    public Optional<Dispute> findDispute(String tradeId, int traderId) {
        T disputeList = this.getDisputeList();
        if (disputeList == null) {
            log.warn("disputes is null");
            return Optional.empty();
        }
        return disputeList.stream().filter(e -> e.getTradeId().equals(tradeId) && e.getTraderId() == traderId).findAny();
    }

    public Optional<Dispute> findDispute(String tradeId) {
        T disputeList = this.getDisputeList();
        if (disputeList == null) {
            log.warn("disputes is null");
            return Optional.empty();
        }
        return disputeList.stream().filter(e -> e.getTradeId().equals(tradeId)).findAny();
    }

    public List<Dispute> findDisputes(String tradeId) {
        T disputeList = this.getDisputeList();
        if (disputeList == null) {
            return new ArrayList<Dispute>();
        }
        return disputeList.stream().filter(e -> e.getTradeId().equals(tradeId)).collect(Collectors.toList());
    }

    public Optional<Dispute> findDisputeById(String disputeId) {
        T disputeList = this.getDisputeList();
        if (disputeList == null) {
            log.warn("disputes is null");
            return Optional.empty();
        }
        return disputeList.stream().filter(e -> e.getId().equals(disputeId)).findAny();
    }

    public Optional<Trade> findTrade(Dispute dispute) {
        Optional<Trade> retVal = this.tradeManager.getOpenTrade(dispute.getTradeId());
        if (!retVal.isPresent()) {
            retVal = this.tradeManager.getClosedTrade(dispute.getTradeId());
        }
        return retVal;
    }

    public boolean canSendChatMessages(Dispute dispute) {
        if (dispute.isClosed()) {
            return false;
        }
        Optional<Trade> tradeOptional = this.findTrade(dispute);
        if (!tradeOptional.isPresent()) {
            return false;
        }
        Trade trade = tradeOptional.get();
        if (trade.isPayoutPublished()) {
            return false;
        }
        if (trade.getDisputeState() == Trade.DisputeState.DISPUTE_REQUESTED) {
            for (ChatMessage msg : dispute.getChatMessages()) {
                if (!Boolean.TRUE.equals(msg.getStoredInMailboxProperty().get())) continue;
                return true;
            }
        }
        return trade.getDisputeState().isOpen();
    }

    private void addMediationResultMessage(Dispute dispute) {
        if (dispute.getMediatorsDisputeResult() != null) {
            String mediatorsDisputeResult = Res.get("support.mediatorsDisputeSummary", dispute.getMediatorsDisputeResult());
            ChatMessage mediatorsDisputeClosedMessage = new ChatMessage(this.getSupportType(), dispute.getTradeId(), this.keyRing.getPubKeyRing().hashCode(), false, mediatorsDisputeResult, this.p2PService.getAddress());
            mediatorsDisputeClosedMessage.setSystemMessage(true);
            dispute.addAndPersistChatMessage(mediatorsDisputeClosedMessage);
            this.requestPersistence();
        }
    }

    public void addMediationReOpenedMessage(Dispute dispute, boolean senderIsTrader) {
        ChatMessage chatMessage = new ChatMessage(this.getSupportType(), dispute.getTradeId(), dispute.getTraderId(), senderIsTrader, Res.get("support.info.disputeReOpened"), this.p2PService.getAddress());
        chatMessage.setSystemMessage(false);
        dispute.addAndPersistChatMessage(chatMessage);
        this.sendChatMessage(chatMessage);
        this.requestPersistence();
    }

    protected void addMediationLogsReceivedMessage(Dispute dispute, String logsIdentifier) {
        String logsReceivedMessage = Res.get("support.mediatorReceivedLogs", logsIdentifier);
        ChatMessage chatMessage = new ChatMessage(this.getSupportType(), dispute.getTradeId(), this.keyRing.hashCode(), false, logsReceivedMessage, this.p2PService.getAddress());
        chatMessage.setSystemMessage(true);
        dispute.addAndPersistChatMessage(chatMessage);
        this.requestPersistence();
    }

    protected void addPriceInfoMessage(Dispute dispute, int counter) {
        String optionTradeDetails;
        String headline;
        if (!this.priceFeedService.hasExternalPrices()) {
            if (counter < 3) {
                log.info("Price provider has still no data. This is expected at startup. We try again in 10 sec.");
                UserThread.runAfter(() -> this.addPriceInfoMessage(dispute, counter + 1), (long)10L);
            } else {
                log.warn("Price provider still has no data after 3 repeated requests and 30 seconds delay. We give up.");
            }
            return;
        }
        Contract contract = dispute.getContract();
        OfferPayload offerPayload = contract.getOfferPayload();
        Price priceAtDisputeOpening = this.getPrice(offerPayload.getCurrencyCode());
        if (priceAtDisputeOpening == null) {
            log.info("Price provider did not provide a price for {}. This is expected if this currency is not supported by the price providers.", (Object)offerPayload.getCurrencyCode());
            return;
        }
        BigInteger potentialAmountAtDisputeOpening = priceAtDisputeOpening.getAmountByVolume(contract.getTradeVolume());
        BigInteger buyerSecurityDeposit = offerPayload.getMaxBuyerSecurityDeposit();
        BigInteger minRefundAtMediatedDispute = Restrictions.getMinRefundAtMediatedDispute();
        BigInteger maxLossSecDeposit = buyerSecurityDeposit.subtract(minRefundAtMediatedDispute);
        BigInteger tradeAmount = contract.getTradeAmount();
        BigInteger potentialGain = potentialAmountAtDisputeOpening.subtract(tradeAmount).subtract(maxLossSecDeposit);
        if (potentialGain.compareTo(BigInteger.ZERO) > 0) {
            headline = "This might be a potential option trade!";
            optionTradeDetails = "\nBTC amount calculated with price at dispute opening: " + HavenoUtils.formatXmr(potentialAmountAtDisputeOpening, true) + "\nMax loss of security deposit is: " + HavenoUtils.formatXmr(maxLossSecDeposit, true) + "\nPossible gain from an option trade is: " + HavenoUtils.formatXmr(potentialGain, true);
        } else {
            headline = "It does not appear to be an option trade.";
            optionTradeDetails = "\nBTC amount calculated with price at dispute opening: " + HavenoUtils.formatXmr(potentialAmountAtDisputeOpening, true) + "\nMax loss of security deposit is: " + HavenoUtils.formatXmr(maxLossSecDeposit, true) + "\nPossible loss from an option trade is: " + HavenoUtils.formatXmr(potentialGain.multiply(BigInteger.valueOf(-1L)), true);
        }
        String percentagePriceDetails = offerPayload.isUseMarketBasedPrice() ? " (market based price was used: " + offerPayload.getMarketPriceMarginPct() * 100.0 + "%)" : " (fix price was used)";
        String priceInfoText = "System message: " + headline + "\n\nTrade price: " + contract.getPrice().toFriendlyString() + percentagePriceDetails + "\nTrade amount: " + HavenoUtils.formatXmr(tradeAmount, true) + "\nPrice at dispute opening: " + priceAtDisputeOpening.toFriendlyString() + optionTradeDetails;
        ChatMessage priceInfoMessage = new ChatMessage(this.getSupportType(), dispute.getTradeId(), this.keyRing.getPubKeyRing().hashCode(), false, priceInfoText, this.p2PService.getAddress());
        priceInfoMessage.setSystemMessage(true);
        dispute.addAndPersistChatMessage(priceInfoMessage);
        this.requestPersistence();
    }

    @Nullable
    private Price getPrice(String currencyCode) {
        MarketPrice marketPrice = this.priceFeedService.getMarketPrice(currencyCode);
        if (marketPrice != null && marketPrice.isRecentExternalPriceAvailable()) {
            double marketPriceAsDouble = marketPrice.getPrice();
            try {
                int precision = CurrencyUtil.isTraditionalCurrency(currencyCode) ? 8 : 8;
                double scaled = MathUtils.scaleUpByPowerOf10((double)marketPriceAsDouble, (int)precision);
                long roundedToLong = MathUtils.roundDoubleToLong((double)scaled);
                return Price.valueOf(currencyCode, roundedToLong);
            }
            catch (Exception e) {
                log.error("Exception at getPrice / parseToFiat: " + e.toString());
                return null;
            }
        }
        return null;
    }

    public boolean hasPendingMessageAtShutdown() {
        if (this.pendingOutgoingMessage.length() > 0) {
            log.warn("{} has an outgoing message pending: {}", (Object)this.getClass().getSimpleName(), (Object)this.pendingOutgoingMessage);
            return true;
        }
        return false;
    }

    private void recordPendingMessage(String className) {
        this.pendingOutgoingMessage = className;
    }

    private void clearPendingMessage() {
        this.pendingOutgoingMessage = "";
    }

    public ObservableList<DisputeValidation.ValidationException> getValidationExceptions() {
        return this.validationExceptions;
    }
}

