/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.support;

import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.crypto.PubKeyRing;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.core.api.CoreNotificationService;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Res;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.messages.ChatMessage;
import haveno.core.support.messages.SupportMessage;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.SendMailboxMessageListener;
import haveno.network.p2p.mailbox.MailboxMessage;
import haveno.network.p2p.mailbox.MailboxMessageService;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SupportManager {
    private static final Logger log = LoggerFactory.getLogger(SupportManager.class);
    protected final P2PService p2PService;
    protected final TradeManager tradeManager;
    protected final XmrConnectionService xmrConnectionService;
    protected final XmrWalletService xmrWalletService;
    protected final CoreNotificationService notificationService;
    protected final Map<String, Timer> delayMsgMap = new HashMap<String, Timer>();
    private final Object lock = new Object();
    private final CopyOnWriteArraySet<DecryptedMessageWithPubKey> decryptedMailboxMessageWithPubKeys = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<DecryptedMessageWithPubKey> decryptedDirectMessageWithPubKeys = new CopyOnWriteArraySet();
    protected final MailboxMessageService mailboxMessageService;
    private boolean allServicesInitialized;

    public SupportManager(P2PService p2PService, XmrConnectionService xmrConnectionService, XmrWalletService xmrWalletService, CoreNotificationService notificationService, TradeManager tradeManager) {
        this.p2PService = p2PService;
        this.xmrConnectionService = xmrConnectionService;
        this.xmrWalletService = xmrWalletService;
        this.mailboxMessageService = p2PService.getMailboxMessageService();
        this.notificationService = notificationService;
        this.tradeManager = tradeManager;
        p2PService.addDecryptedDirectMessageListener((decryptedMessageWithPubKey, senderAddress) -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.isReady()) {
                    this.applyDirectMessage(decryptedMessageWithPubKey);
                } else {
                    this.decryptedDirectMessageWithPubKeys.add(decryptedMessageWithPubKey);
                    this.tryApplyMessages();
                }
            }
        });
        this.mailboxMessageService.addDecryptedMailboxListener((decryptedMessageWithPubKey, senderAddress) -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.isReady()) {
                    this.applyMailboxMessage(decryptedMessageWithPubKey);
                } else {
                    this.decryptedDirectMessageWithPubKeys.add(decryptedMessageWithPubKey);
                    this.tryApplyMessages();
                }
            }
        });
    }

    protected abstract void onSupportMessage(SupportMessage var1);

    public abstract NodeAddress getPeerNodeAddress(ChatMessage var1);

    public abstract PubKeyRing getPeerPubKeyRing(ChatMessage var1);

    public abstract SupportType getSupportType();

    public abstract boolean channelOpen(ChatMessage var1);

    public abstract List<ChatMessage> getAllChatMessages(String var1);

    public abstract void addAndPersistChatMessage(ChatMessage var1);

    public abstract void requestPersistence();

    public abstract void persistNow(@Nullable Runnable var1);

    public boolean isBootstrapped() {
        return this.p2PService.isBootstrapped();
    }

    public NodeAddress getMyAddress() {
        return this.p2PService.getAddress();
    }

    public void onAllServicesInitialized() {
        this.allServicesInitialized = true;
    }

    public void tryApplyMessages() {
        if (this.isReady()) {
            this.applyMessages();
        }
    }

    protected void handle(ChatMessage chatMessage) {
        String tradeId = chatMessage.getTradeId();
        String uid = chatMessage.getUid();
        log.info("Received {} from peer {}. tradeId={}, uid={}", new Object[]{((Object)((Object)chatMessage)).getClass().getSimpleName(), chatMessage.getSenderNodeAddress(), tradeId, uid});
        boolean channelOpen = this.channelOpen(chatMessage);
        if (!channelOpen) {
            log.warn("We got a chatMessage but we don't have a matching chat. TradeId = " + tradeId);
            if (!this.delayMsgMap.containsKey(uid)) {
                Timer timer = UserThread.runAfter(() -> this.handle(chatMessage), (long)1L);
                this.delayMsgMap.put(uid, timer);
            } else {
                String msg = "We got a chatMessage after we already repeated to apply the message after a delay. That should never happen. TradeId = " + tradeId;
                log.warn(msg);
            }
            return;
        }
        this.cleanupRetryMap(uid);
        PubKeyRing receiverPubKeyRing = this.getPeerPubKeyRing(chatMessage);
        this.addAndPersistChatMessage(chatMessage);
        this.notificationService.sendChatNotification(chatMessage);
        if (receiverPubKeyRing != null) {
            this.sendAckMessage(chatMessage, receiverPubKeyRing, true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAckMessage(AckMessage ackMessage) {
        if (ackMessage.getSourceType() == this.getAckMessageSourceType()) {
            if (ackMessage.isSuccess()) {
                log.info("Received AckMessage for {} with tradeId {} and uid {}", new Object[]{ackMessage.getSourceMsgClassName(), ackMessage.getSourceId(), ackMessage.getSourceUid()});
                if (ackMessage.getSourceMsgClassName().equals(ChatMessage.class.getSimpleName())) {
                    Trade trade = this.tradeManager.getTrade(ackMessage.getSourceId());
                    for (Dispute dispute : trade.getDisputes()) {
                        ObservableList<ChatMessage> observableList = dispute.getChatMessages();
                        synchronized (observableList) {
                            for (ChatMessage chatMessage : dispute.getChatMessages()) {
                                if (!chatMessage.getUid().equals(ackMessage.getSourceUid())) continue;
                                if (trade.getDisputeState() == Trade.DisputeState.DISPUTE_PREPARING || trade.getDisputeState() == Trade.DisputeState.DISPUTE_REQUESTED) {
                                    if (dispute.isClosed()) {
                                        dispute.reOpen();
                                    }
                                    trade.advanceDisputeState(Trade.DisputeState.DISPUTE_OPENED);
                                    continue;
                                }
                                if (!dispute.isClosed()) continue;
                                trade.pollWalletNormallyForMs(60000L);
                            }
                        }
                    }
                }
            } else {
                log.warn("Received AckMessage with error state for {} with tradeId={}, sender={}, errorMessage={}", new Object[]{ackMessage.getSourceMsgClassName(), ackMessage.getSourceId(), ackMessage.getSenderNodeAddress(), ackMessage.getErrorMessage()});
                if (ackMessage.getSourceMsgClassName().equals(ChatMessage.class.getSimpleName())) {
                    Trade trade = this.tradeManager.getTrade(ackMessage.getSourceId());
                    for (Dispute dispute : trade.getDisputes()) {
                        ObservableList<ChatMessage> observableList = dispute.getChatMessages();
                        synchronized (observableList) {
                            for (ChatMessage chatMessage : dispute.getChatMessages()) {
                                if (!chatMessage.getUid().equals(ackMessage.getSourceUid()) || trade.isArbitrator() || !trade.getDisputeState().isRequested() && !trade.getDisputeState().isCloseRequested()) continue;
                                log.warn("DisputeOpenedMessage was nacked. We close the dispute now. tradeId={}, nack sender={}", (Object)trade.getId(), (Object)ackMessage.getSenderNodeAddress());
                                dispute.setIsClosed();
                                trade.advanceDisputeState(Trade.DisputeState.DISPUTE_CLOSED);
                            }
                        }
                    }
                }
            }
            this.getAllChatMessages(ackMessage.getSourceId()).stream().filter(msg -> msg.getUid().equals(ackMessage.getSourceUid())).forEach(msg -> UserThread.execute(() -> {
                if (ackMessage.isSuccess()) {
                    msg.setAcknowledged(true);
                } else {
                    msg.setAckError(ackMessage.getErrorMessage());
                }
            }));
            this.tradeManager.persistNow(null);
            this.persistNow(null);
            this.requestPersistence();
        }
    }

    protected abstract AckMessageSourceType getAckMessageSourceType();

    public ChatMessage sendChatMessage(final ChatMessage message) {
        final NodeAddress peersNodeAddress = this.getPeerNodeAddress(message);
        PubKeyRing receiverPubKeyRing = this.getPeerPubKeyRing(message);
        if (peersNodeAddress == null || receiverPubKeyRing == null) {
            UserThread.runAfter(() -> message.setSendMessageError(Res.get("support.receiverNotKnown")), (long)1L);
        } else {
            log.info("Send {} to peer {}. tradeId={}, uid={}", new Object[]{((Object)((Object)message)).getClass().getSimpleName(), peersNodeAddress, message.getTradeId(), message.getUid()});
            this.mailboxMessageService.sendEncryptedMailboxMessage(peersNodeAddress, receiverPubKeyRing, (MailboxMessage)message.copy(), new SendMailboxMessageListener(){

                public void onArrived() {
                    log.info("{} arrived at peer {}. tradeId={}, uid={}", new Object[]{((Object)((Object)message)).getClass().getSimpleName(), peersNodeAddress, message.getTradeId(), message.getUid()});
                    message.setArrived(true);
                    SupportManager.this.requestPersistence();
                }

                public void onStoredInMailbox() {
                    log.info("{} stored in mailbox for peer {}. tradeId={}, uid={}", new Object[]{((Object)((Object)message)).getClass().getSimpleName(), peersNodeAddress, message.getTradeId(), message.getUid()});
                    message.setStoredInMailbox(true);
                    SupportManager.this.requestPersistence();
                }

                public void onFault(String errorMessage) {
                    log.error("{} failed: Peer {}. tradeId={}, uid={}, errorMessage={}", new Object[]{((Object)((Object)message)).getClass().getSimpleName(), peersNodeAddress, message.getTradeId(), message.getUid(), errorMessage});
                    message.setSendMessageError(errorMessage);
                    SupportManager.this.requestPersistence();
                }
            });
        }
        return message;
    }

    protected void sendAckMessage(SupportMessage supportMessage, PubKeyRing peersPubKeyRing, boolean result, @Nullable String errorMessage) {
        final String tradeId = supportMessage.getTradeId();
        final String uid = supportMessage.getUid();
        final AckMessage ackMessage = new AckMessage(this.p2PService.getNetworkNode().getNodeAddress(), this.getAckMessageSourceType(), ((Object)((Object)supportMessage)).getClass().getSimpleName(), uid, tradeId, result, errorMessage);
        final NodeAddress peersNodeAddress = supportMessage.getSenderNodeAddress();
        log.info("Send AckMessage for {} to peer {}. tradeId={}, uid={}", new Object[]{ackMessage.getSourceMsgClassName(), peersNodeAddress, tradeId, uid});
        this.mailboxMessageService.sendEncryptedMailboxMessage(peersNodeAddress, peersPubKeyRing, (MailboxMessage)ackMessage, new SendMailboxMessageListener(){

            public void onArrived() {
                log.info("AckMessage for {} arrived at peer {}. tradeId={}, uid={}", new Object[]{ackMessage.getSourceMsgClassName(), peersNodeAddress, tradeId, uid});
            }

            public void onStoredInMailbox() {
                log.info("AckMessage for {} stored in mailbox for peer {}. tradeId={}, uid={}", new Object[]{ackMessage.getSourceMsgClassName(), peersNodeAddress, tradeId, uid});
            }

            public void onFault(String errorMessage) {
                log.error("AckMessage for {} failed. Peer {}. tradeId={}, uid={}, errorMessage={}", new Object[]{ackMessage.getSourceMsgClassName(), peersNodeAddress, tradeId, uid, errorMessage});
            }
        });
    }

    protected boolean canProcessMessage(SupportMessage message) {
        return message.getSupportType() == this.getSupportType();
    }

    protected void cleanupRetryMap(String uid) {
        Timer timer;
        if (this.delayMsgMap.containsKey(uid) && (timer = this.delayMsgMap.remove(uid)) != null) {
            timer.stop();
        }
    }

    private boolean isReady() {
        return this.allServicesInitialized && this.p2PService.isBootstrapped() && this.xmrConnectionService.isDownloadComplete() && this.xmrConnectionService.hasSufficientPeersForBroadcast() && this.xmrWalletService.isDownloadComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMessages() {
        Object object = this.lock;
        synchronized (object) {
            this.decryptedDirectMessageWithPubKeys.stream().filter(e -> !(e.getNetworkEnvelope() instanceof MailboxMessage)).forEach(decryptedMessageWithPubKey -> this.applyDirectMessage((DecryptedMessageWithPubKey)decryptedMessageWithPubKey));
            this.decryptedMailboxMessageWithPubKeys.stream().filter(e -> !(e.getNetworkEnvelope() instanceof MailboxMessage)).forEach(decryptedMessageWithPubKey -> this.applyMailboxMessage((DecryptedMessageWithPubKey)decryptedMessageWithPubKey));
            this.decryptedDirectMessageWithPubKeys.stream().filter(e -> e.getNetworkEnvelope() instanceof MailboxMessage).sorted((Comparator<DecryptedMessageWithPubKey>)new MailboxMessageService.DecryptedMessageWithPubKeyComparator()).forEach(decryptedMessageWithPubKey -> this.applyDirectMessage((DecryptedMessageWithPubKey)decryptedMessageWithPubKey));
            this.decryptedMailboxMessageWithPubKeys.stream().filter(e -> e.getNetworkEnvelope() instanceof MailboxMessage).sorted((Comparator<DecryptedMessageWithPubKey>)new MailboxMessageService.DecryptedMessageWithPubKeyComparator()).forEach(decryptedMessageWithPubKey -> this.applyMailboxMessage((DecryptedMessageWithPubKey)decryptedMessageWithPubKey));
            this.decryptedDirectMessageWithPubKeys.clear();
            this.decryptedMailboxMessageWithPubKeys.clear();
        }
    }

    private void applyDirectMessage(DecryptedMessageWithPubKey decryptedMessageWithPubKey) {
        NetworkEnvelope networkEnvelope = decryptedMessageWithPubKey.getNetworkEnvelope();
        if (networkEnvelope instanceof SupportMessage) {
            this.onSupportMessage((SupportMessage)networkEnvelope);
        } else if (networkEnvelope instanceof AckMessage) {
            this.onAckMessage((AckMessage)networkEnvelope);
        }
    }

    private void applyMailboxMessage(DecryptedMessageWithPubKey decryptedMessageWithPubKey) {
        NetworkEnvelope networkEnvelope = decryptedMessageWithPubKey.getNetworkEnvelope();
        log.trace("## decryptedMessageWithPubKey message={}", (Object)networkEnvelope.getClass().getSimpleName());
        if (networkEnvelope instanceof SupportMessage) {
            SupportMessage supportMessage = (SupportMessage)networkEnvelope;
            this.onSupportMessage(supportMessage);
            this.mailboxMessageService.removeMailboxMsg((MailboxMessage)supportMessage);
        } else if (networkEnvelope instanceof AckMessage) {
            AckMessage ackMessage = (AckMessage)networkEnvelope;
            this.onAckMessage(ackMessage);
            this.mailboxMessageService.removeMailboxMsg((MailboxMessage)ackMessage);
        }
    }
}

