/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.provider;

import haveno.network.http.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClientProvider {
    private static final Logger log = LoggerFactory.getLogger(HttpClientProvider.class);
    protected final HttpClient httpClient;

    public HttpClientProvider(HttpClient httpClient, String baseUrl) {
        this(httpClient, baseUrl, false);
    }

    public HttpClientProvider(HttpClient httpClient, String baseUrl, boolean ignoreSocks5Proxy) {
        this.httpClient = httpClient;
        log.debug("{} with baseUrl {}", (Object)this.getClass().getSimpleName(), (Object)baseUrl);
        httpClient.setBaseUrl(baseUrl);
        httpClient.setIgnoreSocks5Proxy(ignoreSocks5Proxy);
    }

    public String toString() {
        return "HttpClientProvider{\n     httpClient=" + String.valueOf(this.httpClient) + "\n}";
    }
}

