/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.proto.network;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.proto.ProtobufferException;
import haveno.common.proto.ProtobufferRuntimeException;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.core.alert.Alert;
import haveno.core.alert.PrivateNotificationMessage;
import haveno.core.filter.Filter;
import haveno.core.network.p2p.inventory.messages.GetInventoryRequest;
import haveno.core.network.p2p.inventory.messages.GetInventoryResponse;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.messages.OfferAvailabilityRequest;
import haveno.core.offer.messages.OfferAvailabilityResponse;
import haveno.core.offer.messages.SignOfferRequest;
import haveno.core.offer.messages.SignOfferResponse;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.support.dispute.mediation.mediator.Mediator;
import haveno.core.support.dispute.messages.DisputeClosedMessage;
import haveno.core.support.dispute.messages.DisputeOpenedMessage;
import haveno.core.support.dispute.refund.refundagent.RefundAgent;
import haveno.core.support.messages.ChatMessage;
import haveno.core.trade.messages.DepositRequest;
import haveno.core.trade.messages.DepositResponse;
import haveno.core.trade.messages.DepositsConfirmedMessage;
import haveno.core.trade.messages.InitMultisigRequest;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.messages.MediatedPayoutTxPublishedMessage;
import haveno.core.trade.messages.MediatedPayoutTxSignatureMessage;
import haveno.core.trade.messages.PaymentReceivedMessage;
import haveno.core.trade.messages.PaymentSentMessage;
import haveno.core.trade.messages.SignContractRequest;
import haveno.core.trade.messages.SignContractResponse;
import haveno.network.p2p.BundleOfEnvelopes;
import haveno.network.p2p.CloseConnectionMessage;
import haveno.network.p2p.peers.getdata.messages.GetDataResponse;
import haveno.network.p2p.peers.getdata.messages.PreliminaryGetDataRequest;
import haveno.network.p2p.peers.peerexchange.messages.GetPeersResponse;
import haveno.network.p2p.storage.messages.RefreshOfferMessage;
import haveno.network.p2p.storage.messages.RemoveMailboxDataMessage;
import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.AckMessage;
import protobuf.AddDataMessage;
import protobuf.AddPersistableNetworkPayloadMessage;
import protobuf.FileTransferPart;
import protobuf.GetPeersRequest;
import protobuf.GetUpdatedDataRequest;
import protobuf.MailboxStoragePayload;
import protobuf.NetworkEnvelope;
import protobuf.Ping;
import protobuf.Pong;
import protobuf.PrefixedSealedAndSignedMessage;
import protobuf.ProtectedMailboxStorageEntry;
import protobuf.ProtectedStorageEntry;
import protobuf.RemoveDataMessage;
import protobuf.StorageEntryWrapper;
import protobuf.StoragePayload;

@Singleton
public class CoreNetworkProtoResolver
extends CoreProtoResolver
implements NetworkProtoResolver {
    private static final Logger log = LoggerFactory.getLogger(CoreNetworkProtoResolver.class);

    @Inject
    public CoreNetworkProtoResolver(Clock clock) {
        this.clock = clock;
    }

    public haveno.common.proto.network.NetworkEnvelope fromProto(NetworkEnvelope proto) throws ProtobufferException {
        if (proto != null) {
            String messageVersion = proto.getMessageVersion();
            switch (proto.getMessageCase()) {
                case PRELIMINARY_GET_DATA_REQUEST: {
                    return PreliminaryGetDataRequest.fromProto((protobuf.PreliminaryGetDataRequest)proto.getPreliminaryGetDataRequest(), (String)messageVersion);
                }
                case GET_DATA_RESPONSE: {
                    return GetDataResponse.fromProto((protobuf.GetDataResponse)proto.getGetDataResponse(), (NetworkProtoResolver)this, (String)messageVersion);
                }
                case GET_UPDATED_DATA_REQUEST: {
                    return haveno.network.p2p.peers.getdata.messages.GetUpdatedDataRequest.fromProto((GetUpdatedDataRequest)proto.getGetUpdatedDataRequest(), (String)messageVersion);
                }
                case GET_PEERS_REQUEST: {
                    return haveno.network.p2p.peers.peerexchange.messages.GetPeersRequest.fromProto((GetPeersRequest)proto.getGetPeersRequest(), (String)messageVersion);
                }
                case GET_PEERS_RESPONSE: {
                    return GetPeersResponse.fromProto((protobuf.GetPeersResponse)proto.getGetPeersResponse(), (String)messageVersion);
                }
                case PING: {
                    return haveno.network.p2p.peers.keepalive.messages.Ping.fromProto((Ping)proto.getPing(), (String)messageVersion);
                }
                case PONG: {
                    return haveno.network.p2p.peers.keepalive.messages.Pong.fromProto((Pong)proto.getPong(), (String)messageVersion);
                }
                case SIGN_OFFER_REQUEST: {
                    return SignOfferRequest.fromProto(proto.getSignOfferRequest(), messageVersion);
                }
                case SIGN_OFFER_RESPONSE: {
                    return SignOfferResponse.fromProto(proto.getSignOfferResponse(), messageVersion);
                }
                case OFFER_AVAILABILITY_REQUEST: {
                    return OfferAvailabilityRequest.fromProto(proto.getOfferAvailabilityRequest(), this, messageVersion);
                }
                case OFFER_AVAILABILITY_RESPONSE: {
                    return OfferAvailabilityResponse.fromProto(proto.getOfferAvailabilityResponse(), messageVersion);
                }
                case REFRESH_OFFER_MESSAGE: {
                    return RefreshOfferMessage.fromProto((protobuf.RefreshOfferMessage)proto.getRefreshOfferMessage(), (String)messageVersion);
                }
                case ADD_DATA_MESSAGE: {
                    return haveno.network.p2p.storage.messages.AddDataMessage.fromProto((AddDataMessage)proto.getAddDataMessage(), (NetworkProtoResolver)this, (String)messageVersion);
                }
                case REMOVE_DATA_MESSAGE: {
                    return haveno.network.p2p.storage.messages.RemoveDataMessage.fromProto((RemoveDataMessage)proto.getRemoveDataMessage(), (NetworkProtoResolver)this, (String)messageVersion);
                }
                case REMOVE_MAILBOX_DATA_MESSAGE: {
                    return RemoveMailboxDataMessage.fromProto((protobuf.RemoveMailboxDataMessage)proto.getRemoveMailboxDataMessage(), (NetworkProtoResolver)this, (String)messageVersion);
                }
                case CLOSE_CONNECTION_MESSAGE: {
                    return CloseConnectionMessage.fromProto((protobuf.CloseConnectionMessage)proto.getCloseConnectionMessage(), (String)messageVersion);
                }
                case PREFIXED_SEALED_AND_SIGNED_MESSAGE: {
                    return haveno.network.p2p.PrefixedSealedAndSignedMessage.fromProto((PrefixedSealedAndSignedMessage)proto.getPrefixedSealedAndSignedMessage(), (String)messageVersion);
                }
                case INIT_TRADE_REQUEST: {
                    return InitTradeRequest.fromProto(proto.getInitTradeRequest(), this, messageVersion);
                }
                case INIT_MULTISIG_REQUEST: {
                    return InitMultisigRequest.fromProto(proto.getInitMultisigRequest(), this, messageVersion);
                }
                case SIGN_CONTRACT_REQUEST: {
                    return SignContractRequest.fromProto(proto.getSignContractRequest(), this, messageVersion);
                }
                case SIGN_CONTRACT_RESPONSE: {
                    return SignContractResponse.fromProto(proto.getSignContractResponse(), this, messageVersion);
                }
                case DEPOSIT_REQUEST: {
                    return DepositRequest.fromProto(proto.getDepositRequest(), this, messageVersion);
                }
                case DEPOSIT_RESPONSE: {
                    return DepositResponse.fromProto(proto.getDepositResponse(), this, messageVersion);
                }
                case DEPOSITS_CONFIRMED_MESSAGE: {
                    return DepositsConfirmedMessage.fromProto(proto.getDepositsConfirmedMessage(), this, messageVersion);
                }
                case PAYMENT_SENT_MESSAGE: {
                    return PaymentSentMessage.fromProto(proto.getPaymentSentMessage(), messageVersion);
                }
                case PAYMENT_RECEIVED_MESSAGE: {
                    return PaymentReceivedMessage.fromProto(proto.getPaymentReceivedMessage(), messageVersion);
                }
                case MEDIATED_PAYOUT_TX_SIGNATURE_MESSAGE: {
                    return MediatedPayoutTxSignatureMessage.fromProto(proto.getMediatedPayoutTxSignatureMessage(), messageVersion);
                }
                case MEDIATED_PAYOUT_TX_PUBLISHED_MESSAGE: {
                    return MediatedPayoutTxPublishedMessage.fromProto(proto.getMediatedPayoutTxPublishedMessage(), messageVersion);
                }
                case DISPUTE_OPENED_MESSAGE: {
                    return DisputeOpenedMessage.fromProto(proto.getDisputeOpenedMessage(), this, messageVersion);
                }
                case DISPUTE_CLOSED_MESSAGE: {
                    return DisputeClosedMessage.fromProto(proto.getDisputeClosedMessage(), messageVersion);
                }
                case CHAT_MESSAGE: {
                    return ChatMessage.fromProto(proto.getChatMessage(), messageVersion);
                }
                case PRIVATE_NOTIFICATION_MESSAGE: {
                    return PrivateNotificationMessage.fromProto(proto.getPrivateNotificationMessage(), messageVersion);
                }
                case ADD_PERSISTABLE_NETWORK_PAYLOAD_MESSAGE: {
                    return haveno.network.p2p.storage.messages.AddPersistableNetworkPayloadMessage.fromProto((AddPersistableNetworkPayloadMessage)proto.getAddPersistableNetworkPayloadMessage(), (NetworkProtoResolver)this, (String)messageVersion);
                }
                case ACK_MESSAGE: {
                    return haveno.network.p2p.AckMessage.fromProto((AckMessage)proto.getAckMessage(), (String)messageVersion);
                }
                case BUNDLE_OF_ENVELOPES: {
                    return BundleOfEnvelopes.fromProto((protobuf.BundleOfEnvelopes)proto.getBundleOfEnvelopes(), (NetworkProtoResolver)this, (String)messageVersion);
                }
                case GET_INVENTORY_REQUEST: {
                    return GetInventoryRequest.fromProto(proto.getGetInventoryRequest(), messageVersion);
                }
                case GET_INVENTORY_RESPONSE: {
                    return GetInventoryResponse.fromProto(proto.getGetInventoryResponse(), messageVersion);
                }
                case FILE_TRANSFER_PART: {
                    return haveno.network.p2p.FileTransferPart.fromProto((FileTransferPart)proto.getFileTransferPart(), (String)messageVersion);
                }
            }
            throw new ProtobufferException("Unknown proto message case (PB.NetworkEnvelope). messageCase=" + String.valueOf(proto.getMessageCase()) + "; proto raw data=" + proto.toString());
        }
        log.error("PersistableEnvelope.fromProto: PB.NetworkEnvelope is null");
        throw new ProtobufferException("PB.NetworkEnvelope is null");
    }

    public NetworkPayload fromProto(StorageEntryWrapper proto) {
        if (proto != null) {
            switch (proto.getMessageCase()) {
                case PROTECTED_MAILBOX_STORAGE_ENTRY: {
                    return haveno.network.p2p.storage.payload.ProtectedMailboxStorageEntry.fromProto((ProtectedMailboxStorageEntry)proto.getProtectedMailboxStorageEntry(), (NetworkProtoResolver)this);
                }
                case PROTECTED_STORAGE_ENTRY: {
                    return haveno.network.p2p.storage.payload.ProtectedStorageEntry.fromProto((ProtectedStorageEntry)proto.getProtectedStorageEntry(), (NetworkProtoResolver)this);
                }
            }
            throw new ProtobufferRuntimeException("Unknown proto message case(PB.StorageEntryWrapper). messageCase=" + String.valueOf(proto.getMessageCase()) + "; proto raw data=" + proto.toString());
        }
        log.error("PersistableEnvelope.fromProto: PB.StorageEntryWrapper is null");
        throw new ProtobufferRuntimeException("PB.StorageEntryWrapper is null");
    }

    public NetworkPayload fromProto(StoragePayload proto) {
        if (proto != null) {
            switch (proto.getMessageCase()) {
                case ALERT: {
                    return Alert.fromProto(proto.getAlert());
                }
                case ARBITRATOR: {
                    return Arbitrator.fromProto(proto.getArbitrator());
                }
                case MEDIATOR: {
                    return Mediator.fromProto(proto.getMediator());
                }
                case REFUND_AGENT: {
                    return RefundAgent.fromProto(proto.getRefundAgent());
                }
                case FILTER: {
                    return Filter.fromProto(proto.getFilter());
                }
                case MAILBOX_STORAGE_PAYLOAD: {
                    return haveno.network.p2p.storage.payload.MailboxStoragePayload.fromProto((MailboxStoragePayload)proto.getMailboxStoragePayload());
                }
                case OFFER_PAYLOAD: {
                    return OfferPayload.fromProto(proto.getOfferPayload());
                }
            }
            throw new ProtobufferRuntimeException("Unknown proto message case (PB.StoragePayload). messageCase=" + String.valueOf(proto.getMessageCase()) + "; proto raw data=" + proto.toString());
        }
        log.error("PersistableEnvelope.fromProto: PB.StoragePayload is null");
        throw new ProtobufferRuntimeException("PB.StoragePayload is null");
    }
}

