/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.NumberValidator;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;

public class XmrValidator
extends NumberValidator {
    @Nullable
    protected BigInteger minValue;
    @Nullable
    protected BigInteger maxValue;
    @Nullable
    protected BigInteger maxTradeLimit;

    @Inject
    public XmrValidator() {
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult result = this.validateIfNotEmpty(input);
        if (result.isValid) {
            input = this.cleanInput(input);
            result = this.validateIfNumber(input);
        }
        if (result.isValid) {
            result = result.andValidation(input, x$0 -> this.validateIfNotZero((String)x$0), x$0 -> this.validateIfNotNegative((String)x$0), this::validateIfNotFractionalXmrValue, this::validateIfNotExceedsMaxTradeLimit, this::validateIfNotExceedsMaxValue, this::validateIfNotUnderMinValue);
        }
        return result;
    }

    protected InputValidator.ValidationResult validateIfNotFractionalXmrValue(String input) {
        try {
            BigDecimal bd = new BigDecimal(input);
            BigDecimal atomicUnits = bd.movePointRight(HavenoUtils.XMR_SMALLEST_UNIT_EXPONENT);
            if (atomicUnits.scale() > 0) {
                return new InputValidator.ValidationResult(false, Res.get("validation.xmr.fraction"));
            }
            return new InputValidator.ValidationResult(true);
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t.getMessage()));
        }
    }

    protected InputValidator.ValidationResult validateIfNotExceedsMaxValue(String input) {
        try {
            BigInteger amount = HavenoUtils.parseXmr(input);
            if (this.maxValue != null && amount.compareTo(this.maxValue) > 0) {
                return new InputValidator.ValidationResult(false, Res.get("validation.xmr.tooLarge", HavenoUtils.formatXmr(this.maxValue, true)));
            }
            return new InputValidator.ValidationResult(true);
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t.getMessage()));
        }
    }

    protected InputValidator.ValidationResult validateIfNotExceedsMaxTradeLimit(String input) {
        try {
            BigInteger amount = HavenoUtils.parseXmr(input);
            if (this.maxTradeLimit != null && amount.compareTo(this.maxTradeLimit) > 0) {
                return new InputValidator.ValidationResult(false, Res.get("validation.xmr.exceedsMaxTradeLimit", HavenoUtils.formatXmr(this.maxTradeLimit, true)));
            }
            return new InputValidator.ValidationResult(true);
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t.getMessage()));
        }
    }

    protected InputValidator.ValidationResult validateIfNotUnderMinValue(String input) {
        try {
            BigInteger amount = HavenoUtils.parseXmr(input);
            if (this.minValue != null && amount.compareTo(this.minValue) < 0) {
                return new InputValidator.ValidationResult(false, Res.get("validation.xmr.tooSmall", HavenoUtils.formatXmr(this.minValue)));
            }
            return new InputValidator.ValidationResult(true);
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t.getMessage()));
        }
    }

    public void setMinValue(@Nullable BigInteger minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(@Nullable BigInteger maxValue) {
        this.maxValue = maxValue;
    }

    public void setMaxTradeLimit(@Nullable BigInteger maxTradeLimit) {
        this.maxTradeLimit = maxTradeLimit;
    }

    @Nullable
    public BigInteger getMaxTradeLimit() {
        return this.maxTradeLimit;
    }
}

