/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.core.payment.PaymentAccount;
import haveno.core.util.FormattingUtils;
import haveno.core.util.ParsingUtils;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.NumberValidator;
import haveno.core.xmr.wallet.Restrictions;

public class SecurityDepositValidator
extends NumberValidator {
    private PaymentAccount paymentAccount;

    @Inject
    public SecurityDepositValidator() {
    }

    public void setPaymentAccount(PaymentAccount paymentAccount) {
        this.paymentAccount = paymentAccount;
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult result = this.validateIfNotEmpty(input);
        if (result.isValid) {
            input = this.cleanInput(input);
            result = this.validateIfNumber(input);
        }
        if (result.isValid) {
            result = result.andValidation(input, x$0 -> this.validateIfNotZero((String)x$0), x$0 -> this.validateIfNotNegative((String)x$0), this::validateIfNotTooLowPercentageValue, this::validateIfNotTooHighPercentageValue);
        }
        return result;
    }

    private InputValidator.ValidationResult validateIfNotTooLowPercentageValue(String input) {
        try {
            double percentage = ParsingUtils.parsePercentStringToDouble(input);
            double minPercentage = Restrictions.getMinSecurityDepositPct();
            if (percentage < minPercentage) {
                return new InputValidator.ValidationResult(false, Res.get("validation.inputTooSmall", FormattingUtils.formatToPercentWithSymbol(minPercentage)));
            }
            return new InputValidator.ValidationResult(true);
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t.getMessage()));
        }
    }

    private InputValidator.ValidationResult validateIfNotTooHighPercentageValue(String input) {
        try {
            double percentage = ParsingUtils.parsePercentStringToDouble(input);
            double maxPercentage = Restrictions.getMaxSecurityDepositPct();
            if (percentage > maxPercentage) {
                return new InputValidator.ValidationResult(false, Res.get("validation.inputTooLarge", FormattingUtils.formatToPercentWithSymbol(maxPercentage)));
            }
            return new InputValidator.ValidationResult(true);
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t.getMessage()));
        }
    }
}

