/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import haveno.core.locale.Res;
import haveno.core.payment.validation.CountryCallingCodes;
import haveno.core.util.validation.InputValidator;
import javax.annotation.Nullable;

public class PhoneNumberValidator
extends InputValidator {
    private String isoCountryCode;
    @Nullable
    private String callingCode;
    private String normalizedCallingCode;
    @Nullable
    private String normalizedPhoneNumber;

    public PhoneNumberValidator() {
    }

    public PhoneNumberValidator(String isoCountryCode) {
        this.isoCountryCode = isoCountryCode;
        this.callingCode = CountryCallingCodes.getCallingCode(isoCountryCode);
        this.normalizedCallingCode = CountryCallingCodes.getNormalizedCallingCode(isoCountryCode);
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        this.normalizedPhoneNumber = null;
        InputValidator.ValidationResult result = super.validate(this.isoCountryCode);
        if (!result.isValid) {
            return new InputValidator.ValidationResult(false, Res.get("validation.phone.missingCountryCode"));
        }
        result = super.validate(input);
        if (!result.isValid) {
            return result;
        }
        String trimmedInput = input.trim();
        boolean isCountryDialingCodeExplicit = trimmedInput.startsWith("+");
        String pureNumber = input.replaceAll("[^A-Za-z0-9]", "");
        boolean hasValidCallingCodePrefix = pureNumber.startsWith(this.normalizedCallingCode);
        boolean isCountryCallingCodeImplicit = !isCountryDialingCodeExplicit && hasValidCallingCodePrefix;
        result = this.validateIsNumeric(input, pureNumber).and(this.validateHasSufficientDigits(input, pureNumber)).and(this.validateIsNotTooLong(input, pureNumber)).and(this.validateIncludedCountryDialingCode(input, isCountryDialingCodeExplicit, hasValidCallingCodePrefix));
        if (result.isValid) {
            this.normalizedPhoneNumber = isCountryDialingCodeExplicit || isCountryCallingCodeImplicit ? "+" + pureNumber : "+" + this.getCallingCode() + pureNumber;
        }
        return result;
    }

    public void setIsoCountryCode(String isoCountryCode) {
        this.isoCountryCode = isoCountryCode;
        this.callingCode = CountryCallingCodes.getCallingCode(isoCountryCode);
        this.normalizedCallingCode = CountryCallingCodes.getNormalizedCallingCode(isoCountryCode);
    }

    private InputValidator.ValidationResult validateIsNumeric(String rawInput, String pureNumber) {
        try {
            if (this.isPositiveNumber(pureNumber)) {
                return new InputValidator.ValidationResult(true);
            }
            return new InputValidator.ValidationResult(false, Res.get("validation.phone.invalidCharacters", rawInput));
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t.getMessage()));
        }
    }

    private InputValidator.ValidationResult validateHasSufficientDigits(String rawInput, String pureNumber) {
        try {
            return pureNumber.length() - this.callingCode.length() > 4 ? new InputValidator.ValidationResult(true) : new InputValidator.ValidationResult(false, Res.get("validation.phone.insufficientDigits", rawInput));
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t.getMessage()));
        }
    }

    private InputValidator.ValidationResult validateIsNotTooLong(String rawInput, String pureNumber) {
        try {
            return pureNumber.length() - this.callingCode.length() > 12 ? new InputValidator.ValidationResult(false, Res.get("validation.phone.tooManyDigits", rawInput)) : new InputValidator.ValidationResult(true);
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t.getMessage()));
        }
    }

    private InputValidator.ValidationResult validateIncludedCountryDialingCode(String rawInput, boolean isCountryDialingCodeExplicit, boolean hasValidDialingCodePrefix) {
        try {
            if (isCountryDialingCodeExplicit && !hasValidDialingCodePrefix) {
                return new InputValidator.ValidationResult(false, Res.get("validation.phone.invalidDialingCode", rawInput, this.isoCountryCode, this.callingCode));
            }
            return new InputValidator.ValidationResult(true);
        }
        catch (Throwable t) {
            return new InputValidator.ValidationResult(false, Res.get("validation.invalidInput", t.getMessage()));
        }
    }

    @Nullable
    public String getCallingCode() {
        return this.callingCode;
    }

    @Nullable
    public String getNormalizedPhoneNumber() {
        return this.normalizedPhoneNumber;
    }
}

