/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import haveno.core.locale.BankUtil;
import haveno.core.locale.Res;
import haveno.core.payment.validation.BankValidator;
import haveno.core.util.validation.InputValidator;

public class NationalAccountIdValidator
extends BankValidator {
    public NationalAccountIdValidator(String countryCode) {
        super(countryCode);
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        switch (this.countryCode) {
            case "AR": {
                int length = 22;
                if (this.isNumberWithFixedLength(input, length)) {
                    return super.validate(input);
                }
                String nationalAccountIdLabel = BankUtil.getNationalAccountIdLabel(this.countryCode);
                return new InputValidator.ValidationResult(false, Res.get("validation.nationalAccountId", nationalAccountIdLabel, length));
            }
        }
        return super.validate(input);
    }
}

