/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.core.payment.validation.LengthValidator;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.RegexValidator;

public class InteracETransferAnswerValidator
extends InputValidator {
    private LengthValidator lengthValidator;
    private RegexValidator regexValidator;

    @Inject
    public InteracETransferAnswerValidator(LengthValidator lengthValidator, RegexValidator regexValidator) {
        lengthValidator.setMinLength(3);
        lengthValidator.setMaxLength(25);
        this.lengthValidator = lengthValidator;
        regexValidator.setPattern("[A-Za-z0-9\\-]+");
        regexValidator.setErrorMessage(Res.get("validation.interacETransfer.invalidAnswer"));
        this.regexValidator = regexValidator;
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult result = super.validate(input);
        if (result.isValid) {
            result = this.lengthValidator.validate(input);
        }
        if (result.isValid) {
            result = this.regexValidator.validate(input);
        }
        return result;
    }
}

