/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;

public final class EmailValidator
extends InputValidator {
    private final InputValidator.ValidationResult invalidAddress = new InputValidator.ValidationResult(false, Res.get("validation.email.invalidAddress"));

    @Override
    public InputValidator.ValidationResult validate(String input) {
        if (input == null || input.length() < 6 || input.length() > 100) {
            return this.invalidAddress;
        }
        String[] subStrings = input.split("@", -1);
        if (subStrings.length == 1) {
            return this.invalidAddress;
        }
        if (subStrings.length > 2 && !this.checkForValidQuotes(subStrings)) {
            return this.invalidAddress;
        }
        String local = subStrings[0];
        String domain = subStrings[subStrings.length - 1];
        if (local.isEmpty()) {
            return this.invalidAddress;
        }
        if (local.startsWith(".") || local.endsWith(".")) {
            return this.invalidAddress;
        }
        String[] splitDomain = domain.split("\\.", -1);
        String tld = splitDomain[splitDomain.length - 1];
        if (splitDomain.length < 2) {
            return this.invalidAddress;
        }
        if (splitDomain[0] == null || splitDomain[0].isEmpty()) {
            return this.invalidAddress;
        }
        if (tld.length() < 2) {
            return this.invalidAddress;
        }
        for (int k = 0; k < tld.length(); ++k) {
            if (Character.isLetter(tld.charAt(k))) continue;
            return this.invalidAddress;
        }
        return new InputValidator.ValidationResult(true);
    }

    private boolean checkForValidQuotes(String[] subStrings) {
        int length = subStrings.length - 2;
        if (subStrings[0].split("\"", -1).length % 2 == 1 || subStrings[length].split("\"", -1).length % 2 == 1) {
            return false;
        }
        for (int k = 1; k < length; ++k) {
            if (subStrings[k].split("\"", -1).length % 2 != 0) continue;
            return false;
        }
        String patchLocal = "";
        for (int k = 0; k <= length; ++k) {
            patchLocal = patchLocal.concat(subStrings[k]);
        }
        subStrings[0] = patchLocal;
        return true;
    }
}

