/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import com.google.inject.Inject;
import haveno.asset.AddressValidationResult;
import haveno.asset.Asset;
import haveno.asset.AssetRegistry;
import haveno.common.config.Config;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptoAddressValidator
extends InputValidator {
    private static final Logger log = LoggerFactory.getLogger(CryptoAddressValidator.class);
    private final AssetRegistry assetRegistry;
    private String currencyCode;

    @Inject
    public CryptoAddressValidator(AssetRegistry assetRegistry) {
        this.assetRegistry = assetRegistry;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult validationResult = super.validate(input);
        if (!validationResult.isValid || this.currencyCode == null) {
            return validationResult;
        }
        Optional<Asset> optionalAsset = CurrencyUtil.findAsset(this.assetRegistry, this.currencyCode, Config.baseCurrencyNetwork());
        if (optionalAsset.isPresent()) {
            Asset asset = optionalAsset.get();
            AddressValidationResult result = asset.validateAddress(input);
            if (!result.isValid()) {
                return new InputValidator.ValidationResult(false, Res.get(result.getI18nKey(), asset.getTickerSymbol(), result.getMessage()));
            }
            return new InputValidator.ValidationResult(true);
        }
        return new InputValidator.ValidationResult(false);
    }
}

