/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import java.util.Map;

final class CountryCallingCodes {
    private static final Map<String, String> CALLING_CODE_MAP = Map.ofEntries(Map.entry("AD", "376"), Map.entry("AE", "971"), Map.entry("AF", "93"), Map.entry("AG", "1-268"), Map.entry("AI", "1-264"), Map.entry("AL", "355"), Map.entry("AM", "374"), Map.entry("AO", "244"), Map.entry("AQ", "672"), Map.entry("AR", "54"), Map.entry("AS", "1-684"), Map.entry("AT", "43"), Map.entry("AU", "61"), Map.entry("AW", "297"), Map.entry("AX", "358"), Map.entry("AZ", "994"), Map.entry("BA", "387"), Map.entry("BB", "1-246"), Map.entry("BD", "880"), Map.entry("BE", "32"), Map.entry("BF", "226"), Map.entry("BG", "359"), Map.entry("BH", "973"), Map.entry("BI", "257"), Map.entry("BJ", "229"), Map.entry("BL", "590"), Map.entry("BM", "1-441"), Map.entry("BN", "673"), Map.entry("BO", "591"), Map.entry("BQ", "599"), Map.entry("BR", "55"), Map.entry("BS", "1-242"), Map.entry("BT", "975"), Map.entry("BV", "47"), Map.entry("BW", "267"), Map.entry("BY", "375"), Map.entry("BZ", "501"), Map.entry("CA", "1"), Map.entry("CC", "61"), Map.entry("CD", "243"), Map.entry("CF", "236"), Map.entry("CG", "242"), Map.entry("CH", "41"), Map.entry("CI", "225"), Map.entry("CK", "682"), Map.entry("CL", "56"), Map.entry("CM", "237"), Map.entry("CN", "86"), Map.entry("CO", "57"), Map.entry("CR", "506"), Map.entry("CU", "53"), Map.entry("CV", "238"), Map.entry("CW", "599"), Map.entry("CX", "61"), Map.entry("CY", "357"), Map.entry("CZ", "420"), Map.entry("DE", "49"), Map.entry("DJ", "253"), Map.entry("DK", "45"), Map.entry("DM", "1-767"), Map.entry("DO", "1"), Map.entry("DZ", "213"), Map.entry("EC", "593"), Map.entry("EE", "372"), Map.entry("EG", "20"), Map.entry("EH", "212"), Map.entry("ER", "291"), Map.entry("ES", "34"), Map.entry("ET", "251"), Map.entry("FI", "358"), Map.entry("FJ", "679"), Map.entry("FK", "500"), Map.entry("FM", "691"), Map.entry("FO", "298"), Map.entry("FR", "33"), Map.entry("GA", "241"), Map.entry("GB", "44"), Map.entry("GD", "1-473"), Map.entry("GE", "995"), Map.entry("GF", "594"), Map.entry("GG", "44"), Map.entry("GH", "233"), Map.entry("GI", "350"), Map.entry("GL", "299"), Map.entry("GM", "220"), Map.entry("GN", "224"), Map.entry("GP", "590"), Map.entry("GQ", "240"), Map.entry("GR", "30"), Map.entry("GS", "500"), Map.entry("GT", "502"), Map.entry("GU", "1-671"), Map.entry("GW", "245"), Map.entry("GY", "592"), Map.entry("HK", "852"), Map.entry("HM", "672"), Map.entry("HN", "504"), Map.entry("HR", "385"), Map.entry("HT", "509"), Map.entry("HU", "36"), Map.entry("ID", "62"), Map.entry("IE", "353"), Map.entry("IL", "972"), Map.entry("IM", "44"), Map.entry("IN", "91"), Map.entry("IO", "246"), Map.entry("IQ", "964"), Map.entry("IR", "98"), Map.entry("IS", "354"), Map.entry("IT", "39"), Map.entry("JE", "44"), Map.entry("JM", "1-876"), Map.entry("JO", "962"), Map.entry("JP", "81"), Map.entry("KE", "254"), Map.entry("KG", "996"), Map.entry("KH", "855"), Map.entry("KI", "686"), Map.entry("KM", "269"), Map.entry("KN", "1-869"), Map.entry("KP", "850"), Map.entry("KR", "82"), Map.entry("KW", "965"), Map.entry("KY", "1-345"), Map.entry("KZ", "7"), Map.entry("LA", "856"), Map.entry("LB", "961"), Map.entry("LC", "1-758"), Map.entry("LI", "423"), Map.entry("LK", "94"), Map.entry("LR", "231"), Map.entry("LS", "266"), Map.entry("LT", "370"), Map.entry("LU", "352"), Map.entry("LV", "371"), Map.entry("LY", "218"), Map.entry("MA", "212"), Map.entry("MC", "377"), Map.entry("MD", "373"), Map.entry("ME", "382"), Map.entry("MF", "590"), Map.entry("MG", "261"), Map.entry("MH", "692"), Map.entry("MK", "389"), Map.entry("ML", "223"), Map.entry("MM", "95"), Map.entry("MN", "976"), Map.entry("MO", "853"), Map.entry("MP", "1-670"), Map.entry("MQ", "596"), Map.entry("MR", "222"), Map.entry("MS", "1-664"), Map.entry("MT", "356"), Map.entry("MU", "230"), Map.entry("MV", "960"), Map.entry("MW", "265"), Map.entry("MX", "52"), Map.entry("MY", "60"), Map.entry("MZ", "258"), Map.entry("NA", "264"), Map.entry("NC", "687"), Map.entry("NE", "227"), Map.entry("NF", "672"), Map.entry("NG", "234"), Map.entry("NI", "505"), Map.entry("NL", "31"), Map.entry("NO", "47"), Map.entry("NP", "977"), Map.entry("NR", "674"), Map.entry("NU", "683"), Map.entry("NZ", "64"), Map.entry("OM", "968"), Map.entry("PA", "507"), Map.entry("PE", "51"), Map.entry("PF", "689"), Map.entry("PG", "675"), Map.entry("PH", "63"), Map.entry("PK", "92"), Map.entry("PL", "48"), Map.entry("PM", "508"), Map.entry("PN", "870"), Map.entry("PR", "1"), Map.entry("PS", "970"), Map.entry("PT", "351"), Map.entry("PW", "680"), Map.entry("PY", "595"), Map.entry("QA", "974"), Map.entry("RE", "262"), Map.entry("RO", "40"), Map.entry("RS", "381 p"), Map.entry("RU", "7"), Map.entry("RW", "250"), Map.entry("SA", "966"), Map.entry("SB", "677"), Map.entry("SC", "248"), Map.entry("SD", "249"), Map.entry("SE", "46"), Map.entry("SG", "65"), Map.entry("SH", "290 n"), Map.entry("SI", "386"), Map.entry("SJ", "47"), Map.entry("SK", "421"), Map.entry("SL", "232"), Map.entry("SM", "378"), Map.entry("SN", "221"), Map.entry("SO", "252"), Map.entry("SR", "597"), Map.entry("SS", "211"), Map.entry("ST", "239"), Map.entry("SV", "503"), Map.entry("SX", "1-721"), Map.entry("SY", "963"), Map.entry("SZ", "268"), Map.entry("TC", "1-649"), Map.entry("TD", "235"), Map.entry("TF", "262"), Map.entry("TG", "228"), Map.entry("TH", "66"), Map.entry("TJ", "992"), Map.entry("TK", "690"), Map.entry("TL", "670"), Map.entry("TM", "993"), Map.entry("TN", "216"), Map.entry("TO", "676"), Map.entry("TR", "90"), Map.entry("TT", "1-868"), Map.entry("TV", "688"), Map.entry("TW", "886"), Map.entry("TZ", "255"), Map.entry("UA", "380"), Map.entry("UG", "256"), Map.entry("US", "1"), Map.entry("UY", "598"), Map.entry("UZ", "998"), Map.entry("VA", "39-06"), Map.entry("VC", "1-784"), Map.entry("VE", "58"), Map.entry("VG", "1-284"), Map.entry("VI", "1-340"), Map.entry("VN", "84"), Map.entry("VU", "678"), Map.entry("WF", "681"), Map.entry("WS", "685"), Map.entry("YE", "967"), Map.entry("YT", "262"), Map.entry("ZA", "27"), Map.entry("ZM", "260"), Map.entry("ZW", "263"));
    private static final String normalizedCallingCodeRegex = "[\\-]";

    CountryCallingCodes() {
    }

    static String getCallingCode(String isoCountryCode) {
        return CALLING_CODE_MAP.get(isoCountryCode);
    }

    static String getNormalizedCallingCode(String isoCountryCode) {
        return CountryCallingCodes.getCallingCode(isoCountryCode).replaceAll(normalizedCallingCodeRegex, "");
    }
}

