/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import haveno.core.locale.Res;
import haveno.core.util.validation.InputValidator;
import java.util.Locale;

public final class BICValidator
extends InputValidator {
    @Override
    public InputValidator.ValidationResult validate(String input) {
        if (!this.isStringWithFixedLength(input, 8) && !this.isStringWithFixedLength(input, 11)) {
            return new InputValidator.ValidationResult(false, Res.get("validation.bic.invalidLength"));
        }
        input = input.toUpperCase(Locale.ROOT);
        for (int k = 0; k < 6; ++k) {
            if (Character.isLetter(input.charAt(k))) continue;
            return new InputValidator.ValidationResult(false, Res.get("validation.bic.letters"));
        }
        char ch = input.charAt(6);
        if (ch == '0' || ch == '1' || input.charAt(7) == 'O') {
            return new InputValidator.ValidationResult(false, Res.get("validation.bic.invalidLocationCode"));
        }
        if (input.startsWith("REVO")) {
            return new InputValidator.ValidationResult(false, Res.get("validation.bic.sepaRevolutBic"));
        }
        if (input.length() == 8) {
            return new InputValidator.ValidationResult(true);
        }
        if (input.charAt(8) == 'X' && (input.charAt(9) != 'X' || input.charAt(10) != 'X')) {
            return new InputValidator.ValidationResult(false, Res.get("validation.bic.invalidBranchCode"));
        }
        return new InputValidator.ValidationResult(true);
    }
}

