/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.core.payment.validation.EmailValidator;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.RegexValidator;

public class AdvancedCashValidator
extends InputValidator {
    private EmailValidator emailValidator;
    private RegexValidator regexValidator;

    @Inject
    public AdvancedCashValidator(EmailValidator emailValidator, RegexValidator regexValidator) {
        this.emailValidator = emailValidator;
        regexValidator.setPattern("[A-Za-z]{1}\\d{12}");
        regexValidator.setErrorMessage(Res.get("validation.advancedCash.invalidFormat"));
        this.regexValidator = regexValidator;
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        InputValidator.ValidationResult result = super.validate(input);
        if (!result.isValid) {
            return result;
        }
        result = this.emailValidator.validate(input);
        if (!result.isValid) {
            result = this.regexValidator.validate(input);
        }
        return result;
    }
}

