/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.validation;

import haveno.core.locale.BankUtil;
import haveno.core.locale.Res;
import haveno.core.payment.validation.BankValidator;
import haveno.core.util.validation.InputValidator;
import org.apache.commons.lang3.StringUtils;

public final class AccountNrValidator
extends BankValidator {
    public AccountNrValidator(String countryCode) {
        super(countryCode);
    }

    @Override
    public InputValidator.ValidationResult validate(String input) {
        switch (this.countryCode) {
            case "GB": {
                int length = 8;
                if (this.isNumberWithFixedLength(input, length)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.accountNr", length));
            }
            case "US": {
                if (this.isNumberInRange(input, 4, 17)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.accountNr", "4 - 17"));
            }
            case "BR": {
                if (this.isStringInRange(input, 1, 20)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.accountNrChars", "1 - 20"));
            }
            case "NZ": {
                String input2;
                String string = input2 = input != null ? input.replaceAll("-", "") : null;
                if (this.isNumberInRange(input2, 15, 16)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.accountNrFormat", "03-1587-0050000-00"));
            }
            case "AU": {
                if (this.isNumberInRange(input, 4, 10)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.accountNr", "4 - 10"));
            }
            case "CA": {
                if (this.isNumberInRange(input, 7, 12)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.accountNr", "7 - 12"));
            }
            case "MX": {
                int length = 18;
                if (this.isNumberWithFixedLength(input, length)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.sortCodeNumber", this.getLabel(), length));
            }
            case "HK": {
                String input2;
                String string = input2 = input != null ? input.replaceAll("-", "") : null;
                if (this.isNumberInRange(input2, 9, 12)) {
                    return super.validate(input);
                }
                return new InputValidator.ValidationResult(false, Res.get("validation.accountNrFormat", "005-231289-112"));
            }
            case "NO": {
                if (input != null) {
                    int length = 11;
                    String input2 = StringUtils.remove((String)input, (String)" ");
                    if ((input2 = StringUtils.remove((String)input2, (String)".")).length() != length || !StringUtils.isNumeric((CharSequence)input2)) {
                        return new InputValidator.ValidationResult(false, Res.get("validation.sortCodeNumber", this.getLabel(), length));
                    }
                    int lastDigit = Character.getNumericValue(input2.charAt(input2.length() - 1));
                    if (this.getMod11ControlDigit(input2) != lastDigit) {
                        return new InputValidator.ValidationResult(false, "Kontonummer har feil sjekksum");
                    }
                    return super.validate(input);
                }
                return super.validate(null);
            }
        }
        return super.validate(input);
    }

    private int getMod11ControlDigit(String accountNrString) {
        int sumForMod = 0;
        int controlNumber = 2;
        char[] accountNr = accountNrString.toCharArray();
        for (int i = accountNr.length - 2; i >= 0; --i) {
            sumForMod += Character.getNumericValue(accountNr[i]) * controlNumber;
            if (++controlNumber <= 7) continue;
            controlNumber = 2;
        }
        int calculus = 11 - sumForMod % 11;
        if (calculus == 11) {
            return 0;
        }
        return calculus;
    }

    private String getLabel() {
        String label = BankUtil.getAccountNrLabel(this.countryCode);
        return label.substring(0, label.length() - 1);
    }
}

