/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.payment.payload;

import com.google.protobuf.Message;
import haveno.core.locale.BankUtil;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import haveno.core.payment.payload.CountryBasedPaymentAccountPayload;
import haveno.core.payment.payload.PayloadWithHolderName;
import haveno.core.payment.payload.PaymentAccountPayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.CountryBasedPaymentAccountPayload;
import protobuf.WesternUnionAccountPayload;

public class WesternUnionAccountPayload
extends CountryBasedPaymentAccountPayload
implements PayloadWithHolderName {
    private static final Logger log = LoggerFactory.getLogger(WesternUnionAccountPayload.class);
    private String holderName;
    private String city;
    private String state = "";
    private String email;

    public WesternUnionAccountPayload(String paymentMethod, String id) {
        super(paymentMethod, id);
    }

    private WesternUnionAccountPayload(String paymentMethodName, String id, String countryCode, List<String> acceptedCountryCodes, String holderName, String city, String state, String email, long maxTradePeriod, Map<String, String> excludeFromJsonDataMap) {
        super(paymentMethodName, id, countryCode, acceptedCountryCodes, maxTradePeriod, excludeFromJsonDataMap);
        this.holderName = holderName;
        this.city = city;
        this.state = state;
        this.email = email;
    }

    public Message toProtoMessage() {
        WesternUnionAccountPayload.Builder builder = protobuf.WesternUnionAccountPayload.newBuilder().setHolderName(this.holderName).setCity(this.city).setState(this.state).setEmail(this.email);
        CountryBasedPaymentAccountPayload.Builder countryBasedPaymentAccountPayload = this.getPaymentAccountPayloadBuilder().getCountryBasedPaymentAccountPayloadBuilder().setWesternUnionAccountPayload(builder);
        return this.getPaymentAccountPayloadBuilder().setCountryBasedPaymentAccountPayload(countryBasedPaymentAccountPayload).build();
    }

    public static PaymentAccountPayload fromProto(protobuf.PaymentAccountPayload proto) {
        protobuf.CountryBasedPaymentAccountPayload countryBasedPaymentAccountPayload = proto.getCountryBasedPaymentAccountPayload();
        protobuf.WesternUnionAccountPayload westernUnionAccountPayload = countryBasedPaymentAccountPayload.getWesternUnionAccountPayload();
        return new WesternUnionAccountPayload(proto.getPaymentMethodId(), proto.getId(), countryBasedPaymentAccountPayload.getCountryCode(), new ArrayList<String>((Collection<String>)countryBasedPaymentAccountPayload.getAcceptedCountryCodesList()), westernUnionAccountPayload.getHolderName(), westernUnionAccountPayload.getCity(), westernUnionAccountPayload.getState(), westernUnionAccountPayload.getEmail(), proto.getMaxTradePeriod(), new HashMap<String, String>(proto.getExcludeFromJsonDataMap()));
    }

    @Override
    public String getPaymentDetails() {
        return Res.get(this.paymentMethodId) + " - " + this.getPaymentDetailsForTradePopup().replace("\n", ", ");
    }

    @Override
    public String getPaymentDetailsForTradePopup() {
        String cityState = BankUtil.isStateRequired(this.countryCode) ? Res.get("payment.account.city") + " / " + Res.getWithCol("payment.account.state") + " " + this.city + " / " + this.state + "\n" : Res.getWithCol("payment.account.city") + " " + this.city + "\n";
        return Res.getWithCol("payment.account.fullName") + " " + this.holderName + "\n" + cityState + Res.getWithCol("payment.country") + " " + CountryUtil.getNameByCode(this.countryCode) + "\n" + Res.getWithCol("payment.email") + " " + this.email;
    }

    @Override
    public byte[] getAgeWitnessInputData() {
        String all = this.countryCode + this.holderName + this.email;
        return super.getAgeWitnessInputData(all.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WesternUnionAccountPayload)) {
            return false;
        }
        WesternUnionAccountPayload other = (WesternUnionAccountPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$holderName = this.getHolderName();
        String other$holderName = other.getHolderName();
        if (this$holderName == null ? other$holderName != null : !this$holderName.equals(other$holderName)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WesternUnionAccountPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $holderName = this.getHolderName();
        result = result * 59 + ($holderName == null ? 43 : $holderName.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WesternUnionAccountPayload(holderName=" + this.getHolderName() + ", city=" + this.getCity() + ", state=" + this.getState() + ", email=" + this.getEmail() + ")";
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getHolderName() {
        return this.holderName;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getEmail() {
        return this.email;
    }
}

